/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class JDBCTableSuperTableLoader
extends JDBCBaseLoader {
    public static final String COLUMN_SUPERTABLE_NAME = "SUPERTABLE_NAME";
    static final /* synthetic */ boolean $assertionsDisabled;

    public JDBCTableSuperTableLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCTableSuperTableLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Table)) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table loadSuperTable() throws SQLException {
        Table retVal = null;
        ResultSet rs = null;
        try {
            rs = this.createResultSet();
            if (rs.next()) {
                retVal = this.findTable(rs.getString(COLUMN_SUPERTABLE_NAME));
            }
            Table table = retVal;
            return table;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            Table table = this.getTable();
            Schema schema = table.getSchema();
            return this.getCatalogObject().getConnection().getMetaData().getSuperTables(schema.getCatalog().getName(), schema.getName(), table.getName());
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getSuperTables()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Table getTable() {
        return (Table)this.getCatalogObject();
    }

    protected Table findTable(String tableName) {
        if (tableName == null) {
            return null;
        }
        Iterator tableIt = this.getTable().getSchema().getTables().iterator();
        while (tableIt.hasNext()) {
            Table table = (Table)tableIt.next();
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return null;
    }

    static {
        $assertionsDisabled = !JDBCTableSuperTableLoader.class.desiredAssertionStatus();
    }
}

