/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.containment;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.ContainmentProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public final class ContainmentServiceImpl
implements ContainmentService {
    public static final ContainmentService INSTANCE = new ContainmentServiceImpl();
    private Hashtable packages = new Hashtable();
    private Hashtable cache = new Hashtable();

    public Collection getContainedElements(EObject obj) {
        EClass metaclass = obj.eClass();
        ContainmentProvider provider = this.getProvider(metaclass);
        if (provider == null) {
            LinkedList children = new LinkedList();
            children.addAll(obj.eContents());
            return children;
        }
        return provider.getContainedElements(obj);
    }

    public Collection getAllContainedElements(EObject obj) {
        LinkedList allChildren = new LinkedList();
        Collection children = this.getContainedElements(obj);
        allChildren.addAll(children);
        Iterator it = children.iterator();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            allChildren.addAll(this.getAllContainedElements(child));
        }
        return allChildren;
    }

    public Collection getContainedDisplayableElements(EObject obj) {
        Collection children = this.getContainedElements(obj);
        Iterator it = children.iterator();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            if (this.isDisplayableElement(child)) continue;
            it.remove();
        }
        return children;
    }

    public Collection getAllContainedDisplayableElements(EObject obj) {
        LinkedList allChildren = new LinkedList();
        Collection children = this.getContainedDisplayableElements(obj);
        allChildren.addAll(children);
        Iterator it = children.iterator();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            allChildren.addAll(this.getAllContainedDisplayableElements(child));
        }
        return allChildren;
    }

    public Collection getContainedDisplayableElements(EObject obj, String group) {
        Collection children = this.getContainedElements(obj);
        Iterator it = children.iterator();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            if (this.isDisplayableElement(child)) {
                String id = this.getGroupId(child);
                if (id == group || id != null && id.startsWith(group)) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
        return children;
    }

    public boolean isDisplayableElement(EObject obj) {
        EClass metaclass = obj.eClass();
        ContainmentProvider provider = this.getProvider(metaclass);
        if (provider == null) {
            return false;
        }
        return provider.isDisplayableElement(obj);
    }

    public EObject getContainer(EObject obj) {
        EClass metaclass = obj.eClass();
        ContainmentProvider provider = this.getProvider(metaclass);
        if (provider == null) {
            return obj.eContainer();
        }
        return provider.getContainer(obj);
    }

    public List getAllContainers(EObject obj) {
        LinkedList<EObject> containers = new LinkedList<EObject>();
        EObject container = this.getContainer(obj);
        while (container != null) {
            containers.add(0, container);
            container = this.getContainer(container);
        }
        return containers;
    }

    public EObject getRootElement(EObject obj) {
        EObject container = this.getContainer(obj);
        while (container != null) {
            obj = container;
            container = this.getContainer(obj);
        }
        return obj;
    }

    public EStructuralFeature getContainmentFeature(EObject obj) {
        EClass metaclass = obj.eClass();
        ContainmentProvider provider = this.getProvider(metaclass);
        if (provider == null) {
            return obj.eContainmentFeature();
        }
        return provider.getContainmentFeature(obj);
    }

    public String getGroupId(EObject obj) {
        EClass metaclass = obj.eClass();
        ContainmentProvider provider = this.getProvider(metaclass);
        if (provider == null) {
            return null;
        }
        return provider.getGroupId(obj);
    }

    private ContainmentServiceImpl() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "logicalContainment");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j) {
                if (!configElements[j].getName().equals("containment")) continue;
                String packageURI = configElements[j].getAttribute("package");
                String className = configElements[j].getAttribute("class");
                ContainmentProvider provider = null;
                try {
                    provider = (ContainmentProvider)configElements[j].createExecutableExtension("provider");
                }
                catch (CoreException e) {
                    Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the containment provider for " + className + " in " + packageURI, (Throwable)e);
                    RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    continue;
                }
                if (this.packages.containsKey(packageURI)) {
                    ((Hashtable)this.packages.get(packageURI)).put(className, provider);
                    continue;
                }
                Hashtable<String, ContainmentProvider> classNames = new Hashtable<String, ContainmentProvider>();
                classNames.put(className, provider);
                this.packages.put(packageURI, classNames);
            }
        }
    }

    private ContainmentProvider getProvider(EClass metaclass) {
        if (this.cache.containsKey(metaclass)) {
            return (ContainmentProvider)this.cache.get(metaclass);
        }
        Vector sortedClasses = this.computeClassOrder(metaclass);
        ContainmentProvider provider = this.getProvider(sortedClasses);
        if (provider != null) {
            this.cache.put(metaclass, provider);
        }
        return provider;
    }

    private Vector computeClassOrder(EClass metaclass) {
        Vector<Object> result = new Vector<Object>(4);
        result.addElement(metaclass);
        int index = 0;
        for (index = 0; index < result.size(); ++index) {
            EClass clazz = (EClass)result.elementAt(index);
            Iterator it = clazz.getESuperTypes().iterator();
            while (it.hasNext()) {
                result.addElement(it.next());
            }
        }
        return result;
    }

    private ContainmentProvider getProvider(Vector classes) {
        int count = classes.size();
        for (int i = 0; i < count; ++i) {
            Hashtable classNames;
            EClass clazz = (EClass)classes.elementAt(i);
            String uri = clazz.getEPackage().getNsURI();
            if (!this.packages.containsKey(uri) || !(classNames = (Hashtable)this.packages.get(uri)).containsKey(clazz.getName())) continue;
            return (ContainmentProvider)classNames.get(clazz.getName());
        }
        return null;
    }
}

