/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCSchema;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaFilterProvider;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class JDBCSchemaLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TABLE_SCHEM = "TABLE_SCHEM";
    public static final String COLUMN_TABLE_CATALOG = "TABLE_CATALOG";
    private Set mSupportedColumns;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JDBCSchemaLoader(ICatalogObject catalogObject) {
        this(catalogObject, new SchemaFilterProvider());
    }

    public JDBCSchemaLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Catalog)) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadSchemas() throws SQLException {
        ArrayList<Schema> retVal = new ArrayList<Schema>();
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            if (this.mSupportedColumns == null) {
                this.mSupportedColumns = new TreeSet();
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCount = rsmd.getColumnCount();
                for (int colNum = 1; colNum <= colCount; ++colNum) {
                    this.mSupportedColumns.add(rsmd.getColumnName(colNum));
                }
            }
            while (rs.next()) {
                Schema schema = this.processRow(rs);
                if (schema == null) continue;
                retVal.add(schema);
            }
            ArrayList<Schema> arrayList = retVal;
            return arrayList;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearSchemas(List schemas) {
        schemas.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        return this.getCatalogObject().getConnection().getMetaData().getSchemas();
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Schema processRow(ResultSet rs) throws SQLException {
        String schemaName;
        if (this.mSupportedColumns.contains(COLUMN_TABLE_CATALOG)) {
            Catalog catalog = this.getCatalog();
            String catalogName = rs.getString(COLUMN_TABLE_CATALOG);
            if (!catalog.getName().equals(catalogName) || catalogName == null && catalog.getName().length() != 0) {
                return null;
            }
        } else if (!(this.getCatalog().getName().equals(this.getCatalogObject().getConnection().getCatalog()) || this.getCatalog().getName().length() == 0 && this.getCatalogObject().getConnection().getCatalog() == null)) {
            return null;
        }
        if ((schemaName = rs.getString(COLUMN_TABLE_SCHEM)) == null || this.isFiltered(schemaName)) {
            return null;
        }
        Schema schema = this.createSchema();
        this.initialize(schema, rs);
        return schema;
    }

    protected Schema createSchema() {
        return new JDBCSchema();
    }

    protected void initialize(Schema schema, ResultSet rs) throws SQLException {
        schema.setName(rs.getString(COLUMN_TABLE_SCHEM));
    }

    protected Catalog getCatalog() {
        return (Catalog)this.getCatalogObject();
    }

    static {
        $assertionsDisabled = !JDBCSchemaLoader.class.desiredAssertionStatus();
    }
}

