/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesFactory;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCProcedureColumnLoader
extends JDBCBaseLoader {
    public static final String COLUMN_COLUMN_NAME = "COLUMN_NAME";
    public static final String COLUMN_COLUMN_TYPE = "COLUMN_TYPE";
    public static final String COLUMN_DATA_TYPE = "DATA_TYPE";
    public static final String COLUMN_TYPE_NAME = "TYPE_NAME";
    public static final String COLUMN_PRECISION = "PRECISION";
    public static final String COLUMN_LENGTH = "LENGTH";
    public static final String COLUMN_SCALE = "SCALE";
    public static final String COLUMN_NULLABLE = "NULLABLE";
    public static final String COLUMN_REMARKS = "REMARKS";
    private Pattern mUDTNameMatcherPattern;
    private boolean mCatalogAtStart;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JDBCProcedureColumnLoader(ICatalogObject catalogObject) {
        this(catalogObject, null);
    }

    public JDBCProcedureColumnLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Procedure)) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadColumns() throws SQLException {
        ArrayList<Object> retVal = new ArrayList<Object>();
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            RoutineResultTable rst = null;
            rs = this.createResultSet();
            while (rs.next()) {
                TypedElement element = this.processRow(rs);
                if (element instanceof Column) {
                    if (rst == null) {
                        rst = this.createRoutineResultTable();
                    }
                    rst.getColumns().add((Object)element);
                    continue;
                }
                retVal.add(element);
            }
            if (rst != null) {
                retVal.add(rst);
            }
            ArrayList<Object> arrayList = retVal;
            return arrayList;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearColumns(List columns) {
        columns.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        Procedure procedure = this.getProcedure();
        Schema schema = procedure.getSchema();
        return this.getCatalogObject().getConnection().getMetaData().getProcedureColumns(schema.getCatalog().getName(), schema.getName(), procedure.getName(), null);
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected TypedElement processRow(ResultSet rs) throws SQLException {
        String columnName = rs.getString(COLUMN_COLUMN_NAME);
        if (columnName == null || this.isFiltered(columnName)) {
            return null;
        }
        Column retVal = null;
        if (rs.getShort(COLUMN_COLUMN_TYPE) == 3) {
            retVal = this.createColumn();
            this.initColumn(retVal, rs);
        } else {
            retVal = this.createParameter();
            this.initParameter((Parameter)retVal, rs);
        }
        return retVal;
    }

    protected Parameter createParameter() {
        return SQLRoutinesFactory.eINSTANCE.createParameter();
    }

    protected Column createColumn() {
        return SQLTablesFactory.eINSTANCE.createColumn();
    }

    protected RoutineResultTable createRoutineResultTable() {
        return SQLRoutinesFactory.eINSTANCE.createRoutineResultTable();
    }

    protected void initParameter(Parameter parameter, ResultSet rs) throws SQLException {
        parameter.setName(rs.getString(COLUMN_COLUMN_NAME));
        parameter.setDescription(rs.getString(COLUMN_REMARKS));
        switch (rs.getShort(COLUMN_COLUMN_TYPE)) {
            case 1: {
                parameter.setMode(ParameterMode.IN_LITERAL);
                break;
            }
            case 2: {
                parameter.setMode(ParameterMode.INOUT_LITERAL);
                break;
            }
            case 4: {
                parameter.setMode(ParameterMode.OUT_LITERAL);
                break;
            }
            default: {
                parameter.setMode(ParameterMode.IN_LITERAL);
            }
        }
        this.initType((TypedElement)parameter, rs);
    }

    protected void initColumn(Column column, ResultSet rs) throws SQLException {
        column.setName(rs.getString(COLUMN_COLUMN_NAME));
        column.setDescription(rs.getString(COLUMN_REMARKS));
        this.initType((TypedElement)column, rs);
        column.setNullable(rs.getInt(COLUMN_NULLABLE) == 1);
    }

    protected void initType(TypedElement element, ResultSet rs) throws SQLException {
        String typeName = rs.getString(COLUMN_TYPE_NAME).toUpperCase();
        int typeCode = rs.getInt(COLUMN_DATA_TYPE);
        List pdtds = this.getDatabaseDefinition().getPredefinedDataTypeDefinitionsByJDBCEnumType(typeCode);
        if (pdtds.size() > 0) {
            PredefinedDataTypeDefinition pdtd = null;
            Iterator it = pdtds.iterator();
            block0: while (pdtd == null && it.hasNext()) {
                PredefinedDataTypeDefinition curPDTD = (PredefinedDataTypeDefinition)it.next();
                Iterator nameIt = curPDTD.getName().iterator();
                while (nameIt.hasNext()) {
                    String name = (String)nameIt.next();
                    if (!typeName.equals(name)) continue;
                    pdtd = curPDTD;
                    continue block0;
                }
            }
            if (pdtd == null) {
                pdtd = this.getDatabaseDefinition().getPredefinedDataTypeDefinition(typeName);
            }
            if (pdtd != null || pdtd == null && typeCode != 1111 && typeCode != 2006) {
                EStructuralFeature feature;
                if (pdtd == null) {
                    pdtd = (PredefinedDataTypeDefinition)pdtds.get(0);
                }
                PredefinedDataType pdt = this.getDatabaseDefinition().getPredefinedDataType(pdtd);
                if (pdtd.isLengthSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("length");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_LENGTH)));
                }
                if (pdtd.isPrecisionSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("precision");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_PRECISION)));
                }
                if (pdtd.isScaleSupported()) {
                    feature = pdt.eClass().getEStructuralFeature("scale");
                    pdt.eSet(feature, (Object)new Integer(rs.getInt(COLUMN_SCALE)));
                }
                element.setDataType((DataType)pdt);
                return;
            }
        }
        if (typeName == null) {
            return;
        }
        UserDefinedType udt = this.findUserDefinedType(typeName);
        element.setDataType((DataType)udt);
    }

    protected Procedure getProcedure() {
        return (Procedure)this.getCatalogObject();
    }

    protected DatabaseDefinition getDatabaseDefinition() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogObject().getCatalogDatabase());
    }

    protected Matcher getUDTNameMatcher(String name) throws SQLException {
        if (this.mUDTNameMatcherPattern == null) {
            DatabaseMetaData dbmd = this.getCatalogObject().getConnection().getMetaData();
            String namePattern = "([a-zA-Z0-9_" + dbmd.getExtraNameCharacters() + "]*)";
            String catalogSeparator = dbmd.getCatalogSeparator();
            String regex = namePattern + "." + namePattern;
            if (name.indexOf(catalogSeparator) < 0) {
                regex = regex + "()";
            } else if (dbmd.isCatalogAtStart()) {
                this.mCatalogAtStart = true;
                regex = namePattern + catalogSeparator + regex;
            } else {
                regex = regex + catalogSeparator + namePattern;
            }
            this.mUDTNameMatcherPattern = Pattern.compile(regex);
        }
        return this.mUDTNameMatcherPattern.matcher(name);
    }

    protected UserDefinedType findUserDefinedType(String typeName) {
        Matcher matcher;
        try {
            matcher = this.getUDTNameMatcher(typeName);
        }
        catch (SQLException e) {
            return null;
        }
        if (matcher.matches()) {
            String udtName;
            String schemaName;
            String catalogName;
            if (this.mCatalogAtStart) {
                catalogName = matcher.group(1);
                schemaName = matcher.group(2);
                udtName = matcher.group(3);
            } else {
                schemaName = matcher.group(1);
                udtName = matcher.group(2);
                catalogName = matcher.group(3);
            }
            if (udtName == null) {
                return null;
            }
            if (catalogName == null) {
                catalogName = new String();
            }
            if (schemaName == null) {
                schemaName = new String();
            }
            Database db = this.getCatalogObject().getCatalogDatabase();
            Iterator catIt = db.getCatalogs().iterator();
            while (catIt.hasNext()) {
                Catalog catalog = (Catalog)catIt.next();
                if (!catalogName.equals(catalog.getName())) continue;
                Iterator schemIt = catalog.getSchemas().iterator();
                while (schemIt.hasNext()) {
                    Schema schema = (Schema)schemIt.next();
                    if (!schemaName.equals(schema.getName())) continue;
                    Iterator udtIt = schema.getUserDefinedTypes().iterator();
                    while (udtIt.hasNext()) {
                        UserDefinedType udt = (UserDefinedType)udtIt.next();
                        if (!udtName.equals(udt.getName())) continue;
                        return udt;
                    }
                }
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !JDBCProcedureColumnLoader.class.desiredAssertionStatus();
    }
}

