/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.services;

import commonj.sdo.DataObject;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.services.ILabelService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.services.LabelSelector;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;

public class LabelService
implements ILabelService {
    private static final ResourceLoader resourceLoader = ResourceLoader.getResourceLoader();
    private static final String ELEMENT_SELECTED = resourceLoader.queryString("DATATOOLS.CORE.UI.EXPLORER.MULTI_SELECTION");
    private static final String CONNECTION_NAME = resourceLoader.queryString("DATATOOLS.CORE.UI.STATUS.CONNECTION");
    private static final String PROJECT_NAME = resourceLoader.queryString("DATATOOLS.CORE.UI.STATUS.PROJECT");
    private static final String BLANK = "";
    private Map typeProvider = new HashMap();
    private Map cache = new HashMap();
    private Map packages = new HashMap();
    private Object element;
    private LabelInfo labelInfo;

    public LabelService() {
        this.initializeLabelServiceProvider();
    }

    private void initializeLabelServiceProvider() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core.ui", "labelService");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j) {
                if (!configElements[j].getName().equals("contributor")) continue;
                LabelInfo li = new LabelInfo(configElements[j]);
                String type = li.getType();
                if (!this.typeProvider.containsKey(type)) {
                    this.typeProvider.put(type, new ArrayList());
                }
                ((List)this.typeProvider.get(type)).add(li);
            }
        }
    }

    private LabelInfo getLabelInfo(EClass metaclass) {
        Vector sortedClasses = this.computeClassOrder(metaclass);
        LabelInfo provider = this.getProvider(sortedClasses);
        return provider;
    }

    private LabelInfo getLabelInfo(Class metaclass) {
        Vector sortedClasses = this.computeClassOrder(metaclass);
        LabelInfo provider = this.getClassProvider(sortedClasses);
        return provider;
    }

    private Vector computeClassOrder(Class metaclass) {
        Vector result = new Vector(4);
        result.addElement(metaclass);
        int index = 0;
        for (index = 0; index < result.size(); ++index) {
            Class clazz = (Class)result.elementAt(index);
            Class<?>[] it = clazz.getInterfaces();
            int n = it.length;
            for (int i = 0; i < n; ++i) {
                result.addElement(it[i]);
            }
        }
        return result;
    }

    private Vector computeClassOrder(EClass metaclass) {
        Vector<Object> result = new Vector<Object>(4);
        result.addElement(metaclass);
        int index = 0;
        for (index = 0; index < result.size(); ++index) {
            EClass clazz = (EClass)result.elementAt(index);
            Iterator it = clazz.getESuperTypes().iterator();
            while (it.hasNext()) {
                result.addElement(it.next());
            }
        }
        return result;
    }

    private LabelInfo getClassProvider(Vector classes) {
        int count = classes.size();
        for (int i = 0; i < count; ++i) {
            Class clazz = (Class)classes.elementAt(i);
            String name = clazz.getName();
            if (!this.typeProvider.containsKey(name)) continue;
            Iterator labelInfoListIterator = ((List)this.typeProvider.get(name)).iterator();
            LabelInfo returnLocalLabelInfo = null;
            while (labelInfoListIterator.hasNext()) {
                LabelInfo localLabelInfo = (LabelInfo)labelInfoListIterator.next();
                if (localLabelInfo.getSelector() == null) {
                    returnLocalLabelInfo = localLabelInfo;
                    continue;
                }
                if (!localLabelInfo.getSelector().select(this.element)) continue;
                return localLabelInfo;
            }
            return returnLocalLabelInfo;
        }
        return null;
    }

    private LabelInfo getProvider(Vector classes) {
        int count = classes.size();
        for (int i = 0; i < count; ++i) {
            EClass clazz = (EClass)classes.elementAt(i);
            String name = clazz.getInstanceClassName();
            if (!this.typeProvider.containsKey(name)) continue;
            Iterator labelInfoListIterator = ((List)this.typeProvider.get(name)).iterator();
            LabelInfo returnLabelInfo = null;
            while (labelInfoListIterator.hasNext()) {
                LabelInfo localLabelInfo = (LabelInfo)labelInfoListIterator.next();
                if (localLabelInfo.getSelector() == null) {
                    returnLabelInfo = localLabelInfo;
                    continue;
                }
                if (!localLabelInfo.getSelector().select(this.element)) continue;
                return localLabelInfo;
            }
            return returnLabelInfo;
        }
        return null;
    }

    private LabelInfo getLabelInfo() {
        if (this.element instanceof EClass) {
            return this.getLabelInfo((EClass)this.element);
        }
        if (this.element instanceof EObject) {
            return this.getLabelInfo(((EObject)this.element).eClass());
        }
        return this.getLabelInfo(this.element.getClass());
    }

    private void findService() {
        this.labelInfo = this.getLabelInfo();
    }

    private boolean matchLabelService() {
        if (this.labelInfo == null) {
            this.findService();
        }
        return this.labelInfo != null;
    }

    public void setElement(Object element) {
        this.labelInfo = null;
        this.element = element;
    }

    public Image getIcon() {
        if (this.matchLabelService()) {
            return this.labelInfo.getIcon();
        }
        return null;
    }

    public String getDisplayType() {
        if (this.matchLabelService()) {
            String displayType = this.labelInfo.getDisplayType();
            return displayType != null ? displayType : (this.element instanceof EObject ? ((EObject)this.element).eClass().getName() : (this.element instanceof IVirtualNode ? ((IVirtualNode)this.element).getDisplayName() : null));
        }
        return null;
    }

    private String buildConnectionName(Object object, String name) {
        ConnectionInfo cinfo;
        String connectionName = "NO_NAME_FOUND";
        Database db = null;
        if (object instanceof ICatalogObject) {
            ICatalogObject catObject = (ICatalogObject)object;
            db = catObject.getCatalogDatabase();
        } else {
            db = this.getDatabase(object);
        }
        if (db != null && (cinfo = DatabaseConnectionRegistry.getConnectionForDatabase((Database)db)) != null && cinfo.getConnectionProfile() != null) {
            connectionName = cinfo.getConnectionProfile().getName();
        }
        return MessageFormat.format(CONNECTION_NAME, name, connectionName);
    }

    private Database getDatabase(Object object) {
        Database db = null;
        if (object instanceof Database) {
            db = (Database)object;
        } else if (object instanceof Catalog) {
            db = ((Catalog)object).getDatabase();
        } else if (object instanceof Schema) {
            db = ((Schema)object).getCatalog().getDatabase();
        } else {
            if (object instanceof Routine) {
                Schema container = ((Routine)object).getSchema();
                return this.getDatabase(container);
            }
            if (object instanceof Table) {
                Schema container = ((Table)object).getSchema();
                return this.getDatabase(container);
            }
            if (object instanceof Column) {
                DataObject container = ((Column)object).getContainer();
                return this.getDatabase(container);
            }
            if (object instanceof Index) {
                Table container = ((Index)object).getTable();
                return this.getDatabase(container);
            }
            if (object instanceof SQLObject) {
                DataObject container = ((SQLObject)object).getContainer();
                return this.getDatabase(container);
            }
        }
        return db;
    }

    private String buildProjectName(IProject project, String name) {
        return MessageFormat.format(PROJECT_NAME, name, project.getName());
    }

    public static String getResourcePath(Resource resource) {
        String fileName = BLANK;
        if (resource == null || resource.getURI() == null) {
            return null;
        }
        String[] segments = resource.getURI().segments();
        int n = segments.length;
        for (int j = 1; j < n; ++j) {
            fileName = fileName + (segments[j].indexOf(File.separator) != -1 ? segments[j] : File.separator + segments[j]);
        }
        return fileName;
    }

    private IFile getIFile(Resource resource) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String fileString = LabelService.getResourcePath(resource);
        if (fileString != null && !fileString.equals(BLANK)) {
            return workspaceRoot.getFile((IPath)new Path(fileString));
        }
        return null;
    }

    private IProject getProject(Object object) {
        if (object == null || !(object instanceof SQLObject)) {
            return null;
        }
        SQLObject parent = (SQLObject)object;
        Resource resource = parent.eResource();
        IFile file = this.getIFile(resource);
        return file == null ? null : file.getProject();
    }

    private Object getParent(IVirtualNode object) {
        Object parent = null;
        while (!((parent = object.getParent()) instanceof SQLObject) && parent instanceof IVirtualNode) {
            object = (IVirtualNode)parent;
        }
        return parent;
    }

    private String getFullName(SQLObject object) {
        return "<" + IDataToolsUIServiceManager.INSTANCE.getLabelService(object).getDisplayType() + "> " + object.getName();
    }

    private String getFullName(IVirtualNode object) {
        return "<" + IDataToolsUIServiceManager.INSTANCE.getLabelService(object).getDisplayType() + "> " + object.getDisplayName();
    }

    private String getName(SQLObject object) {
        if (object instanceof ICatalogObject) {
            return this.buildConnectionName(object, this.getFullName(object));
        }
        IProject project = this.getProject(object);
        if (project == null) {
            return this.getFullName(object);
        }
        return this.buildProjectName(project, this.getFullName(object));
    }

    private String getName(IAdaptable object) {
        Object file = object.getAdapter(IFile.class);
        if (file != null) {
            return this.buildProjectName(((IFile)file).getProject(), ((IFile)file).getName());
        }
        return BLANK;
    }

    private String getName(IVirtualNode object) {
        Object parent = this.getParent(object);
        if (parent != null && parent instanceof ICatalogObject) {
            return this.buildConnectionName(parent, this.getFullName(object));
        }
        IProject project = this.getProject(parent);
        if (project == null) {
            return this.getFullName(object);
        }
        return this.buildProjectName(project, this.getFullName(object));
    }

    private String getName(Object object) {
        if (object instanceof SQLObject) {
            return this.getName((SQLObject)object);
        }
        if (object instanceof IVirtualNode) {
            return this.getName((IVirtualNode)object);
        }
        if (object instanceof IAdaptable) {
            return this.getName((IAdaptable)object);
        }
        return BLANK;
    }

    public String getName() {
        if (this.element instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)this.element;
            if (selection.size() == 1) {
                return this.getName(selection.getFirstElement());
            }
            if (selection.size() > 1) {
                return MessageFormat.format(ELEMENT_SELECTED, BLANK + selection.size());
            }
        }
        return this.getName(this.element);
    }

    private static class LabelInfo {
        public static final String ATTR_TYPE = "type";
        public static final String ATTR_ICON_LOCATION = "iconLocation";
        public static final String ATTR_DISPLAY_TYPE = "displayType";
        public static final String ATTR_SELECTOR = "selector";
        private IConfigurationElement configElement;
        private URL iconLocation;
        private LabelSelector selector;
        private boolean selectorInitialized;

        public LabelInfo(IConfigurationElement configElement) {
            this.configElement = configElement;
        }

        public String getType() {
            return this.configElement.getAttribute(ATTR_TYPE);
        }

        public Image getIcon() {
            if (this.iconLocation == null) {
                String location = this.configElement.getAttribute(ATTR_ICON_LOCATION);
                if (location == null) {
                    return null;
                }
                this.iconLocation = Platform.getBundle((String)this.configElement.getContributor().getName()).getEntry(location);
            }
            return resourceLoader.queryImageFromRegistry(this.iconLocation);
        }

        public String getDisplayType() {
            return this.configElement.getAttribute(ATTR_DISPLAY_TYPE);
        }

        public LabelSelector getSelector() {
            if (!this.selectorInitialized) {
                this.selectorInitialized = true;
                String selectorClassName = this.configElement.getAttribute(ATTR_SELECTOR);
                if (selectorClassName != null && selectorClassName.length() > 0) {
                    try {
                        this.selector = (LabelSelector)this.configElement.createExecutableExtension(ATTR_SELECTOR);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            return this.selector;
        }
    }
}

