/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeExpression
extends FilterExpression {
    private static final FilterExpression[] EMPTY_ARRAY = new FilterExpression[0];
    protected List<FilterExpression> m_expressions;

    public CompositeExpression add(FilterExpression expression) {
        if (this.m_expressions == null) {
            this.m_expressions = new ArrayList<FilterExpression>(2);
        }
        this.m_expressions.add(expression);
        return this;
    }

    public int childCount() {
        return this.m_expressions == null ? 0 : this.m_expressions.size();
    }

    public FilterExpression[] getChildren() {
        if (this.m_expressions == null) {
            return EMPTY_ARRAY;
        }
        return this.m_expressions.toArray(new FilterExpression[this.m_expressions.size()]);
    }

    protected List<FilterExpression> getExpressions() {
        if (this.m_expressions == null) {
            this.m_expressions = new ArrayList<FilterExpression>(2);
        }
        return this.m_expressions;
    }

    @Override
    public void validate(ValidationContext context) throws OdaException {
        if (context != null && context.getValidator() != null) {
            context.getValidator().validate(this, context);
        }
        if (this.m_expressions == null) {
            return;
        }
        Iterator<FilterExpression> iter = this.m_expressions.iterator();
        while (iter.hasNext()) {
            iter.next().validate(context);
        }
    }

    protected void validateMinElements(int minimumChildren) throws OdaException {
        if (this.getExpressions().size() < minimumChildren) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_MISSING_COMPOSITE_MIN_CHILDREN, (Object)this.getQualifiedId(), (Object)minimumChildren));
        }
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(super.toString()) + " [");
        if (this.m_expressions == null) {
            buffer.append(this.m_expressions);
        } else {
            Iterator<FilterExpression> iter = this.m_expressions.iterator();
            while (iter.hasNext()) {
                buffer.append("\n (" + iter.next().toString() + ")");
            }
        }
        buffer.append("]");
        return buffer.toString();
    }
}

