/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateExpression {
    protected static final String ALIAS_SEPARATOR = "_";
    private List<ExpressionVariable> m_inputVariables;
    private boolean m_ignoresDups = false;
    private boolean m_ignoresNull = false;
    private String m_alias;

    protected AggregateExpression(ExpressionVariable inputSourceVar) {
        this.add(inputSourceVar);
    }

    public AggregateExpression add(ExpressionVariable inputSourceVar) {
        this.getVariables().add(inputSourceVar);
        return this;
    }

    public List<ExpressionVariable> getVariables() {
        if (this.m_inputVariables == null) {
            this.m_inputVariables = new ArrayList<ExpressionVariable>(1);
        }
        return this.m_inputVariables;
    }

    public void setVariables(List<ExpressionVariable> variables) {
        this.m_inputVariables = variables;
    }

    public String getQualifiedId() {
        return this.getClass().getName();
    }

    public String getAlias() {
        if (this.m_alias == null) {
            StringBuffer combinedAlias = new StringBuffer();
            Iterator<ExpressionVariable> iter = this.getVariables().iterator();
            while (iter.hasNext()) {
                if (combinedAlias.length() > 0) {
                    combinedAlias.append(ALIAS_SEPARATOR);
                }
                combinedAlias.append(iter.next().getAlias());
            }
            this.m_alias = combinedAlias.toString();
        }
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public boolean ignoresDuplicateValues() {
        return this.m_ignoresDups;
    }

    public void setIgnoreDuplicateValues(boolean ignoresDups) {
        this.m_ignoresDups = ignoresDups;
    }

    public boolean ignoresNullValues() {
        return this.m_ignoresNull;
    }

    public void setIgnoreNullValues(boolean ignoresNull) {
        this.m_ignoresNull = ignoresNull;
    }

    public void validate() throws OdaException {
        this.validate(null);
    }

    public abstract void validate(ValidationContext var1) throws OdaException;
}

