/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.util.Hashtable;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;

public class DataTypeMapping {
    private static Hashtable sm_odaTypeCodes;
    private int m_nativeTypeCode;
    private String m_nativeType;
    private String m_odaScalarType;
    private String[] m_alternativeDataTypes;

    DataTypeMapping(IConfigurationElement dataTypeMapping, String dataSetTypeName) throws OdaException {
        this.m_nativeType = dataTypeMapping.getAttribute("nativeDataType");
        if (this.m_nativeType == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_NATIVE_TYPE_NAME_DEFINED, (Object)dataSetTypeName));
        }
        String nativeDataTypeCode = dataTypeMapping.getAttribute("nativeDataTypeCode");
        if (nativeDataTypeCode == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_NATIVE_TYPE_CODE_DEFINED, (Object)this.m_nativeType, (Object)dataSetTypeName));
        }
        try {
            this.m_nativeTypeCode = Integer.parseInt(nativeDataTypeCode);
        }
        catch (NumberFormatException ex) {
            throw new OdaException(Messages.bind((String)Messages.manifest_INVALID_NATIVE_TYPE_CODE_VALUE, (Object[])new Object[]{this.m_nativeType, nativeDataTypeCode, dataSetTypeName}));
        }
        this.m_odaScalarType = dataTypeMapping.getAttribute("odaScalarDataType");
        this.sanityCheckOdaScalarType(this.m_odaScalarType, false);
        IConfigurationElement[] alternativeDataTypes = dataTypeMapping.getChildren("alternativeOdaDataType");
        int length = alternativeDataTypes.length;
        this.m_alternativeDataTypes = new String[length];
        for (int i = 0; i < length; ++i) {
            this.m_alternativeDataTypes[i] = alternativeDataTypes[i].getAttribute("odaScalarDataType");
            this.sanityCheckOdaScalarType(this.m_alternativeDataTypes[i], true);
        }
    }

    protected DataTypeMapping(int nativeTypeCode, String nativeType, String odaScalarType, String[] alternativeDataTypes) {
        this.m_nativeTypeCode = nativeTypeCode;
        this.m_nativeType = nativeType;
        this.m_odaScalarType = odaScalarType;
        this.m_alternativeDataTypes = alternativeDataTypes;
    }

    private void sanityCheckOdaScalarType(String odaScalarType, boolean isForAlternatives) throws OdaException {
        if (odaScalarType == null) {
            throw new OdaException(isForAlternatives ? Messages.bind((String)Messages.manifest_NO_ODA_SCALAR_DATA_TYPE_DEFINED_2, (Object)this.m_nativeType) : Messages.bind((String)Messages.manifest_NO_ODA_SCALAR_DATA_TYPE_DEFINED_1, (Object)this.m_nativeType));
        }
        if (!(odaScalarType.equalsIgnoreCase("Date") || odaScalarType.equalsIgnoreCase("Double") || odaScalarType.equalsIgnoreCase("Integer") || odaScalarType.equalsIgnoreCase("String") || odaScalarType.equalsIgnoreCase("Time") || odaScalarType.equalsIgnoreCase("Timestamp") || odaScalarType.equalsIgnoreCase("Decimal") || odaScalarType.equalsIgnoreCase("Blob") || odaScalarType.equalsIgnoreCase("Clob"))) {
            throw new OdaException(Messages.bind((String)Messages.manifest_INVALID_ODA_SCALAR_DATA_TYPE_VALUE, (Object)odaScalarType, (Object)this.m_nativeType));
        }
    }

    public String getNativeType() {
        return this.m_nativeType;
    }

    public int getNativeTypeCode() {
        return this.m_nativeTypeCode;
    }

    public String getOdaScalarDataType() {
        return this.m_odaScalarType;
    }

    public int getOdaScalarDataTypeCode() {
        return DataTypeMapping.toOdaDataTypeCode(this.m_odaScalarType);
    }

    public String[] getAlternativeOdaDataTypes() {
        return this.m_alternativeDataTypes;
    }

    public static int toOdaDataTypeCode(String odaDataTypeLiteral) {
        Object typeCode;
        if (odaDataTypeLiteral == null || odaDataTypeLiteral.length() == 0) {
            return 0;
        }
        Locale caseLocl = Locale.US;
        if (sm_odaTypeCodes == null) {
            sm_odaTypeCodes = new Hashtable(10);
            sm_odaTypeCodes.put("String".toLowerCase(caseLocl), new Integer(1));
            sm_odaTypeCodes.put("Integer".toLowerCase(caseLocl), new Integer(4));
            sm_odaTypeCodes.put("Double".toLowerCase(caseLocl), new Integer(8));
            sm_odaTypeCodes.put("Decimal".toLowerCase(caseLocl), new Integer(3));
            sm_odaTypeCodes.put("Date".toLowerCase(caseLocl), new Integer(91));
            sm_odaTypeCodes.put("Time".toLowerCase(caseLocl), new Integer(92));
            sm_odaTypeCodes.put("Timestamp".toLowerCase(caseLocl), new Integer(93));
            sm_odaTypeCodes.put("Blob".toLowerCase(caseLocl), new Integer(2004));
            sm_odaTypeCodes.put("Clob".toLowerCase(caseLocl), new Integer(2005));
        }
        if ((typeCode = sm_odaTypeCodes.get(odaDataTypeLiteral.toLowerCase(caseLocl))) != null) {
            return (Integer)typeCode;
        }
        return 0;
    }
}

