/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile.internal;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConfigurationType;
import org.eclipse.datatools.connectivity.IConnectListener;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IPropertySetListener;

public class OdaConnectionProfile
extends PlatformObject
implements IConnectionProfile {
    private IConnectionProfile m_wrappedProfile;
    private String m_odaWrapperExtensionId;
    private boolean m_hideWrapperId = false;
    private String m_directProviderId;

    public OdaConnectionProfile(IConnectionProfile wrappedProfile) {
        if (wrappedProfile == null) {
            throw new NullPointerException();
        }
        this.setWrappedProfile(wrappedProfile);
    }

    protected OdaConnectionProfile() {
    }

    protected void setWrappedProfile(IConnectionProfile wrappedProfile) {
        this.m_wrappedProfile = wrappedProfile;
    }

    protected IConnectionProfile getWrappedProfile() {
        return this.m_wrappedProfile;
    }

    public boolean hasWrappedProfile() {
        return this.m_wrappedProfile != null;
    }

    public boolean equals(IConnectionProfile aProfile) {
        if (aProfile == null || !this.hasWrappedProfile()) {
            return false;
        }
        return this.getWrappedProfile().getInstanceID().equals(aProfile.getInstanceID());
    }

    public void setOdaWrapperExtensionId(String odaWrapperExtensionId) {
        this.m_odaWrapperExtensionId = this.hasWrappedProfile() && !this.getWrappedProfile().getProviderId().equals(odaWrapperExtensionId) ? odaWrapperExtensionId : null;
    }

    public void setDirectProviderId(String directProviderId) {
        this.m_directProviderId = directProviderId;
    }

    public void setHideWrapperId(boolean hide) {
        this.m_hideWrapperId = hide;
    }

    public String getProviderId() {
        if (this.m_hideWrapperId) {
            return this.getDirectProviderId();
        }
        return this.hasOdaWrapperProvider() ? this.m_odaWrapperExtensionId : this.getDirectProviderId();
    }

    public boolean hasOdaWrapperProvider() {
        return this.m_odaWrapperExtensionId != null;
    }

    public String getDirectProviderId() {
        if (this.m_directProviderId != null) {
            return this.m_directProviderId;
        }
        return this.hasWrappedProfile() ? this.getWrappedProfile().getProviderId() : null;
    }

    public void addConnectListener(IConnectListener listener) {
        this.m_wrappedProfile.addConnectListener(listener);
    }

    public void addPropertySetListener(IPropertySetListener listener) {
        this.m_wrappedProfile.addPropertySetListener(listener);
    }

    public boolean arePropertiesComplete() {
        if (this.hasWrappedProfile()) {
            return this.getWrappedProfile().arePropertiesComplete();
        }
        return false;
    }

    public boolean arePropertiesComplete(String type) {
        if (this.hasWrappedProfile()) {
            return this.getWrappedProfile().arePropertiesComplete(type);
        }
        return false;
    }

    public boolean canWorkOffline() {
        if (this.hasWrappedProfile()) {
            return this.getWrappedProfile().canWorkOffline();
        }
        return false;
    }

    public IStatus connect() {
        return this.m_wrappedProfile.connect();
    }

    public IStatus connectWithoutJob() {
        return this.m_wrappedProfile.connectWithoutJob();
    }

    public void connect(IJobChangeListener listener) {
        this.m_wrappedProfile.connect(listener);
    }

    public IStatus disconnect() {
        return this.m_wrappedProfile.disconnect();
    }

    public void disconnect(IJobChangeListener listener) {
        this.m_wrappedProfile.disconnect(listener);
    }

    public IStatus saveWorkOfflineData() {
        return this.m_wrappedProfile.saveWorkOfflineData();
    }

    public void saveWorkOfflineData(IJobChangeListener listener) {
        this.m_wrappedProfile.saveWorkOfflineData(listener);
    }

    public IStatus workOffline() {
        return this.m_wrappedProfile.workOffline();
    }

    public void workOffline(IJobChangeListener listener) {
        this.m_wrappedProfile.workOffline(listener);
    }

    public IConnection createConnection(String factory) {
        return this.m_wrappedProfile.createConnection(factory);
    }

    public IConnection createConnection(String factoryId, String uid, String pwd) {
        return this.m_wrappedProfile.createConnection(factoryId, uid, pwd);
    }

    public Properties getBaseProperties() {
        return this.m_wrappedProfile.getBaseProperties();
    }

    public ICategory getCategory() {
        return this.m_wrappedProfile.getCategory();
    }

    public IConfigurationType getConfigurationType() {
        return this.m_wrappedProfile.getConfigurationType();
    }

    public int getConnectionState() {
        if (this.hasWrappedProfile()) {
            return this.getWrappedProfile().getConnectionState();
        }
        return 0;
    }

    public String getDescription() {
        return this.m_wrappedProfile.getDescription();
    }

    public String getInstanceID() {
        return this.m_wrappedProfile.getInstanceID();
    }

    public IManagedConnection getManagedConnection(String type) {
        return this.m_wrappedProfile.getManagedConnection(type);
    }

    public String getName() {
        return this.m_wrappedProfile.getName();
    }

    public IConnectionProfile getParentProfile() {
        return this.m_wrappedProfile.getParentProfile();
    }

    public Map getProfileExtensions() {
        return this.m_wrappedProfile.getProfileExtensions();
    }

    public Properties getProperties(String type) {
        return this.m_wrappedProfile.getProperties(type);
    }

    public IConnectionProfileProvider getProvider() {
        return this.m_wrappedProfile.getProvider();
    }

    public String getProviderName() {
        return this.m_wrappedProfile.getProviderName();
    }

    public boolean isAutoConnect() {
        if (this.hasWrappedProfile()) {
            return this.getWrappedProfile().isAutoConnect();
        }
        return false;
    }

    public boolean isConnected() {
        if (this.hasWrappedProfile()) {
            return this.getWrappedProfile().getConnectionState() == 1;
        }
        return false;
    }

    public void removeConnectListener(IConnectListener listener) {
        this.m_wrappedProfile.removeConnectListener(listener);
    }

    public void removePropertySetListener(IPropertySetListener listener) {
        this.m_wrappedProfile.removePropertySetListener(listener);
    }

    public void setBaseProperties(Properties props) {
        this.m_wrappedProfile.setBaseProperties(props);
    }

    public void setConnected(boolean connected) {
        if (this.hasWrappedProfile()) {
            this.getWrappedProfile().setConnected(connected);
        }
    }

    public void setProperties(String type, Properties props) {
        this.m_wrappedProfile.setProperties(type, props);
    }

    public boolean supportsWorkOfflineMode() {
        if (this.hasWrappedProfile()) {
            return this.getWrappedProfile().supportsWorkOfflineMode();
        }
        return false;
    }
}

