/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class OdaProfileExplorer {
    private static OdaProfileExplorer sm_instance = null;

    public static synchronized OdaProfileExplorer getInstance() {
        if (sm_instance == null) {
            sm_instance = new OdaProfileExplorer();
        }
        return sm_instance;
    }

    protected OdaProfileExplorer() {
    }

    public Map getProfiles(String odaDataSourceId) throws OdaException {
        File profileStore = ConnectionProfileMgmt.getStorageLocation().append("ServerProfiles.dat").toFile();
        return this.getProfiles(odaDataSourceId, profileStore);
    }

    public Map getProfiles(String odaDataSourceId, File storageFile) throws OdaException {
        IConnectionProfile[] profilesInFile = this.loadProfiles(storageFile);
        Properties profileIds = new Properties();
        for (int i = 0; i < profilesInFile.length; ++i) {
            if (!profilesInFile[i].getProviderId().equals(odaDataSourceId)) continue;
            IConnectionProfile matchedProfile = profilesInFile[i];
            String profileDisplayName = matchedProfile.getDescription();
            if (profileDisplayName == null || profileDisplayName.length() == 0) {
                profileDisplayName = matchedProfile.getName();
            }
            profileIds.setProperty(matchedProfile.getInstanceID(), profileDisplayName);
            this.addProfileToCache(matchedProfile);
        }
        return profileIds;
    }

    private IConnectionProfile[] loadProfiles(File storageFile) throws OdaException {
        IConnectionProfile[] profilesInFile;
        try {
            profilesInFile = ConnectionProfileMgmt.loadCPs((File)storageFile);
        }
        catch (Exception ex) {
            throw new OdaException((Throwable)ex);
        }
        return profilesInFile;
    }

    private void addProfileToCache(IConnectionProfile profile) throws OdaException {
        try {
            ProfileManager.getInstance().addProfile(profile, true);
        }
        catch (ConnectionProfileException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    public Properties getProfileProperties(String profileInstanceId) {
        IConnectionProfile profile = this.getProfile(profileInstanceId);
        return profile.getBaseProperties();
    }

    public IConnectionProfile getProfile(String profileInstanceId) {
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByInstanceID(profileInstanceId);
        if (profile == null) {
            throw new IllegalArgumentException(profileInstanceId);
        }
        return profile;
    }

    public IConnectionProfile getProfileByName(String profileName, File storageFile) throws OdaException {
        IConnectionProfile[] profilesInFile = this.loadProfiles(storageFile);
        for (int i = 0; i < profilesInFile.length; ++i) {
            if (!profilesInFile[i].getName().equals(profileName)) continue;
            return profilesInFile[i];
        }
        return null;
    }
}

