/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.DataTypes;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class ResultSetMetaData
implements IResultSetMetaData {
    private String[] columnNames = null;
    private String[] columnTypeNames = null;
    private String[] columnLabels = null;

    ResultSetMetaData(String[] colNames, String[] colTypes, String[] colLabels) throws OdaException {
        if (colNames == null) {
            throw new OdaException(Messages.getString("common_ARGUMENT_CANNOT_BE_NULL"));
        }
        this.columnNames = colNames;
        this.columnTypeNames = colTypes;
        this.columnLabels = colLabels;
    }

    public int getColumnCount() throws OdaException {
        return this.columnNames.length;
    }

    public String getColumnName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnNames[index - 1].trim();
    }

    public String getColumnLabel(int index) throws OdaException {
        this.validateColumnIndex(index);
        if (this.columnLabels == null || this.columnLabels[index - 1].equals("null")) {
            return this.getColumnName(index);
        }
        return this.columnLabels[index - 1].trim();
    }

    public int getColumnType(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnTypeNames == null ? 12 : DataTypes.getTypeCode(this.columnTypeNames[index - 1]);
    }

    public String getColumnTypeName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnTypeNames == null ? "NULL" : this.columnTypeNames[index - 1].trim();
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    private void validateColumnIndex(int index) throws OdaException {
        if (index > this.getColumnCount() || index < 1) {
            throw new OdaException(Messages.getString("resultSetMetaData_INVALID_COLUMN_INDEX") + index);
        }
    }
}

