/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import java.util.HashMap;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public final class DataTypes {
    public static final int INT = 4;
    public static final int DOUBLE = 8;
    public static final int STRING = 12;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int BIGDECIMAL = 2;
    public static final int NULL = 0;
    private static HashMap typeStringIntPair = new HashMap();

    public static int getTypeCode(String typeName) throws OdaException {
        String preparedTypeName = typeName.trim().toUpperCase();
        if (typeStringIntPair.containsKey(preparedTypeName)) {
            return (Integer)typeStringIntPair.get(preparedTypeName);
        }
        throw new OdaException(Messages.getString("dataTypes_TYPE_NAME_INVALID") + typeName);
    }

    public static boolean isValidType(String typeName) {
        return typeStringIntPair.containsKey(typeName.trim().toUpperCase());
    }

    private DataTypes() {
    }

    static {
        typeStringIntPair.put("INT", new Integer(4));
        typeStringIntPair.put("DOUBLE", new Integer(8));
        typeStringIntPair.put("STRING", new Integer(12));
        typeStringIntPair.put("DATE", new Integer(91));
        typeStringIntPair.put("TIME", new Integer(92));
        typeStringIntPair.put("TIMESTAMP", new Integer(93));
        typeStringIntPair.put("BLOB", new Integer(2004));
        typeStringIntPair.put("CLOB", new Integer(2005));
        typeStringIntPair.put("BIGDECIMAL", new Integer(2));
        typeStringIntPair.put("NULL", new Integer(0));
    }
}

