/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import java.io.File;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.DataSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.Query;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class Connection
implements IConnection {
    private String homeDir = null;
    private String charSet = null;
    private boolean includeTypeLine = true;
    private boolean isOpen = false;

    public void open(Properties connProperties) throws OdaException {
        File file;
        if (connProperties == null) {
            throw new OdaException(Messages.getString("connection_CONNECTION_PROPERTIES_MISSING"));
        }
        this.homeDir = connProperties.getProperty("HOME");
        this.charSet = connProperties.getProperty("CHARSET");
        String inclTypeLine = connProperties.getProperty("INCLTYPELINE");
        if (inclTypeLine != null && inclTypeLine.trim().length() > 0) {
            boolean bl = this.includeTypeLine = !inclTypeLine.equalsIgnoreCase("NO");
        }
        if (!(file = new File(this.homeDir)).exists()) {
            throw new OdaException(Messages.getString("connection_CANNOT_OPEN_FLAT_FILE_DB_DIR") + this.homeDir);
        }
        this.isOpen = true;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.homeDir = null;
        this.isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSourceType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException(Messages.getString("common_CONNECTION_HAS_NOT_OPEN"));
        }
        return new Query(this.homeDir, this, this.charSet, this.includeTypeLine);
    }

    public void commit() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }
}

