/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignPackage;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.Property;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PropertiesImpl
extends EObjectImpl
implements Properties {
    public static final String copyright = "Copyright (c) 2005, 2006 Actuate Corporation";
    protected EList m_properties = null;

    protected PropertiesImpl() {
    }

    protected EClass eStaticClass() {
        return DesignPackage.eINSTANCE.getProperties();
    }

    public Property findProperty(String propName) {
        if (this.isEmpty()) {
            return null;
        }
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!propName.equalsIgnoreCase(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public String getProperty(String propName) {
        Property prop = this.findProperty(propName);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public void setProperty(String propName, String propValue) {
        Property prop = this.findProperty(propName);
        if (prop != null) {
            prop.setNameValue(propName, propValue);
            return;
        }
        prop = DesignFactory.eINSTANCE.createProperty();
        prop.setNameValue(propName, propValue);
        this.getProperties().add((Object)prop);
    }

    public void unsetProperty(String propName) {
        Property prop = this.findProperty(propName);
        if (prop == null) {
            return;
        }
        this.getProperties().remove((Object)prop);
    }

    public boolean isEmpty() {
        return this.m_properties == null || this.m_properties.isEmpty();
    }

    public EList getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new EObjectContainmentEList(Property.class, (InternalEObject)this, 0);
        }
        return this.m_properties;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getProperties();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getProperties().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.m_properties != null && !this.m_properties.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }
}

