/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.impl;

import com.ibm.icu.util.ULocale;
import org.eclipse.datatools.connectivity.oda.design.DesignPackage;
import org.eclipse.datatools.connectivity.oda.design.Locale;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class LocaleImpl
extends EObjectImpl
implements Locale {
    public static final String copyright = "Copyright (c) 2005, 2006 Actuate Corporation";
    protected static final String LANGUAGE_EDEFAULT = "en";
    protected String m_language = "en";
    protected boolean m_languageESet = false;
    protected static final String COUNTRY_EDEFAULT = null;
    protected String m_country = COUNTRY_EDEFAULT;
    protected static final String VARIANT_EDEFAULT = null;
    protected String m_variant = VARIANT_EDEFAULT;
    protected static final String EMPTY_STRING = "";
    protected static final String UNDERBAR = "_";

    protected LocaleImpl() {
    }

    protected EClass eStaticClass() {
        return DesignPackage.eINSTANCE.getLocale();
    }

    public ULocale getLocale() {
        if (!this.hasLanguage()) {
            return ULocale.getDefault();
        }
        return new ULocale(this.getLanguageGen(), this.toNonNullString(this.getCountry()), this.toNonNullString(this.getVariant()));
    }

    public void setLocale(ULocale locale) {
        if (locale.getLanguage().length() == 0) {
            this.unsetLanguage();
        } else {
            this.setLanguage(locale.getLanguage());
        }
        if (locale.getCountry().length() == 0) {
            this.setCountry(COUNTRY_EDEFAULT);
        } else {
            this.setCountry(locale.getCountry());
        }
        if (locale.getVariant().length() == 0) {
            this.setVariant(VARIANT_EDEFAULT);
        } else {
            this.setVariant(locale.getVariant());
        }
    }

    public String toLanguageCountryString() {
        ULocale theLocale = this.getLocale();
        String strValue = theLocale.getLanguage();
        if (theLocale.getCountry().length() != 0) {
            strValue = strValue + UNDERBAR + theLocale.getCountry();
        }
        return strValue;
    }

    private String toNonNullString(String strValue) {
        if (strValue == null) {
            return EMPTY_STRING;
        }
        return strValue;
    }

    private boolean hasLanguage() {
        return this.isSetLanguage() && this.getLanguageGen() != null && this.getLanguageGen().length() != 0;
    }

    public String getLanguage() {
        return this.getLocale().getLanguage();
    }

    public String getLanguageGen() {
        return this.m_language;
    }

    public void setLanguage(String newLanguage) {
        String oldLanguage = this.m_language;
        this.m_language = newLanguage;
        boolean oldLanguageESet = this.m_languageESet;
        this.m_languageESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLanguage, (Object)this.m_language, !oldLanguageESet));
        }
    }

    public void unsetLanguage() {
        String oldLanguage = this.m_language;
        boolean oldLanguageESet = this.m_languageESet;
        this.m_language = LANGUAGE_EDEFAULT;
        this.m_languageESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 0, (Object)oldLanguage, (Object)LANGUAGE_EDEFAULT, oldLanguageESet));
        }
    }

    public boolean isSetLanguage() {
        return this.m_languageESet;
    }

    public String getCountry() {
        return this.m_country;
    }

    public void setCountry(String newCountry) {
        String oldCountry = this.m_country;
        this.m_country = newCountry;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCountry, (Object)this.m_country));
        }
    }

    public String getVariant() {
        return this.m_variant;
    }

    public void setVariant(String newVariant) {
        String oldVariant = this.m_variant;
        this.m_variant = newVariant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldVariant, (Object)this.m_variant));
        }
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getLanguage();
            }
            case 1: {
                return this.getCountry();
            }
            case 2: {
                return this.getVariant();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setLanguage((String)newValue);
                return;
            }
            case 1: {
                this.setCountry((String)newValue);
                return;
            }
            case 2: {
                this.setVariant((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.unsetLanguage();
                return;
            }
            case 1: {
                this.setCountry(COUNTRY_EDEFAULT);
                return;
            }
            case 2: {
                this.setVariant(VARIANT_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.isSetLanguage();
            }
            case 1: {
                return COUNTRY_EDEFAULT == null ? this.m_country != null : !COUNTRY_EDEFAULT.equals(this.m_country);
            }
            case 2: {
                return VARIANT_EDEFAULT == null ? this.m_variant != null : !VARIANT_EDEFAULT.equals(this.m_variant);
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (language: ");
        if (this.m_languageESet) {
            result.append(this.m_language);
        } else {
            result.append("<unset>");
        }
        result.append(", country: ");
        result.append(this.m_country);
        result.append(", variant: ");
        result.append(this.m_variant);
        result.append(')');
        return result.toString();
    }
}

