/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfileUtil;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfileWizardPage;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbTypesSelectionPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.NewDataSourceWizard;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class NewDbDataSourceWizardBase
extends NewDataSourceWizard {
    private DbTypesSelectionPage m_dbSelectionPage;
    private DbProfileWizardPage m_dbProfileWizPage;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.NewDbDataSourceWizardBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected NewDbDataSourceWizardBase(String odaDataSourceId) throws OdaException {
        super(odaDataSourceId);
    }

    protected NewDbDataSourceWizardBase() {
    }

    public boolean isValid(String odaDataSourceId, OdaConnectionProfile odaProfile) {
        if (!this.getOdaDataSourceId().equals(odaDataSourceId)) {
            return false;
        }
        if (this.getPageCount() == 0) {
            return true;
        }
        if (odaProfile == null) {
            return this.m_dbSelectionPage != null;
        }
        if (this.m_dbProfileWizPage == null) {
            return false;
        }
        String dbProviderId = DbProfileUtil.getDbProviderIdFromProfileProperties(odaProfile);
        if (dbProviderId == null) {
            dbProviderId = odaProfile.getProviderId();
        }
        if (!dbProviderId.equals(this.m_dbProfileWizPage.getDbProfileProviderId())) {
            return false;
        }
        if (!this.hasLinkToProfile()) {
            return true;
        }
        return odaProfile.equals(this.getLinkedProfile());
    }

    public void addPages() {
        super.addPages();
        this.setSkipProfileNamePage(true);
    }

    public void addCustomPages() {
        IConnectionProfile selectedProfile;
        if (this.hasLinkToProfile() && (selectedProfile = this.getLinkedProfile()) instanceof OdaConnectionProfile) {
            this.m_dbProfileWizPage = this.createDbProfileWizardPage((OdaConnectionProfile)selectedProfile);
            if (this.m_dbProfileWizPage != null) {
                this.addPage((IWizardPage)this.m_dbProfileWizPage);
                return;
            }
        }
        this.addPage((IWizardPage)this.getDbProfileTypesSelectionPage());
    }

    private DbTypesSelectionPage getDbProfileTypesSelectionPage() {
        if (this.m_dbSelectionPage == null) {
            this.m_dbSelectionPage = new DbTypesSelectionPage();
        }
        return this.m_dbSelectionPage;
    }

    private DbProfileWizardPage getDbProfileWizardPage() {
        return this.m_dbProfileWizPage;
    }

    private boolean isCreatingFromProfile() {
        return this.hasLinkToProfile() && this.getDbProfileWizardPage() != null;
    }

    private DbProfileWizardPage createDbProfileWizardPage(OdaConnectionProfile odaDbProfile) {
        if (!$assertionsDisabled && odaDbProfile == null) {
            throw new AssertionError();
        }
        ProfilePropertyPage customDbPropPage = DbProfileUtil.createDbPropertyPage(odaDbProfile, this.getOdaDataSourceId());
        if (customDbPropPage == null) {
            return null;
        }
        return new DbProfileWizardPage(customDbPropPage.getTitle(), customDbPropPage);
    }

    public IWizardPage getCustomStartingPage() {
        DataSourceWizardPage customPage = this.getCustomWizardPage();
        if (customPage != null) {
            return customPage;
        }
        return this.getDbProfileTypesSelectionPage();
    }

    protected DataSourceWizardPage getCustomWizardPage() {
        if (this.isCreatingFromProfile()) {
            return this.getDbProfileWizardPage();
        }
        return null;
    }

    protected Properties collectCustomProperties() {
        Properties dbProfileProps;
        String dbProviderId = null;
        if (this.isCreatingFromProfile()) {
            dbProfileProps = this.getDbProfileWizardPage().collectCustomProperties();
            dbProviderId = this.getDbProfileWizardPage().getDbProfileProviderId();
        } else {
            IWizard cpNodeWizard = this.getDbProfileTypesSelectionPage().getSelectedNodeWizard();
            if (!(cpNodeWizard instanceof NewConnectionProfileWizard)) {
                return new Properties();
            }
            NewConnectionProfileWizard castedCpNodeWizard = (NewConnectionProfileWizard)cpNodeWizard;
            dbProfileProps = castedCpNodeWizard.getProfileProperties();
            dbProviderId = castedCpNodeWizard.getProfileProviderID();
        }
        DbProfileUtil.setDbProviderIdInProperties(dbProfileProps, dbProviderId);
        return dbProfileProps;
    }

    protected void setDataSourceDesignProperties(DataSourceDesign newDesign, Properties customPropertyValues) throws OdaException {
        DbProfileUtil.updateDataSourceDesignManifestProperties(newDesign, customPropertyValues);
    }
}

