/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSourceDesignSessionBase;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelection;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

class ProfileSelectionPageHelper {
    private static final String EMPTY_STRING = "";
    private static final String CONTEXT_ID_CONNECTIONPROFILE = "org.eclipse.datatools.oda.cshelp.Wizard_ConnectionProfile_ID";
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private transient Label m_dataSourceNameLabel = null;
    private transient Text m_connectionProfilePath = null;
    private transient Text m_dataSourceDesignNameControl = null;
    private transient Button m_linkRefCheckBox = null;
    private transient String m_profileID;
    private transient String m_odaDataSourceID;
    private transient Button m_useDefaultDSNameCheckBox = null;
    private transient Tree m_odaDataSourceTree = null;
    private transient String m_treeFilter;
    private transient Properties m_dataSourceIDProperties = null;
    private transient DataSourceDesignSessionBase.IDesignNameValidatorBase m_designNameValidator;
    private String m_dataSourceDesignName = "";
    static final /* synthetic */ boolean $assertionsDisabled;

    ProfileSelectionPageHelper(WizardPage page) {
        this.m_wizardPage = page;
    }

    ProfileSelectionPageHelper(PropertyPage page) {
        this.m_propertyPage = page;
    }

    Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.setupConnectionProfilePath(container);
        this.setupLinkCheckBox(container);
        this.setupTreeViewer(container);
        this.setupDataSourceName(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, CONTEXT_ID_CONNECTIONPROFILE);
        return container;
    }

    void initControl(ProfileSelection selectedProfile) {
        if (selectedProfile == null) {
            return;
        }
        this.m_treeFilter = selectedProfile.getOdaDataSourceId();
        DataSourceDesignSessionBase.ProfileReferenceBase profileRef = selectedProfile.getProfileRef();
        if (profileRef != null) {
            String profileStorePath = profileRef.getStorageFilePath();
            if (profileStorePath != null) {
                this.setConnProfilePathControlText(profileStorePath);
                TreeItem profileItem = this.findProfileInTree(selectedProfile.getOdaDataSourceId(), profileRef.getInstanceId());
                if (profileItem != null) {
                    if (!$assertionsDisabled && this.m_odaDataSourceTree == null) {
                        throw new AssertionError();
                    }
                    this.m_odaDataSourceTree.setSelection(profileItem);
                    this.m_odaDataSourceTree.showSelection();
                    this.m_useDefaultDSNameCheckBox.setSelection(profileItem.getText().equals(selectedProfile.getDataSourceDesignName()));
                    this.m_profileID = profileItem.getData().toString();
                    this.m_odaDataSourceID = profileItem.getParentItem().getData().toString();
                    this.setPageComplete(true);
                }
            }
            this.m_linkRefCheckBox.setSelection(profileRef.maintainExternalLink());
        }
        this.m_dataSourceDesignName = selectedProfile.getDataSourceDesignName();
        this.m_dataSourceDesignNameControl.setText(this.m_dataSourceDesignName);
        if (this.inEditMode()) {
            this.setDataSourceNameEditorVisible(false);
        }
    }

    void setDesignNameValidator(DataSourceDesignSessionBase.IDesignNameValidatorBase validator) {
        this.m_designNameValidator = validator;
    }

    ProfileSelection collectProfileSelection() {
        if (!this.hasSelectedProfile() || !this.isPageComplete()) {
            return null;
        }
        return new ProfileSelection(this.m_odaDataSourceID, this.m_dataSourceDesignName, new DataSourceDesignSessionBase.ProfileReferenceBase(this.m_profileID, new Path(this.getConnProfilePathControlText()).toFile(), this.m_linkRefCheckBox.getSelection()));
    }

    private boolean isPageComplete() {
        boolean isPageComplete = true;
        if (this.m_wizardPage != null) {
            isPageComplete = this.m_wizardPage.isPageComplete();
        } else if (this.m_propertyPage != null) {
            isPageComplete = this.m_propertyPage.isValid();
        } else {
            boolean bl = isPageComplete = this.getMessageType() != 3;
        }
        if (!isPageComplete) {
            return isPageComplete;
        }
        if (this.m_linkRefCheckBox != null && this.m_linkRefCheckBox.getSelection()) {
            isPageComplete = this.hasSelectedProfile();
        }
        return isPageComplete;
    }

    private void setPageComplete(boolean complete) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(complete);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setValid(complete);
        }
        if (complete) {
            this.setMessage(EMPTY_STRING, 0);
        } else {
            this.setDefaultMessageAsError(true);
        }
    }

    private void setMessage(String newMessage, int newType) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(newMessage, newType);
        } else if (this.m_propertyPage != null) {
            if (newMessage == EMPTY_STRING && newType == 0) {
                newMessage = Messages.profilePage_pageTitle;
            }
            this.m_propertyPage.setMessage(newMessage, newType);
        }
    }

    private void setDefaultMessageAsError(boolean isError) {
        int newType = isError ? 3 : 0;
        this.setMessage(Messages.profilePage_selectProfileDefaultMessage, newType);
    }

    int getMessageType() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getMessageType();
        }
        if (this.m_propertyPage != null) {
            return this.m_propertyPage.getMessageType();
        }
        return 0;
    }

    private Shell getShell() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getShell();
        }
        if (!$assertionsDisabled && this.m_propertyPage == null) {
            throw new AssertionError();
        }
        return this.m_propertyPage.getShell();
    }

    private void setupConnectionProfilePath(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.profilePage_label_profileStore);
        label.setLayoutData((Object)new GridData(32));
        this.m_connectionProfilePath = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 260;
        this.m_connectionProfilePath.setLayoutData((Object)layoutData);
        this.m_connectionProfilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusyIndicator.showWhile((Display)(ProfileSelectionPageHelper.this.getShell() == null ? null : ProfileSelectionPageHelper.this.getShell().getDisplay()), (Runnable)new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        ProfileSelectionPageHelper.access$200(1.access$100(this.this$1));
                        ProfileSelectionPageHelper.access$300(1.access$100(this.this$1));
                        ProfileSelectionPageHelper.access$400(1.access$100(this.this$1), "");
                        boolean isError = ProfileSelectionPageHelper.access$500(1.access$100(this.this$1));
                        ProfileSelectionPageHelper.access$600(1.access$100(this.this$1), isError);
                    }
                });
            }

            static /* synthetic */ ProfileSelectionPageHelper access$100(1 x0) {
                return x0.ProfileSelectionPageHelper.this;
            }
        });
        Button button = new Button(composite, 8);
        button.setText(Messages.profilePage_button_browse);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ProfileSelectionPageHelper.this.getShell());
                String text = dialog.open();
                if (text != null) {
                    ProfileSelectionPageHelper.this.setConnProfilePathControlText(text);
                }
            }
        });
    }

    private void setupTreeViewer(Composite composite) {
        this.m_odaDataSourceTree = new Tree(composite, 2564);
        this.m_odaDataSourceTree.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        this.m_odaDataSourceTree.setLayoutData((Object)layoutData);
        this.m_odaDataSourceTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.handleTreeSelection();
            }

            private void handleTreeSelection() {
                TreeItem item = ProfileSelectionPageHelper.this.getSelectedProfileItem();
                if (item == null) {
                    ProfileSelectionPageHelper.this.clearSelectedProfile();
                    ProfileSelectionPageHelper.this.setSelectedDataSourceName(ProfileSelectionPageHelper.EMPTY_STRING);
                    ProfileSelectionPageHelper.this.setDefaultMessageAsError(true);
                } else {
                    ProfileSelectionPageHelper.this.m_profileID = item.getData().toString();
                    ProfileSelectionPageHelper.this.m_odaDataSourceID = item.getParentItem().getData().toString();
                    ProfileSelectionPageHelper.this.setSelectedDataSourceName(item.getText());
                }
            }
        });
        this.populateTree();
    }

    private void setSelectedDataSourceName(String name) {
        if (this.m_dataSourceDesignNameControl == null) {
            return;
        }
        String trimmedName = name.trim();
        this.m_dataSourceDesignNameControl.setText(trimmedName);
    }

    private boolean hasSelectedProfile() {
        return this.m_profileID != null && this.m_odaDataSourceID != null;
    }

    private void clearSelectedProfile() {
        this.m_profileID = null;
        this.m_odaDataSourceID = null;
    }

    private void setDataSourceDesignName(String name) {
        if (this.inEditMode()) {
            return;
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.m_dataSourceDesignName = name.trim();
    }

    private void populateTree() {
        this.resetTreeViewer();
        if (!this.hasConnectionProfilePath()) {
            return;
        }
        this.generateDataSourceIdentifiers();
        TreeItem root = new TreeItem(this.m_odaDataSourceTree, 0);
        root.setText(Messages.profilePage_odaTreeName);
        try {
            Iterator<Object> iterator = this.m_dataSourceIDProperties.keySet().iterator();
            while (iterator.hasNext()) {
                Object odaDataSourceId = iterator.next();
                String dsID = odaDataSourceId.toString();
                if (this.m_treeFilter != null && !this.m_treeFilter.equals(dsID) || !this.hasProfileInstance(odaDataSourceId)) continue;
                TreeItem dsCategory = new TreeItem(root, 0);
                String dsDisplayName = this.m_dataSourceIDProperties.getProperty(dsID);
                dsCategory.setData((Object)dsID);
                dsCategory.setText(dsDisplayName);
                this.createDSTreeItems(dsCategory);
                this.m_odaDataSourceTree.showItem(dsCategory);
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    private void resetTreeViewer() {
        if (this.m_odaDataSourceTree != null) {
            this.m_odaDataSourceTree.removeAll();
        }
    }

    private TreeItem getSelectedProfileItem() {
        TreeItem[] items = this.m_odaDataSourceTree.getSelection();
        if (items.length == 0) {
            return null;
        }
        TreeItem item = items[0];
        if (item.getParentItem() == null || this.m_dataSourceIDProperties.containsKey(item.getData())) {
            return null;
        }
        return item;
    }

    private TreeItem findProfileInTree(String odaDataSourceId, String profileId) {
        if (profileId == null) {
            return null;
        }
        TreeItem dsCategory = this.findOdaCategoryInTree(odaDataSourceId);
        if (dsCategory == null) {
            return null;
        }
        TreeItem[] profileItems = dsCategory.getItems();
        for (int i = 0; i < profileItems.length; ++i) {
            TreeItem profileItem = profileItems[i];
            if (!profileItem.getData().toString().equals(profileId)) continue;
            return profileItem;
        }
        return null;
    }

    private TreeItem findOdaCategoryInTree(String odaDataSourceId) {
        if (this.m_odaDataSourceTree == null || odaDataSourceId == null) {
            return null;
        }
        TreeItem[] root = this.m_odaDataSourceTree.getItems();
        if (root.length == 0) {
            return null;
        }
        TreeItem[] dsCategories = root[0].getItems();
        for (int i = 0; i < dsCategories.length; ++i) {
            TreeItem dsCategory = dsCategories[i];
            if (!dsCategory.getData().toString().equals(odaDataSourceId)) continue;
            return dsCategory;
        }
        return null;
    }

    private void generateDataSourceIdentifiers() {
        if (this.m_dataSourceIDProperties == null) {
            this.m_dataSourceIDProperties = ManifestExplorer.getInstance().getDataSourceIdentifiers();
        }
    }

    private boolean hasProfileInstance(Object odaDataSourceId) throws OdaException {
        Map profiles = this.getProfileIdentifiers(odaDataSourceId.toString());
        if (profiles == null) {
            return false;
        }
        return profiles.keySet().size() > 0;
    }

    private Map getProfileIdentifiers(String odaDataSourceId) {
        try {
            return DesignSessionUtil.getProfileIdentifiers(odaDataSourceId, new Path(this.getConnProfilePathControlText()).toFile());
        }
        catch (OdaException ex) {
            this.setMessage(Messages.profilePage_error_invalidProfileStorePath, 3);
            return null;
        }
    }

    private void createDSTreeItems(TreeItem dsCategory) throws OdaException {
        Map profiles = this.getProfileIdentifiers(dsCategory.getData().toString());
        if (profiles == null) {
            return;
        }
        ArrayList treeList = new ArrayList();
        Iterator iterator = profiles.keySet().iterator();
        while (iterator.hasNext()) {
            treeList.add(iterator.next());
        }
        this.createTreeItems(profiles, dsCategory, treeList, 0);
    }

    private TreeItem[] createTreeItems(Map profiles, TreeItem dsCategory, ArrayList dataSource, int style) {
        if (dataSource == null) {
            return null;
        }
        TreeItem[] item = new TreeItem[dataSource.size()];
        for (int i = 0; i < dataSource.size(); ++i) {
            item[i] = new TreeItem(dsCategory, style);
            Object source = dataSource.get(i);
            item[i].setData(source);
            item[i].setText(profiles.get(source).toString());
        }
        return item;
    }

    private void setupDataSourceName(Composite composite) {
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.m_useDefaultDSNameCheckBox = new Button(composite, 32);
        this.m_useDefaultDSNameCheckBox.setText(Messages.profilePage_checkboxLabel_useDefaultName);
        this.m_useDefaultDSNameCheckBox.setSelection(true);
        this.m_useDefaultDSNameCheckBox.setLayoutData((Object)layoutData);
        this.m_useDefaultDSNameCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                if (ProfileSelectionPageHelper.this.m_useDefaultDSNameCheckBox.getSelection() && (item = ProfileSelectionPageHelper.this.getSelectedProfileItem()) != null) {
                    ProfileSelectionPageHelper.this.setSelectedDataSourceName(item.getText());
                }
                ProfileSelectionPageHelper.this.enableDataSourceNameEditor(!ProfileSelectionPageHelper.this.m_useDefaultDSNameCheckBox.getSelection());
            }
        });
        this.m_dataSourceNameLabel = new Label(composite, 0);
        this.m_dataSourceNameLabel.setText(Messages.profilePage_label_dataSourceName);
        this.m_dataSourceNameLabel.setLayoutData((Object)new GridData(32));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.m_dataSourceDesignNameControl = new Text(composite, 2048);
        this.m_dataSourceDesignNameControl.setLayoutData((Object)layoutData);
        this.m_dataSourceDesignNameControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProfileSelectionPageHelper.this.setDataSourceDesignName(ProfileSelectionPageHelper.this.m_dataSourceDesignNameControl.getText());
                String invalidMessage = null;
                if (ProfileSelectionPageHelper.this.isDesignNameBlank()) {
                    ProfileSelectionPageHelper.this.setPageComplete(false);
                    ProfileSelectionPageHelper.this.setMessage(Messages.profilePage_error_emptyName, 3);
                } else {
                    invalidMessage = ProfileSelectionPageHelper.this.validateAndGetErrorMessage();
                    if (invalidMessage != null) {
                        ProfileSelectionPageHelper.this.setPageComplete(false);
                        ProfileSelectionPageHelper.this.setMessage(invalidMessage, 3);
                    } else {
                        boolean isNameOk = ProfileSelectionPageHelper.this.inEditMode() ? true : ProfileSelectionPageHelper.this.hasSelectedProfile();
                        ProfileSelectionPageHelper.this.setPageComplete(isNameOk);
                    }
                }
            }
        });
        this.enableDataSourceNameEditor(false);
    }

    private void setupLinkCheckBox(Composite composite) {
        this.m_linkRefCheckBox = new Button(composite, 32);
        this.m_linkRefCheckBox.setToolTipText(Messages.profilePage_checkboxTooltip_maintainLink);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.m_linkRefCheckBox.setLayoutData((Object)data);
        this.m_linkRefCheckBox.setText(Messages.profilePage_checkboxLabel_maintainLink);
        this.m_linkRefCheckBox.setSelection(true);
        this.m_linkRefCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProfileSelectionPageHelper.this.inEditMode() || ProfileSelectionPageHelper.this.m_odaDataSourceTree == null) {
                    return;
                }
                boolean maintainLink = ProfileSelectionPageHelper.this.m_linkRefCheckBox.getSelection();
                ProfileSelectionPageHelper.this.m_odaDataSourceTree.setEnabled(maintainLink);
                if (ProfileSelectionPageHelper.this.isPageComplete()) {
                    ProfileSelectionPageHelper.this.setMessage(ProfileSelectionPageHelper.EMPTY_STRING, 0);
                } else {
                    ProfileSelectionPageHelper.this.setDefaultMessageAsError(maintainLink);
                }
            }
        });
    }

    private boolean isDesignNameBlank() {
        return this.m_dataSourceDesignName == null || this.m_dataSourceDesignName.length() == 0;
    }

    private String validateAndGetErrorMessage() {
        if (this.m_designNameValidator != null) {
            try {
                if (this.m_designNameValidator.isValid(this.m_dataSourceDesignName)) {
                    return null;
                }
                return Messages.profilePage_error_invalidName;
            }
            catch (OdaException ex) {
                return ex.getMessage();
            }
        }
        return null;
    }

    private void enableDataSourceNameEditor(boolean bool) {
        this.m_dataSourceNameLabel.setEnabled(bool);
        this.m_dataSourceDesignNameControl.setEnabled(bool);
    }

    private void setDataSourceNameEditorVisible(boolean visible) {
        this.m_useDefaultDSNameCheckBox.setVisible(visible);
        this.m_dataSourceNameLabel.setVisible(visible);
        this.m_dataSourceDesignNameControl.setVisible(visible);
    }

    private boolean inEditMode() {
        return this.m_propertyPage != null;
    }

    private boolean hasConnectionProfilePath() {
        return this.getConnProfilePathControlText().trim().length() > 0;
    }

    private void setConnProfilePathControlText(String text) {
        String localizedText = TextProcessorWrapper.process(text);
        this.m_connectionProfilePath.setText(localizedText);
    }

    private String getConnProfilePathControlText() {
        String localizedText = this.m_connectionProfilePath.getText();
        return TextProcessorWrapper.deprocess(localizedText);
    }

    static /* synthetic */ void access$200(ProfileSelectionPageHelper x0) {
        x0.populateTree();
    }

    static /* synthetic */ boolean access$500(ProfileSelectionPageHelper x0) {
        return x0.hasConnectionProfilePath();
    }

    static {
        $assertionsDisabled = !ProfileSelectionPageHelper.class.desiredAssertionStatus();
    }
}

