/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.designsession;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignSessionUtilBase;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.OdaProfileUIExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetUIElement;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetEditorPage;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizard;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class DataSetDesignSessionBase {
    private OdaDesignSession m_odaDesign;
    private String m_odaDataSourceId;
    private DataSetUIElement m_dataSetUIElement;
    private DataSetWizard m_wizard;
    private ArrayList m_editorPages;

    protected DataSetDesignSessionBase(OdaDesignSession odaDesign) throws OdaException {
        this.initOdaDesign(odaDesign);
    }

    protected void restartNewDesign(String newDataSetName, String odaDataSetId, DataSourceDesign dataSourceDesign) throws OdaException {
        if (this.m_odaDesign != null && odaDataSetId.equalsIgnoreCase(this.m_odaDesign.getRequestDataSetDesign().getOdaExtensionDataSetId()) && EcoreUtil.equals((EObject)dataSourceDesign, (EObject)this.m_odaDesign.getRequestDataSourceDesign())) {
            this.m_odaDesign.getRequestDataSetDesign().setName(newDataSetName);
            return;
        }
        OdaDesignSession odaDesign = DesignSessionUtilBase.createNewDataSetRequestSession(newDataSetName, odaDataSetId, dataSourceDesign);
        this.initOdaDesign(odaDesign);
        this.disposePages();
        this.initWizard();
    }

    protected void initWizard() throws OdaException {
        DataSetWizard wizard = this.getExtendedWizard();
        wizard.initialize(this.m_odaDesign, this.m_dataSetUIElement);
    }

    private void initOdaDesign(OdaDesignSession odaDesign) throws OdaException {
        this.m_odaDesign = odaDesign;
        DataSetDesign dataSetDesign = odaDesign.getRequestDataSetDesign();
        this.m_odaDataSourceId = dataSetDesign.getOdaExtensionDataSourceId();
        this.m_dataSetUIElement = DesignSessionUtilBase.getDataSetUIElement(this.m_odaDataSourceId, dataSetDesign.getOdaExtensionDataSetId());
    }

    protected DesignSessionRequest getRequest() {
        if (this.m_odaDesign == null) {
            return null;
        }
        return this.m_odaDesign.getRequest();
    }

    protected OdaDesignSession finish() throws OdaException {
        if (this.m_odaDesign == null) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        OdaDesignSession finishedSession = this.finishDataSetDesign();
        this.m_odaDesign = null;
        this.disposePages();
        return finishedSession;
    }

    protected OdaDesignSession cancel() throws IllegalStateException {
        if (this.m_odaDesign == null) {
            throw new IllegalStateException(Messages.common_notInDesignSession);
        }
        this.m_odaDesign.setResponseInCancelledState();
        OdaDesignSession cancelledSession = this.m_odaDesign;
        this.m_odaDesign = null;
        this.disposePages();
        return cancelledSession;
    }

    protected IWizard getNewWizard() throws OdaException {
        return this.getExtendedWizard();
    }

    protected IWizardPage getWizardStartingPage() throws OdaException {
        return this.getNewWizard().getStartingPage();
    }

    protected DataSetWizard getExtendedWizard() throws OdaException {
        if (this.m_odaDesign == null) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        if (this.m_wizard == null) {
            this.m_wizard = OdaProfileUIExplorer.getInstance().getDataSetWizard(this.m_odaDataSourceId, this.m_dataSetUIElement);
        }
        return this.m_wizard;
    }

    protected DataSetEditorPage[] getEditorPages() throws OdaException {
        ArrayList editorPages = this.getExtendedEditorPages();
        return editorPages.toArray(new DataSetEditorPage[editorPages.size()]);
    }

    protected ArrayList getExtendedEditorPages() throws OdaException {
        if (this.m_odaDesign == null) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        if (this.m_editorPages != null) {
            return this.m_editorPages;
        }
        IWizardPage[] pages = this.getExtendedWizard().getPages();
        this.m_editorPages = new ArrayList(pages.length);
        for (int i = 0; i < pages.length; ++i) {
            if (!(pages[i] instanceof DataSetWizardPage)) continue;
            this.m_editorPages.add(new DataSetEditorPage((DataSetWizardPage)pages[i]));
        }
        return this.m_editorPages;
    }

    protected IAdaptable getEditorPageElement() throws OdaException {
        if (this.m_odaDesign == null) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        DataSetDesign dataSetDesign = this.m_odaDesign.getRequestDataSetDesign();
        return (IAdaptable)EcoreUtil.copy((EObject)dataSetDesign);
    }

    protected OdaDesignSession finishDataSetDesign() throws OdaException {
        DataSetWizard wizard = this.getExtendedWizard();
        return wizard.getResponseSession();
    }

    private void disposePages() {
        if (this.m_wizard != null) {
            this.m_wizard.dispose();
            this.m_wizard = null;
        }
        if (this.m_editorPages != null) {
            int numPages = this.m_editorPages.size();
            for (int i = 0; i < numPages; ++i) {
                DataSetEditorPage page = (DataSetEditorPage)((Object)this.m_editorPages.get(i));
                page.dispose();
            }
            this.m_editorPages = null;
        }
    }
}

