/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile;

import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSourceDesignSessionBase;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelection;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionPageHelper;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProfileSelectionEditorPage
extends DataSourceEditorPage {
    private ProfileSelection m_initProfileSelection;
    private ProfileSelectionPageHelper m_pageHelper;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProfileSelectionEditorPage() {
        this.setMessage(Messages.profilePage_pageTitle);
    }

    protected void createAndInitCustomControl(Composite parent, Properties profileProps) {
        if (this.m_pageHelper == null) {
            this.m_pageHelper = new ProfileSelectionPageHelper((PropertyPage)this);
        }
        this.m_pageHelper.createControl(parent);
        this.m_pageHelper.initControl(this.getInitializeProfileSelection());
        this.setPingButtonVisible(false);
        if (!this.isEditableSessionRequested()) {
            this.getControl().setEnabled(false);
        }
    }

    private ProfileSelection getInitializeProfileSelection() {
        if (this.m_initProfileSelection == null) {
            DataSourceDesign design = this.getEditingDataSource();
            this.m_initProfileSelection = new ProfileSelection(design.getOdaExtensionDataSourceId(), design.getName(), this.createProfileRef(design));
        }
        return this.m_initProfileSelection;
    }

    private DataSourceDesignSessionBase.ProfileReferenceBase createProfileRef(DataSourceDesign design) {
        String profileInstanceName = design.getLinkedProfileName();
        if (profileInstanceName == null || profileInstanceName.length() == 0) {
            return null;
        }
        return new DataSourceDesignSessionBase.ProfileReferenceBase(profileInstanceName, design.getLinkedProfileStoreFilePath(), true);
    }

    public String getTitle() {
        return Messages.profilePage_pageLabel;
    }

    public OdaDesignSession getEditSessionResponse() throws OdaException {
        OdaDesignSession responseSession = super.getEditSessionResponse();
        if (!$assertionsDisabled && responseSession.getResponse() == null) {
            throw new AssertionError();
        }
        if (responseSession.getResponse().getSessionStatus() == SessionStatus.OK_LITERAL) {
            this.collectDataSourceDesign(responseSession.getResponseDataSourceDesign());
        }
        return responseSession;
    }

    public Properties collectCustomProperties(Properties candidateProps) {
        DataSourceDesignSessionBase.ProfileReferenceBase profileRef = this.collectEditedProfileRef();
        if (profileRef == null) {
            return candidateProps;
        }
        Properties selectedProfileProps = profileRef.getProfileInstance().getBaseProperties();
        if (selectedProfileProps != null) {
            candidateProps.putAll((Map<?, ?>)selectedProfileProps);
        }
        return candidateProps;
    }

    protected DataSourceDesign collectDataSourceDesign(DataSourceDesign design) {
        DataSourceDesignSessionBase.ProfileReferenceBase profileRef = this.collectEditedProfileRef();
        if (profileRef != null && profileRef.maintainExternalLink()) {
            design.setLinkedProfileName(profileRef.getName());
            design.setLinkedProfileStoreFile(profileRef.getStorageFile());
        } else {
            design.setLinkedProfileName(null);
            design.setLinkedProfileStoreFile(null);
        }
        return design;
    }

    private DataSourceDesignSessionBase.ProfileReferenceBase collectEditedProfileRef() {
        if (this.m_pageHelper == null) {
            return null;
        }
        ProfileSelection selectedProfile = this.m_pageHelper.collectProfileSelection();
        if (selectedProfile == null) {
            return null;
        }
        return selectedProfile.getProfileRef();
    }

    static {
        $assertionsDisabled = !ProfileSelectionEditorPage.class.desiredAssertionStatus();
    }
}

