/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.AdaptableDataSourceProfile;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;

public class DesignerUtil {
    private DesignerUtil() {
    }

    public static AdaptableDataSourceProfile getAdaptableDataSourceDesign(OdaDesignSession designSession) throws OdaException {
        if (designSession == null) {
            throw new OdaException(Messages.common_nullArgument);
        }
        DataSourceDesign dataSourceDesign = designSession.getRequestDataSourceDesign();
        if (dataSourceDesign == null) {
            throw new OdaException(Messages.common_missingDataSourceDesign);
        }
        DataSourceDesign editDataSourceDesign = (DataSourceDesign)EcoreUtil.copy((EObject)dataSourceDesign);
        return new AdaptableDataSourceProfile(editDataSourceDesign);
    }

    static Object createInstanceWithStringArg(String pluginId, String className, String argument) throws RuntimeException {
        Object newInstance = null;
        try {
            Bundle bundle = Platform.getBundle((String)pluginId);
            Class loadedClass = bundle.loadClass(className);
            Class[] argTypes = new Class[]{String.class};
            Constructor ct = loadedClass.getConstructor(argTypes);
            Object[] argList = new Object[]{argument};
            newInstance = ct.newInstance(argList);
        }
        catch (Exception ex) {
            throw new RuntimeException(Messages.bind((String)Messages.common_createClassFailed, (Object)className), ex);
        }
        return newInstance;
    }

    public static void enableAllControls(Control parent, boolean enabled, Button preservedButton) {
        if (parent == null) {
            return;
        }
        if (preservedButton != null && preservedButton.isDisposed()) {
            preservedButton = null;
        }
        boolean isButtonEnabled = preservedButton != null ? preservedButton.isEnabled() : true;
        DesignerUtil.enableAllControls(parent, enabled);
        if (preservedButton != null) {
            preservedButton.setEnabled(isButtonEnabled);
            preservedButton.getParent().setEnabled(isButtonEnabled);
            parent.setEnabled(isButtonEnabled);
        } else {
            parent.setEnabled(isButtonEnabled);
        }
    }

    public static void enableAllControls(Control aControl, boolean enabled) {
        if (aControl == null) {
            return;
        }
        if (aControl instanceof Composite) {
            Control[] childControls = ((Composite)aControl).getChildren();
            for (int i = 0; i < childControls.length; ++i) {
                DesignerUtil.enableAllControls(childControls[i], enabled);
            }
        }
        if (!aControl.isDisposed()) {
            aControl.setEnabled(enabled);
        }
    }
}

