/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConfigurationType;
import org.eclipse.datatools.connectivity.IConnectListener;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.internal.UUID;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;

public class AdaptableDataSourceProfile
extends PlatformObject
implements IConnectionProfile {
    private DataSourceDesign m_dataSourceDesign;
    private IConnectionProfile m_linkedProfile;
    private String m_instanceID;

    public AdaptableDataSourceProfile(DataSourceDesign design) throws OdaException {
        this.m_dataSourceDesign = design;
        this.m_linkedProfile = DesignSessionUtil.getLinkedProfile(design);
    }

    protected AdaptableDataSourceProfile() {
        this.m_dataSourceDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
    }

    public DataSourceDesign getDataSourceDesign() {
        return this.m_dataSourceDesign;
    }

    public boolean hasLinkedProfile() {
        return this.m_linkedProfile != null;
    }

    public IConnectionProfile getLinkedProfile() {
        return this.m_linkedProfile;
    }

    public String getName() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getName();
        }
        return this.getDataSourceDesign().getName();
    }

    public String getDescription() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getDescription();
        }
        return this.getDataSourceDesign().getDisplayName();
    }

    public boolean isAutoConnect() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().isAutoConnect();
        }
        return false;
    }

    public String getInstanceID() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getInstanceID();
        }
        if (this.m_instanceID == null) {
            this.m_instanceID = UUID.createUUID().toString();
        }
        return this.m_instanceID;
    }

    public IConnectionProfile getParentProfile() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getParentProfile();
        }
        return null;
    }

    public Properties getBaseProperties() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getBaseProperties();
        }
        return DesignUtil.convertDataSourceProperties((DataSourceDesign)this.getDataSourceDesign());
    }

    public void setBaseProperties(Properties props) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().setBaseProperties(props);
            return;
        }
        String dataSourceElmtId = this.getDataSourceDesign().getOdaExtensionDataSourceId();
        if (dataSourceElmtId == null) {
            return;
        }
        try {
            this.getDataSourceDesign().setPublicProperties(DesignSessionUtil.createDataSourcePublicProperties(dataSourceElmtId, props));
            this.getDataSourceDesign().setPrivateProperties(DesignSessionUtil.createDataSourceNonPublicProperties(dataSourceElmtId, props));
        }
        catch (OdaException e) {
            return;
        }
    }

    public Properties getProperties(String type) {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getProperties(type);
        }
        return this.getBaseProperties();
    }

    public void setProperties(String type, Properties props) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().setProperties(type, props);
            return;
        }
        this.setBaseProperties(props);
    }

    public void setConnected(boolean connected) {
        if (this.hasLinkedProfile()) {
            if (connected) {
                this.getLinkedProfile().connect();
            } else {
                this.getLinkedProfile().disconnect();
            }
            return;
        }
    }

    public boolean isConnected() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().isConnected();
        }
        return false;
    }

    public IStatus connect() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().connect();
        }
        return null;
    }

    public void connect(IJobChangeListener listener) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().connect(listener);
            return;
        }
    }

    public IStatus disconnect() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().disconnect();
        }
        return null;
    }

    public void disconnect(IJobChangeListener listener) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().disconnect(listener);
            return;
        }
    }

    public void addConnectListener(IConnectListener listener) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().addConnectListener(listener);
            return;
        }
    }

    public void removeConnectListener(IConnectListener listener) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().removeConnectListener(listener);
            return;
        }
    }

    public IManagedConnection getManagedConnection(String type) {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getManagedConnection(type);
        }
        return null;
    }

    public void addPropertySetListener(IPropertySetListener listener) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().addPropertySetListener(listener);
            return;
        }
    }

    public void removePropertySetListener(IPropertySetListener listener) {
        if (this.hasLinkedProfile()) {
            this.getLinkedProfile().removePropertySetListener(listener);
            return;
        }
    }

    public String getProviderName() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getProviderName();
        }
        return this.getDataSourceDesign().getOdaExtensionDataSourceId();
    }

    public String getProviderId() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getProviderId();
        }
        return this.getDataSourceDesign().getOdaExtensionDataSourceId();
    }

    public ICategory getCategory() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getCategory();
        }
        return null;
    }

    public IConfigurationType getConfigurationType() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getConfigurationType();
        }
        return null;
    }

    public Map getProfileExtensions() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getProfileExtensions();
        }
        return null;
    }

    public IConnection createConnection(String factory) {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().createConnection(factory);
        }
        return null;
    }

    public IConnection createConnection(String factoryId, String uid, String pwd) {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().createConnection(factoryId, uid, pwd);
        }
        return null;
    }

    public IConnectionProfileProvider getProvider() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().getProvider();
        }
        return null;
    }

    public boolean arePropertiesComplete() {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().arePropertiesComplete();
        }
        return true;
    }

    public boolean arePropertiesComplete(String type) {
        if (this.hasLinkedProfile()) {
            return this.getLinkedProfile().arePropertiesComplete(type);
        }
        return true;
    }
}

