/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.ClobReader;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;

public class OdaClob
extends OdaDriverObject
implements IClob {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String COMMA_SEPARATOR = ", ";

    protected OdaClob(IClob clob, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)clob, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaClob( Clob , " + connection + " )\t";
        this.logMethodCalled(context);
    }

    private IClob getDriverClob() {
        return (IClob)this.getObject();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reader getCharacterStream() throws OdaException {
        this.logMethodCalled("OdaClob.getCharacterStream()\t");
        try {
            Reader reader;
            try {
                this.setContextClassloader();
                Reader ret = this.getDriverClob().getCharacterStream();
                this.logMethodExitWithReturn("OdaClob.getCharacterStream()\t", ret);
                reader = ret;
                Object var2_6 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IClob.getCharacterStream()");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var2_7 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return reader;
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSubString(long position, int length) throws OdaException {
        String context = "OdaClob.getSubString( " + position + COMMA_SEPARATOR + length + " )\t";
        this.logMethodCalled(context);
        String ret = null;
        try {
            String string;
            try {
                this.setContextClassloader();
                ret = this.getDriverClob().getSubString(position, length);
                this.logMethodExitWithReturnLen(context, ret);
                string = ret;
                Object var7_7 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block7: {
                    ret = this.getSubStringFromReader(position, length);
                    if (ret != null) {
                        this.logMethodExitWithReturnLen(context, ret);
                        String string2 = ret;
                        Object var7_9 = null;
                        this.resetContextClassloader();
                        return string2;
                    }
                    this.handleUnsupportedOp(uoException, "IClob.getSubString()");
                    break block7;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block7;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var7_8 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return string;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long length() throws OdaException {
        long l;
        this.logMethodCalled("OdaClob.length()\t");
        try {
            try {
                this.setContextClassloader();
                long ret = this.getDriverClob().length();
                this.logMethodExitWithReturn("OdaClob.length()\t", ret);
                l = ret;
                Object var3_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                long l2 = this.handleUnsupportedOpAndRetZero(uoException, "IClob.length()");
                Object var3_10 = null;
                this.resetContextClassloader();
                return l2;
            }
            catch (RuntimeException rtException) {
                long l3 = this.handleErrorAndReturnZero(rtException);
                Object var3_11 = null;
                this.resetContextClassloader();
                return l3;
            }
            catch (OdaException odaException) {
                long l4 = this.handleErrorAndReturnZero(odaException);
                Object var3_12 = null;
                this.resetContextClassloader();
                return l4;
            }
        }
        catch (Throwable throwable) {
            Object var3_13 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSubStringFromReader(long startPos, int length) {
        String context = "OdaClob.getSubStringFromReader( " + startPos + COMMA_SEPARATOR + length + " )\t";
        String ret = null;
        try {
            try {
                this.setContextClassloader();
                ClobReader reader = new ClobReader(this, this.getReaderBufferSize());
                ret = reader.getSubString(startPos, length);
            }
            catch (RuntimeException rte) {
                this.handleError(rte);
            }
            catch (IOException e) {
                this.log(context, e.toString());
            }
            catch (OdaException ex) {
                this.log(context, ex.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        this.resetContextClassloader();
        return ret;
    }

    protected int getReaderBufferSize() {
        return 2048;
    }
}

