/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IParameterRowSet;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaBlob;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaClob;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaQuery;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSet;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaRowSet;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;

public class OdaAdvancedQuery
extends OdaQuery
implements IAdvancedQuery {
    private boolean m_calledExecuteQueryForExecute = false;
    private IResultSet m_resultSet;
    static /* synthetic */ Class class$0;

    protected OdaAdvancedQuery(IAdvancedQuery statement, OdaConnection connection, String dataSetType, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((IQuery)statement, connection, dataSetType, switchContextClassloader, driverClassLoader);
        String context = "OdaAdvancedQuery.OdaAdvancedQuery( " + statement + ", " + connection + ", " + dataSetType + " )\t";
        this.logMethodExitWithReturn(context, this);
    }

    private IAdvancedQuery getAdvancedQuery() {
        return (IAdvancedQuery)this.getQuery();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute() throws OdaException {
        boolean bl;
        this.logMethodCalled("OdaAdvancedQuery.execute()\t");
        try {
            try {
                this.setContextClassloader();
                this.doExecute();
                this.logMethodExitWithReturn("OdaAdvancedQuery.execute()\t", this.isExecuted());
                bl = this.isExecuted();
                Object var2_5 = null;
            }
            catch (UnsupportedOperationException uoException) {
                boolean bl2 = this.handleUnsupportedOpAndRetFalse(uoException, "IAdvancedQuery.execute()");
                Object var2_6 = null;
                this.resetContextClassloader();
                return bl2;
            }
            catch (RuntimeException rtException) {
                boolean bl3 = this.handleErrorAndReturnFalse(rtException);
                Object var2_7 = null;
                this.resetContextClassloader();
                return bl3;
            }
            catch (OdaException odaException) {
                boolean bl4 = this.handleErrorAndReturnFalse(odaException);
                Object var2_8 = null;
                this.resetContextClassloader();
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var2_9 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return bl;
    }

    private boolean doExecute() throws OdaException {
        this.resetExecuteStates();
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotExecuteBeforePrepare);
        }
        boolean supportsMultipleResultSets = this.getDSMetaData().checkSupportForMultipleResultSets();
        boolean supportsNamedResultSets = this.getDSMetaData().checkSupportForNamedResultSets();
        boolean isExecuted = false;
        if (supportsMultipleResultSets || supportsNamedResultSets) {
            isExecuted = this.getAdvancedQuery().execute();
        } else {
            this.m_resultSet = this.getQuery().executeQuery();
            this.m_calledExecuteQueryForExecute = true;
            isExecuted = true;
        }
        this.setIsExecuted(isExecuted);
        return isExecuted;
    }

    private boolean wasExecuteQueryCalledForExec() {
        return this.m_calledExecuteQueryForExecute;
    }

    protected void resetExecuteStates() {
        super.resetExecuteStates();
        this.m_calledExecuteQueryForExecute = false;
        this.m_resultSet = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResultSet getResultSet() throws OdaException {
        this.logMethodCalled("OdaAdvancedQuery.getResultSet()\t");
        try {
            OdaResultSet odaResultSet;
            try {
                this.setContextClassloader();
                OdaResultSet ret = null;
                if (this.m_calledExecuteQueryForExecute) {
                    ret = this.m_resultSet == null ? null : this.newResultSetHelper(this.m_resultSet);
                    this.m_resultSet = null;
                } else {
                    IResultSet resultSet = this.getAdvancedQuery().getResultSet();
                    ret = resultSet == null ? null : this.newResultSetHelper(resultSet);
                }
                this.logMethodExitWithReturn("OdaAdvancedQuery.getResultSet()\t", ret);
                odaResultSet = ret;
                Object var3_7 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getResultSet()");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var3_8 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaResultSet;
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getMoreResults() throws OdaException {
        boolean bl;
        this.logMethodCalled("OdaAdvancedQuery.getMoreResults()\t");
        try {
            try {
                this.setContextClassloader();
                boolean ret = this.m_calledExecuteQueryForExecute ? false : this.getAdvancedQuery().getMoreResults();
                this.logMethodExitWithReturn("OdaAdvancedQuery.getMoreResults()\t", ret);
                bl = ret;
                Object var2_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                boolean bl2 = this.handleUnsupportedOpAndRetFalse(uoException, "IAdvancedQuery.getMoreResults()");
                Object var2_10 = null;
                this.resetContextClassloader();
                return bl2;
            }
            catch (RuntimeException rtException) {
                boolean bl3 = this.handleErrorAndReturnFalse(rtException);
                Object var2_11 = null;
                this.resetContextClassloader();
                return bl3;
            }
            catch (OdaException odaException) {
                boolean bl4 = this.handleErrorAndReturnFalse(odaException);
                Object var2_12 = null;
                this.resetContextClassloader();
                return bl4;
            }
        }
        catch (Throwable throwable) {
            Object var2_13 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResultSetMetaData getMetaDataOf(String resultSetName) throws OdaException {
        String context = "OdaAdvancedQuery.getMetaDataOf( " + resultSetName + " )\t";
        this.logMethodCalled(context);
        try {
            OdaResultSetMetaData odaResultSetMetaData;
            try {
                this.setContextClassloader();
                IResultSetMetaData resultSetMetaData = this.getAdvancedQuery().getMetaDataOf(resultSetName);
                OdaResultSetMetaData ret = resultSetMetaData == null ? null : new OdaResultSetMetaData(resultSetMetaData, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
                this.logMethodExitWithReturn(context, ret);
                odaResultSetMetaData = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getMetaDataOf( String resultSetName )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaResultSetMetaData;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getResultSetNames() throws OdaException {
        this.logMethodCalled("OdaAdvancedQuery.getResultSetNames()\t");
        try {
            String[] stringArray;
            try {
                this.setContextClassloader();
                String[] ret = this.getAdvancedQuery().getResultSetNames();
                this.logMethodExitWithReturn("OdaAdvancedQuery.getResultSetNames()\t", ret);
                stringArray = ret;
                Object var2_6 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getResultSetNames()");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var2_7 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var2_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResultSet getResultSet(String resultSetName) throws OdaException {
        String context = "OdaAdvancedQuery.getResultSet( " + resultSetName + " )\t";
        this.logMethodCalled(context);
        try {
            OdaResultSet odaResultSet;
            try {
                this.setContextClassloader();
                if (this.wasExecuteQueryCalledForExec()) {
                    throw this.newOdaException(Messages.helper_cannotGetNamedResultsAfterExecuteQuery);
                }
                IResultSet resultSet = this.getAdvancedQuery().getResultSet(resultSetName);
                OdaResultSet ret = null;
                ret = resultSet == null ? null : this.newResultSetHelper(resultSet);
                this.logMethodExitWithReturn(context, ret);
                odaResultSet = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block7: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getResultSet( String resultSetName )");
                    break block7;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block7;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaResultSet;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IParameterRowSet setNewRow(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRow( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            OdaRowSet odaRowSet;
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                IParameterRowSet rowSet = this.getAdvancedQuery().setNewRow(parameterName);
                OdaRowSet ret = this.createFactoryRow(rowSet);
                this.logMethodExitWithReturn(context, ret);
                odaRowSet = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRow( String parameterName )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaRowSet;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IParameterRowSet setNewRow(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRow( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            OdaRowSet odaRowSet;
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                IParameterRowSet rowSet = this.getAdvancedQuery().setNewRow(parameterId);
                OdaRowSet ret = this.createFactoryRow(rowSet);
                this.logMethodExitWithReturn(context, ret);
                odaRowSet = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRow( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaRowSet;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IParameterRowSet setNewRowSet(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRowSet( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            OdaRowSet odaRowSet;
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                IParameterRowSet rowSet = this.getAdvancedQuery().setNewRowSet(parameterName);
                OdaRowSet ret = rowSet == null ? null : new OdaRowSet(rowSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
                this.logMethodExitWithReturn(context, ret);
                odaRowSet = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRowSet( String parameterName )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaRowSet;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IParameterRowSet setNewRowSet(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.setNewRowSet( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            OdaRowSet odaRowSet;
            try {
                this.setContextClassloader();
                this.throwIfSetParamBeforePrepare();
                IParameterRowSet rowSet = this.getAdvancedQuery().setNewRowSet(parameterId);
                OdaRowSet ret = rowSet == null ? null : new OdaRowSet(rowSet, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
                this.logMethodExitWithReturn(context, ret);
                odaRowSet = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.setNewRowSet( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaRowSet;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInt(String parameterName) throws OdaException {
        int n;
        String context = "OdaAdvancedQuery.getInt( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                int ret = 0;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    ret = this.getAdvancedQuery().getInt(parameterName);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    ret = this.getAdvancedQuery().getInt(index);
                }
                this.logMethodExitWithReturn(context, ret);
                n = ret;
                Object var5_12 = null;
            }
            catch (UnsupportedOperationException uoException) {
                int n2 = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.getInt( String parameterName )");
                Object var5_13 = null;
                this.resetContextClassloader();
                return n2;
            }
            catch (RuntimeException rtException) {
                int n3 = this.handleErrorAndReturnZero(rtException);
                Object var5_14 = null;
                this.resetContextClassloader();
                return n3;
            }
            catch (OdaException odaException) {
                int n4 = this.handleErrorAndReturnZero(odaException);
                Object var5_15 = null;
                this.resetContextClassloader();
                return n4;
            }
        }
        catch (Throwable throwable) {
            Object var5_16 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getInt(int parameterId) throws OdaException {
        int n;
        String context = "OdaAdvancedQuery.getInt( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                int ret = this.getAdvancedQuery().getInt(parameterId);
                this.logMethodExitWithReturn(context, ret);
                n = ret;
                Object var4_11 = null;
            }
            catch (UnsupportedOperationException uoException) {
                int n2 = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.getInt( int parameterId )");
                Object var4_12 = null;
                this.resetContextClassloader();
                return n2;
            }
            catch (RuntimeException rtException) {
                int n3 = this.handleErrorAndReturnZero(rtException);
                Object var4_13 = null;
                this.resetContextClassloader();
                return n3;
            }
            catch (OdaException odaException) {
                int n4 = this.handleErrorAndReturnZero(odaException);
                Object var4_14 = null;
                this.resetContextClassloader();
                return n4;
            }
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return n;
    }

    /*
     * Exception decompiling
     */
    public double getDouble(String parameterName) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public double getDouble(int parameterId) throws OdaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBigDecimal(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimal( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            block9: {
                BigDecimal bigDecimal;
                try {
                    this.setContextClassloader();
                    this.throwIfNotExecuted();
                    BigDecimal ret = null;
                    if (this.getDSMetaData().checkSupportForNamedParameters()) {
                        ret = this.getAdvancedQuery().getBigDecimal(parameterName);
                    } else {
                        int index = this.getAdvancedQuery().findOutParameter(parameterName);
                        ret = this.getAdvancedQuery().getBigDecimal(index);
                    }
                    this.logMethodExitWithReturn(context, ret);
                    bigDecimal = ret;
                    Object var5_9 = null;
                }
                catch (UnsupportedOperationException uoException) {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBigDecimal( String parameterName )");
                    break block9;
                }
                catch (RuntimeException rtException) {
                    this.handleError(rtException);
                    break block9;
                }
                catch (OdaException odaException) {
                    this.handleError(odaException);
                }
                this.resetContextClassloader();
                return bigDecimal;
            }
            Object var5_11 = null;
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBigDecimal(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimal( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            block7: {
                BigDecimal bigDecimal;
                try {
                    this.setContextClassloader();
                    this.throwIfNotExecuted();
                    BigDecimal ret = this.getAdvancedQuery().getBigDecimal(parameterId);
                    this.logMethodExitWithReturn(context, ret);
                    bigDecimal = ret;
                    Object var4_8 = null;
                }
                catch (UnsupportedOperationException uoException) {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBigDecimal( int parameterId )");
                    break block7;
                }
                catch (RuntimeException rtException) {
                    this.handleError(rtException);
                    break block7;
                }
                catch (OdaException odaException) {
                    this.handleError(odaException);
                }
                this.resetContextClassloader();
                return bigDecimal;
            }
            Object var4_10 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(String parameterName) throws OdaException {
        String string;
        String context = "OdaAdvancedQuery.getString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                String ret = null;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    ret = this.getAdvancedQuery().getString(parameterName);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    ret = this.getAdvancedQuery().getString(index);
                }
                this.logMethodExitWithReturn(context, ret);
                string = ret;
                Object var5_12 = null;
            }
            catch (UnsupportedOperationException uoException) {
                String string2 = this.handleUnsupportedOpAndRetEmptyString(uoException, "IAdvancedQuery.getString( String parameterName )");
                Object var5_13 = null;
                this.resetContextClassloader();
                return string2;
            }
            catch (RuntimeException rtException) {
                String string3 = this.handleErrorAndReturnEmptyString(rtException);
                Object var5_14 = null;
                this.resetContextClassloader();
                return string3;
            }
            catch (OdaException odaException) {
                String string4 = this.handleErrorAndReturnEmptyString(odaException);
                Object var5_15 = null;
                this.resetContextClassloader();
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var5_16 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getString(int parameterId) throws OdaException {
        String string;
        String context = "OdaAdvancedQuery.getString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                String ret = this.getAdvancedQuery().getString(parameterId);
                this.logMethodExitWithReturn(context, ret);
                string = ret;
                Object var4_11 = null;
            }
            catch (UnsupportedOperationException uoException) {
                String string2 = this.handleUnsupportedOpAndRetEmptyString(uoException, "IAdvancedQuery.getString( int parameterId )");
                Object var4_12 = null;
                this.resetContextClassloader();
                return string2;
            }
            catch (RuntimeException rtException) {
                String string3 = this.handleErrorAndReturnEmptyString(rtException);
                Object var4_13 = null;
                this.resetContextClassloader();
                return string3;
            }
            catch (OdaException odaException) {
                String string4 = this.handleErrorAndReturnEmptyString(odaException);
                Object var4_14 = null;
                this.resetContextClassloader();
                return string4;
            }
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getDate(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getDate( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            Date date;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                Date ret = null;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    ret = this.getAdvancedQuery().getDate(parameterName);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    ret = this.getAdvancedQuery().getDate(index);
                }
                this.logMethodExitWithReturn(context, ret);
                date = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getDate( String parameterName )");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return date;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getDate(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getDate( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            Date date;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                Date ret = this.getAdvancedQuery().getDate(parameterId);
                this.logMethodExitWithReturn(context, ret);
                date = ret;
                Object var4_8 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getDate( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var4_9 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return date;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Time getTime(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTime( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            Time time;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                Time ret = null;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    ret = this.getAdvancedQuery().getTime(parameterName);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    ret = this.getAdvancedQuery().getTime(index);
                }
                this.logMethodExitWithReturn(context, ret);
                time = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTime( String parameterName )");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return time;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Time getTime(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTime( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            Time time;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                Time ret = this.getAdvancedQuery().getTime(parameterId);
                this.logMethodExitWithReturn(context, ret);
                time = ret;
                Object var4_8 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTime( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var4_9 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return time;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getTimestamp(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestamp( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            Timestamp timestamp;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                Timestamp ret = null;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    ret = this.getAdvancedQuery().getTimestamp(parameterName);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    ret = this.getAdvancedQuery().getTimestamp(index);
                }
                this.logMethodExitWithReturn(context, ret);
                timestamp = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTimestamp( String parameterName )");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return timestamp;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getTimestamp(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestamp( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            Timestamp timestamp;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                Timestamp ret = this.getAdvancedQuery().getTimestamp(parameterId);
                this.logMethodExitWithReturn(context, ret);
                timestamp = ret;
                Object var4_8 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getTimestamp( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var4_9 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return timestamp;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBlob getBlob(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBlob( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            IBlob iBlob;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                IBlob driverBlob = null;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    driverBlob = this.getAdvancedQuery().getBlob(parameterName);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    driverBlob = this.getAdvancedQuery().getBlob(index);
                }
                IBlob ret = this.createBlobWrapper(driverBlob);
                this.logMethodExitWithReturn(context, ret);
                iBlob = ret;
                Object var5_10 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBlob( String parameterName )");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_11 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return iBlob;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBlob getBlob(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBlob( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            IBlob iBlob;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                IBlob driverBlob = this.getAdvancedQuery().getBlob(parameterId);
                IBlob ret = this.createBlobWrapper(driverBlob);
                this.logMethodExitWithReturn(context, ret);
                iBlob = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBlob( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return iBlob;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    private IBlob createBlobWrapper(IBlob driverBlob) {
        return driverBlob == null ? null : new OdaBlob(driverBlob, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IClob getClob(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getClob( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            IClob iClob;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                IClob driverClob = null;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    driverClob = this.getAdvancedQuery().getClob(parameterName);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    driverClob = this.getAdvancedQuery().getClob(index);
                }
                IClob ret = this.createClobWrapper(driverClob);
                this.logMethodExitWithReturn(context, ret);
                iClob = ret;
                Object var5_10 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getClob( String parameterName )");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_11 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return iClob;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IClob getClob(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getClob( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            IClob iClob;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                IClob driverClob = this.getAdvancedQuery().getClob(parameterId);
                IClob ret = this.createClobWrapper(driverClob);
                this.logMethodExitWithReturn(context, ret);
                iClob = ret;
                Object var5_9 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getClob( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_10 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return iClob;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    private IClob createClobWrapper(IClob driverClob) {
        return driverClob == null ? null : new OdaClob(driverClob, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBoolean(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBoolean( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            block10: {
                boolean bl;
                try {
                    this.setContextClassloader();
                    this.throwIfNotExecuted();
                    boolean ret = false;
                    if (this.getDSMetaData().checkSupportForNamedParameters()) {
                        ret = this.getAdvancedQuery().getBoolean(parameterName);
                    } else {
                        int index = this.getAdvancedQuery().findOutParameter(parameterName);
                        ret = this.getAdvancedQuery().getBoolean(index);
                    }
                    this.logMethodExitWithReturn(context, ret);
                    bl = ret;
                    Object var5_10 = null;
                }
                catch (AbstractMethodError abstractMethodError) {
                    String msg = this.formatMethodNotImplementedMsg("IAdvancedQuery.getBoolean( String )");
                    this.log(context, msg);
                    this.handleUnsupportedOp(new UnsupportedOperationException(msg), msg);
                    break block10;
                }
                catch (UnsupportedOperationException uoException) {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBoolean( String )");
                    break block10;
                }
                catch (RuntimeException rtException) {
                    this.handleError(rtException);
                    break block10;
                }
                catch (OdaException odaException) {
                    this.handleError(odaException);
                }
                this.resetContextClassloader();
                return bl;
            }
            Object var5_12 = null;
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getBoolean(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBoolean( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            block8: {
                boolean bl;
                try {
                    this.setContextClassloader();
                    this.throwIfNotExecuted();
                    boolean ret = this.getAdvancedQuery().getBoolean(parameterId);
                    this.logMethodExitWithReturn(context, ret);
                    bl = ret;
                    Object var4_9 = null;
                }
                catch (AbstractMethodError abstractMethodError) {
                    String msg = this.formatMethodNotImplementedMsg("IAdvancedQuery.getBoolean( int )");
                    this.log(context, msg);
                    this.handleUnsupportedOp(new UnsupportedOperationException(msg), msg);
                    break block8;
                }
                catch (UnsupportedOperationException uoException) {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getBoolean( int )");
                    break block8;
                }
                catch (RuntimeException rtException) {
                    this.handleError(rtException);
                    break block8;
                }
                catch (OdaException odaException) {
                    this.handleError(odaException);
                }
                this.resetContextClassloader();
                return bl;
            }
            Object var4_11 = null;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IParameterRowSet getRow(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getRow( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            OdaRowSet odaRowSet;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                OdaRowSet ret = null;
                if (this.getDSMetaData().checkSupportForNamedParameters()) {
                    IParameterRowSet rowSet = this.getAdvancedQuery().getRow(parameterName);
                    ret = this.createFactoryRow(rowSet);
                } else {
                    int index = this.getAdvancedQuery().findOutParameter(parameterName);
                    ret = this.doGetRow(index);
                }
                this.logMethodExitWithReturn(context, ret);
                odaRowSet = ret;
                Object var5_10 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block8: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getRow( String parameterName )");
                    break block8;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block8;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var5_11 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaRowSet;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IParameterRowSet getRow(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getRow( " + parameterId + " )\t";
        this.logMethodCalled(context);
        try {
            OdaRowSet odaRowSet;
            try {
                this.setContextClassloader();
                this.throwIfNotExecuted();
                OdaRowSet ret = this.doGetRow(parameterId);
                this.logMethodExitWithReturn(context, ret);
                odaRowSet = ret;
                Object var4_8 = null;
            }
            catch (UnsupportedOperationException uoException) {
                block6: {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getRow( int parameterId )");
                    break block6;
                    catch (RuntimeException rtException) {
                        this.handleError(rtException);
                        break block6;
                    }
                    catch (OdaException odaException) {
                        this.handleError(odaException);
                    }
                }
                Object var4_9 = null;
                this.resetContextClassloader();
                return null;
            }
            this.resetContextClassloader();
            return odaRowSet;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            this.resetContextClassloader();
            throw throwable;
        }
    }

    private OdaRowSet doGetRow(int parameterId) throws OdaException {
        IParameterRowSet rowSet = this.getAdvancedQuery().getRow(parameterId);
        return this.createFactoryRow(rowSet);
    }

    private OdaRowSet createFactoryRow(IParameterRowSet driverRow) throws OdaException {
        OdaRowSet retSet = driverRow == null ? null : new OdaRowSet(driverRow, this.getOdaConnection(), this.switchContextClassloader(), this.getDriverClassLoader());
        return retSet != null && driverRow.absolute(1) ? retSet : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findOutParameter(String parameterName) throws OdaException {
        int n;
        String context = "OdaAdvancedQuery.findOutParameter( " + parameterName + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                if (!this.isPreparedSuccessfully()) {
                    throw this.newOdaException(Messages.helper_cannotGetParamMdBeforePrepare);
                }
                int ret = this.getAdvancedQuery().findOutParameter(parameterName);
                this.logMethodExitWithReturn(context, ret);
                n = ret;
                Object var4_11 = null;
            }
            catch (UnsupportedOperationException uoException) {
                int n2 = this.handleUnsupportedOpAndRetZero(uoException, "IAdvancedQuery.findOutParameter( String parameterName )");
                Object var4_12 = null;
                this.resetContextClassloader();
                return n2;
            }
            catch (RuntimeException rtException) {
                int n3 = this.handleErrorAndReturnZero(rtException);
                Object var4_13 = null;
                this.resetContextClassloader();
                return n3;
            }
            catch (OdaException odaException) {
                int n4 = this.handleErrorAndReturnZero(odaException);
                Object var4_14 = null;
                this.resetContextClassloader();
                return n4;
            }
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean wasNull() throws OdaException {
        boolean bl;
        block9: {
            block8: {
                this.logMethodCalled("OdaAdvancedQuery.wasNull()\t");
                try {
                    try {
                        this.setContextClassloader();
                        if (!this.isExecuted()) {
                            this.logMethodExit("OdaAdvancedQuery.wasNull()\t");
                            Object var2_1 = null;
                            break block8;
                        }
                        boolean ret = this.getAdvancedQuery().wasNull();
                        this.logMethodExitWithReturn("OdaAdvancedQuery.wasNull()\t", ret);
                        bl = ret;
                        break block9;
                    }
                    catch (UnsupportedOperationException uoException) {
                        boolean bl2 = this.handleUnsupportedOpAndRetFalse(uoException, "IAdvancedQuery.wasNull()");
                        Object var2_3 = null;
                        this.resetContextClassloader();
                        return bl2;
                    }
                    catch (RuntimeException rtException) {
                        boolean bl3 = this.handleErrorAndReturnFalse(rtException);
                        Object var2_4 = null;
                        this.resetContextClassloader();
                        return bl3;
                    }
                    catch (OdaException odaException) {
                        boolean bl4 = this.handleErrorAndReturnFalse(odaException);
                        Object var2_5 = null;
                        this.resetContextClassloader();
                        return bl4;
                    }
                }
                catch (Throwable throwable) {
                    Object var2_6 = null;
                    this.resetContextClassloader();
                    throw throwable;
                }
            }
            this.resetContextClassloader();
            return true;
        }
        Object var2_2 = null;
        this.resetContextClassloader();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSortSpec(String resultSetName, SortSpec sortBy) throws OdaException {
        String context = "OdaAdvancedQuery.setSortSpec( " + resultSetName + ", " + sortBy + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                this.setContextClassloader();
                if (!this.isPreparedSuccessfully()) {
                    throw this.newOdaException(Messages.helper_cannotSetSortSpecBeforePrepare);
                }
                this.getAdvancedQuery().setSortSpec(resultSetName, sortBy);
                this.logMethodExit(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.handleUnsupportedOp(uoException, "IAdvancedQuery.setSortSpec( String resultSetName, SortSpec sortBy )");
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.resetContextClassloader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SortSpec getSortSpec(String resultSetName) throws OdaException {
        String context = "OdaAdvancedQuery.getSortSpec( " + resultSetName + " )\t";
        this.logMethodCalled(context);
        try {
            block7: {
                SortSpec sortSpec;
                try {
                    this.setContextClassloader();
                    SortSpec sortSpec2 = this.getAdvancedQuery().getSortSpec(resultSetName);
                    this.logMethodExitWithReturn(context, sortSpec2);
                    sortSpec = sortSpec2;
                    Object var4_8 = null;
                }
                catch (UnsupportedOperationException uoException) {
                    this.handleUnsupportedOp(uoException, "IAdvancedQuery.getSortSpec( String resultSetName )");
                    break block7;
                }
                catch (RuntimeException rtException) {
                    this.handleError(rtException);
                    break block7;
                }
                catch (OdaException odaException) {
                    this.handleError(odaException);
                }
                this.resetContextClassloader();
                return sortSpec;
            }
            Object var4_10 = null;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.resetContextClassloader();
            throw throwable;
        }
        this.resetContextClassloader();
        return null;
    }

    public String getBigDecimalAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimalAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        BigDecimal decimal = this.getBigDecimal(parameterName);
        String ret = decimal == null ? null : decimal.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getBigDecimalAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getBigDecimalAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        BigDecimal decimal = this.getBigDecimal(parameterId);
        String ret = decimal == null ? null : decimal.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getDateAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getDateAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        Date date = this.getDate(parameterName);
        String ret = date == null ? null : date.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getDateAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getDateAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        Date date = this.getDate(parameterId);
        String ret = date == null ? null : date.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimeAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTimeAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        Time time = this.getTime(parameterName);
        String ret = time == null ? null : time.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimeAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTimeAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        Time time = this.getTime(parameterId);
        String ret = time == null ? null : time.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimestampAsString(String parameterName) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestampAsString( " + parameterName + " )\t";
        this.logMethodCalled(context);
        Timestamp timestamp = this.getTimestamp(parameterName);
        String ret = timestamp == null ? null : timestamp.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getTimestampAsString(int parameterId) throws OdaException {
        String context = "OdaAdvancedQuery.getTimestampAsString( " + parameterId + " )\t";
        this.logMethodCalled(context);
        Timestamp timestamp = this.getTimestamp(parameterId);
        String ret = timestamp == null ? null : timestamp.toString();
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getClobAsString(String columnName) throws OdaException {
        String context = "OdaAdvancedQuery.getClobAsString( " + columnName + " )\t";
        this.logMethodCalled(context);
        String ret = this.getClobAsStringImpl(this.getClob(columnName), context);
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getClobAsString(int index) throws OdaException {
        String context = "OdaAdvancedQuery.getClobAsString( " + index + " )\t";
        this.logMethodCalled(context);
        String ret = this.getClobAsStringImpl(this.getClob(index), context);
        this.logMethodExitWithReturn(context, ret);
        return ret;
    }

    public String getInterfaceName() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.connectivity.oda.IAdvancedQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    private void throwIfNotExecuted() throws OdaException {
        if (!this.isExecuted()) {
            throw this.newOdaException(Messages.helper_cannotGetParamBeforeExecute);
        }
    }

    private void throwIfSetParamBeforePrepare() throws OdaException {
        if (!this.isPreparedSuccessfully()) {
            throw this.newOdaException(Messages.helper_cannotSetParamBeforePrepare);
        }
    }
}

