/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.internal.impl;

import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.internal.impl.LogPathHelper;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.TraceLogging;

public class LogConfigHelper {
    private ExtensionManifest m_driverManifest;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LogConfigHelper(ExtensionManifest driverManifest) throws OdaException {
        if (driverManifest == null) {
            throw new OdaException((Throwable)new IllegalArgumentException());
        }
        this.m_driverManifest = driverManifest;
    }

    public LogConfiguration getDriverLogConfiguration() {
        LogConfiguration logOptions = this.createLogConfigFromTraceOptions();
        if (logOptions != null) {
            return logOptions;
        }
        return this.createLogConfigFromTraceLogging();
    }

    private LogConfiguration createLogConfigFromTraceOptions() {
        String pluginId = this.getDriverPluginId();
        String debugOption = pluginId + "/debug";
        String debugOptionValue = Platform.getDebugOption((String)debugOption);
        Boolean isDebug = Boolean.valueOf(debugOptionValue);
        if (isDebug == Boolean.FALSE) {
            return null;
        }
        String logLevelOption = pluginId + "/traceLogging/logLevel";
        int logLevel = TraceLogging.toLogLevelNumber((String)Platform.getDebugOption((String)logLevelOption));
        String logFormatterOption = pluginId + "/traceLogging/logFormatterClass";
        String logFilePrefixOption = pluginId + "/traceLogging/logFileNamePrefix";
        String logDirOption = pluginId + "/traceLogging/logDirectory";
        String logFilenamePrefix = Platform.getDebugOption((String)logFilePrefixOption);
        String logDest = Platform.getDebugOption((String)logDirOption);
        if (this.isNotEmpty(logFilenamePrefix) || this.isNotEmpty(logDest)) {
            logFilenamePrefix = this.getDefaultLogFilenamePrefix(logFilenamePrefix);
            logDest = LogPathHelper.getAbsoluteLogDirName(this.getDefaultLogDirectory(logDest));
        }
        return new LogConfiguration(pluginId, logLevel, logDest, logFilenamePrefix, Platform.getDebugOption((String)logFormatterOption));
    }

    private LogConfiguration createLogConfigFromTraceLogging() {
        ExtensionManifest manifest = this.m_driverManifest;
        if (!$assertionsDisabled && manifest == null) {
            throw new AssertionError();
        }
        TraceLogging loggingElement = manifest.getTraceLogging();
        if (loggingElement == null) {
            return null;
        }
        String logFilenamePrefix = loggingElement.getLogFileNamePrefix();
        String logDest = loggingElement.getLogDirectory();
        if (this.isNotEmpty(logFilenamePrefix) || this.isNotEmpty(logDest)) {
            logFilenamePrefix = this.getDefaultLogFilenamePrefix(logFilenamePrefix);
            logDest = LogPathHelper.getAbsoluteLogDirName(this.getDefaultLogDirectory(logDest));
        }
        return new LogConfiguration(this.getDriverPluginId(), loggingElement.getLogLevel(), logDest, logFilenamePrefix, loggingElement.getLogFormatterClass());
    }

    private String getDefaultLogFilenamePrefix(String prefix) {
        if (this.isNotEmpty(prefix)) {
            return prefix;
        }
        return this.getDriverPluginId();
    }

    private String getDefaultLogDirectory(String logDir) {
        if (this.isNotEmpty(logDir)) {
            return logDir;
        }
        return this.getDriverPluginId();
    }

    private String getDriverPluginId() {
        if (!$assertionsDisabled && this.m_driverManifest == null) {
            throw new AssertionError();
        }
        return this.m_driverManifest.getNamespace();
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private boolean isNotEmpty(String value) {
        return !this.isNullOrEmpty(value);
    }

    static {
        $assertionsDisabled = !LogConfigHelper.class.desiredAssertionStatus();
    }
}

