/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriverObject;

public class OdaClob
extends OdaDriverObject
implements IClob {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final String COMMA_SEPARATOR = ", ";

    protected OdaClob(IClob clob, OdaConnection connection, boolean switchContextClassloader, ClassLoader driverClassLoader) {
        super((Object)clob, connection, switchContextClassloader, driverClassLoader);
        String context = "OdaClob( Clob , " + connection + " )\t";
        this.logMethodCalled(context);
    }

    private IClob getDriverClob() {
        return (IClob)this.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws OdaException {
        String context = "OdaClob.getCharacterStream()\t";
        String unsupportedOpContext = "IClob.getCharacterStream()";
        this.logMethodCalled("OdaClob.getCharacterStream()\t");
        try {
            this.setContextClassloader();
            Reader ret = this.getDriverClob().getCharacterStream();
            this.logMethodExitWithReturn("OdaClob.getCharacterStream()\t", ret);
            Reader reader = ret;
            return reader;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IClob.getCharacterStream()");
            Reader reader = null;
            return reader;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            Reader reader = null;
            return reader;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            Reader reader = null;
            return reader;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long position, int length) throws OdaException {
        String context = "OdaClob.getSubString( " + position + COMMA_SEPARATOR + length + " )\t";
        String unsupportedOpContext = "IClob.getSubString()";
        this.logMethodCalled(context);
        String ret = null;
        try {
            this.setContextClassloader();
            ret = this.getDriverClob().getSubString(position, length);
            this.logMethodExitWithReturnLen(context, ret);
            String string = ret;
            return string;
        }
        catch (UnsupportedOperationException uoException) {
            ret = this.getSubStringFromReader(position, length);
            if (ret == null) {
                this.handleUnsupportedOp(uoException, "IClob.getSubString()");
                String string = null;
                return string;
            }
            this.logMethodExitWithReturnLen(context, ret);
            String string = ret;
            return string;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            String string = null;
            return string;
        }
        catch (OdaException odaException) {
            this.handleError(odaException);
            String string = null;
            return string;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws OdaException {
        String context = "OdaClob.length()\t";
        String unsupportedOpContext = "IClob.length()";
        this.logMethodCalled("OdaClob.length()\t");
        try {
            this.setContextClassloader();
            long ret = this.getDriverClob().length();
            this.logMethodExitWithReturn("OdaClob.length()\t", ret);
            long l = ret;
            return l;
        }
        catch (UnsupportedOperationException uoException) {
            long l = this.handleUnsupportedOpAndRetZero(uoException, "IClob.length()");
            return l;
        }
        catch (RuntimeException rtException) {
            long l = this.handleErrorAndReturnZero(rtException);
            return l;
        }
        catch (OdaException odaException) {
            long l = this.handleErrorAndReturnZero(odaException);
            return l;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubStringFromReader(long startPos, int length) {
        String context = "OdaClob.getSubStringFromReader( " + startPos + COMMA_SEPARATOR + length + " )\t";
        Reader driverReader = null;
        try {
            driverReader = this.getCharacterStream();
        }
        catch (OdaException e1) {
            this.log(context, e1.toString());
            return null;
        }
        String ret = null;
        try {
            this.setContextClassloader();
            ret = this.getSubStringFromReaderImpl(startPos, length, driverReader);
        }
        catch (RuntimeException rte) {
            this.handleError(rte);
        }
        catch (IOException e) {
            this.log(context, e.toString());
        }
        finally {
            this.resetContextClassloader();
        }
        return ret;
    }

    protected int getReaderBufferSize() {
        return 2048;
    }

    private String getSubStringFromReaderImpl(long position, int length, Reader driverReader) throws IOException {
        long numToSkip;
        long numSkipped;
        if (driverReader == null || length < 0) {
            return null;
        }
        if (position > 1L && (numSkipped = driverReader.skip(numToSkip = position - 1L)) != numToSkip) {
            return null;
        }
        char[] outBuffer = new char[length];
        int numRead = driverReader.read(outBuffer, 0, length);
        if (numRead >= 0) {
            return new String(outBuffer);
        }
        return null;
    }
}

