/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.jdt.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.jdt.internal.DriverClasspathContainer;
import org.eclipse.datatools.connectivity.jdt.internal.DriverClasspathMessages;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DriverClasspathContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private DriverListCombo combo;
    private Set fUsedPaths = new HashSet();
    private String initialSelectName = null;

    public DriverClasspathContainerPage() {
        this(DriverClasspathMessages.getString("DriverClasspathContainerPage.name"));
        this.setTitle(DriverClasspathMessages.getString("DriverClasspathContainerPage.title"));
        this.setMessage(DriverClasspathMessages.getString("DriverClasspathContainerPage.msg"));
    }

    public DriverClasspathContainerPage(String pageName) {
        super(pageName);
    }

    public DriverClasspathContainerPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        if (this.combo.getSelectedDriverInstance() != null) {
            DriverInstance di = this.combo.getSelectedDriverInstance();
            DriverClasspathContainer container = new DriverClasspathContainer(di.getName());
            IClasspathEntry entry = JavaCore.newContainerEntry((IPath)container.getPath());
            return entry;
        }
        return null;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        IPath path;
        if (containerEntry != null && this.isDriverContainer(path = containerEntry.getPath())) {
            this.initialSelectName = path.segment(1);
        }
    }

    private boolean isDriverContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.datatools.connectivity.jdt.DRIVERLIBRARY".equals(path.segment(0));
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        for (int i = 0; i < currentEntries.length; ++i) {
            IClasspathEntry curr = currentEntries[i];
            if (curr.getEntryKind() != 5) continue;
            this.fUsedPaths.add(curr.getPath());
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setFont(parent.getFont());
        this.combo = new DriverListCombo();
        this.combo.setLabelText(DriverClasspathMessages.getString("DriverClasspathContainerPage.combo.title"));
        this.combo.createContents(composite);
        this.combo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        this.combo.setSelection(this.initialSelectName);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }
}

