/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogSynonym;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogTable;
import org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogView;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class DerbyTableLoader
extends JDBCTableLoader {
    public static final String DERBY_TYPE_SYNONYM = "A";
    public static final String DERBY_TYPE_TABLE = "T";
    public static final String DERBY_TYPE_VIEW = "V";
    public static final String DERBY_TYPE_SYSTEM = "S";

    public DerbyTableLoader() {
        super(null);
    }

    public DerbyTableLoader(ICatalogObject catalogObject) {
        this(catalogObject, (IConnectionFilterProvider)new SchemaObjectFilterProvider("DatatoolsTableFilterPredicate"));
    }

    public DerbyTableLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        this.unregisterTableFactory("TABLE");
        this.unregisterTableFactory("VIEW");
        this.unregisterTableFactory("SYSTEM TABLE");
        this.unregisterTableFactory("GLOBAL TEMPORARY");
        this.unregisterTableFactory("LOCAL TEMPORARY");
        this.registerTableFactory(DERBY_TYPE_TABLE, (JDBCTableLoader.ITableFactory)new DerbyTableFactory());
        this.registerTableFactory(DERBY_TYPE_VIEW, (JDBCTableLoader.ITableFactory)new DerbyViewFactory());
        this.registerTableFactory(DERBY_TYPE_SYSTEM, (JDBCTableLoader.ITableFactory)new DerbyTableFactory());
        this.registerTableFactory(DERBY_TYPE_SYNONYM, (JDBCTableLoader.ITableFactory)new SynonymTableFactory());
    }

    protected ResultSet createResultSet() throws SQLException {
        Schema schema = (Schema)this.getCatalogObject();
        String query = "SELECT TABLENAME AS TABLE_NAME, TABLETYPE AS TABLE_TYPE FROM SYS.SYSTABLES A,SYS.SYSSCHEMAS B WHERE A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + schema.getName() + "' AND ( TABLETYPE='A' OR TABLETYPE='T' OR TABLETYPE='S' OR TABLETYPE='V' )";
        if (this.getSQLFilterExpression() != null && this.getSQLFilterExpression().length() > 0) {
            String filter = " AND TABLENAME " + this.getSQLFilterExpression();
            query = query + filter;
        }
        Statement s = this.getCatalogObject().getConnection().createStatement();
        ResultSet r = s.executeQuery(query);
        return r;
    }

    public static class DerbyTableFactory
    extends JDBCTableLoader.TableFactory {
        protected Table newTable() {
            return new DerbyCatalogTable();
        }
    }

    public static class DerbyViewFactory
    extends JDBCTableLoader.ViewFactory {
        protected Table newTable() {
            return new DerbyCatalogView();
        }
    }

    public static class SynonymTableFactory
    extends JDBCTableLoader.TableFactory {
        protected Table newTable() {
            return new DerbyCatalogSynonym();
        }
    }
}

