/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.ddl;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlBuilder;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;

public class DerbyDdlBuilder
extends GenericDdlBuilder {
    protected static final String IN = "IN";
    protected static final String OUT = "OUT";
    protected static final String INOUT = "INOUT";
    protected static final String LOCATOR = "LOCATOR";
    protected static final String EXTERNAL = "EXTERNAL";
    protected static final String RETURNS = "RETURNS";
    protected static final String CAST = "CAST";
    protected static final String FROM = "FROM";
    protected static final String COMMENT = "COMMENT";
    protected static final String IS = "IS";
    protected static final String COLUMN = "COLUMN";
    protected static final String MODE_DB2SQL = "MODE DB2SQL";

    public String createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        Database database = procedure.getSchema().getDatabase();
        String text = "CREATE PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames) + " " + "(" + this.getParameters((Routine)procedure) + ")";
        text = text + NEWLINE + "\t" + "LANGUAGE " + procedure.getLanguage();
        text = text + this.getExternalNameOption((Routine)procedure, quoteIdentifiers, qualifyNames);
        text = text + this.getParameterStyleOption((Routine)procedure);
        return text;
    }

    public String createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        Database database = function.getSchema().getDatabase();
        String text = "CREATE FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
        Source source = function.getSource();
        if (source != null) {
            text = text + source.getBody();
        }
        text = text + this.getExternalNameOption((Routine)function, quoteIdentifiers, qualifyNames);
        return text;
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        Database database = procedure.getSchema().getDatabase();
        return "DROP PROCEDURE " + this.getName((Routine)procedure, quoteIdentifiers, qualifyNames);
    }

    public String dropFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        Database database = function.getSchema().getDatabase();
        return "DROP FUNCTION " + this.getName((Routine)function, quoteIdentifiers, qualifyNames);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        String columnDefinition = super.getColumnString(column, quoteIdentifiers);
        IdentitySpecifier spec = column.getIdentitySpecifier();
        ValueExpression v = column.getGenerateExpression();
        if (spec != null) {
            columnDefinition = columnDefinition + " GENERATED ALWAYS AS IDENTITY ";
            columnDefinition = columnDefinition + " (" + this.getIdentityString(spec) + ")";
        } else if (v != null) {
            columnDefinition = columnDefinition + " GENERATED ALWAYS AS " + v.getSQL();
        }
        return columnDefinition;
    }

    protected String getIdentityString(IdentitySpecifier identitySpecifier) {
        String clause = "START WITH " + identitySpecifier.getStartValue() + " ,INCREMENT BY " + identitySpecifier.getIncrement();
        return clause;
    }

    protected String getParameters(Routine routine) {
        String parameters = "";
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            ParameterMode mode = p.getMode();
            if (mode == ParameterMode.INOUT_LITERAL) {
                parameters = parameters + "INOUT ";
            } else if (mode == ParameterMode.OUT_LITERAL) {
                parameters = parameters + "OUT ";
            }
            String name = p.getName();
            if (name != null && name.length() != 0) {
                parameters = parameters + p.getName() + " ";
            }
            parameters = parameters + this.getDataTypeString((TypedElement)p, routine.getSchema());
            if (p.isLocator()) {
                parameters = parameters + " AS LOCATOR";
            }
            if (!it.hasNext()) continue;
            parameters = parameters + "," + NEWLINE + "\t" + "\t";
        }
        return parameters;
    }

    protected String getExternalNameOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String option = NEWLINE + "\t" + EXTERNAL;
        String externalName = routine.getExternalName();
        if (externalName != null && externalName.length() != 0) {
            String schemaName = routine.getSchema().getName();
            if (routine.getLanguage().equalsIgnoreCase("JAVA")) {
                externalName = this.getSingleQuotedString(externalName);
            } else {
                if (quoteIdentifiers) {
                    externalName = this.getDoubleQuotedString(externalName);
                    schemaName = this.getDoubleQuotedString(schemaName);
                }
                if (qualifyNames) {
                    externalName = schemaName + "." + externalName;
                }
            }
            option = option + " NAME " + externalName;
        }
        return option;
    }

    protected String getParameterStyleOption(Routine routine) {
        return NEWLINE + "\t" + "PARAMETER STYLE " + routine.getParameterStyle();
    }

    protected String getFunctionReturnsClause(UserDefinedFunction function) {
        if (function.getReturnScalar() != null) {
            Parameter scaler = function.getReturnScalar();
            String text = "RETURNS " + this.getDataTypeString((TypedElement)scaler, function.getSchema());
            if (function.getReturnCast() != null) {
                Parameter cast = function.getReturnCast();
                text = text + " CAST FROM " + this.getDataTypeString((TypedElement)cast, function.getSchema());
            }
            return text;
        }
        if (function.getReturnTable() != null) {
            RoutineResultTable resultTable = function.getReturnTable();
            String text = "RETURNS TABLE (";
            Iterator it = resultTable.getColumns().iterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                text = text + c.getName() + " " + this.getDataTypeString((TypedElement)c, function.getSchema());
                if (!it.hasNext()) continue;
                text = text + ", ";
            }
            text = text + ")";
            return text;
        }
        Parameter parameter = function.getReturnCast();
        if (parameter != null) {
            return parameter.getName();
        }
        return null;
    }

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + " ";
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = statement + "AFTER";
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = statement + "BEFORE";
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = statement + "INSTEAD OF";
        }
        statement = statement + " ";
        if (trigger.isDeleteType()) {
            statement = statement + "DELETE";
        } else if (trigger.isInsertType()) {
            statement = statement + "INSERT";
        } else if (trigger.isUpdateType()) {
            statement = statement + "UPDATE";
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = statement + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = statement + column.getName();
                    if (!it.hasNext()) continue;
                    statement = statement + ", ";
                }
            }
        }
        statement = statement + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        String newTable = trigger.getNewTable();
        String oldTable = trigger.getOldTable();
        if (newRow != null && newRow.length() != 0) {
            statement = statement + "REFERENCING NEW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = statement + "REFERENCING OLD AS " + oldRow + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? statement + "FOR EACH ROW MODE DB2SQL" + NEWLINE : statement + "FOR EACH STATEMENT MODE DB2SQL" + NEWLINE;
        Iterator it = trigger.getActionStatement().iterator();
        while (it.hasNext()) {
            SQLStatement s = (SQLStatement)it.next();
            statement = statement + s.getSQL();
        }
        return statement;
    }
}

