/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.catalog;

import com.ibm.icu.util.StringTokenizer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.apache.internal.derby.DerbyPlugin;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyCatalogProcedure;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyCatalogUserDefinedFunction;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.modelbase.sql.routines.DataAccess;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;

public class DerbyRoutineLoader
extends JDBCRoutineLoader {
    private static final String rsKeyword = "RESULT SETS";

    public DerbyRoutineLoader(ICatalogObject catalogObject) {
        super(catalogObject);
        this.setProcedureFactory((JDBCRoutineLoader.IRoutineFactory)new DerbyProcedureFactory(catalogObject));
        this.setUserDefinedFunctionFactory((JDBCRoutineLoader.IRoutineFactory)new DerbyUserDefinedFunctionFactory(catalogObject));
    }

    public DerbyRoutineLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider, JDBCRoutineLoader.IRoutineFactory udfFactory, JDBCRoutineLoader.IRoutineFactory spFactory) {
        super(catalogObject, connectionFilterProvider, udfFactory, spFactory);
        this.setProcedureFactory((JDBCRoutineLoader.IRoutineFactory)new DerbyProcedureFactory(catalogObject));
        this.setUserDefinedFunctionFactory((JDBCRoutineLoader.IRoutineFactory)new DerbyUserDefinedFunctionFactory(catalogObject));
    }

    protected ResultSet createResultSet() throws SQLException {
        Schema schema = (Schema)this.getCatalogObject();
        String query = "SELECT ALIAS AS PROCEDURE_NAME,ALIASTYPE, CAST(NULL AS VARCHAR(1)) AS REMARKS, ALIAS, JAVACLASSNAME, ALIASINFO  FROM SYS.SYSALIASES A,SYS.SYSSCHEMAS B WHERE A.ALIASTYPE IN ('P','F') AND A.SCHEMAID=B.SCHEMAID AND B.SCHEMANAME='" + schema.getName() + "'";
        if (this.getJDBCFilterPattern() != null && this.getJDBCFilterPattern().length() > 0) {
            String filter = " AND ALIAS LIKE " + this.getJDBCFilterPattern();
            query = String.valueOf(query) + filter;
        }
        Statement s = this.getCatalogObject().getConnection().createStatement();
        ResultSet r = s.executeQuery(query);
        return r;
    }

    protected boolean isProcedure(ResultSet rs) throws SQLException {
        String type = rs.getString("ALIASTYPE");
        return type.equals("P");
    }

    private static void setRestOfMetaData(Routine routine, ResultSet rs, ICatalogObject catalogObject) {
        routine.setLanguage("JAVA");
        routine.setParameterStyle("JAVA");
        try {
            String aliasInfoString = rs.getString("ALIASINFO");
            DerbyRoutineLoader.setSqlDataAccess(routine, aliasInfoString);
            int index = aliasInfoString.lastIndexOf(rsKeyword);
            if (index != -1) {
                StringTokenizer tokenizer = new StringTokenizer(aliasInfoString.substring(index + rsKeyword.length()));
                String nextToken = tokenizer.nextToken();
                try {
                    int resultSets = Integer.parseInt(nextToken);
                    ((Procedure)routine).setMaxResultSets(resultSets);
                }
                catch (Exception exception) {}
            }
            index = aliasInfoString.indexOf("(");
            String methodName = aliasInfoString.substring(0, index);
            routine.setExternalName(String.valueOf(rs.getString("JAVACLASSNAME")) + '.' + methodName);
            DerbyRoutineLoader.loadSource(routine, aliasInfoString, catalogObject.getCatalogDatabase());
        }
        catch (Exception e) {
            Status status = new Status(4, DerbyPlugin.getDefault().getBundle().getSymbolicName(), 4, "###Error..org.eclipse.datatools.connectivity.internal.derby.catalog.DerbyCatalogProcedure.load", (Throwable)e);
            DerbyPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private static void setSqlDataAccess(Routine routine, String aliasInfo) {
        int index = aliasInfo.indexOf("NO SQL");
        if (index != -1) {
            routine.setSqlDataAccess(DataAccess.NO_SQL_LITERAL);
        } else {
            index = aliasInfo.indexOf("MODIFIES SQL DATA");
            if (index != -1) {
                routine.setSqlDataAccess(DataAccess.MODIFIES_SQL_DATA_LITERAL);
            } else {
                index = aliasInfo.indexOf("CONTAINS SQL");
                if (index != -1) {
                    routine.setSqlDataAccess(DataAccess.CONTAINS_SQL_LITERAL);
                } else {
                    index = aliasInfo.indexOf("READS SQL DATA");
                    if (index != -1) {
                        routine.setSqlDataAccess(DataAccess.READS_SQL_DATA_LITERAL);
                    }
                }
            }
        }
    }

    private static void loadSource(Routine routine, String aliasInfo, Database database) {
        int index = aliasInfo.indexOf("(");
        String body = aliasInfo.substring(index);
        body = body.replaceAll("IN ", "");
        DatabaseDefinition definition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = definition.getDataModelElementFactory();
        Source s = (Source)factory.create(SQLRoutinesPackage.eINSTANCE.getSource());
        s.setBody(body);
        routine.setSource(s);
    }

    public static class DerbyProcedureFactory
    extends JDBCRoutineLoader.ProcedureFactory {
        private ICatalogObject catalogObject;

        public DerbyProcedureFactory(ICatalogObject catalogObject) {
            this.catalogObject = catalogObject;
        }

        protected Routine newRoutine() {
            return new DerbyCatalogProcedure();
        }

        public void initialize(Routine routine, ResultSet rs) throws SQLException {
            super.initialize(routine, rs);
            DerbyRoutineLoader.setRestOfMetaData(routine, rs, this.catalogObject);
        }
    }

    public static class DerbyUserDefinedFunctionFactory
    extends JDBCRoutineLoader.UserDefinedFunctionFactory {
        private ICatalogObject catalogObject;

        public DerbyUserDefinedFunctionFactory(ICatalogObject catalogObject) {
            this.catalogObject = catalogObject;
        }

        protected Routine newRoutine() {
            return new DerbyCatalogUserDefinedFunction();
        }

        public void initialize(Routine routine, ResultSet rs) throws SQLException {
            super.initialize(routine, rs);
            DerbyRoutineLoader.setRestOfMetaData(routine, rs, this.catalogObject);
        }
    }
}

