/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.datatools.enablement.oda.xml.ui.control.FileSelectionButton;
import org.eclipse.datatools.enablement.oda.xml.ui.control.IMenuActionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.util.ResourceLocatorUtil;
import org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromPath;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XMLSelectionPageHelper {
    private static final String AUTO_ENCODING = Messages.getString("wizard.autoEncoding");
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private transient Text m_folderLocation = null;
    private transient Text m_schemaLocation = null;
    private transient FileSelectionButton browseFolderButton = null;
    private transient Combo encodingCombo = null;
    private transient Composite parent = null;
    private transient org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers ri = null;
    static final String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFolder");
    private static final String EMPTY_STRING = "";
    private final String[] XML_FILTER = new String[]{"*.xml", "*.*"};
    private final String[] XSD_FILTER = new String[]{"*.xsd", "*.*"};

    XMLSelectionPageHelper(WizardPage page) {
        this.m_wizardPage = page;
    }

    XMLSelectionPageHelper(PreferencePage page) {
        this.m_propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        this.parent = parent;
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(272);
        data.horizontalSpan = 2;
        Label label1 = new Label(composite, 0);
        label1.setText(Messages.getString("lable.selectXmlFile"));
        label1.setLayoutData((Object)data);
        this.setupXMLFolderLocation(composite);
        data = new GridData(272);
        data.horizontalSpan = 2;
        Label label3 = new Label(composite, 0);
        label3.setText(Messages.getString("lable.selectXmlSchmaFile"));
        label3.setLayoutData((Object)data);
        this.setupSchemaFolderLocation(composite);
        data = new GridData(272);
        data.horizontalSpan = 2;
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.getString("label.selectEncoding"));
        label2.setLayoutData((Object)data);
        this.setupEncodingControl(composite);
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_XML_Datasource_ID");
    }

    String getFolderLocation() {
        if (this.m_folderLocation == null) {
            return EMPTY_STRING;
        }
        return this.getFolderLocationString();
    }

    String getSchemaFileLocation() {
        if (this.m_schemaLocation == null) {
            return EMPTY_STRING;
        }
        return this.getSchemaLocationString();
    }

    String getEncoding() {
        if (this.encodingCombo == null || this.encodingCombo.getText().equals(AUTO_ENCODING)) {
            return EMPTY_STRING;
        }
        return this.encodingCombo.getText();
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("FILELIST", this.getFolderLocation());
        props.setProperty("SCHEMAFILELIST", this.getSchemaFileLocation());
        props.setProperty("ENCODINGLIST", this.getEncoding());
        return props;
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty() || this.m_folderLocation == null) {
            this.validatePageStatus();
            return;
        }
        String folderPath = profileProps.getProperty("FILELIST");
        if (folderPath == null) {
            folderPath = EMPTY_STRING;
        }
        this.setFolderLocation(folderPath);
        String encoding = profileProps.getProperty("ENCODINGLIST");
        if (encoding == null) {
            this.encodingCombo.select(0);
        } else {
            this.encodingCombo.select(this.getIndex(encoding));
        }
        String schemaPath = profileProps.getProperty("SCHEMAFILELIST");
        if (schemaPath == null) {
            schemaPath = EMPTY_STRING;
        }
        this.setSchemaLocation(schemaPath);
        this.validatePageStatus();
    }

    private int getIndex(String encoding) {
        return Arrays.binarySearch(this.encodingCombo.getItems(), encoding);
    }

    private void setupEncodingControl(Composite composite) {
        GridData data = new GridData(768);
        this.encodingCombo = new Combo(composite, 8);
        this.encodingCombo.setLayoutData((Object)data);
        this.encodingCombo.add(AUTO_ENCODING);
        for (String encoding : Charset.availableCharsets().keySet()) {
            this.encodingCombo.add(encoding);
        }
        this.encodingCombo.select(0);
    }

    private void setupXMLFolderLocation(Composite composite) {
        GridData data = new GridData(768);
        this.m_folderLocation = new Text(composite, 2048);
        this.m_folderLocation.setLayoutData((Object)data);
        this.m_folderLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLSelectionPageHelper.this.validatePageStatus();
            }
        });
        this.browseFolderButton = new FileSelectionButton(composite, 0);
        this.browseFolderButton.setText(Messages.getString("file.choose"));
        this.browseFolderButton.setActionHandler(new IMenuActionHandler(){

            @Override
            public String getBaseFolder() {
                return XMLSelectionPageHelper.this.getResourceFolder();
            }

            @Override
            public String[] getExtensionsFilter() {
                return XMLSelectionPageHelper.this.XML_FILTER;
            }

            @Override
            public void setPath(String path) {
                XMLSelectionPageHelper.this.m_folderLocation.setText(path);
                XMLSelectionPageHelper.this.validatePageStatus();
            }

            @Override
            public String getFilePath() {
                return XMLSelectionPageHelper.this.getFolderLocation();
            }
        });
    }

    private String getResourceFolder() {
        if (this.ri != null && this.ri.getApplResourceBaseURI() != null) {
            return new File(this.ri.getApplResourceBaseURI()).getAbsolutePath();
        }
        return null;
    }

    private void setupSchemaFolderLocation(Composite composite) {
        GridData data = new GridData(768);
        this.m_schemaLocation = new Text(composite, 2048);
        this.m_schemaLocation.setLayoutData((Object)data);
        this.browseFolderButton = new FileSelectionButton(composite, 0);
        this.browseFolderButton.setText(Messages.getString("schema.choose"));
        this.browseFolderButton.setActionHandler(new IMenuActionHandler(){

            @Override
            public String getBaseFolder() {
                return XMLSelectionPageHelper.this.getResourceFolder();
            }

            @Override
            public String[] getExtensionsFilter() {
                return XMLSelectionPageHelper.this.XSD_FILTER;
            }

            @Override
            public void setPath(String path) {
                XMLSelectionPageHelper.this.m_schemaLocation.setText(path);
            }

            @Override
            public String getFilePath() {
                return XMLSelectionPageHelper.this.getSchemaFileLocation();
            }
        });
    }

    private void setFolderLocation(String text) {
        this.m_folderLocation.setText(ResourceLocatorUtil.processPath((String)TextProcessorWrapper.process((String)text)));
        this.validatePageStatus();
    }

    private String getFolderLocationString() {
        return TextProcessorWrapper.deprocess((String)ResourceLocatorUtil.processPath((String)this.m_folderLocation.getText()));
    }

    private void setSchemaLocation(String text) {
        this.m_schemaLocation.setText(ResourceLocatorUtil.processPath((String)TextProcessorWrapper.process((String)text)));
    }

    private String getSchemaLocationString() {
        return TextProcessorWrapper.deprocess((String)ResourceLocatorUtil.processPath((String)this.m_schemaLocation.getText()));
    }

    private void setMessage(String message) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(message);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(message);
        }
    }

    private Control getControl() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getControl();
        }
        assert (this.m_propertyPage != null);
        return this.m_propertyPage.getControl();
    }

    public Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            @Override
            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (exception == null) {
                    try {
                        XMLSelectionPageHelper.this.testConnection();
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)XMLSelectionPageHelper.this.parent.getShell(), (Throwable)exception);
                if (conn != null) {
                    conn.close();
                }
            }
        };
    }

    private void validatePageStatus() {
        if (this.getFolderLocation().trim().length() == 0) {
            if (this.m_wizardPage != null) {
                this.m_wizardPage.setMessage(Messages.getString("XMLSelectionWizardPage.message.error.emptyXMLSource"), 3);
                this.m_wizardPage.setPageComplete(false);
            } else if (this.m_propertyPage != null) {
                this.m_propertyPage.setMessage(Messages.getString("XMLSelectionWizardPage.message.error.emptyXMLSource"), 3);
            }
        } else if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(DEFAULT_MESSAGE);
            this.m_wizardPage.setPageComplete(true);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setMessage(DEFAULT_MESSAGE);
        }
    }

    private void testConnection() throws Exception {
        String xmlFile;
        String schema = this.getSchemaFileLocation();
        String encoding = this.getEncoding();
        if (schema != null && schema.length() > 0) {
            InputStream is = new XMLSourceFromPath(schema, encoding, (Object)this.ri).openInputStream();
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if ((xmlFile = this.getFolderLocation()) == null || xmlFile.length() <= 0) {
            throw new OdaException(Messages.getString("error.invalidSource"));
        }
        InputStream is = new XMLSourceFromPath(xmlFile, encoding, (Object)this.ri).openInputStream();
        try {
            is.close();
        }
        catch (IOException iOException) {}
    }

    protected void setResourceIdentifiers(ResourceIdentifiers ri) {
        if (ri == null) {
            return;
        }
        this.ri = DesignSessionUtil.createRuntimeResourceIdentifiers((ResourceIdentifiers)ri);
    }
}

