/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.SybaseASESQLUtil;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class SybaseASEConstraintDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider
implements ISybaseASEDdlConstants {
    SybaseDdlBuilder _builder = SybaseASEDdlBuilder.getInstance();

    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableAddConstraintStatement(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableDropConstraintStatement(statement);
    }

    protected void addConstraintRenameStatement(TableConstraint constraint, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        BaseTable table;
        StringBuffer statement = new StringBuffer(128);
        String constraintName = newValue.toString();
        if (quoteIdentifiers) {
            constraintName = SQLDevToolsUtil.quoteWhenNecessary((String)constraintName, (DatabaseIdentifier)((DatabaseIdentifier)this.getParameter()));
        }
        if ((table = constraint.getBaseTable()) == null && constraint.eContainer() instanceof PrimaryKey) {
            return;
        }
        String tableName = table.getName();
        String oldObjectName = String.valueOf(tableName) + "." + oldValue;
        if (!(constraint instanceof CheckConstraint)) {
            if (constraint instanceof ForeignKey) {
                oldObjectName = (String)oldValue;
            }
            statement.append("EXEC").append(" ").append("sp_rename").append(" ").append(SQLUtil.quote((String)oldObjectName, (String)"'")).append(",");
            statement.append(constraintName);
            Schema creator = constraint.getBaseTable().getSchema();
            String setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
            if (!setUserStr.equals("")) {
                script.addAlterTableRenameConstraintStatement(setUserStr);
            }
            script.addAlterTableRenameConstraintStatement(statement.toString());
            String setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(creator);
            if (!setUserDbo.equals("")) {
                script.addAlterTableRenameConstraintStatement(setUserDbo);
            }
        }
    }

    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        if (!(e instanceof TableConstraint)) {
            return;
        }
    }

    protected boolean isConstraintNameChanged(Map modifyRecordMap, TableConstraint constraint) {
        List records = (List)modifyRecordMap.get(constraint);
        if (records != null) {
            for (SybaseDeltaDdlGeneration.FeatureChangeRecord r : records) {
                int featureID = r.feature.getFeatureID();
                if (featureID != 1) continue;
                return true;
            }
        }
        return false;
    }

    protected String getConstraintOldName(Map modifyRecordMap, TableConstraint constraint) {
        List records = (List)modifyRecordMap.get(constraint);
        if (records != null) {
            for (SybaseDeltaDdlGeneration.FeatureChangeRecord r : records) {
                int featureID = r.feature.getFeatureID();
                if (featureID != 1) continue;
                return (String)r.oldValue;
            }
        }
        return constraint.getName();
    }
}

