/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.tableviewer;

import org.eclipse.datatools.sqltools.common.core.tableviewer.IRowData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.ITableData;
import org.eclipse.datatools.sqltools.common.core.tableviewer.RowData;
import org.eclipse.datatools.sqltools.common.ui.tableviewer.IEnhanceTableDataReadOnly;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EnhancedTableViewer
extends TableViewer {
    private IEnhanceTableDataReadOnly _readOnly = null;
    private Listener _sortListener = new Listener(){

        public void handleEvent(Event e) {
            if (EnhancedTableViewer.this.getTable().getSortColumn() == null) {
                EnhancedTableViewer.this.getTable().setSortColumn(EnhancedTableViewer.this.getTable().getColumn(0));
                EnhancedTableViewer.this.getTable().setSortDirection(128);
            }
            TableColumn sortColumn = EnhancedTableViewer.this.getTable().getSortColumn();
            TableColumn currentColumn = (TableColumn)e.widget;
            int dir = EnhancedTableViewer.this.getTable().getSortDirection();
            if (sortColumn == currentColumn) {
                dir = dir == 128 ? 1024 : 128;
            } else {
                EnhancedTableViewer.this.getTable().setSortColumn(currentColumn);
                dir = 128;
            }
            int index = 0;
            int columnCount = EnhancedTableViewer.this.getTable().getColumnCount();
            int i = 0;
            while (i < columnCount) {
                TableColumn tableColumn = EnhancedTableViewer.this.getTable().getColumn(i);
                if (tableColumn == currentColumn) {
                    index = i;
                    break;
                }
                ++i;
            }
            final int finalIndex = index;
            final int direction = dir;
            EnhancedTableViewer.this.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object obj1, Object obj2) {
                    int ret = 0;
                    Object value1 = ((IRowData)obj1).getValue(finalIndex);
                    Object value2 = ((IRowData)obj2).getValue(finalIndex);
                    int columnType = ((ITableData)viewer.getInput()).getColumnType(finalIndex);
                    switch (columnType) {
                        case 4: {
                            ret = new Long(value1.toString()).compareTo(new Long(value2.toString()));
                            break;
                        }
                        case 5: {
                            ret = new Integer(value1.toString()) - new Integer(value2.toString());
                            break;
                        }
                        case 8: {
                            ret = new Double(value1.toString()).compareTo(new Double(value2.toString()));
                            break;
                        }
                        case 6: {
                            ret = new Double(value1.toString()).compareTo(new Double(value2.toString()));
                            break;
                        }
                        case 91: {
                            ret = value1.toString().compareTo(value2.toString());
                            break;
                        }
                        case 92: {
                            ret = value1.toString().compareTo(value2.toString());
                            break;
                        }
                        default: {
                            ret = value1.toString().compareTo(value2.toString());
                        }
                    }
                    if (ret == 0) {
                        return ret;
                    }
                    if (direction == 128) {
                        return ret > 0 ? 1 : -1;
                    }
                    return ret > 0 ? -1 : 1;
                }
            });
            sortColumn.getParent().setSortDirection(dir);
            sortColumn.getParent().redraw();
            EnhancedTableViewer.this.refresh();
        }
    };

    public EnhancedTableViewer(Composite parent) {
        super(parent);
    }

    public EnhancedTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    public EnhancedTableViewer(Table table) {
        super(table);
    }

    public void setSortable(boolean sortable) {
        Table table = this.getTable();
        if (sortable) {
            TableColumn[] tableColumns = table.getColumns();
            int i = 0;
            while (i < tableColumns.length) {
                tableColumns[i].addListener(13, this._sortListener);
                ++i;
            }
        } else {
            TableColumn[] tableColumns = table.getColumns();
            int i = 0;
            while (i < tableColumns.length) {
                tableColumns[i].removeListener(13, this._sortListener);
                ++i;
            }
            table.setSortColumn(null);
        }
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
        this.setReadOnlyColor();
    }

    private void setReadOnlyColor() {
        if (!(this.getInput() instanceof ITableData)) {
            return;
        }
        if (this._readOnly == null) {
            return;
        }
        int itemCount = this.getTable().getItemCount();
        if (itemCount < 1) {
            return;
        }
        int i = 0;
        while (i < itemCount) {
            this.setReadOnlyColor(this.getTable().getItem(i));
            ++i;
        }
    }

    protected void setReadOnlyColor(TableItem tableItem) {
        if (tableItem == null) {
            return;
        }
        int columnCount = this.getTable().getColumnCount();
        if (!(tableItem.getData() instanceof RowData)) {
            return;
        }
        ((RowData)tableItem.getData()).getTableData();
        Color backgroundColor = new Color((Device)this.getTable().getDisplay(), 238, 237, 224);
        Color foregroundColor = new Color((Device)this.getTable().getDisplay(), 128, 128, 128);
        int i = 0;
        while (i < columnCount) {
            boolean readOnly = this._readOnly.isReadOnly((RowData)tableItem.getData(), i);
            if (readOnly) {
                tableItem.setBackground(i, backgroundColor);
                tableItem.setForeground(i, foregroundColor);
            }
            ++i;
        }
    }

    public void setReadOnly(IEnhanceTableDataReadOnly readOnly) {
        this._readOnly = readOnly;
    }

    public IEnhanceTableDataReadOnly getReadOnly() {
        return this._readOnly;
    }
}

