/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DBVersionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLDBUtil;

public class SQLIdentifier {
    public static final int PLATFORM_ANY = 0;
    public static final int PLATFORM_LUWO = 1;
    public static final int PLATFORM_390 = 2;
    public static final int PLATFORM_400 = 4;
    public static final int PLATFORM_DB2 = 0;
    public static final int PLATFORM_CLOUDSCAPE = 8;
    public static final int PLATFORM_ALL = 15;
    public static final int PLATFORM_DERBY = 8;
    public static final int PLATFORM_INFORMIX = 32;
    public static final int PLATFORM_ORACLE = 64;
    public static final int PLATFORM_SYBASE = 128;
    public static final int PLATFORM_SQLSERVER = 256;
    public static final int PLATFORM_OTHER = 0x10000000;
    public static final String PLATFORM_390_KEY = "390_PLATFORM";
    public static final String PLATFORM_400_KEY = "400_PLATFORM";
    public static final String PLATFORM_LUWO_KEY = "LUWO_PLATFORM";
    public static final String PLATFORM_CLOUDSCAPE_KEY = "CLOUDSCAPE_PLATFORM";
    public static final String PLATFORM_OTHER_KEY = "OTHER_PLATFORM";
    public static final String DB2_ZSERIES = "zSeries";
    public static final String DB2_ISERIES = "iSeries";
    public static final String DB2_LUW0 = "DB2 UDB";
    public static final String CLOUDSCAPE = "Cloudscape";
    public static final String DERBY = "Derby";
    protected static String ordinaryDigits;
    protected static Hashtable ordinaryFlagsSet;
    protected static String ordinaryWideDigits;
    protected static ArrayList langsUNO;
    protected static List luwoReserved;
    protected static List os390Reserved;
    protected static List os400Reserved;
    protected static List cloudscapeReserved;
    protected static HashSet otherOrdinaryFlags;
    protected static Set schemaReserved;
    public static final int TRIM_ALL = 7;
    public static final int TRIM_BOTH = 3;
    public static final int TRIM_INSIDE = 4;
    public static final int TRIM_LEFT = 1;
    public static final int TRIM_RIGHT = 2;

    static {
        ordinaryFlagsSet = new Hashtable(37);
        ordinaryDigits = "0123456789";
        ordinaryWideDigits = "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19";
        schemaReserved = new HashSet(6);
        schemaReserved.add("SYSCAT");
        schemaReserved.add("SYSFUN");
        schemaReserved.add("SYSIBM");
        schemaReserved.add("SYSSTAT");
    }

    public static String getIdentifierQuoteString(ISQLEditorConnectionInfo connInfo) {
        String delimiter = null;
        DatabaseDefinition dbDef = SQLDBUtil.getDatabaseDefinition(connInfo);
        if (dbDef != null) {
            delimiter = dbDef.getIdentifierQuoteString();
        }
        if (delimiter == null || delimiter.length() == 0) {
            delimiter = "\"";
        }
        return delimiter;
    }

    public static String convertAuthID(String id, ISQLEditorConnectionInfo coninfo) {
        String delimiter = SQLIdentifier.getIdentifierQuoteString(coninfo);
        int platform = SQLIdentifier.getPlatform(coninfo);
        return SQLIdentifier.convertAuthID(id, delimiter.charAt(0), platform);
    }

    public static String convertAuthID(String id, char delim, int platforms) {
        if (SQLIdentifier.isUserInputOrdinary(id, delim, platforms)) {
            return id.toUpperCase();
        }
        String sqlid = SQLIdentifier.convertDBID(id, delim, platforms, false);
        boolean reserved = SQLIdentifier.isReservedIdentifier(sqlid, delim, platforms);
        if (reserved) {
            StringBuffer sb = new StringBuffer();
            sb.insert(0, delim).append(sqlid).append(delim);
            return sb.toString();
        }
        return sqlid;
    }

    public static String toCatalogFormat(String id, ISQLEditorConnectionInfo coninfo) {
        String delimiter = SQLIdentifier.getIdentifierQuoteString(coninfo);
        return SQLIdentifier.convertUserInput(id, delimiter.charAt(0), 0);
    }

    public static String toSQLFormat(String id, ISQLEditorConnectionInfo coninfo) {
        String delimiter = SQLIdentifier.getIdentifierQuoteString(coninfo);
        int platform = SQLIdentifier.getPlatform(coninfo);
        String sqlid = SQLIdentifier.convertDBID(id, delimiter.charAt(0), platform, false);
        boolean reserved = platform == 0x10000000 ? SQLIdentifier.isReservedIdentifier(sqlid, coninfo) : SQLIdentifier.isReservedIdentifier(sqlid, delimiter.charAt(0), platform);
        if (reserved) {
            StringBuffer sb = new StringBuffer();
            sb.insert(0, delimiter).append(sqlid).append(delimiter);
            return sb.toString();
        }
        return sqlid;
    }

    public static boolean beginsWith(String id, String prefix, char delimiter) {
        int plen;
        String nid = SQLIdentifier.trim(id, 7, delimiter);
        String pref = SQLIdentifier.trim(prefix, 7, delimiter);
        pref = pref.charAt(0) == delimiter ? (pref.charAt((plen = pref.length()) - 1) == delimiter ? pref.substring(1, plen - 2) : pref.substring(1)) : pref.toUpperCase();
        if (nid.charAt(0) == delimiter) {
            if (nid.length() + 1 < pref.length()) {
                return false;
            }
            nid = nid.substring(1, pref.length() + 1);
        } else {
            if (nid.length() < pref.length()) {
                return false;
            }
            nid = nid.substring(0, pref.length()).toUpperCase();
        }
        return pref.equals(nid);
    }

    public static boolean checkName(Enumeration e, String identifier, char delimiter) {
        while (e.hasMoreElements()) {
            if (!SQLIdentifier.equals((String)e.nextElement(), identifier, delimiter)) continue;
            return true;
        }
        return false;
    }

    public static String concatIdentifier(String id, Object add, char delimiter) {
        int epos;
        String nid = SQLIdentifier.trim(id, 7, delimiter);
        if (nid.charAt(epos = nid.length() - 1) == delimiter) {
            StringBuffer sb = new StringBuffer();
            sb.append(nid.substring(0, epos)).append(add.toString()).append(delimiter);
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(nid).append(add.toString());
        return sb.toString();
    }

    public static String convertDBID(String id, char delimiter) {
        return SQLIdentifier.convertDBID(id, delimiter, 1, true);
    }

    public static String convertDBID(String id, char delimiter, int platforms) {
        return SQLIdentifier.convertDBID(id, delimiter, platforms, true);
    }

    public static String convertDBID(String id, char delimiter, int platforms, boolean checkReserved) {
        if (id == null || id.length() == 0) {
            return id;
        }
        boolean ordinary = true;
        StringBuffer sb = new StringBuffer();
        char ch = id.charAt(0);
        if (ch == delimiter) {
            sb.append(ch);
            ordinary = false;
        } else if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms)) {
            ordinary = false;
        }
        sb.append(ch);
        int range = id.length();
        int c = 1;
        while (c < range) {
            ch = id.charAt(c);
            if (ch == delimiter) {
                sb.append(ch);
                ordinary = false;
            } else if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms) && !SQLIdentifier.isOrdinaryDigit(ch) && ch != '_') {
                ordinary = false;
            }
            sb.append(ch);
            ++c;
        }
        if (checkReserved && SQLIdentifier.isReservedIdentifier(sb.toString(), delimiter, platforms)) {
            ordinary = false;
        }
        if (!ordinary) {
            sb.insert(0, delimiter).append(delimiter);
            return sb.toString();
        }
        return id;
    }

    public static String convertUserInput(String id, char delimiter) {
        return SQLIdentifier.convertUserInput(id, delimiter, 1);
    }

    public static String convertUserInput(String id, char delimiter, int platforms) {
        if (id == null || id.length() == 0) {
            return id;
        }
        if (SQLIdentifier.trim(id, 1, delimiter).length() == 0) {
            return "";
        }
        if (SQLIdentifier.trim(id, 1, delimiter).charAt(0) == delimiter) {
            int range;
            StringBuffer sb = new StringBuffer();
            if ((id = SQLIdentifier.trim(id, 7, delimiter)).charAt(range = id.length() - 1) == delimiter) {
                int c = 1;
                while (c < range) {
                    char ch = id.charAt(c);
                    if (ch == delimiter) {
                        ++c;
                    }
                    sb.append(ch);
                    ++c;
                }
            } else {
                int c = 1;
                while (c <= range) {
                    char ch = id.charAt(c);
                    if (ch == delimiter) {
                        ++c;
                    }
                    sb.append(ch);
                    ++c;
                }
            }
            return sb.toString();
        }
        return SQLIdentifier.trim(id, 3, delimiter).toUpperCase();
    }

    public static boolean equals(String id1, String id2, ISQLEditorConnectionInfo coninfo) {
        String delimiter = SQLIdentifier.getIdentifierQuoteString(coninfo);
        int platform = SQLIdentifier.getPlatform(coninfo);
        return SQLIdentifier.equals(id1, id2, delimiter.charAt(0), platform);
    }

    public static boolean equals(String ident1, String ident2, char delimiter) {
        return SQLIdentifier.equals(ident1, ident2, delimiter, 1);
    }

    public static boolean equals(String ident1, String ident2, char delimiter, int platforms) {
        return SQLIdentifier.convertUserInput(ident1, delimiter, platforms).equals(SQLIdentifier.convertUserInput(ident2, delimiter, platforms));
    }

    public static long getCatalogLength(String text, ISQLEditorConnectionInfo aConInfo) {
        long len = 0L;
        int p = SQLIdentifier.getPlatform(aConInfo);
        int[] v = SQLIdentifier.getVersion(aConInfo);
        len = p == 2 && v[0] > 7 ? SQLIdentifier.getUTF8Length(text) : (p == 1 && v[0] > 8 ? SQLIdentifier.getUTF8Length(text) : (long)text.length());
        return len;
    }

    public static long getUTF8Length(String text) {
        long len = 0L;
        if (text != null) {
            long n = text.length();
            int i = 0;
            while ((long)i < n) {
                char c = text.charAt(i);
                len = c < '\u0080' ? ++len : (c < '\u0800' ? (len += 2L) : (c < '\u10000' ? (len += 3L) : (c < '\u200000' ? (len += 4L) : (c < '\u4000000' ? (len += 5L) : (len += 6L)))));
                ++i;
            }
        }
        return len;
    }

    public static char getDelimiter(Connection connection) {
        try {
            return connection.getMetaData().getIdentifierQuoteString().charAt(0);
        }
        catch (SQLException sQLException) {
            return '\"';
        }
    }

    public static int getPlatform(ISQLEditorConnectionInfo aConInfo) {
        DatabaseDefinition ddef = SQLDBUtil.getDatabaseDefinition(aConInfo);
        String product = ddef.getProduct();
        if (product != null) {
            if (product.indexOf(DB2_ZSERIES) > -1) {
                return 2;
            }
            if (product.indexOf(DB2_ISERIES) > -1) {
                return 4;
            }
            if (product.indexOf(DB2_LUW0) > -1) {
                return 1;
            }
            if (product.indexOf(CLOUDSCAPE) > -1) {
                return 8;
            }
            if (product.indexOf(DERBY) > -1) {
                return 8;
            }
        }
        return 0x10000000;
    }

    public static int[] getVersion(ISQLEditorConnectionInfo aConInfo) {
        DBVersionHelper ver = new DBVersionHelper(aConInfo);
        return new int[]{ver.getVersion(), ver.getRelease(), ver.getMod()};
    }

    public static boolean isDB2SpecialChar(char c) {
        switch (c) {
            case ' ': 
            case '!': 
            case '\"': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '^': 
            case '_': 
            case '|': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isDBCSLanguage() {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        return lang.equals("zh") || lang.equals("ja") || lang.equals("ko");
    }

    public static boolean isDBIDOrdinary(String id) {
        return SQLIdentifier.isDBIDOrdinary(id, '\"', 1);
    }

    public static boolean isDBIDOrdinary(String id, int platforms) {
        return SQLIdentifier.isDBIDOrdinary(id, '\"', platforms);
    }

    public static boolean isDBIDOrdinary(String id, char delimiter, int platforms) {
        if (id == null || id.length() == 0) {
            return true;
        }
        char ch = id.charAt(0);
        if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms)) {
            return false;
        }
        String tid = SQLIdentifier.trim(id, 2, delimiter);
        int range = tid.length() - 1;
        if (range > -1) {
            int c = 1;
            while (c < range) {
                ch = tid.charAt(c);
                if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms) && !SQLIdentifier.isOrdinaryDigit(ch) && ch != '_') {
                    return false;
                }
                ++c;
            }
            ch = tid.charAt(range);
            if (!SQLIdentifier.isOrdinaryUpperChar(ch, platforms)) {
                return false;
            }
            if (SQLIdentifier.isReservedIdentifier(tid, delimiter, platforms)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isOrdinary390Char(char ch) {
        boolean isOrdinary = false;
        if (!Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet flags = (HashSet)ordinaryFlagsSet.get(PLATFORM_390_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlags390();
            }
            isOrdinary = flags.contains(new Character(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinary400Char(char ch) {
        boolean isOrdinary = false;
        if (!Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet flags = (HashSet)ordinaryFlagsSet.get(PLATFORM_400_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlags400();
            }
            isOrdinary = flags.contains(new Character(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryChar(char ch, int platforms) {
        boolean ok = false;
        if (otherOrdinaryFlags != null) {
            ok = SQLIdentifier.isOrdinaryOtherChar(ch);
        } else {
            if ((platforms & 1) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 2) > 0) {
                ok = SQLIdentifier.isOrdinary390Char(ch);
            }
            if (!ok && (platforms & 4) > 0) {
                ok = SQLIdentifier.isOrdinary400Char(ch);
            }
            if (!ok && (platforms & 8) > 0) {
                ok = SQLIdentifier.isOrdinaryCloudscapeChar(ch);
            }
            if (!ok && (platforms & 0x10000000) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
        }
        return ok;
    }

    public static boolean isOrdinaryDigit(char c) {
        boolean isOrdinary = false;
        boolean bl = isOrdinary = ordinaryDigits.indexOf(c) > -1;
        if (!isOrdinary && SQLIdentifier.isDBCSLanguage()) {
            isOrdinary = ordinaryWideDigits.indexOf(c) > -1;
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryLUWOChar(char ch) {
        String lang;
        boolean isOrdinary = false;
        if (langsUNO == null) {
            SQLIdentifier.initOrdinaryFlagsLUWO();
        }
        if (!langsUNO.contains(lang = Locale.getDefault().getLanguage().toLowerCase())) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet flags = (HashSet)ordinaryFlagsSet.get(PLATFORM_LUWO_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlagsLUWO();
            }
            isOrdinary = flags.contains(new Character(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryCloudscapeChar(char ch) {
        boolean isOrdinary = false;
        if (!Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            isOrdinary = Character.isUnicodeIdentifierStart(ch);
        } else {
            HashSet flags = (HashSet)ordinaryFlagsSet.get(PLATFORM_CLOUDSCAPE_KEY);
            if (flags == null) {
                flags = SQLIdentifier.initOrdinaryFlagsCloudscape();
            }
            isOrdinary = flags.contains(new Character(ch));
        }
        return isOrdinary;
    }

    public static boolean isOrdinaryOtherChar(char ch) {
        if (otherOrdinaryFlags == null) {
            return SQLIdentifier.isOrdinaryLUWOChar(ch);
        }
        return otherOrdinaryFlags.contains(new Character(ch));
    }

    public static boolean isOrdinaryUpperChar(char ch, int platforms) {
        boolean ok = false;
        if (otherOrdinaryFlags != null) {
            ok = SQLIdentifier.isOrdinaryOtherChar(ch);
        } else {
            if ((platforms & 1) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
            if (!ok && (platforms & 2) > 0) {
                ok = SQLIdentifier.isOrdinary390Char(ch);
            }
            if (!ok && (platforms & 4) > 0) {
                ok = SQLIdentifier.isOrdinary400Char(ch);
            }
            if (!ok && (platforms & 8) > 0) {
                ok = SQLIdentifier.isOrdinaryCloudscapeChar(ch);
            }
            if (!ok && (platforms & 0x10000000) > 0) {
                ok = SQLIdentifier.isOrdinaryLUWOChar(ch);
            }
        }
        if (ok) {
            ok = !Character.isLowerCase(ch);
        }
        return ok;
    }

    public static boolean isReservedIdentifier(String id, char delimiter) {
        return SQLIdentifier.isReservedIdentifier(id, delimiter, 1);
    }

    public static boolean isReservedIdentifier(String id, char delimiter, int platforms) {
        String up = SQLIdentifier.convertUserInput(id, delimiter, platforms);
        boolean ok = false;
        if ((platforms & 1) > 0) {
            if (luwoReserved == null) {
                luwoReserved = SQLIdentifier.initReserved(DB2_LUW0, "V8.2");
            }
            boolean bl = ok = luwoReserved != null && luwoReserved.contains(up);
        }
        if (!ok && (platforms & 2) > 0) {
            if (os390Reserved == null) {
                os390Reserved = SQLIdentifier.initReserved("DB2 UDB zSeries", "V8 (New-Function Mode)");
            }
            boolean bl = ok = os390Reserved != null && os390Reserved.contains(up);
        }
        if (!ok && (platforms & 4) > 0) {
            if (os400Reserved == null) {
                os400Reserved = SQLIdentifier.initReserved("DB2 UDB iSeries", "V5R4");
            }
            boolean bl = ok = os400Reserved != null && os400Reserved.contains(up);
        }
        if (!ok && (platforms & 8) > 0) {
            if (cloudscapeReserved == null) {
                cloudscapeReserved = SQLIdentifier.initReserved("IBM Cloudscape", "10.0");
            }
            boolean bl = ok = cloudscapeReserved != null && cloudscapeReserved.contains(up);
        }
        if (!ok && (platforms & 0x10000000) > 0) {
            if (luwoReserved == null) {
                luwoReserved = SQLIdentifier.initReserved(DB2_LUW0, "V8.2");
            }
            ok = luwoReserved != null && luwoReserved.contains(up);
        }
        return ok;
    }

    public static boolean isReservedIdentifier(String id, ISQLEditorConnectionInfo coninfo) {
        DatabaseDefinition ddef = SQLDBUtil.getDatabaseDefinition(coninfo);
        if (ddef != null) {
            List reslist = ddef.getSQLKeywords();
            return reslist.contains(id);
        }
        return false;
    }

    public static boolean isReservedSchema(String id, char delimiter) {
        return schemaReserved.contains(SQLIdentifier.convertUserInput(id, delimiter));
    }

    public static boolean isUserInputOrdinary(String id) {
        return SQLIdentifier.isUserInputOrdinary(id, 1);
    }

    public static boolean isUserInputOrdinary(String id, char delimiter, int platforms) {
        int range;
        if (id == null || id.length() == 0) {
            return true;
        }
        boolean delimited = false;
        String upid = id;
        if (upid.charAt(0) == delimiter) {
            delimited = true;
            if ((upid = upid.substring(1)).charAt(range = upid.length() - 1) == delimiter) {
                upid = upid.substring(0, range);
            }
        }
        char ch = upid.charAt(0);
        if (delimited && Character.toUpperCase(ch) != ch || !SQLIdentifier.isOrdinaryChar(ch, platforms)) {
            return false;
        }
        upid = SQLIdentifier.trim(upid, 2, delimiter);
        range = upid.length();
        int c = 1;
        while (c < range) {
            ch = upid.charAt(c);
            if (delimited && Character.toUpperCase(ch) != ch || !SQLIdentifier.isOrdinaryChar(ch, platforms) && !SQLIdentifier.isOrdinaryDigit(ch) && ch != '_') {
                return false;
            }
            ++c;
        }
        return !SQLIdentifier.isReservedIdentifier(upid, delimiter, platforms);
    }

    public static boolean isUserInputOrdinary(String id, int platforms) {
        return SQLIdentifier.isUserInputOrdinary(id, '\"', platforms);
    }

    public static void setExtraOrdinaryChars(Connection connection) {
        otherOrdinaryFlags = null;
        if (connection != null) {
            String prod = null;
            try {
                prod = connection.getMetaData().getDatabaseProductName();
            }
            catch (SQLException sQLException) {
                prod = PLATFORM_OTHER_KEY;
            }
            otherOrdinaryFlags = (HashSet)ordinaryFlagsSet.get(prod);
            if (otherOrdinaryFlags == null) {
                String extras = null;
                try {
                    extras = connection.getMetaData().getExtraNameCharacters();
                }
                catch (SQLException sQLException) {
                    return;
                }
                otherOrdinaryFlags = new HashSet(59);
                ordinaryFlagsSet.put(prod, otherOrdinaryFlags);
                if (extras != null) {
                    int elen = extras.length();
                    int i = 0;
                    while (i < elen) {
                        char c = extras.charAt(i);
                        otherOrdinaryFlags.add(new Character(c));
                        ++i;
                    }
                }
                SQLIdentifier.initCommonOrdinaryFlags(otherOrdinaryFlags);
                otherOrdinaryFlags.add(new Character('_'));
            }
        }
    }

    public static String trim(String id, int side, char delimiter) {
        int right;
        char ch;
        if (id == null || id.length() == 0) {
            return id;
        }
        int left = 0;
        if ((side & 1) > 0) {
            ch = id.charAt(left);
            while (ch == ' ' && left < id.length()) {
                if (++left >= id.length()) continue;
                ch = id.charAt(left);
            }
        }
        if ((right = id.length() - 1) > -1 && (side & 2) > 0) {
            ch = id.charAt(right);
            while (ch == ' ' && right > -1) {
                if (--right <= -1) continue;
                ch = id.charAt(right);
            }
        }
        if (right > -1) {
            ch = id.charAt(right);
            int r = -1;
            if ((side & 4) > 0 && (side & 2) == 0) {
                while (right > -1 && ch == ' ' && ch != delimiter) {
                    if (--right <= -1) continue;
                    ch = id.charAt(right);
                }
                if (right > -1 && right < id.length() - 1) {
                    r = right + 1;
                }
            }
            if ((side & 4) > 0 && right > 0 && ch == delimiter) {
                ch = id.charAt(--right);
                while (ch == ' ' && right > -1) {
                    if (--right <= -1) continue;
                    ch = id.charAt(right);
                }
                StringBuffer sb2 = new StringBuffer();
                if (right >= left) {
                    sb2.append(id.substring(left, right + 1)).append(delimiter);
                    if (r > -1) {
                        sb2.append(id.substring(r));
                    }
                } else {
                    sb2.append(id.substring(left)).append(delimiter);
                }
                return sb2.toString();
            }
            if (right >= left) {
                if ((side & 4) > 0 && (side & 2) == 0) {
                    return id;
                }
                return id.substring(left, right + 1);
            }
            return id.substring(left);
        }
        return "";
    }

    private SQLIdentifier() {
    }

    public static List initReserved(String vendor, String version) {
        DatabaseDefinitionRegistry ddreg;
        DatabaseDefinition ddef;
        RDBCorePlugin rdb = RDBCorePlugin.getDefault();
        if (rdb != null && (ddef = (ddreg = rdb.getDatabaseDefinitionRegistry()).getDefinition(vendor, version)) != null) {
            return ddef.getSQLKeywords();
        }
        return luwoReserved;
    }

    protected static HashSet initOrdinaryFlagsCloudscape() {
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_CLOUDSCAPE_KEY, f);
        SQLIdentifier.initCommonOrdinaryFlags(f);
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00b5'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00c0'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c3'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c5'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c8'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00ca'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cc'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00cf'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d1'));
        f.add(new Character('\u00d2'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d5'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00d9'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00db'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e3'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e5'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00ef'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f1'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f5'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fb'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u00ff'));
        f.add(new Character('\u0100'));
        f.add(new Character('\u0101'));
        f.add(new Character('\u0102'));
        f.add(new Character('\u0103'));
        f.add(new Character('\u0104'));
        f.add(new Character('\u0105'));
        f.add(new Character('\u0106'));
        f.add(new Character('\u0107'));
        f.add(new Character('\u0108'));
        f.add(new Character('\u0109'));
        f.add(new Character('\u010a'));
        f.add(new Character('\u010b'));
        f.add(new Character('\u010c'));
        f.add(new Character('\u010d'));
        f.add(new Character('\u010e'));
        f.add(new Character('\u010f'));
        f.add(new Character('\u0110'));
        f.add(new Character('\u0111'));
        f.add(new Character('\u0112'));
        f.add(new Character('\u0113'));
        f.add(new Character('\u0114'));
        f.add(new Character('\u0115'));
        f.add(new Character('\u0116'));
        f.add(new Character('\u0117'));
        f.add(new Character('\u0118'));
        f.add(new Character('\u0119'));
        f.add(new Character('\u011a'));
        f.add(new Character('\u011b'));
        f.add(new Character('\u011c'));
        f.add(new Character('\u011d'));
        f.add(new Character('\u011e'));
        f.add(new Character('\u011f'));
        f.add(new Character('\u0120'));
        f.add(new Character('\u0121'));
        f.add(new Character('\u0122'));
        f.add(new Character('\u0123'));
        f.add(new Character('\u0124'));
        f.add(new Character('\u0125'));
        f.add(new Character('\u0126'));
        f.add(new Character('\u0127'));
        f.add(new Character('\u0128'));
        f.add(new Character('\u0129'));
        f.add(new Character('\u012a'));
        f.add(new Character('\u012b'));
        f.add(new Character('\u012c'));
        f.add(new Character('\u012d'));
        f.add(new Character('\u012e'));
        f.add(new Character('\u012f'));
        f.add(new Character('\u0130'));
        f.add(new Character('\u0131'));
        f.add(new Character('\u0132'));
        f.add(new Character('\u0133'));
        f.add(new Character('\u0134'));
        f.add(new Character('\u0135'));
        f.add(new Character('\u0136'));
        f.add(new Character('\u0137'));
        f.add(new Character('\u0138'));
        f.add(new Character('\u0139'));
        f.add(new Character('\u013a'));
        f.add(new Character('\u013b'));
        f.add(new Character('\u013c'));
        f.add(new Character('\u013d'));
        f.add(new Character('\u013e'));
        f.add(new Character('\u013f'));
        f.add(new Character('\u0140'));
        f.add(new Character('\u0141'));
        f.add(new Character('\u0142'));
        f.add(new Character('\u0143'));
        f.add(new Character('\u0144'));
        f.add(new Character('\u0145'));
        f.add(new Character('\u0146'));
        f.add(new Character('\u0147'));
        f.add(new Character('\u0148'));
        f.add(new Character('\u0149'));
        f.add(new Character('\u014a'));
        f.add(new Character('\u014b'));
        f.add(new Character('\u014c'));
        f.add(new Character('\u014d'));
        f.add(new Character('\u014e'));
        f.add(new Character('\u014f'));
        f.add(new Character('\u0150'));
        f.add(new Character('\u0151'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0154'));
        f.add(new Character('\u0155'));
        f.add(new Character('\u0156'));
        f.add(new Character('\u0157'));
        f.add(new Character('\u0158'));
        f.add(new Character('\u0159'));
        f.add(new Character('\u015a'));
        f.add(new Character('\u015b'));
        f.add(new Character('\u015c'));
        f.add(new Character('\u015d'));
        f.add(new Character('\u015e'));
        f.add(new Character('\u015f'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0162'));
        f.add(new Character('\u0163'));
        f.add(new Character('\u0164'));
        f.add(new Character('\u0165'));
        f.add(new Character('\u0166'));
        f.add(new Character('\u0167'));
        f.add(new Character('\u0168'));
        f.add(new Character('\u0169'));
        f.add(new Character('\u016a'));
        f.add(new Character('\u016b'));
        f.add(new Character('\u016c'));
        f.add(new Character('\u016d'));
        f.add(new Character('\u016e'));
        f.add(new Character('\u016f'));
        f.add(new Character('\u0170'));
        f.add(new Character('\u0171'));
        f.add(new Character('\u0172'));
        f.add(new Character('\u0173'));
        f.add(new Character('\u0174'));
        f.add(new Character('\u0175'));
        f.add(new Character('\u0176'));
        f.add(new Character('\u0177'));
        f.add(new Character('\u0178'));
        f.add(new Character('\u0179'));
        f.add(new Character('\u017a'));
        f.add(new Character('\u017b'));
        f.add(new Character('\u017c'));
        f.add(new Character('\u017d'));
        f.add(new Character('\u017e'));
        f.add(new Character('\u017f'));
        f.add(new Character('\u0180'));
        f.add(new Character('\u0181'));
        f.add(new Character('\u0182'));
        f.add(new Character('\u0183'));
        f.add(new Character('\u0184'));
        f.add(new Character('\u0185'));
        f.add(new Character('\u0186'));
        f.add(new Character('\u0187'));
        f.add(new Character('\u0188'));
        f.add(new Character('\u0189'));
        f.add(new Character('\u018a'));
        f.add(new Character('\u018b'));
        f.add(new Character('\u018c'));
        f.add(new Character('\u018d'));
        f.add(new Character('\u018e'));
        f.add(new Character('\u018f'));
        f.add(new Character('\u0190'));
        f.add(new Character('\u0191'));
        f.add(new Character('\u0192'));
        f.add(new Character('\u0193'));
        f.add(new Character('\u0194'));
        f.add(new Character('\u0195'));
        f.add(new Character('\u0196'));
        f.add(new Character('\u0197'));
        f.add(new Character('\u0198'));
        f.add(new Character('\u0199'));
        f.add(new Character('\u019a'));
        f.add(new Character('\u019b'));
        f.add(new Character('\u019c'));
        f.add(new Character('\u019d'));
        f.add(new Character('\u019e'));
        f.add(new Character('\u019f'));
        f.add(new Character('\u01a0'));
        f.add(new Character('\u01a1'));
        f.add(new Character('\u01a2'));
        f.add(new Character('\u01a3'));
        f.add(new Character('\u01a4'));
        f.add(new Character('\u01a5'));
        f.add(new Character('\u01a6'));
        f.add(new Character('\u01a7'));
        f.add(new Character('\u01a8'));
        f.add(new Character('\u01a9'));
        f.add(new Character('\u01aa'));
        f.add(new Character('\u01ab'));
        f.add(new Character('\u01ac'));
        f.add(new Character('\u01ad'));
        f.add(new Character('\u01ae'));
        f.add(new Character('\u01af'));
        f.add(new Character('\u01b0'));
        f.add(new Character('\u01b1'));
        f.add(new Character('\u01b2'));
        f.add(new Character('\u01b3'));
        f.add(new Character('\u01b4'));
        f.add(new Character('\u01b5'));
        f.add(new Character('\u01b6'));
        f.add(new Character('\u01b7'));
        f.add(new Character('\u01b8'));
        f.add(new Character('\u01b9'));
        f.add(new Character('\u01ba'));
        f.add(new Character('\u01bb'));
        f.add(new Character('\u01bc'));
        f.add(new Character('\u01bd'));
        f.add(new Character('\u01be'));
        f.add(new Character('\u01bf'));
        f.add(new Character('\u01c0'));
        f.add(new Character('\u01c1'));
        f.add(new Character('\u01c2'));
        f.add(new Character('\u01c3'));
        f.add(new Character('\u01c4'));
        f.add(new Character('\u01c5'));
        f.add(new Character('\u01c6'));
        f.add(new Character('\u01c7'));
        f.add(new Character('\u01c8'));
        f.add(new Character('\u01c9'));
        f.add(new Character('\u01ca'));
        f.add(new Character('\u01cb'));
        f.add(new Character('\u01cc'));
        f.add(new Character('\u01cd'));
        f.add(new Character('\u01ce'));
        f.add(new Character('\u01cf'));
        f.add(new Character('\u01d0'));
        f.add(new Character('\u01d1'));
        f.add(new Character('\u01d2'));
        f.add(new Character('\u01d3'));
        f.add(new Character('\u01d4'));
        f.add(new Character('\u01d5'));
        f.add(new Character('\u01d6'));
        f.add(new Character('\u01d7'));
        f.add(new Character('\u01d8'));
        f.add(new Character('\u01d9'));
        f.add(new Character('\u01da'));
        f.add(new Character('\u01db'));
        f.add(new Character('\u01dc'));
        f.add(new Character('\u01dd'));
        f.add(new Character('\u01de'));
        f.add(new Character('\u01df'));
        f.add(new Character('\u01e0'));
        f.add(new Character('\u01e1'));
        f.add(new Character('\u01e2'));
        f.add(new Character('\u01e3'));
        f.add(new Character('\u01e4'));
        f.add(new Character('\u01e5'));
        f.add(new Character('\u01e6'));
        f.add(new Character('\u01e7'));
        f.add(new Character('\u01e8'));
        f.add(new Character('\u01e9'));
        f.add(new Character('\u01ea'));
        f.add(new Character('\u01eb'));
        f.add(new Character('\u01ec'));
        f.add(new Character('\u01ed'));
        f.add(new Character('\u01ee'));
        f.add(new Character('\u01ef'));
        f.add(new Character('\u01f0'));
        f.add(new Character('\u01f1'));
        f.add(new Character('\u01f2'));
        f.add(new Character('\u01f3'));
        f.add(new Character('\u01f4'));
        f.add(new Character('\u01f5'));
        f.add(new Character('\u01fa'));
        f.add(new Character('\u01fb'));
        f.add(new Character('\u01fc'));
        f.add(new Character('\u01fd'));
        f.add(new Character('\u01fe'));
        f.add(new Character('\u01ff'));
        f.add(new Character('\u0200'));
        f.add(new Character('\u0201'));
        f.add(new Character('\u0202'));
        f.add(new Character('\u0203'));
        f.add(new Character('\u0204'));
        f.add(new Character('\u0205'));
        f.add(new Character('\u0206'));
        f.add(new Character('\u0207'));
        f.add(new Character('\u0208'));
        f.add(new Character('\u0209'));
        f.add(new Character('\u020a'));
        f.add(new Character('\u020b'));
        f.add(new Character('\u020c'));
        f.add(new Character('\u020d'));
        f.add(new Character('\u020e'));
        f.add(new Character('\u020f'));
        f.add(new Character('\u0210'));
        f.add(new Character('\u0211'));
        f.add(new Character('\u0212'));
        f.add(new Character('\u0213'));
        f.add(new Character('\u0214'));
        f.add(new Character('\u0215'));
        f.add(new Character('\u0216'));
        f.add(new Character('\u0217'));
        f.add(new Character('\u0250'));
        f.add(new Character('\u0251'));
        f.add(new Character('\u0252'));
        f.add(new Character('\u0253'));
        f.add(new Character('\u0254'));
        f.add(new Character('\u0255'));
        f.add(new Character('\u0256'));
        f.add(new Character('\u0257'));
        f.add(new Character('\u0258'));
        f.add(new Character('\u0259'));
        f.add(new Character('\u025a'));
        f.add(new Character('\u025b'));
        f.add(new Character('\u025c'));
        f.add(new Character('\u025d'));
        f.add(new Character('\u025e'));
        f.add(new Character('\u025f'));
        f.add(new Character('\u0260'));
        f.add(new Character('\u0261'));
        f.add(new Character('\u0262'));
        f.add(new Character('\u0263'));
        f.add(new Character('\u0264'));
        f.add(new Character('\u0265'));
        f.add(new Character('\u0266'));
        f.add(new Character('\u0267'));
        f.add(new Character('\u0268'));
        f.add(new Character('\u0269'));
        f.add(new Character('\u026a'));
        f.add(new Character('\u026b'));
        f.add(new Character('\u026c'));
        f.add(new Character('\u026d'));
        f.add(new Character('\u026e'));
        f.add(new Character('\u026f'));
        f.add(new Character('\u0270'));
        f.add(new Character('\u0271'));
        f.add(new Character('\u0272'));
        f.add(new Character('\u0273'));
        f.add(new Character('\u0274'));
        f.add(new Character('\u0275'));
        f.add(new Character('\u0276'));
        f.add(new Character('\u0277'));
        f.add(new Character('\u0278'));
        f.add(new Character('\u0279'));
        f.add(new Character('\u027a'));
        f.add(new Character('\u027b'));
        f.add(new Character('\u027c'));
        f.add(new Character('\u027d'));
        f.add(new Character('\u027e'));
        f.add(new Character('\u027f'));
        f.add(new Character('\u0280'));
        f.add(new Character('\u0281'));
        f.add(new Character('\u0282'));
        f.add(new Character('\u0283'));
        f.add(new Character('\u0284'));
        f.add(new Character('\u0285'));
        f.add(new Character('\u0286'));
        f.add(new Character('\u0287'));
        f.add(new Character('\u0288'));
        f.add(new Character('\u0289'));
        f.add(new Character('\u028a'));
        f.add(new Character('\u028b'));
        f.add(new Character('\u028c'));
        f.add(new Character('\u028d'));
        f.add(new Character('\u028e'));
        f.add(new Character('\u028f'));
        f.add(new Character('\u0290'));
        f.add(new Character('\u0291'));
        f.add(new Character('\u0292'));
        f.add(new Character('\u0293'));
        f.add(new Character('\u0294'));
        f.add(new Character('\u0295'));
        f.add(new Character('\u0296'));
        f.add(new Character('\u0297'));
        f.add(new Character('\u0298'));
        f.add(new Character('\u0299'));
        f.add(new Character('\u029a'));
        f.add(new Character('\u029b'));
        f.add(new Character('\u029c'));
        f.add(new Character('\u029d'));
        f.add(new Character('\u029e'));
        f.add(new Character('\u029f'));
        f.add(new Character('\u02a0'));
        f.add(new Character('\u02a1'));
        f.add(new Character('\u02a2'));
        f.add(new Character('\u02a3'));
        f.add(new Character('\u02a4'));
        f.add(new Character('\u02a5'));
        f.add(new Character('\u02a6'));
        f.add(new Character('\u02a7'));
        f.add(new Character('\u02a8'));
        f.add(new Character('\u02b0'));
        f.add(new Character('\u02b1'));
        f.add(new Character('\u02b2'));
        f.add(new Character('\u02b3'));
        f.add(new Character('\u02b4'));
        f.add(new Character('\u02b5'));
        f.add(new Character('\u02b6'));
        f.add(new Character('\u02b7'));
        f.add(new Character('\u02b8'));
        f.add(new Character('\u02bb'));
        f.add(new Character('\u02bc'));
        f.add(new Character('\u02bd'));
        f.add(new Character('\u02be'));
        f.add(new Character('\u02bf'));
        f.add(new Character('\u02c0'));
        f.add(new Character('\u02c1'));
        f.add(new Character('\u02d0'));
        f.add(new Character('\u02d1'));
        f.add(new Character('\u02e0'));
        f.add(new Character('\u02e1'));
        f.add(new Character('\u02e2'));
        f.add(new Character('\u02e3'));
        f.add(new Character('\u02e4'));
        f.add(new Character('\u037a'));
        f.add(new Character('\u0386'));
        f.add(new Character('\u0388'));
        f.add(new Character('\u0389'));
        f.add(new Character('\u038a'));
        f.add(new Character('\u038c'));
        f.add(new Character('\u038e'));
        f.add(new Character('\u038f'));
        f.add(new Character('\u0390'));
        f.add(new Character('\u0391'));
        f.add(new Character('\u0392'));
        f.add(new Character('\u0393'));
        f.add(new Character('\u0394'));
        f.add(new Character('\u0395'));
        f.add(new Character('\u0396'));
        f.add(new Character('\u0397'));
        f.add(new Character('\u0398'));
        f.add(new Character('\u0399'));
        f.add(new Character('\u039a'));
        f.add(new Character('\u039b'));
        f.add(new Character('\u039c'));
        f.add(new Character('\u039d'));
        f.add(new Character('\u039e'));
        f.add(new Character('\u039f'));
        f.add(new Character('\u03a0'));
        f.add(new Character('\u03a1'));
        f.add(new Character('\u03a3'));
        f.add(new Character('\u03a4'));
        f.add(new Character('\u03a5'));
        f.add(new Character('\u03a6'));
        f.add(new Character('\u03a7'));
        f.add(new Character('\u03a8'));
        f.add(new Character('\u03a9'));
        f.add(new Character('\u03aa'));
        f.add(new Character('\u03ab'));
        f.add(new Character('\u03ac'));
        f.add(new Character('\u03ad'));
        f.add(new Character('\u03ae'));
        f.add(new Character('\u03af'));
        f.add(new Character('\u03b0'));
        f.add(new Character('\u03b1'));
        f.add(new Character('\u03b2'));
        f.add(new Character('\u03b3'));
        f.add(new Character('\u03b4'));
        f.add(new Character('\u03b5'));
        f.add(new Character('\u03b6'));
        f.add(new Character('\u03b7'));
        f.add(new Character('\u03b8'));
        f.add(new Character('\u03b9'));
        f.add(new Character('\u03ba'));
        f.add(new Character('\u03bb'));
        f.add(new Character('\u03bc'));
        f.add(new Character('\u03bd'));
        f.add(new Character('\u03be'));
        f.add(new Character('\u03bf'));
        f.add(new Character('\u03c0'));
        f.add(new Character('\u03c1'));
        f.add(new Character('\u03c2'));
        f.add(new Character('\u03c3'));
        f.add(new Character('\u03c4'));
        f.add(new Character('\u03c5'));
        f.add(new Character('\u03c6'));
        f.add(new Character('\u03c7'));
        f.add(new Character('\u03c8'));
        f.add(new Character('\u03c9'));
        f.add(new Character('\u03ca'));
        f.add(new Character('\u03cb'));
        f.add(new Character('\u03cc'));
        f.add(new Character('\u03cd'));
        f.add(new Character('\u03ce'));
        f.add(new Character('\u03d0'));
        f.add(new Character('\u03d1'));
        f.add(new Character('\u03d2'));
        f.add(new Character('\u03d3'));
        f.add(new Character('\u03d4'));
        f.add(new Character('\u03d5'));
        f.add(new Character('\u03d6'));
        f.add(new Character('\u03da'));
        f.add(new Character('\u03dc'));
        f.add(new Character('\u03de'));
        f.add(new Character('\u03e0'));
        f.add(new Character('\u03e2'));
        f.add(new Character('\u03e3'));
        f.add(new Character('\u03e4'));
        f.add(new Character('\u03e5'));
        f.add(new Character('\u03e6'));
        f.add(new Character('\u03e7'));
        f.add(new Character('\u03e8'));
        f.add(new Character('\u03e9'));
        f.add(new Character('\u03ea'));
        f.add(new Character('\u03eb'));
        f.add(new Character('\u03ec'));
        f.add(new Character('\u03ed'));
        f.add(new Character('\u03ee'));
        f.add(new Character('\u03ef'));
        f.add(new Character('\u03f0'));
        f.add(new Character('\u03f1'));
        f.add(new Character('\u03f2'));
        f.add(new Character('\u03f3'));
        f.add(new Character('\u0401'));
        f.add(new Character('\u0402'));
        f.add(new Character('\u0403'));
        f.add(new Character('\u0404'));
        f.add(new Character('\u0405'));
        f.add(new Character('\u0406'));
        f.add(new Character('\u0407'));
        f.add(new Character('\u0408'));
        f.add(new Character('\u0409'));
        f.add(new Character('\u040a'));
        f.add(new Character('\u040b'));
        f.add(new Character('\u040c'));
        f.add(new Character('\u040e'));
        f.add(new Character('\u040f'));
        f.add(new Character('\u0410'));
        f.add(new Character('\u0411'));
        f.add(new Character('\u0412'));
        f.add(new Character('\u0413'));
        f.add(new Character('\u0414'));
        f.add(new Character('\u0415'));
        f.add(new Character('\u0416'));
        f.add(new Character('\u0417'));
        f.add(new Character('\u0418'));
        f.add(new Character('\u0419'));
        f.add(new Character('\u041a'));
        f.add(new Character('\u041b'));
        f.add(new Character('\u041c'));
        f.add(new Character('\u041d'));
        f.add(new Character('\u041e'));
        f.add(new Character('\u041f'));
        f.add(new Character('\u0420'));
        f.add(new Character('\u0421'));
        f.add(new Character('\u0422'));
        f.add(new Character('\u0423'));
        f.add(new Character('\u0424'));
        f.add(new Character('\u0425'));
        f.add(new Character('\u0426'));
        f.add(new Character('\u0427'));
        f.add(new Character('\u0428'));
        f.add(new Character('\u0429'));
        f.add(new Character('\u042a'));
        f.add(new Character('\u042b'));
        f.add(new Character('\u042c'));
        f.add(new Character('\u042d'));
        f.add(new Character('\u042e'));
        f.add(new Character('\u042f'));
        f.add(new Character('\u0430'));
        f.add(new Character('\u0431'));
        f.add(new Character('\u0432'));
        f.add(new Character('\u0433'));
        f.add(new Character('\u0434'));
        f.add(new Character('\u0435'));
        f.add(new Character('\u0436'));
        f.add(new Character('\u0437'));
        f.add(new Character('\u0438'));
        f.add(new Character('\u0439'));
        f.add(new Character('\u043a'));
        f.add(new Character('\u043b'));
        f.add(new Character('\u043c'));
        f.add(new Character('\u043d'));
        f.add(new Character('\u043e'));
        f.add(new Character('\u043f'));
        f.add(new Character('\u0440'));
        f.add(new Character('\u0441'));
        f.add(new Character('\u0442'));
        f.add(new Character('\u0443'));
        f.add(new Character('\u0444'));
        f.add(new Character('\u0445'));
        f.add(new Character('\u0446'));
        f.add(new Character('\u0447'));
        f.add(new Character('\u0448'));
        f.add(new Character('\u0449'));
        f.add(new Character('\u044a'));
        f.add(new Character('\u044b'));
        f.add(new Character('\u044c'));
        f.add(new Character('\u044d'));
        f.add(new Character('\u044e'));
        f.add(new Character('\u044f'));
        f.add(new Character('\u0451'));
        f.add(new Character('\u0452'));
        f.add(new Character('\u0453'));
        f.add(new Character('\u0454'));
        f.add(new Character('\u0455'));
        f.add(new Character('\u0456'));
        f.add(new Character('\u0457'));
        f.add(new Character('\u0458'));
        f.add(new Character('\u0459'));
        f.add(new Character('\u045a'));
        f.add(new Character('\u045b'));
        f.add(new Character('\u045c'));
        f.add(new Character('\u045e'));
        f.add(new Character('\u045f'));
        f.add(new Character('\u0460'));
        f.add(new Character('\u0461'));
        f.add(new Character('\u0462'));
        f.add(new Character('\u0463'));
        f.add(new Character('\u0464'));
        f.add(new Character('\u0465'));
        f.add(new Character('\u0466'));
        f.add(new Character('\u0467'));
        f.add(new Character('\u0468'));
        f.add(new Character('\u0469'));
        f.add(new Character('\u046a'));
        f.add(new Character('\u046b'));
        f.add(new Character('\u046c'));
        f.add(new Character('\u046d'));
        f.add(new Character('\u046e'));
        f.add(new Character('\u046f'));
        f.add(new Character('\u0470'));
        f.add(new Character('\u0471'));
        f.add(new Character('\u0472'));
        f.add(new Character('\u0473'));
        f.add(new Character('\u0474'));
        f.add(new Character('\u0475'));
        f.add(new Character('\u0476'));
        f.add(new Character('\u0477'));
        f.add(new Character('\u0478'));
        f.add(new Character('\u0479'));
        f.add(new Character('\u047a'));
        f.add(new Character('\u047b'));
        f.add(new Character('\u047c'));
        f.add(new Character('\u047d'));
        f.add(new Character('\u047e'));
        f.add(new Character('\u047f'));
        f.add(new Character('\u0480'));
        f.add(new Character('\u0481'));
        f.add(new Character('\u0490'));
        f.add(new Character('\u0491'));
        f.add(new Character('\u0492'));
        f.add(new Character('\u0493'));
        f.add(new Character('\u0494'));
        f.add(new Character('\u0495'));
        f.add(new Character('\u0496'));
        f.add(new Character('\u0497'));
        f.add(new Character('\u0498'));
        f.add(new Character('\u0499'));
        f.add(new Character('\u049a'));
        f.add(new Character('\u049b'));
        f.add(new Character('\u049c'));
        f.add(new Character('\u049d'));
        f.add(new Character('\u049e'));
        f.add(new Character('\u049f'));
        f.add(new Character('\u04a0'));
        f.add(new Character('\u04a1'));
        f.add(new Character('\u04a2'));
        f.add(new Character('\u04a3'));
        f.add(new Character('\u04a4'));
        f.add(new Character('\u04a5'));
        f.add(new Character('\u04a6'));
        f.add(new Character('\u04a7'));
        f.add(new Character('\u04a8'));
        f.add(new Character('\u04a9'));
        f.add(new Character('\u04aa'));
        f.add(new Character('\u04ab'));
        f.add(new Character('\u04ac'));
        f.add(new Character('\u04ad'));
        f.add(new Character('\u04ae'));
        f.add(new Character('\u04af'));
        f.add(new Character('\u04b0'));
        f.add(new Character('\u04b1'));
        f.add(new Character('\u04b2'));
        f.add(new Character('\u04b3'));
        f.add(new Character('\u04b4'));
        f.add(new Character('\u04b5'));
        f.add(new Character('\u04b6'));
        f.add(new Character('\u04b7'));
        f.add(new Character('\u04b8'));
        f.add(new Character('\u04b9'));
        f.add(new Character('\u04ba'));
        f.add(new Character('\u04bb'));
        f.add(new Character('\u04bc'));
        f.add(new Character('\u04bd'));
        f.add(new Character('\u04be'));
        f.add(new Character('\u04bf'));
        f.add(new Character('\u04c0'));
        f.add(new Character('\u04c1'));
        f.add(new Character('\u04c2'));
        f.add(new Character('\u04c3'));
        f.add(new Character('\u04c4'));
        f.add(new Character('\u04c7'));
        f.add(new Character('\u04c8'));
        f.add(new Character('\u04cb'));
        f.add(new Character('\u04cc'));
        f.add(new Character('\u04d0'));
        f.add(new Character('\u04d1'));
        f.add(new Character('\u04d2'));
        f.add(new Character('\u04d3'));
        f.add(new Character('\u04d4'));
        f.add(new Character('\u04d5'));
        f.add(new Character('\u04d6'));
        f.add(new Character('\u04d7'));
        f.add(new Character('\u04d8'));
        f.add(new Character('\u04d9'));
        f.add(new Character('\u04da'));
        f.add(new Character('\u04db'));
        f.add(new Character('\u04dc'));
        f.add(new Character('\u04dd'));
        f.add(new Character('\u04de'));
        f.add(new Character('\u04df'));
        f.add(new Character('\u04e0'));
        f.add(new Character('\u04e1'));
        f.add(new Character('\u04e2'));
        f.add(new Character('\u04e3'));
        f.add(new Character('\u04e4'));
        f.add(new Character('\u04e5'));
        f.add(new Character('\u04e6'));
        f.add(new Character('\u04e7'));
        f.add(new Character('\u04e8'));
        f.add(new Character('\u04e9'));
        f.add(new Character('\u04ea'));
        f.add(new Character('\u04eb'));
        f.add(new Character('\u04ee'));
        f.add(new Character('\u04ef'));
        f.add(new Character('\u04f0'));
        f.add(new Character('\u04f1'));
        f.add(new Character('\u04f2'));
        f.add(new Character('\u04f3'));
        f.add(new Character('\u04f4'));
        f.add(new Character('\u04f5'));
        f.add(new Character('\u04f8'));
        f.add(new Character('\u04f9'));
        f.add(new Character('\u0531'));
        f.add(new Character('\u0532'));
        f.add(new Character('\u0533'));
        f.add(new Character('\u0534'));
        f.add(new Character('\u0535'));
        f.add(new Character('\u0536'));
        f.add(new Character('\u0537'));
        f.add(new Character('\u0538'));
        f.add(new Character('\u0539'));
        f.add(new Character('\u053a'));
        f.add(new Character('\u053b'));
        f.add(new Character('\u053c'));
        f.add(new Character('\u053d'));
        f.add(new Character('\u053e'));
        f.add(new Character('\u053f'));
        f.add(new Character('\u0540'));
        f.add(new Character('\u0541'));
        f.add(new Character('\u0542'));
        f.add(new Character('\u0543'));
        f.add(new Character('\u0544'));
        f.add(new Character('\u0545'));
        f.add(new Character('\u0546'));
        f.add(new Character('\u0547'));
        f.add(new Character('\u0548'));
        f.add(new Character('\u0549'));
        f.add(new Character('\u054a'));
        f.add(new Character('\u054b'));
        f.add(new Character('\u054c'));
        f.add(new Character('\u054d'));
        f.add(new Character('\u054e'));
        f.add(new Character('\u054f'));
        f.add(new Character('\u0550'));
        f.add(new Character('\u0551'));
        f.add(new Character('\u0552'));
        f.add(new Character('\u0553'));
        f.add(new Character('\u0554'));
        f.add(new Character('\u0555'));
        f.add(new Character('\u0556'));
        f.add(new Character('\u0559'));
        f.add(new Character('\u0561'));
        f.add(new Character('\u0562'));
        f.add(new Character('\u0563'));
        f.add(new Character('\u0564'));
        f.add(new Character('\u0565'));
        f.add(new Character('\u0566'));
        f.add(new Character('\u0567'));
        f.add(new Character('\u0568'));
        f.add(new Character('\u0569'));
        f.add(new Character('\u056a'));
        f.add(new Character('\u056b'));
        f.add(new Character('\u056c'));
        f.add(new Character('\u056d'));
        f.add(new Character('\u056e'));
        f.add(new Character('\u056f'));
        f.add(new Character('\u0570'));
        f.add(new Character('\u0571'));
        f.add(new Character('\u0572'));
        f.add(new Character('\u0573'));
        f.add(new Character('\u0574'));
        f.add(new Character('\u0575'));
        f.add(new Character('\u0576'));
        f.add(new Character('\u0577'));
        f.add(new Character('\u0578'));
        f.add(new Character('\u0579'));
        f.add(new Character('\u057a'));
        f.add(new Character('\u057b'));
        f.add(new Character('\u057c'));
        f.add(new Character('\u057d'));
        f.add(new Character('\u057e'));
        f.add(new Character('\u057f'));
        f.add(new Character('\u0580'));
        f.add(new Character('\u0581'));
        f.add(new Character('\u0582'));
        f.add(new Character('\u0583'));
        f.add(new Character('\u0584'));
        f.add(new Character('\u0585'));
        f.add(new Character('\u0586'));
        f.add(new Character('\u0587'));
        f.add(new Character('\u05d0'));
        f.add(new Character('\u05d1'));
        f.add(new Character('\u05d2'));
        f.add(new Character('\u05d3'));
        f.add(new Character('\u05d4'));
        f.add(new Character('\u05d5'));
        f.add(new Character('\u05d6'));
        f.add(new Character('\u05d7'));
        f.add(new Character('\u05d8'));
        f.add(new Character('\u05d9'));
        f.add(new Character('\u05da'));
        f.add(new Character('\u05db'));
        f.add(new Character('\u05dc'));
        f.add(new Character('\u05dd'));
        f.add(new Character('\u05de'));
        f.add(new Character('\u05df'));
        f.add(new Character('\u05e0'));
        f.add(new Character('\u05e1'));
        f.add(new Character('\u05e2'));
        f.add(new Character('\u05e3'));
        f.add(new Character('\u05e4'));
        f.add(new Character('\u05e5'));
        f.add(new Character('\u05e6'));
        f.add(new Character('\u05e7'));
        f.add(new Character('\u05e8'));
        f.add(new Character('\u05e9'));
        f.add(new Character('\u05ea'));
        f.add(new Character('\u05f0'));
        f.add(new Character('\u05f1'));
        f.add(new Character('\u05f2'));
        f.add(new Character('\u0621'));
        f.add(new Character('\u0622'));
        f.add(new Character('\u0623'));
        f.add(new Character('\u0624'));
        f.add(new Character('\u0625'));
        f.add(new Character('\u0626'));
        f.add(new Character('\u0627'));
        f.add(new Character('\u0628'));
        f.add(new Character('\u0629'));
        f.add(new Character('\u062a'));
        f.add(new Character('\u062b'));
        f.add(new Character('\u062c'));
        f.add(new Character('\u062d'));
        f.add(new Character('\u062e'));
        f.add(new Character('\u062f'));
        f.add(new Character('\u0630'));
        f.add(new Character('\u0631'));
        f.add(new Character('\u0632'));
        f.add(new Character('\u0633'));
        f.add(new Character('\u0634'));
        f.add(new Character('\u0635'));
        f.add(new Character('\u0636'));
        f.add(new Character('\u0637'));
        f.add(new Character('\u0638'));
        f.add(new Character('\u0639'));
        f.add(new Character('\u063a'));
        f.add(new Character('\u0640'));
        f.add(new Character('\u0641'));
        f.add(new Character('\u0642'));
        f.add(new Character('\u0643'));
        f.add(new Character('\u0644'));
        f.add(new Character('\u0645'));
        f.add(new Character('\u0646'));
        f.add(new Character('\u0647'));
        f.add(new Character('\u0648'));
        f.add(new Character('\u0649'));
        f.add(new Character('\u064a'));
        f.add(new Character('\u0671'));
        f.add(new Character('\u0672'));
        f.add(new Character('\u0673'));
        f.add(new Character('\u0674'));
        f.add(new Character('\u0675'));
        f.add(new Character('\u0676'));
        f.add(new Character('\u0677'));
        f.add(new Character('\u0678'));
        f.add(new Character('\u0679'));
        f.add(new Character('\u067a'));
        f.add(new Character('\u067b'));
        f.add(new Character('\u067c'));
        f.add(new Character('\u067d'));
        f.add(new Character('\u067e'));
        f.add(new Character('\u067f'));
        f.add(new Character('\u0680'));
        f.add(new Character('\u0681'));
        f.add(new Character('\u0682'));
        f.add(new Character('\u0683'));
        f.add(new Character('\u0684'));
        f.add(new Character('\u0685'));
        f.add(new Character('\u0686'));
        f.add(new Character('\u0687'));
        f.add(new Character('\u0688'));
        f.add(new Character('\u0689'));
        f.add(new Character('\u068a'));
        f.add(new Character('\u068b'));
        f.add(new Character('\u068c'));
        f.add(new Character('\u068d'));
        f.add(new Character('\u068e'));
        f.add(new Character('\u068f'));
        f.add(new Character('\u0690'));
        f.add(new Character('\u0691'));
        f.add(new Character('\u0692'));
        f.add(new Character('\u0693'));
        f.add(new Character('\u0694'));
        f.add(new Character('\u0695'));
        f.add(new Character('\u0696'));
        f.add(new Character('\u0697'));
        f.add(new Character('\u0698'));
        f.add(new Character('\u0699'));
        f.add(new Character('\u069a'));
        f.add(new Character('\u069b'));
        f.add(new Character('\u069c'));
        f.add(new Character('\u069d'));
        f.add(new Character('\u069e'));
        f.add(new Character('\u069f'));
        f.add(new Character('\u06a0'));
        f.add(new Character('\u06a1'));
        f.add(new Character('\u06a2'));
        f.add(new Character('\u06a3'));
        f.add(new Character('\u06a4'));
        f.add(new Character('\u06a5'));
        f.add(new Character('\u06a6'));
        f.add(new Character('\u06a7'));
        f.add(new Character('\u06a8'));
        f.add(new Character('\u06a9'));
        f.add(new Character('\u06aa'));
        f.add(new Character('\u06ab'));
        f.add(new Character('\u06ac'));
        f.add(new Character('\u06ad'));
        f.add(new Character('\u06ae'));
        f.add(new Character('\u06af'));
        f.add(new Character('\u06b0'));
        f.add(new Character('\u06b1'));
        f.add(new Character('\u06b2'));
        f.add(new Character('\u06b3'));
        f.add(new Character('\u06b4'));
        f.add(new Character('\u06b5'));
        f.add(new Character('\u06b6'));
        f.add(new Character('\u06b7'));
        f.add(new Character('\u06ba'));
        f.add(new Character('\u06bb'));
        f.add(new Character('\u06bc'));
        f.add(new Character('\u06bd'));
        f.add(new Character('\u06be'));
        f.add(new Character('\u06c0'));
        f.add(new Character('\u06c1'));
        f.add(new Character('\u06c2'));
        f.add(new Character('\u06c3'));
        f.add(new Character('\u06c4'));
        f.add(new Character('\u06c5'));
        f.add(new Character('\u06c6'));
        f.add(new Character('\u06c7'));
        f.add(new Character('\u06c8'));
        f.add(new Character('\u06c9'));
        f.add(new Character('\u06ca'));
        f.add(new Character('\u06cb'));
        f.add(new Character('\u06cc'));
        f.add(new Character('\u06cd'));
        f.add(new Character('\u06ce'));
        f.add(new Character('\u06d0'));
        f.add(new Character('\u06d1'));
        f.add(new Character('\u06d2'));
        f.add(new Character('\u06d3'));
        f.add(new Character('\u06d5'));
        f.add(new Character('\u06e5'));
        f.add(new Character('\u06e6'));
        f.add(new Character('\u0905'));
        f.add(new Character('\u0906'));
        f.add(new Character('\u0907'));
        f.add(new Character('\u0908'));
        f.add(new Character('\u0909'));
        f.add(new Character('\u090a'));
        f.add(new Character('\u090b'));
        f.add(new Character('\u090c'));
        f.add(new Character('\u090d'));
        f.add(new Character('\u090e'));
        f.add(new Character('\u090f'));
        f.add(new Character('\u0910'));
        f.add(new Character('\u0911'));
        f.add(new Character('\u0912'));
        f.add(new Character('\u0913'));
        f.add(new Character('\u0914'));
        f.add(new Character('\u0915'));
        f.add(new Character('\u0916'));
        f.add(new Character('\u0917'));
        f.add(new Character('\u0918'));
        f.add(new Character('\u0919'));
        f.add(new Character('\u091a'));
        f.add(new Character('\u091b'));
        f.add(new Character('\u091c'));
        f.add(new Character('\u091d'));
        f.add(new Character('\u091e'));
        f.add(new Character('\u091f'));
        f.add(new Character('\u0920'));
        f.add(new Character('\u0921'));
        f.add(new Character('\u0922'));
        f.add(new Character('\u0923'));
        f.add(new Character('\u0924'));
        f.add(new Character('\u0925'));
        f.add(new Character('\u0926'));
        f.add(new Character('\u0927'));
        f.add(new Character('\u0928'));
        f.add(new Character('\u0929'));
        f.add(new Character('\u092a'));
        f.add(new Character('\u092b'));
        f.add(new Character('\u092c'));
        f.add(new Character('\u092d'));
        f.add(new Character('\u092e'));
        f.add(new Character('\u092f'));
        f.add(new Character('\u0930'));
        f.add(new Character('\u0931'));
        f.add(new Character('\u0932'));
        f.add(new Character('\u0933'));
        f.add(new Character('\u0934'));
        f.add(new Character('\u0935'));
        f.add(new Character('\u0936'));
        f.add(new Character('\u0937'));
        f.add(new Character('\u0938'));
        f.add(new Character('\u0939'));
        f.add(new Character('\u093d'));
        f.add(new Character('\u0958'));
        f.add(new Character('\u0959'));
        f.add(new Character('\u095a'));
        f.add(new Character('\u095b'));
        f.add(new Character('\u095c'));
        f.add(new Character('\u095d'));
        f.add(new Character('\u095e'));
        f.add(new Character('\u095f'));
        f.add(new Character('\u0960'));
        f.add(new Character('\u0961'));
        f.add(new Character('\u0985'));
        f.add(new Character('\u0986'));
        f.add(new Character('\u0987'));
        f.add(new Character('\u0988'));
        f.add(new Character('\u0989'));
        f.add(new Character('\u098a'));
        f.add(new Character('\u098b'));
        f.add(new Character('\u098c'));
        f.add(new Character('\u098f'));
        f.add(new Character('\u0990'));
        f.add(new Character('\u0993'));
        f.add(new Character('\u0994'));
        f.add(new Character('\u0995'));
        f.add(new Character('\u0996'));
        f.add(new Character('\u0997'));
        f.add(new Character('\u0998'));
        f.add(new Character('\u0999'));
        f.add(new Character('\u099a'));
        f.add(new Character('\u099b'));
        f.add(new Character('\u099c'));
        f.add(new Character('\u099d'));
        f.add(new Character('\u099e'));
        f.add(new Character('\u099f'));
        f.add(new Character('\u09a0'));
        f.add(new Character('\u09a1'));
        f.add(new Character('\u09a2'));
        f.add(new Character('\u09a3'));
        f.add(new Character('\u09a4'));
        f.add(new Character('\u09a5'));
        f.add(new Character('\u09a6'));
        f.add(new Character('\u09a7'));
        f.add(new Character('\u09a8'));
        f.add(new Character('\u09aa'));
        f.add(new Character('\u09ab'));
        f.add(new Character('\u09ac'));
        f.add(new Character('\u09ad'));
        f.add(new Character('\u09ae'));
        f.add(new Character('\u09af'));
        f.add(new Character('\u09b0'));
        f.add(new Character('\u09b2'));
        f.add(new Character('\u09b6'));
        f.add(new Character('\u09b7'));
        f.add(new Character('\u09b8'));
        f.add(new Character('\u09b9'));
        f.add(new Character('\u09dc'));
        f.add(new Character('\u09dd'));
        f.add(new Character('\u09df'));
        f.add(new Character('\u09e0'));
        f.add(new Character('\u09e1'));
        f.add(new Character('\u09f0'));
        f.add(new Character('\u09f1'));
        f.add(new Character('\u0a05'));
        f.add(new Character('\u0a06'));
        f.add(new Character('\u0a07'));
        f.add(new Character('\u0a08'));
        f.add(new Character('\u0a09'));
        f.add(new Character('\u0a0a'));
        f.add(new Character('\u0a0f'));
        f.add(new Character('\u0a10'));
        f.add(new Character('\u0a13'));
        f.add(new Character('\u0a14'));
        f.add(new Character('\u0a15'));
        f.add(new Character('\u0a16'));
        f.add(new Character('\u0a17'));
        f.add(new Character('\u0a18'));
        f.add(new Character('\u0a19'));
        f.add(new Character('\u0a1a'));
        f.add(new Character('\u0a1b'));
        f.add(new Character('\u0a1c'));
        f.add(new Character('\u0a1d'));
        f.add(new Character('\u0a1e'));
        f.add(new Character('\u0a1f'));
        f.add(new Character('\u0a20'));
        f.add(new Character('\u0a21'));
        f.add(new Character('\u0a22'));
        f.add(new Character('\u0a23'));
        f.add(new Character('\u0a24'));
        f.add(new Character('\u0a25'));
        f.add(new Character('\u0a26'));
        f.add(new Character('\u0a27'));
        f.add(new Character('\u0a28'));
        f.add(new Character('\u0a2a'));
        f.add(new Character('\u0a2b'));
        f.add(new Character('\u0a2c'));
        f.add(new Character('\u0a2d'));
        f.add(new Character('\u0a2e'));
        f.add(new Character('\u0a2f'));
        f.add(new Character('\u0a30'));
        f.add(new Character('\u0a32'));
        f.add(new Character('\u0a33'));
        f.add(new Character('\u0a35'));
        f.add(new Character('\u0a36'));
        f.add(new Character('\u0a38'));
        f.add(new Character('\u0a39'));
        f.add(new Character('\u0a59'));
        f.add(new Character('\u0a5a'));
        f.add(new Character('\u0a5b'));
        f.add(new Character('\u0a5c'));
        f.add(new Character('\u0a5e'));
        f.add(new Character('\u0a72'));
        f.add(new Character('\u0a73'));
        f.add(new Character('\u0a74'));
        f.add(new Character('\u0a85'));
        f.add(new Character('\u0a86'));
        f.add(new Character('\u0a87'));
        f.add(new Character('\u0a88'));
        f.add(new Character('\u0a89'));
        f.add(new Character('\u0a8a'));
        f.add(new Character('\u0a8b'));
        f.add(new Character('\u0a8d'));
        f.add(new Character('\u0a8f'));
        f.add(new Character('\u0a90'));
        f.add(new Character('\u0a91'));
        f.add(new Character('\u0a93'));
        f.add(new Character('\u0a94'));
        f.add(new Character('\u0a95'));
        f.add(new Character('\u0a96'));
        f.add(new Character('\u0a97'));
        f.add(new Character('\u0a98'));
        f.add(new Character('\u0a99'));
        f.add(new Character('\u0a9a'));
        f.add(new Character('\u0a9b'));
        f.add(new Character('\u0a9c'));
        f.add(new Character('\u0a9d'));
        f.add(new Character('\u0a9e'));
        f.add(new Character('\u0a9f'));
        f.add(new Character('\u0aa0'));
        f.add(new Character('\u0aa1'));
        f.add(new Character('\u0aa2'));
        f.add(new Character('\u0aa3'));
        f.add(new Character('\u0aa4'));
        f.add(new Character('\u0aa5'));
        f.add(new Character('\u0aa6'));
        f.add(new Character('\u0aa7'));
        f.add(new Character('\u0aa8'));
        f.add(new Character('\u0aaa'));
        f.add(new Character('\u0aab'));
        f.add(new Character('\u0aac'));
        f.add(new Character('\u0aad'));
        f.add(new Character('\u0aae'));
        f.add(new Character('\u0aaf'));
        f.add(new Character('\u0ab0'));
        f.add(new Character('\u0ab2'));
        f.add(new Character('\u0ab3'));
        f.add(new Character('\u0ab5'));
        f.add(new Character('\u0ab6'));
        f.add(new Character('\u0ab7'));
        f.add(new Character('\u0ab8'));
        f.add(new Character('\u0ab9'));
        f.add(new Character('\u0abd'));
        f.add(new Character('\u0ae0'));
        f.add(new Character('\u0b05'));
        f.add(new Character('\u0b06'));
        f.add(new Character('\u0b07'));
        f.add(new Character('\u0b08'));
        f.add(new Character('\u0b09'));
        f.add(new Character('\u0b0a'));
        f.add(new Character('\u0b0b'));
        f.add(new Character('\u0b0c'));
        f.add(new Character('\u0b0f'));
        f.add(new Character('\u0b10'));
        f.add(new Character('\u0b13'));
        f.add(new Character('\u0b14'));
        f.add(new Character('\u0b15'));
        f.add(new Character('\u0b16'));
        f.add(new Character('\u0b17'));
        f.add(new Character('\u0b18'));
        f.add(new Character('\u0b19'));
        f.add(new Character('\u0b1a'));
        f.add(new Character('\u0b1b'));
        f.add(new Character('\u0b1c'));
        f.add(new Character('\u0b1d'));
        f.add(new Character('\u0b1e'));
        f.add(new Character('\u0b1f'));
        f.add(new Character('\u0b20'));
        f.add(new Character('\u0b21'));
        f.add(new Character('\u0b22'));
        f.add(new Character('\u0b23'));
        f.add(new Character('\u0b24'));
        f.add(new Character('\u0b25'));
        f.add(new Character('\u0b26'));
        f.add(new Character('\u0b27'));
        f.add(new Character('\u0b28'));
        f.add(new Character('\u0b2a'));
        f.add(new Character('\u0b2b'));
        f.add(new Character('\u0b2c'));
        f.add(new Character('\u0b2d'));
        f.add(new Character('\u0b2e'));
        f.add(new Character('\u0b2f'));
        f.add(new Character('\u0b30'));
        f.add(new Character('\u0b32'));
        f.add(new Character('\u0b33'));
        f.add(new Character('\u0b36'));
        f.add(new Character('\u0b37'));
        f.add(new Character('\u0b38'));
        f.add(new Character('\u0b39'));
        f.add(new Character('\u0b3d'));
        f.add(new Character('\u0b5c'));
        f.add(new Character('\u0b5d'));
        f.add(new Character('\u0b5f'));
        f.add(new Character('\u0b60'));
        f.add(new Character('\u0b61'));
        f.add(new Character('\u0b85'));
        f.add(new Character('\u0b86'));
        f.add(new Character('\u0b87'));
        f.add(new Character('\u0b88'));
        f.add(new Character('\u0b89'));
        f.add(new Character('\u0b8a'));
        f.add(new Character('\u0b8e'));
        f.add(new Character('\u0b8f'));
        f.add(new Character('\u0b90'));
        f.add(new Character('\u0b92'));
        f.add(new Character('\u0b93'));
        f.add(new Character('\u0b94'));
        f.add(new Character('\u0b95'));
        f.add(new Character('\u0b99'));
        f.add(new Character('\u0b9a'));
        f.add(new Character('\u0b9c'));
        f.add(new Character('\u0b9e'));
        f.add(new Character('\u0b9f'));
        f.add(new Character('\u0ba3'));
        f.add(new Character('\u0ba4'));
        f.add(new Character('\u0ba8'));
        f.add(new Character('\u0ba9'));
        f.add(new Character('\u0baa'));
        f.add(new Character('\u0bae'));
        f.add(new Character('\u0baf'));
        f.add(new Character('\u0bb0'));
        f.add(new Character('\u0bb1'));
        f.add(new Character('\u0bb2'));
        f.add(new Character('\u0bb3'));
        f.add(new Character('\u0bb4'));
        f.add(new Character('\u0bb5'));
        f.add(new Character('\u0bb7'));
        f.add(new Character('\u0bb8'));
        f.add(new Character('\u0bb9'));
        f.add(new Character('\u0c05'));
        f.add(new Character('\u0c06'));
        f.add(new Character('\u0c07'));
        f.add(new Character('\u0c08'));
        f.add(new Character('\u0c09'));
        f.add(new Character('\u0c0a'));
        f.add(new Character('\u0c0b'));
        f.add(new Character('\u0c0c'));
        f.add(new Character('\u0c0e'));
        f.add(new Character('\u0c0f'));
        f.add(new Character('\u0c10'));
        f.add(new Character('\u0c12'));
        f.add(new Character('\u0c13'));
        f.add(new Character('\u0c14'));
        f.add(new Character('\u0c15'));
        f.add(new Character('\u0c16'));
        f.add(new Character('\u0c17'));
        f.add(new Character('\u0c18'));
        f.add(new Character('\u0c19'));
        f.add(new Character('\u0c1a'));
        f.add(new Character('\u0c1b'));
        f.add(new Character('\u0c1c'));
        f.add(new Character('\u0c1d'));
        f.add(new Character('\u0c1e'));
        f.add(new Character('\u0c1f'));
        f.add(new Character('\u0c20'));
        f.add(new Character('\u0c21'));
        f.add(new Character('\u0c22'));
        f.add(new Character('\u0c23'));
        f.add(new Character('\u0c24'));
        f.add(new Character('\u0c25'));
        f.add(new Character('\u0c26'));
        f.add(new Character('\u0c27'));
        f.add(new Character('\u0c28'));
        f.add(new Character('\u0c2a'));
        f.add(new Character('\u0c2b'));
        f.add(new Character('\u0c2c'));
        f.add(new Character('\u0c2d'));
        f.add(new Character('\u0c2e'));
        f.add(new Character('\u0c2f'));
        f.add(new Character('\u0c30'));
        f.add(new Character('\u0c31'));
        f.add(new Character('\u0c32'));
        f.add(new Character('\u0c33'));
        f.add(new Character('\u0c35'));
        f.add(new Character('\u0c36'));
        f.add(new Character('\u0c37'));
        f.add(new Character('\u0c38'));
        f.add(new Character('\u0c39'));
        f.add(new Character('\u0c60'));
        f.add(new Character('\u0c61'));
        f.add(new Character('\u0c85'));
        f.add(new Character('\u0c86'));
        f.add(new Character('\u0c87'));
        f.add(new Character('\u0c88'));
        f.add(new Character('\u0c89'));
        f.add(new Character('\u0c8a'));
        f.add(new Character('\u0c8b'));
        f.add(new Character('\u0c8c'));
        f.add(new Character('\u0c8e'));
        f.add(new Character('\u0c8f'));
        f.add(new Character('\u0c90'));
        f.add(new Character('\u0c92'));
        f.add(new Character('\u0c93'));
        f.add(new Character('\u0c94'));
        f.add(new Character('\u0c95'));
        f.add(new Character('\u0c96'));
        f.add(new Character('\u0c97'));
        f.add(new Character('\u0c98'));
        f.add(new Character('\u0c99'));
        f.add(new Character('\u0c9a'));
        f.add(new Character('\u0c9b'));
        f.add(new Character('\u0c9c'));
        f.add(new Character('\u0c9d'));
        f.add(new Character('\u0c9e'));
        f.add(new Character('\u0c9f'));
        f.add(new Character('\u0ca0'));
        f.add(new Character('\u0ca1'));
        f.add(new Character('\u0ca2'));
        f.add(new Character('\u0ca3'));
        f.add(new Character('\u0ca4'));
        f.add(new Character('\u0ca5'));
        f.add(new Character('\u0ca6'));
        f.add(new Character('\u0ca7'));
        f.add(new Character('\u0ca8'));
        f.add(new Character('\u0caa'));
        f.add(new Character('\u0cab'));
        f.add(new Character('\u0cac'));
        f.add(new Character('\u0cad'));
        f.add(new Character('\u0cae'));
        f.add(new Character('\u0caf'));
        f.add(new Character('\u0cb0'));
        f.add(new Character('\u0cb1'));
        f.add(new Character('\u0cb2'));
        f.add(new Character('\u0cb3'));
        f.add(new Character('\u0cb5'));
        f.add(new Character('\u0cb6'));
        f.add(new Character('\u0cb7'));
        f.add(new Character('\u0cb8'));
        f.add(new Character('\u0cb9'));
        f.add(new Character('\u0cde'));
        f.add(new Character('\u0ce0'));
        f.add(new Character('\u0ce1'));
        f.add(new Character('\u0d05'));
        f.add(new Character('\u0d06'));
        f.add(new Character('\u0d07'));
        f.add(new Character('\u0d08'));
        f.add(new Character('\u0d09'));
        f.add(new Character('\u0d0a'));
        f.add(new Character('\u0d0b'));
        f.add(new Character('\u0d0c'));
        f.add(new Character('\u0d0e'));
        f.add(new Character('\u0d0f'));
        f.add(new Character('\u0d10'));
        f.add(new Character('\u0d12'));
        f.add(new Character('\u0d13'));
        f.add(new Character('\u0d14'));
        f.add(new Character('\u0d15'));
        f.add(new Character('\u0d16'));
        f.add(new Character('\u0d17'));
        f.add(new Character('\u0d18'));
        f.add(new Character('\u0d19'));
        f.add(new Character('\u0d1a'));
        f.add(new Character('\u0d1b'));
        f.add(new Character('\u0d1c'));
        f.add(new Character('\u0d1d'));
        f.add(new Character('\u0d1e'));
        f.add(new Character('\u0d1f'));
        f.add(new Character('\u0d20'));
        f.add(new Character('\u0d21'));
        f.add(new Character('\u0d22'));
        f.add(new Character('\u0d23'));
        f.add(new Character('\u0d24'));
        f.add(new Character('\u0d25'));
        f.add(new Character('\u0d26'));
        f.add(new Character('\u0d27'));
        f.add(new Character('\u0d28'));
        f.add(new Character('\u0d2a'));
        f.add(new Character('\u0d2b'));
        f.add(new Character('\u0d2c'));
        f.add(new Character('\u0d2d'));
        f.add(new Character('\u0d2e'));
        f.add(new Character('\u0d2f'));
        f.add(new Character('\u0d30'));
        f.add(new Character('\u0d31'));
        f.add(new Character('\u0d32'));
        f.add(new Character('\u0d33'));
        f.add(new Character('\u0d34'));
        f.add(new Character('\u0d35'));
        f.add(new Character('\u0d36'));
        f.add(new Character('\u0d37'));
        f.add(new Character('\u0d38'));
        f.add(new Character('\u0d39'));
        f.add(new Character('\u0d60'));
        f.add(new Character('\u0d61'));
        f.add(new Character('\u0e01'));
        f.add(new Character('\u0e02'));
        f.add(new Character('\u0e03'));
        f.add(new Character('\u0e04'));
        f.add(new Character('\u0e05'));
        f.add(new Character('\u0e06'));
        f.add(new Character('\u0e07'));
        f.add(new Character('\u0e08'));
        f.add(new Character('\u0e09'));
        f.add(new Character('\u0e0a'));
        f.add(new Character('\u0e0b'));
        f.add(new Character('\u0e0c'));
        f.add(new Character('\u0e0d'));
        f.add(new Character('\u0e0e'));
        f.add(new Character('\u0e0f'));
        f.add(new Character('\u0e10'));
        f.add(new Character('\u0e11'));
        f.add(new Character('\u0e12'));
        f.add(new Character('\u0e13'));
        f.add(new Character('\u0e14'));
        f.add(new Character('\u0e15'));
        f.add(new Character('\u0e16'));
        f.add(new Character('\u0e17'));
        f.add(new Character('\u0e18'));
        f.add(new Character('\u0e19'));
        f.add(new Character('\u0e1a'));
        f.add(new Character('\u0e1b'));
        f.add(new Character('\u0e1c'));
        f.add(new Character('\u0e1d'));
        f.add(new Character('\u0e1e'));
        f.add(new Character('\u0e1f'));
        f.add(new Character('\u0e20'));
        f.add(new Character('\u0e21'));
        f.add(new Character('\u0e22'));
        f.add(new Character('\u0e23'));
        f.add(new Character('\u0e24'));
        f.add(new Character('\u0e25'));
        f.add(new Character('\u0e26'));
        f.add(new Character('\u0e27'));
        f.add(new Character('\u0e28'));
        f.add(new Character('\u0e29'));
        f.add(new Character('\u0e2a'));
        f.add(new Character('\u0e2b'));
        f.add(new Character('\u0e2c'));
        f.add(new Character('\u0e2d'));
        f.add(new Character('\u0e2e'));
        f.add(new Character('\u0e30'));
        f.add(new Character('\u0e32'));
        f.add(new Character('\u0e33'));
        f.add(new Character('\u0e40'));
        f.add(new Character('\u0e41'));
        f.add(new Character('\u0e42'));
        f.add(new Character('\u0e43'));
        f.add(new Character('\u0e44'));
        f.add(new Character('\u0e45'));
        f.add(new Character('\u0e46'));
        f.add(new Character('\u0e81'));
        f.add(new Character('\u0e82'));
        f.add(new Character('\u0e84'));
        f.add(new Character('\u0e87'));
        f.add(new Character('\u0e88'));
        f.add(new Character('\u0e8a'));
        f.add(new Character('\u0e8d'));
        f.add(new Character('\u0e94'));
        f.add(new Character('\u0e95'));
        f.add(new Character('\u0e96'));
        f.add(new Character('\u0e97'));
        f.add(new Character('\u0e99'));
        f.add(new Character('\u0e9a'));
        f.add(new Character('\u0e9b'));
        f.add(new Character('\u0e9c'));
        f.add(new Character('\u0e9d'));
        f.add(new Character('\u0e9e'));
        f.add(new Character('\u0e9f'));
        f.add(new Character('\u0ea1'));
        f.add(new Character('\u0ea2'));
        f.add(new Character('\u0ea3'));
        f.add(new Character('\u0ea5'));
        f.add(new Character('\u0ea7'));
        f.add(new Character('\u0eaa'));
        f.add(new Character('\u0eab'));
        f.add(new Character('\u0ead'));
        f.add(new Character('\u0eae'));
        f.add(new Character('\u0eb0'));
        f.add(new Character('\u0eb2'));
        f.add(new Character('\u0eb3'));
        f.add(new Character('\u0ebd'));
        f.add(new Character('\u0ec0'));
        f.add(new Character('\u0ec1'));
        f.add(new Character('\u0ec2'));
        f.add(new Character('\u0ec3'));
        f.add(new Character('\u0ec4'));
        f.add(new Character('\u0ec6'));
        f.add(new Character('\u0edc'));
        f.add(new Character('\u0edd'));
        f.add(new Character('\u0f40'));
        f.add(new Character('\u0f41'));
        f.add(new Character('\u0f42'));
        f.add(new Character('\u0f43'));
        f.add(new Character('\u0f44'));
        f.add(new Character('\u0f45'));
        f.add(new Character('\u0f46'));
        f.add(new Character('\u0f47'));
        f.add(new Character('\u0f49'));
        f.add(new Character('\u0f4a'));
        f.add(new Character('\u0f4b'));
        f.add(new Character('\u0f4c'));
        f.add(new Character('\u0f4d'));
        f.add(new Character('\u0f4e'));
        f.add(new Character('\u0f4f'));
        f.add(new Character('\u0f50'));
        f.add(new Character('\u0f51'));
        f.add(new Character('\u0f52'));
        f.add(new Character('\u0f53'));
        f.add(new Character('\u0f54'));
        f.add(new Character('\u0f55'));
        f.add(new Character('\u0f56'));
        f.add(new Character('\u0f57'));
        f.add(new Character('\u0f58'));
        f.add(new Character('\u0f59'));
        f.add(new Character('\u0f5a'));
        f.add(new Character('\u0f5b'));
        f.add(new Character('\u0f5c'));
        f.add(new Character('\u0f5d'));
        f.add(new Character('\u0f5e'));
        f.add(new Character('\u0f5f'));
        f.add(new Character('\u0f60'));
        f.add(new Character('\u0f61'));
        f.add(new Character('\u0f62'));
        f.add(new Character('\u0f63'));
        f.add(new Character('\u0f64'));
        f.add(new Character('\u0f65'));
        f.add(new Character('\u0f66'));
        f.add(new Character('\u0f67'));
        f.add(new Character('\u0f68'));
        f.add(new Character('\u0f69'));
        return f;
    }

    protected static HashSet initOrdinaryFlags400() {
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_400_KEY, f);
        f.add(new Character('#'));
        f.add(new Character('$'));
        f.add(new Character('@'));
        SQLIdentifier.initCommonOrdinaryFlags(f);
        return f;
    }

    protected static HashSet initOrdinaryFlags390() {
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_390_KEY, f);
        f.add(new Character('#'));
        f.add(new Character('$'));
        f.add(new Character('@'));
        SQLIdentifier.initCommonOrdinaryFlags(f);
        return f;
    }

    protected static void initCommonOrdinaryFlags(HashSet f) {
        f.add(new Character('A'));
        f.add(new Character('B'));
        f.add(new Character('C'));
        f.add(new Character('D'));
        f.add(new Character('E'));
        f.add(new Character('F'));
        f.add(new Character('G'));
        f.add(new Character('H'));
        f.add(new Character('I'));
        f.add(new Character('J'));
        f.add(new Character('K'));
        f.add(new Character('L'));
        f.add(new Character('M'));
        f.add(new Character('N'));
        f.add(new Character('O'));
        f.add(new Character('P'));
        f.add(new Character('Q'));
        f.add(new Character('R'));
        f.add(new Character('S'));
        f.add(new Character('T'));
        f.add(new Character('U'));
        f.add(new Character('V'));
        f.add(new Character('W'));
        f.add(new Character('X'));
        f.add(new Character('Y'));
        f.add(new Character('Z'));
        f.add(new Character('a'));
        f.add(new Character('b'));
        f.add(new Character('c'));
        f.add(new Character('d'));
        f.add(new Character('e'));
        f.add(new Character('f'));
        f.add(new Character('g'));
        f.add(new Character('h'));
        f.add(new Character('i'));
        f.add(new Character('j'));
        f.add(new Character('k'));
        f.add(new Character('l'));
        f.add(new Character('m'));
        f.add(new Character('n'));
        f.add(new Character('o'));
        f.add(new Character('p'));
        f.add(new Character('q'));
        f.add(new Character('r'));
        f.add(new Character('s'));
        f.add(new Character('t'));
        f.add(new Character('u'));
        f.add(new Character('v'));
        f.add(new Character('w'));
        f.add(new Character('x'));
        f.add(new Character('y'));
        f.add(new Character('z'));
    }

    protected static void initOrdinaryFlagsLUWO(HashSet f, Locale locale) {
        String lang = locale.getLanguage();
        if (lang.equalsIgnoreCase("cs")) {
            SQLIdentifier.initCSFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("de")) {
            SQLIdentifier.initDEFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("es")) {
            SQLIdentifier.initESFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("fr")) {
            SQLIdentifier.initFRFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("hu")) {
            SQLIdentifier.initHUFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("it")) {
            SQLIdentifier.initITFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("ja")) {
            SQLIdentifier.initJAFlags(f);
        } else if (lang.equalsIgnoreCase("ko")) {
            SQLIdentifier.initKOFlags(f);
        } else if (lang.equalsIgnoreCase("pl")) {
            SQLIdentifier.initPLFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("pt")) {
            SQLIdentifier.initPTFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("ru")) {
            SQLIdentifier.initRUFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        } else if (lang.equalsIgnoreCase("zh")) {
            String country = locale.getCountry();
            if (country.equalsIgnoreCase("TW")) {
                SQLIdentifier.initTWFlags(f);
            } else {
                SQLIdentifier.initZHFlags(f);
            }
        } else {
            SQLIdentifier.initENFlags(f);
            SQLIdentifier.init_EU_Flags(f);
        }
    }

    protected static void initENFlags(HashSet f) {
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00c0'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c3'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c5'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c8'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00ca'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cc'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00cf'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d1'));
        f.add(new Character('\u00d2'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d5'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00d9'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00db'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e3'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e5'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00ef'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f1'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f5'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fb'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u00ff'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0178'));
    }

    protected static void init_EU_Flags(HashSet f) {
        f.add(new Character('\uff03'));
        f.add(new Character('\uff04'));
        f.add(new Character('\uff20'));
        f.add(new Character('\uff21'));
        f.add(new Character('\uff22'));
        f.add(new Character('\uff23'));
        f.add(new Character('\uff24'));
        f.add(new Character('\uff25'));
        f.add(new Character('\uff26'));
        f.add(new Character('\uff27'));
        f.add(new Character('\uff28'));
        f.add(new Character('\uff29'));
        f.add(new Character('\uff2a'));
        f.add(new Character('\uff2b'));
        f.add(new Character('\uff2c'));
        f.add(new Character('\uff2d'));
        f.add(new Character('\uff2e'));
        f.add(new Character('\uff2f'));
        f.add(new Character('\uff30'));
        f.add(new Character('\uff31'));
        f.add(new Character('\uff32'));
        f.add(new Character('\uff33'));
        f.add(new Character('\uff34'));
        f.add(new Character('\uff35'));
        f.add(new Character('\uff36'));
        f.add(new Character('\uff37'));
        f.add(new Character('\uff38'));
        f.add(new Character('\uff39'));
        f.add(new Character('\uff3a'));
        f.add(new Character('\uff41'));
        f.add(new Character('\uff42'));
        f.add(new Character('\uff43'));
        f.add(new Character('\uff44'));
        f.add(new Character('\uff45'));
        f.add(new Character('\uff46'));
        f.add(new Character('\uff47'));
        f.add(new Character('\uff48'));
        f.add(new Character('\uff49'));
        f.add(new Character('\uff4a'));
        f.add(new Character('\uff4b'));
        f.add(new Character('\uff4c'));
        f.add(new Character('\uff4d'));
        f.add(new Character('\uff4e'));
        f.add(new Character('\uff4f'));
        f.add(new Character('\uff50'));
        f.add(new Character('\uff51'));
        f.add(new Character('\uff52'));
        f.add(new Character('\uff53'));
        f.add(new Character('\uff54'));
        f.add(new Character('\uff55'));
        f.add(new Character('\uff56'));
        f.add(new Character('\uff57'));
        f.add(new Character('\uff58'));
        f.add(new Character('\uff59'));
        f.add(new Character('\uff5a'));
    }

    protected static void initZHFlags(HashSet f) {
        f.add(new Character('\u00a4'));
        f.add(new Character('\u00a7'));
        f.add(new Character('\u00a8'));
        f.add(new Character('\u00b0'));
        f.add(new Character('\u00b1'));
        f.add(new Character('\u00b7'));
        f.add(new Character('\u00d7'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u0101'));
        f.add(new Character('\u0113'));
        f.add(new Character('\u011b'));
        f.add(new Character('\u012b'));
        f.add(new Character('\u0144'));
        f.add(new Character('\u0148'));
        f.add(new Character('\u014d'));
        f.add(new Character('\u016b'));
        f.add(new Character('\u01ce'));
        f.add(new Character('\u01d0'));
        f.add(new Character('\u01d2'));
        f.add(new Character('\u01d4'));
        f.add(new Character('\u01d6'));
        f.add(new Character('\u01d8'));
        f.add(new Character('\u01da'));
        f.add(new Character('\u01dc'));
        f.add(new Character('\u01f9'));
        f.add(new Character('\u0251'));
        f.add(new Character('\u0261'));
        f.add(new Character('\u02c7'));
        f.add(new Character('\u02c9'));
        f.add(new Character('\u02ca'));
        f.add(new Character('\u02cb'));
        f.add(new Character('\u02d9'));
        f.add(new Character('\u0391'));
        f.add(new Character('\u0392'));
        f.add(new Character('\u0393'));
        f.add(new Character('\u0394'));
        f.add(new Character('\u0395'));
        f.add(new Character('\u0396'));
        f.add(new Character('\u0397'));
        f.add(new Character('\u0398'));
        f.add(new Character('\u0399'));
        f.add(new Character('\u039a'));
        f.add(new Character('\u039b'));
        f.add(new Character('\u039c'));
        f.add(new Character('\u039d'));
        f.add(new Character('\u039e'));
        f.add(new Character('\u039f'));
        f.add(new Character('\u03a0'));
        f.add(new Character('\u03a1'));
        f.add(new Character('\u03a3'));
        f.add(new Character('\u03a4'));
        f.add(new Character('\u03a5'));
        f.add(new Character('\u03a6'));
        f.add(new Character('\u03a7'));
        f.add(new Character('\u03a8'));
        f.add(new Character('\u03a9'));
        f.add(new Character('\u03b1'));
        f.add(new Character('\u03b2'));
        f.add(new Character('\u03b3'));
        f.add(new Character('\u03b4'));
        f.add(new Character('\u03b5'));
        f.add(new Character('\u03b6'));
        f.add(new Character('\u03b7'));
        f.add(new Character('\u03b8'));
        f.add(new Character('\u03b9'));
        f.add(new Character('\u03ba'));
        f.add(new Character('\u03bb'));
        f.add(new Character('\u03bc'));
        f.add(new Character('\u03bd'));
        f.add(new Character('\u03be'));
        f.add(new Character('\u03bf'));
        f.add(new Character('\u03c0'));
        f.add(new Character('\u03c1'));
        f.add(new Character('\u03c3'));
        f.add(new Character('\u03c4'));
        f.add(new Character('\u03c5'));
        f.add(new Character('\u03c6'));
        f.add(new Character('\u03c7'));
        f.add(new Character('\u03c8'));
        f.add(new Character('\u03c9'));
        f.add(new Character('\u0401'));
        f.add(new Character('\u0410'));
        f.add(new Character('\u0411'));
        f.add(new Character('\u0412'));
        f.add(new Character('\u0413'));
        f.add(new Character('\u0414'));
        f.add(new Character('\u0415'));
        f.add(new Character('\u0416'));
        f.add(new Character('\u0417'));
        f.add(new Character('\u0418'));
        f.add(new Character('\u0419'));
        f.add(new Character('\u041a'));
        f.add(new Character('\u041b'));
        f.add(new Character('\u041c'));
        f.add(new Character('\u041d'));
        f.add(new Character('\u041e'));
        f.add(new Character('\u041f'));
        f.add(new Character('\u0420'));
        f.add(new Character('\u0421'));
        f.add(new Character('\u0422'));
        f.add(new Character('\u0423'));
        f.add(new Character('\u0424'));
        f.add(new Character('\u0425'));
        f.add(new Character('\u0426'));
        f.add(new Character('\u0427'));
        f.add(new Character('\u0428'));
        f.add(new Character('\u0429'));
        f.add(new Character('\u042a'));
        f.add(new Character('\u042b'));
        f.add(new Character('\u042c'));
        f.add(new Character('\u042d'));
        f.add(new Character('\u042e'));
        f.add(new Character('\u042f'));
        f.add(new Character('\u0430'));
        f.add(new Character('\u0431'));
        f.add(new Character('\u0432'));
        f.add(new Character('\u0433'));
        f.add(new Character('\u0434'));
        f.add(new Character('\u0435'));
        f.add(new Character('\u0436'));
        f.add(new Character('\u0437'));
        f.add(new Character('\u0438'));
        f.add(new Character('\u0439'));
        f.add(new Character('\u043a'));
        f.add(new Character('\u043b'));
        f.add(new Character('\u043c'));
        f.add(new Character('\u043d'));
        f.add(new Character('\u043e'));
        f.add(new Character('\u043f'));
        f.add(new Character('\u0440'));
        f.add(new Character('\u0441'));
        f.add(new Character('\u0442'));
        f.add(new Character('\u0443'));
        f.add(new Character('\u0444'));
        f.add(new Character('\u0445'));
        f.add(new Character('\u0446'));
        f.add(new Character('\u0447'));
        f.add(new Character('\u0448'));
        f.add(new Character('\u0449'));
        f.add(new Character('\u044a'));
        f.add(new Character('\u044b'));
        f.add(new Character('\u044c'));
        f.add(new Character('\u044d'));
        f.add(new Character('\u044e'));
        f.add(new Character('\u044f'));
        f.add(new Character('\u0451'));
        f.add(new Character('\u2010'));
        f.add(new Character('\u2013'));
        f.add(new Character('\u2014'));
        f.add(new Character('\u2015'));
        f.add(new Character('\u2016'));
        f.add(new Character('\u2018'));
        f.add(new Character('\u2019'));
        f.add(new Character('\u201c'));
        f.add(new Character('\u201d'));
        f.add(new Character('\u2025'));
        f.add(new Character('\u2026'));
        f.add(new Character('\u2030'));
        f.add(new Character('\u2032'));
        f.add(new Character('\u2033'));
        f.add(new Character('\u2035'));
        f.add(new Character('\u203b'));
        f.add(new Character('\u20ac'));
        f.add(new Character('\u2103'));
        f.add(new Character('\u2105'));
        f.add(new Character('\u2109'));
        f.add(new Character('\u2116'));
        f.add(new Character('\u2121'));
        f.add(new Character('\u2160'));
        f.add(new Character('\u2161'));
        f.add(new Character('\u2162'));
        f.add(new Character('\u2163'));
        f.add(new Character('\u2164'));
        f.add(new Character('\u2165'));
        f.add(new Character('\u2166'));
        f.add(new Character('\u2167'));
        f.add(new Character('\u2168'));
        f.add(new Character('\u2169'));
        f.add(new Character('\u216a'));
        f.add(new Character('\u216b'));
        f.add(new Character('\u2170'));
        f.add(new Character('\u2171'));
        f.add(new Character('\u2172'));
        f.add(new Character('\u2173'));
        f.add(new Character('\u2174'));
        f.add(new Character('\u2175'));
        f.add(new Character('\u2176'));
        f.add(new Character('\u2177'));
        f.add(new Character('\u2178'));
        f.add(new Character('\u2179'));
        f.add(new Character('\u2190'));
        f.add(new Character('\u2191'));
        f.add(new Character('\u2192'));
        f.add(new Character('\u2193'));
        f.add(new Character('\u2196'));
        f.add(new Character('\u2197'));
        f.add(new Character('\u2198'));
        f.add(new Character('\u2199'));
        f.add(new Character('\u2208'));
        f.add(new Character('\u220f'));
        f.add(new Character('\u2211'));
        f.add(new Character('\u2215'));
        f.add(new Character('\u221a'));
        f.add(new Character('\u221d'));
        f.add(new Character('\u221e'));
        f.add(new Character('\u221f'));
        f.add(new Character('\u2220'));
        f.add(new Character('\u2223'));
        f.add(new Character('\u2225'));
        f.add(new Character('\u2227'));
        f.add(new Character('\u2228'));
        f.add(new Character('\u2229'));
        f.add(new Character('\u222a'));
        f.add(new Character('\u222b'));
        f.add(new Character('\u222e'));
        f.add(new Character('\u2234'));
        f.add(new Character('\u2235'));
        f.add(new Character('\u2236'));
        f.add(new Character('\u2237'));
        f.add(new Character('\u223d'));
        f.add(new Character('\u2248'));
        f.add(new Character('\u224c'));
        f.add(new Character('\u2252'));
        f.add(new Character('\u2260'));
        f.add(new Character('\u2261'));
        f.add(new Character('\u2264'));
        f.add(new Character('\u2265'));
        f.add(new Character('\u2266'));
        f.add(new Character('\u2267'));
        f.add(new Character('\u226e'));
        f.add(new Character('\u226f'));
        f.add(new Character('\u2295'));
        f.add(new Character('\u2299'));
        f.add(new Character('\u22a5'));
        f.add(new Character('\u22bf'));
        f.add(new Character('\u2312'));
        f.add(new Character('\u2460'));
        f.add(new Character('\u2461'));
        f.add(new Character('\u2462'));
        f.add(new Character('\u2463'));
        f.add(new Character('\u2464'));
        f.add(new Character('\u2465'));
        f.add(new Character('\u2466'));
        f.add(new Character('\u2467'));
        f.add(new Character('\u2468'));
        f.add(new Character('\u2469'));
        f.add(new Character('\u2474'));
        f.add(new Character('\u2475'));
        f.add(new Character('\u2476'));
        f.add(new Character('\u2477'));
        f.add(new Character('\u2478'));
        f.add(new Character('\u2479'));
        f.add(new Character('\u247a'));
        f.add(new Character('\u247b'));
        f.add(new Character('\u247c'));
        f.add(new Character('\u247d'));
        f.add(new Character('\u247e'));
        f.add(new Character('\u247f'));
        f.add(new Character('\u2480'));
        f.add(new Character('\u2481'));
        f.add(new Character('\u2482'));
        f.add(new Character('\u2483'));
        f.add(new Character('\u2484'));
        f.add(new Character('\u2485'));
        f.add(new Character('\u2486'));
        f.add(new Character('\u2487'));
        f.add(new Character('\u2488'));
        f.add(new Character('\u2489'));
        f.add(new Character('\u248a'));
        f.add(new Character('\u248b'));
        f.add(new Character('\u248c'));
        f.add(new Character('\u248d'));
        f.add(new Character('\u248e'));
        f.add(new Character('\u248f'));
        f.add(new Character('\u2490'));
        f.add(new Character('\u2491'));
        f.add(new Character('\u2492'));
        f.add(new Character('\u2493'));
        f.add(new Character('\u2494'));
        f.add(new Character('\u2495'));
        f.add(new Character('\u2496'));
        f.add(new Character('\u2497'));
        f.add(new Character('\u2498'));
        f.add(new Character('\u2499'));
        f.add(new Character('\u249a'));
        f.add(new Character('\u249b'));
        f.add(new Character('\u2500'));
        f.add(new Character('\u2501'));
        f.add(new Character('\u2502'));
        f.add(new Character('\u2503'));
        f.add(new Character('\u2504'));
        f.add(new Character('\u2505'));
        f.add(new Character('\u2506'));
        f.add(new Character('\u2507'));
        f.add(new Character('\u2508'));
        f.add(new Character('\u2509'));
        f.add(new Character('\u250a'));
        f.add(new Character('\u250b'));
        f.add(new Character('\u250c'));
        f.add(new Character('\u250d'));
        f.add(new Character('\u250e'));
        f.add(new Character('\u250f'));
        f.add(new Character('\u2510'));
        f.add(new Character('\u2511'));
        f.add(new Character('\u2512'));
        f.add(new Character('\u2513'));
        f.add(new Character('\u2514'));
        f.add(new Character('\u2515'));
        f.add(new Character('\u2516'));
        f.add(new Character('\u2517'));
        f.add(new Character('\u2518'));
        f.add(new Character('\u2519'));
        f.add(new Character('\u251a'));
        f.add(new Character('\u251b'));
        f.add(new Character('\u251c'));
        f.add(new Character('\u251d'));
        f.add(new Character('\u251e'));
        f.add(new Character('\u251f'));
        f.add(new Character('\u2520'));
        f.add(new Character('\u2521'));
        f.add(new Character('\u2522'));
        f.add(new Character('\u2523'));
        f.add(new Character('\u2524'));
        f.add(new Character('\u2525'));
        f.add(new Character('\u2526'));
        f.add(new Character('\u2527'));
        f.add(new Character('\u2528'));
        f.add(new Character('\u2529'));
        f.add(new Character('\u252a'));
        f.add(new Character('\u252b'));
        f.add(new Character('\u252c'));
        f.add(new Character('\u252d'));
        f.add(new Character('\u252e'));
        f.add(new Character('\u252f'));
        f.add(new Character('\u2530'));
        f.add(new Character('\u2531'));
        f.add(new Character('\u2532'));
        f.add(new Character('\u2533'));
        f.add(new Character('\u2534'));
        f.add(new Character('\u2535'));
        f.add(new Character('\u2536'));
        f.add(new Character('\u2537'));
        f.add(new Character('\u2538'));
        f.add(new Character('\u2539'));
        f.add(new Character('\u253a'));
        f.add(new Character('\u253b'));
        f.add(new Character('\u253c'));
        f.add(new Character('\u253d'));
        f.add(new Character('\u253e'));
        f.add(new Character('\u253f'));
        f.add(new Character('\u2540'));
        f.add(new Character('\u2541'));
        f.add(new Character('\u2542'));
        f.add(new Character('\u2543'));
        f.add(new Character('\u2544'));
        f.add(new Character('\u2545'));
        f.add(new Character('\u2546'));
        f.add(new Character('\u2547'));
        f.add(new Character('\u2548'));
        f.add(new Character('\u2549'));
        f.add(new Character('\u254a'));
        f.add(new Character('\u254b'));
        f.add(new Character('\u2550'));
        f.add(new Character('\u2551'));
        f.add(new Character('\u2552'));
        f.add(new Character('\u2553'));
        f.add(new Character('\u2554'));
        f.add(new Character('\u2555'));
        f.add(new Character('\u2556'));
        f.add(new Character('\u2557'));
        f.add(new Character('\u2558'));
        f.add(new Character('\u2559'));
        f.add(new Character('\u255a'));
        f.add(new Character('\u255b'));
        f.add(new Character('\u255c'));
        f.add(new Character('\u255d'));
        f.add(new Character('\u255e'));
        f.add(new Character('\u255f'));
        f.add(new Character('\u2560'));
        f.add(new Character('\u2561'));
        f.add(new Character('\u2562'));
        f.add(new Character('\u2563'));
        f.add(new Character('\u2564'));
        f.add(new Character('\u2565'));
        f.add(new Character('\u2566'));
        f.add(new Character('\u2567'));
        f.add(new Character('\u2568'));
        f.add(new Character('\u2569'));
        f.add(new Character('\u256a'));
        f.add(new Character('\u256b'));
        f.add(new Character('\u256c'));
        f.add(new Character('\u256d'));
        f.add(new Character('\u256e'));
        f.add(new Character('\u256f'));
        f.add(new Character('\u2570'));
        f.add(new Character('\u2571'));
        f.add(new Character('\u2572'));
        f.add(new Character('\u2573'));
        f.add(new Character('\u2581'));
        f.add(new Character('\u2582'));
        f.add(new Character('\u2583'));
        f.add(new Character('\u2584'));
        f.add(new Character('\u2585'));
        f.add(new Character('\u2586'));
        f.add(new Character('\u2587'));
        f.add(new Character('\u2588'));
        f.add(new Character('\u2589'));
        f.add(new Character('\u258a'));
        f.add(new Character('\u258b'));
        f.add(new Character('\u258c'));
        f.add(new Character('\u258d'));
        f.add(new Character('\u258e'));
        f.add(new Character('\u258f'));
        f.add(new Character('\u2593'));
        f.add(new Character('\u2594'));
        f.add(new Character('\u2595'));
        f.add(new Character('\u25a0'));
        f.add(new Character('\u25a1'));
        f.add(new Character('\u25b2'));
        f.add(new Character('\u25b3'));
        f.add(new Character('\u25bc'));
        f.add(new Character('\u25bd'));
        f.add(new Character('\u25c6'));
        f.add(new Character('\u25c7'));
        f.add(new Character('\u25cb'));
        f.add(new Character('\u25ce'));
        f.add(new Character('\u25cf'));
        f.add(new Character('\u25e2'));
        f.add(new Character('\u25e3'));
        f.add(new Character('\u25e4'));
        f.add(new Character('\u25e5'));
        f.add(new Character('\u2605'));
        f.add(new Character('\u2606'));
        f.add(new Character('\u2609'));
        f.add(new Character('\u2640'));
        f.add(new Character('\u2642'));
        f.add(new Character('\u2e81'));
        f.add(new Character('\u2e84'));
        f.add(new Character('\u2e88'));
        f.add(new Character('\u2e8b'));
        f.add(new Character('\u2e8c'));
        f.add(new Character('\u2e97'));
        f.add(new Character('\u2ea7'));
        f.add(new Character('\u2eaa'));
        f.add(new Character('\u2eae'));
        f.add(new Character('\u2eb3'));
        f.add(new Character('\u2eb6'));
        f.add(new Character('\u2eb7'));
        f.add(new Character('\u2ebb'));
        f.add(new Character('\u2eca'));
        f.add(new Character('\u2ff0'));
        f.add(new Character('\u2ff1'));
        f.add(new Character('\u2ff2'));
        f.add(new Character('\u2ff3'));
        f.add(new Character('\u2ff4'));
        f.add(new Character('\u2ff5'));
        f.add(new Character('\u2ff6'));
        f.add(new Character('\u2ff7'));
        f.add(new Character('\u2ff8'));
        f.add(new Character('\u2ff9'));
        f.add(new Character('\u2ffa'));
        f.add(new Character('\u2ffb'));
        f.add(new Character('\u3001'));
        f.add(new Character('\u3002'));
        f.add(new Character('\u3003'));
        f.add(new Character('\u3005'));
        f.add(new Character('\u3006'));
        f.add(new Character('\u3007'));
        f.add(new Character('\u3008'));
        f.add(new Character('\u3009'));
        f.add(new Character('\u300a'));
        f.add(new Character('\u300b'));
        f.add(new Character('\u300c'));
        f.add(new Character('\u300d'));
        f.add(new Character('\u300e'));
        f.add(new Character('\u300f'));
        f.add(new Character('\u3010'));
        f.add(new Character('\u3011'));
        f.add(new Character('\u3012'));
        f.add(new Character('\u3013'));
        f.add(new Character('\u3014'));
        f.add(new Character('\u3015'));
        f.add(new Character('\u3016'));
        f.add(new Character('\u3017'));
        f.add(new Character('\u301d'));
        f.add(new Character('\u301e'));
        f.add(new Character('\u3021'));
        f.add(new Character('\u3022'));
        f.add(new Character('\u3023'));
        f.add(new Character('\u3024'));
        f.add(new Character('\u3025'));
        f.add(new Character('\u3026'));
        f.add(new Character('\u3027'));
        f.add(new Character('\u3028'));
        f.add(new Character('\u3029'));
        f.add(new Character('\u303e'));
        f.add(new Character('\u3041'));
        f.add(new Character('\u3042'));
        f.add(new Character('\u3043'));
        f.add(new Character('\u3044'));
        f.add(new Character('\u3045'));
        f.add(new Character('\u3046'));
        f.add(new Character('\u3047'));
        f.add(new Character('\u3048'));
        f.add(new Character('\u3049'));
        f.add(new Character('\u304a'));
        f.add(new Character('\u304b'));
        f.add(new Character('\u304c'));
        f.add(new Character('\u304d'));
        f.add(new Character('\u304e'));
        f.add(new Character('\u304f'));
        f.add(new Character('\u3050'));
        f.add(new Character('\u3051'));
        f.add(new Character('\u3052'));
        f.add(new Character('\u3053'));
        f.add(new Character('\u3054'));
        f.add(new Character('\u3055'));
        f.add(new Character('\u3056'));
        f.add(new Character('\u3057'));
        f.add(new Character('\u3058'));
        f.add(new Character('\u3059'));
        f.add(new Character('\u305a'));
        f.add(new Character('\u305b'));
        f.add(new Character('\u305c'));
        f.add(new Character('\u305d'));
        f.add(new Character('\u305e'));
        f.add(new Character('\u305f'));
        f.add(new Character('\u3060'));
        f.add(new Character('\u3061'));
        f.add(new Character('\u3062'));
        f.add(new Character('\u3063'));
        f.add(new Character('\u3064'));
        f.add(new Character('\u3065'));
        f.add(new Character('\u3066'));
        f.add(new Character('\u3067'));
        f.add(new Character('\u3068'));
        f.add(new Character('\u3069'));
        f.add(new Character('\u306a'));
        f.add(new Character('\u306b'));
        f.add(new Character('\u306c'));
        f.add(new Character('\u306d'));
        f.add(new Character('\u306e'));
        f.add(new Character('\u306f'));
        f.add(new Character('\u3070'));
        f.add(new Character('\u3071'));
        f.add(new Character('\u3072'));
        f.add(new Character('\u3073'));
        f.add(new Character('\u3074'));
        f.add(new Character('\u3075'));
        f.add(new Character('\u3076'));
        f.add(new Character('\u3077'));
        f.add(new Character('\u3078'));
        f.add(new Character('\u3079'));
        f.add(new Character('\u307a'));
        f.add(new Character('\u307b'));
        f.add(new Character('\u307c'));
        f.add(new Character('\u307d'));
        f.add(new Character('\u307e'));
        f.add(new Character('\u307f'));
        f.add(new Character('\u3080'));
        f.add(new Character('\u3081'));
        f.add(new Character('\u3082'));
        f.add(new Character('\u3083'));
        f.add(new Character('\u3084'));
        f.add(new Character('\u3085'));
        f.add(new Character('\u3086'));
        f.add(new Character('\u3087'));
        f.add(new Character('\u3088'));
        f.add(new Character('\u3089'));
        f.add(new Character('\u308a'));
        f.add(new Character('\u308b'));
        f.add(new Character('\u308c'));
        f.add(new Character('\u308d'));
        f.add(new Character('\u308e'));
        f.add(new Character('\u308f'));
        f.add(new Character('\u3090'));
        f.add(new Character('\u3091'));
        f.add(new Character('\u3092'));
        f.add(new Character('\u3093'));
        f.add(new Character('\u309b'));
        f.add(new Character('\u309c'));
        f.add(new Character('\u309d'));
        f.add(new Character('\u309e'));
        f.add(new Character('\u30a1'));
        f.add(new Character('\u30a2'));
        f.add(new Character('\u30a3'));
        f.add(new Character('\u30a4'));
        f.add(new Character('\u30a5'));
        f.add(new Character('\u30a6'));
        f.add(new Character('\u30a7'));
        f.add(new Character('\u30a8'));
        f.add(new Character('\u30a9'));
        f.add(new Character('\u30aa'));
        f.add(new Character('\u30ab'));
        f.add(new Character('\u30ac'));
        f.add(new Character('\u30ad'));
        f.add(new Character('\u30ae'));
        f.add(new Character('\u30af'));
        f.add(new Character('\u30b0'));
        f.add(new Character('\u30b1'));
        f.add(new Character('\u30b2'));
        f.add(new Character('\u30b3'));
        f.add(new Character('\u30b4'));
        f.add(new Character('\u30b5'));
        f.add(new Character('\u30b6'));
        f.add(new Character('\u30b7'));
        f.add(new Character('\u30b8'));
        f.add(new Character('\u30b9'));
        f.add(new Character('\u30ba'));
        f.add(new Character('\u30bb'));
        f.add(new Character('\u30bc'));
        f.add(new Character('\u30bd'));
        f.add(new Character('\u30be'));
        f.add(new Character('\u30bf'));
        f.add(new Character('\u30c0'));
        f.add(new Character('\u30c1'));
        f.add(new Character('\u30c2'));
        f.add(new Character('\u30c3'));
        f.add(new Character('\u30c4'));
        f.add(new Character('\u30c5'));
        f.add(new Character('\u30c6'));
        f.add(new Character('\u30c7'));
        f.add(new Character('\u30c8'));
        f.add(new Character('\u30c9'));
        f.add(new Character('\u30ca'));
        f.add(new Character('\u30cb'));
        f.add(new Character('\u30cc'));
        f.add(new Character('\u30cd'));
        f.add(new Character('\u30ce'));
        f.add(new Character('\u30cf'));
        f.add(new Character('\u30d0'));
        f.add(new Character('\u30d1'));
        f.add(new Character('\u30d2'));
        f.add(new Character('\u30d3'));
        f.add(new Character('\u30d4'));
        f.add(new Character('\u30d5'));
        f.add(new Character('\u30d6'));
        f.add(new Character('\u30d7'));
        f.add(new Character('\u30d8'));
        f.add(new Character('\u30d9'));
        f.add(new Character('\u30da'));
        f.add(new Character('\u30db'));
        f.add(new Character('\u30dc'));
        f.add(new Character('\u30dd'));
        f.add(new Character('\u30de'));
        f.add(new Character('\u30df'));
        f.add(new Character('\u30e0'));
        f.add(new Character('\u30e1'));
        f.add(new Character('\u30e2'));
        f.add(new Character('\u30e3'));
        f.add(new Character('\u30e4'));
        f.add(new Character('\u30e5'));
        f.add(new Character('\u30e6'));
        f.add(new Character('\u30e7'));
        f.add(new Character('\u30e8'));
        f.add(new Character('\u30e9'));
        f.add(new Character('\u30ea'));
        f.add(new Character('\u30eb'));
        f.add(new Character('\u30ec'));
        f.add(new Character('\u30ed'));
        f.add(new Character('\u30ee'));
        f.add(new Character('\u30ef'));
        f.add(new Character('\u30f0'));
        f.add(new Character('\u30f1'));
        f.add(new Character('\u30f2'));
        f.add(new Character('\u30f3'));
        f.add(new Character('\u30f4'));
        f.add(new Character('\u30f5'));
        f.add(new Character('\u30f6'));
        f.add(new Character('\u30fc'));
        f.add(new Character('\u30fd'));
        f.add(new Character('\u30fe'));
        f.add(new Character('\u3105'));
        f.add(new Character('\u3106'));
        f.add(new Character('\u3107'));
        f.add(new Character('\u3108'));
        f.add(new Character('\u3109'));
        f.add(new Character('\u310a'));
        f.add(new Character('\u310b'));
        f.add(new Character('\u310c'));
        f.add(new Character('\u310d'));
        f.add(new Character('\u310e'));
        f.add(new Character('\u310f'));
        f.add(new Character('\u3110'));
        f.add(new Character('\u3111'));
        f.add(new Character('\u3112'));
        f.add(new Character('\u3113'));
        f.add(new Character('\u3114'));
        f.add(new Character('\u3115'));
        f.add(new Character('\u3116'));
        f.add(new Character('\u3117'));
        f.add(new Character('\u3118'));
        f.add(new Character('\u3119'));
        f.add(new Character('\u311a'));
        f.add(new Character('\u311b'));
        f.add(new Character('\u311c'));
        f.add(new Character('\u311d'));
        f.add(new Character('\u311e'));
        f.add(new Character('\u311f'));
        f.add(new Character('\u3120'));
        f.add(new Character('\u3121'));
        f.add(new Character('\u3122'));
        f.add(new Character('\u3123'));
        f.add(new Character('\u3124'));
        f.add(new Character('\u3125'));
        f.add(new Character('\u3126'));
        f.add(new Character('\u3127'));
        f.add(new Character('\u3128'));
        f.add(new Character('\u3129'));
        f.add(new Character('\u3220'));
        f.add(new Character('\u3221'));
        f.add(new Character('\u3222'));
        f.add(new Character('\u3223'));
        f.add(new Character('\u3224'));
        f.add(new Character('\u3225'));
        f.add(new Character('\u3226'));
        f.add(new Character('\u3227'));
        f.add(new Character('\u3228'));
        f.add(new Character('\u3229'));
        f.add(new Character('\u3231'));
        f.add(new Character('\u32a3'));
        f.add(new Character('\u338e'));
        f.add(new Character('\u338f'));
        f.add(new Character('\u339c'));
        f.add(new Character('\u339d'));
        f.add(new Character('\u339e'));
        f.add(new Character('\u33a1'));
        f.add(new Character('\u33c4'));
        f.add(new Character('\u33ce'));
        f.add(new Character('\u33d1'));
        f.add(new Character('\u33d2'));
        f.add(new Character('\u33d5'));
        f.add(new Character('\u3447'));
        f.add(new Character('\u3473'));
        f.add(new Character('\u359e'));
        f.add(new Character('\u360e'));
        f.add(new Character('\u361a'));
        f.add(new Character('\u3918'));
        f.add(new Character('\u396e'));
        f.add(new Character('\u39cf'));
        f.add(new Character('\u39d0'));
        f.add(new Character('\u39df'));
        f.add(new Character('\u3a73'));
        f.add(new Character('\u3b4e'));
        f.add(new Character('\u3c6e'));
        f.add(new Character('\u3ce0'));
        f.add(new Character('\u4056'));
        f.add(new Character('\u415f'));
        f.add(new Character('\u4337'));
        f.add(new Character('\u43ac'));
        f.add(new Character('\u43b1'));
        f.add(new Character('\u43dd'));
        f.add(new Character('\u44d6'));
        f.add(new Character('\u464c'));
        f.add(new Character('\u4661'));
        f.add(new Character('\u4723'));
        f.add(new Character('\u4729'));
        f.add(new Character('\u477c'));
        f.add(new Character('\u478d'));
        f.add(new Character('\u4947'));
        f.add(new Character('\u497a'));
        f.add(new Character('\u497d'));
        f.add(new Character('\u4982'));
        f.add(new Character('\u4983'));
        f.add(new Character('\u4985'));
        f.add(new Character('\u4986'));
        f.add(new Character('\u499b'));
        f.add(new Character('\u499f'));
        f.add(new Character('\u49b6'));
        f.add(new Character('\u49b7'));
        f.add(new Character('\u4c77'));
        f.add(new Character('\u4c9f'));
        f.add(new Character('\u4ca0'));
        f.add(new Character('\u4ca1'));
        f.add(new Character('\u4ca2'));
        f.add(new Character('\u4ca3'));
        f.add(new Character('\u4d13'));
        f.add(new Character('\u4d14'));
        f.add(new Character('\u4d15'));
        f.add(new Character('\u4d16'));
        f.add(new Character('\u4d17'));
        f.add(new Character('\u4d18'));
        f.add(new Character('\u4d19'));
        f.add(new Character('\u4dae'));
        f.add(new Character('\u4e00'));
        f.add(new Character('\u4e01'));
        f.add(new Character('\u4e02'));
        f.add(new Character('\u4e03'));
        f.add(new Character('\u4e04'));
        f.add(new Character('\u4e05'));
        f.add(new Character('\u4e06'));
        f.add(new Character('\u4e07'));
        f.add(new Character('\u4e08'));
        f.add(new Character('\u4e09'));
    }

    protected static void initTWFlags(HashSet f) {
        f.add(new Character('\u00a7'));
        f.add(new Character('\u00a8'));
        f.add(new Character('\u00af'));
        f.add(new Character('\u00b0'));
        f.add(new Character('\u00b1'));
        f.add(new Character('\u00b4'));
        f.add(new Character('\u00b6'));
        f.add(new Character('\u00b7'));
        f.add(new Character('\u00d7'));
        f.add(new Character('\u0100'));
        f.add(new Character('\u0101'));
        f.add(new Character('\u0102'));
        f.add(new Character('\u0103'));
        f.add(new Character('\u0104'));
        f.add(new Character('\u0105'));
        f.add(new Character('\u0106'));
        f.add(new Character('\u0107'));
        f.add(new Character('\u0108'));
        f.add(new Character('\u0109'));
        f.add(new Character('\u010a'));
        f.add(new Character('\u010b'));
        f.add(new Character('\u010c'));
        f.add(new Character('\u010d'));
        f.add(new Character('\u010e'));
        f.add(new Character('\u010f'));
        f.add(new Character('\u0110'));
        f.add(new Character('\u0111'));
        f.add(new Character('\u0112'));
        f.add(new Character('\u0113'));
        f.add(new Character('\u0114'));
        f.add(new Character('\u0115'));
        f.add(new Character('\u0116'));
        f.add(new Character('\u0117'));
        f.add(new Character('\u0118'));
        f.add(new Character('\u0119'));
        f.add(new Character('\u011a'));
        f.add(new Character('\u011b'));
        f.add(new Character('\u011c'));
        f.add(new Character('\u011d'));
        f.add(new Character('\u011e'));
        f.add(new Character('\u011f'));
        f.add(new Character('\u0120'));
        f.add(new Character('\u0121'));
        f.add(new Character('\u0122'));
        f.add(new Character('\u0123'));
        f.add(new Character('\u0124'));
        f.add(new Character('\u0125'));
        f.add(new Character('\u0126'));
        f.add(new Character('\u0127'));
        f.add(new Character('\u0128'));
        f.add(new Character('\u0129'));
        f.add(new Character('\u012a'));
        f.add(new Character('\u012b'));
        f.add(new Character('\u012c'));
        f.add(new Character('\u012d'));
        f.add(new Character('\u012e'));
        f.add(new Character('\u012f'));
        f.add(new Character('\u0130'));
        f.add(new Character('\u0131'));
        f.add(new Character('\u0132'));
        f.add(new Character('\u0133'));
        f.add(new Character('\u0134'));
        f.add(new Character('\u0135'));
        f.add(new Character('\u0136'));
        f.add(new Character('\u0137'));
        f.add(new Character('\u0138'));
        f.add(new Character('\u0139'));
        f.add(new Character('\u013a'));
        f.add(new Character('\u013b'));
        f.add(new Character('\u013c'));
        f.add(new Character('\u013d'));
        f.add(new Character('\u013e'));
        f.add(new Character('\u013f'));
        f.add(new Character('\u0140'));
        f.add(new Character('\u0141'));
        f.add(new Character('\u0142'));
        f.add(new Character('\u0143'));
        f.add(new Character('\u0144'));
        f.add(new Character('\u0145'));
        f.add(new Character('\u0146'));
        f.add(new Character('\u0147'));
        f.add(new Character('\u0148'));
        f.add(new Character('\u0149'));
        f.add(new Character('\u014a'));
        f.add(new Character('\u014b'));
        f.add(new Character('\u014c'));
        f.add(new Character('\u014d'));
        f.add(new Character('\u014e'));
        f.add(new Character('\u014f'));
        f.add(new Character('\u0150'));
        f.add(new Character('\u0151'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0154'));
        f.add(new Character('\u0155'));
        f.add(new Character('\u0156'));
        f.add(new Character('\u0157'));
        f.add(new Character('\u0158'));
        f.add(new Character('\u0159'));
        f.add(new Character('\u015a'));
        f.add(new Character('\u015b'));
        f.add(new Character('\u015c'));
        f.add(new Character('\u015d'));
        f.add(new Character('\u015e'));
        f.add(new Character('\u015f'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0162'));
        f.add(new Character('\u0163'));
        f.add(new Character('\u0164'));
        f.add(new Character('\u0165'));
        f.add(new Character('\u0166'));
        f.add(new Character('\u0167'));
        f.add(new Character('\u0168'));
        f.add(new Character('\u0169'));
        f.add(new Character('\u016a'));
        f.add(new Character('\u016b'));
        f.add(new Character('\u016c'));
        f.add(new Character('\u016d'));
        f.add(new Character('\u016e'));
        f.add(new Character('\u016f'));
        f.add(new Character('\u0170'));
        f.add(new Character('\u0171'));
        f.add(new Character('\u0172'));
        f.add(new Character('\u0173'));
        f.add(new Character('\u0174'));
        f.add(new Character('\u0175'));
        f.add(new Character('\u0176'));
        f.add(new Character('\u0177'));
        f.add(new Character('\u0178'));
        f.add(new Character('\u0179'));
        f.add(new Character('\u017a'));
        f.add(new Character('\u017b'));
        f.add(new Character('\u017c'));
        f.add(new Character('\u017d'));
        f.add(new Character('\u017e'));
        f.add(new Character('\u017f'));
        f.add(new Character('\u0180'));
        f.add(new Character('\u0181'));
        f.add(new Character('\u0182'));
        f.add(new Character('\u0183'));
        f.add(new Character('\u0184'));
        f.add(new Character('\u0185'));
        f.add(new Character('\u0186'));
        f.add(new Character('\u0187'));
        f.add(new Character('\u0188'));
        f.add(new Character('\u0189'));
        f.add(new Character('\u018a'));
        f.add(new Character('\u018b'));
        f.add(new Character('\u018c'));
        f.add(new Character('\u018d'));
        f.add(new Character('\u018e'));
        f.add(new Character('\u018f'));
        f.add(new Character('\u0190'));
        f.add(new Character('\u0191'));
        f.add(new Character('\u0192'));
        f.add(new Character('\u0193'));
        f.add(new Character('\u0194'));
        f.add(new Character('\u0195'));
        f.add(new Character('\u0196'));
        f.add(new Character('\u0197'));
        f.add(new Character('\u0198'));
        f.add(new Character('\u0199'));
        f.add(new Character('\u019a'));
        f.add(new Character('\u019b'));
        f.add(new Character('\u019c'));
        f.add(new Character('\u019d'));
        f.add(new Character('\u019e'));
        f.add(new Character('\u019f'));
        f.add(new Character('\u01a0'));
        f.add(new Character('\u01a1'));
        f.add(new Character('\u01a2'));
        f.add(new Character('\u01a3'));
        f.add(new Character('\u01a4'));
        f.add(new Character('\u01a5'));
        f.add(new Character('\u01a6'));
        f.add(new Character('\u01a7'));
        f.add(new Character('\u01a8'));
        f.add(new Character('\u01a9'));
        f.add(new Character('\u01aa'));
        f.add(new Character('\u01ab'));
        f.add(new Character('\u01ac'));
        f.add(new Character('\u01ad'));
        f.add(new Character('\u01ae'));
        f.add(new Character('\u01af'));
        f.add(new Character('\u01b0'));
        f.add(new Character('\u01b1'));
        f.add(new Character('\u01b2'));
        f.add(new Character('\u01b3'));
        f.add(new Character('\u01b4'));
        f.add(new Character('\u01b5'));
        f.add(new Character('\u01b6'));
        f.add(new Character('\u01b7'));
        f.add(new Character('\u01b8'));
        f.add(new Character('\u01b9'));
        f.add(new Character('\u01ba'));
        f.add(new Character('\u01bb'));
        f.add(new Character('\u01bc'));
        f.add(new Character('\u01bd'));
        f.add(new Character('\u01be'));
        f.add(new Character('\u01bf'));
        f.add(new Character('\u01c0'));
        f.add(new Character('\u01c1'));
        f.add(new Character('\u01c2'));
        f.add(new Character('\u01c3'));
        f.add(new Character('\u01c4'));
        f.add(new Character('\u01c5'));
        f.add(new Character('\u01c6'));
        f.add(new Character('\u01c7'));
        f.add(new Character('\u01c8'));
        f.add(new Character('\u01c9'));
        f.add(new Character('\u01ca'));
        f.add(new Character('\u01cb'));
        f.add(new Character('\u01cc'));
        f.add(new Character('\u01cd'));
        f.add(new Character('\u01ce'));
        f.add(new Character('\u01cf'));
        f.add(new Character('\u01d0'));
        f.add(new Character('\u01d1'));
        f.add(new Character('\u01d2'));
        f.add(new Character('\u01d3'));
        f.add(new Character('\u01d4'));
        f.add(new Character('\u01d5'));
        f.add(new Character('\u01d6'));
        f.add(new Character('\u01d7'));
        f.add(new Character('\u01d8'));
        f.add(new Character('\u01d9'));
        f.add(new Character('\u01da'));
        f.add(new Character('\u01db'));
        f.add(new Character('\u01dc'));
        f.add(new Character('\u01dd'));
        f.add(new Character('\u01de'));
        f.add(new Character('\u01df'));
        f.add(new Character('\u01e0'));
        f.add(new Character('\u01e1'));
        f.add(new Character('\u01e2'));
        f.add(new Character('\u01e3'));
        f.add(new Character('\u01e4'));
        f.add(new Character('\u01e5'));
        f.add(new Character('\u01e6'));
        f.add(new Character('\u01e7'));
        f.add(new Character('\u01e8'));
        f.add(new Character('\u01e9'));
        f.add(new Character('\u01ea'));
        f.add(new Character('\u01eb'));
        f.add(new Character('\u01ec'));
        f.add(new Character('\u01ed'));
        f.add(new Character('\u01ee'));
        f.add(new Character('\u01ef'));
        f.add(new Character('\u01f0'));
        f.add(new Character('\u01f1'));
        f.add(new Character('\u01f2'));
        f.add(new Character('\u01f3'));
        f.add(new Character('\u01f4'));
        f.add(new Character('\u01f5'));
        f.add(new Character('\u01f6'));
        f.add(new Character('\u01f7'));
        f.add(new Character('\u01f8'));
        f.add(new Character('\u01f9'));
        f.add(new Character('\u01fa'));
        f.add(new Character('\u01fb'));
        f.add(new Character('\u01fc'));
        f.add(new Character('\u01fd'));
        f.add(new Character('\u01fe'));
        f.add(new Character('\u01ff'));
        f.add(new Character('\u0200'));
        f.add(new Character('\u0201'));
        f.add(new Character('\u0202'));
        f.add(new Character('\u0203'));
        f.add(new Character('\u0204'));
        f.add(new Character('\u0205'));
        f.add(new Character('\u0206'));
        f.add(new Character('\u0207'));
        f.add(new Character('\u0208'));
        f.add(new Character('\u0209'));
        f.add(new Character('\u020a'));
        f.add(new Character('\u020b'));
        f.add(new Character('\u020c'));
        f.add(new Character('\u020d'));
        f.add(new Character('\u020e'));
        f.add(new Character('\u020f'));
        f.add(new Character('\u0210'));
        f.add(new Character('\u0211'));
        f.add(new Character('\u0212'));
        f.add(new Character('\u0213'));
        f.add(new Character('\u0214'));
        f.add(new Character('\u0215'));
        f.add(new Character('\u0216'));
        f.add(new Character('\u0217'));
        f.add(new Character('\u0218'));
        f.add(new Character('\u0219'));
        f.add(new Character('\u021a'));
        f.add(new Character('\u021b'));
        f.add(new Character('\u021c'));
        f.add(new Character('\u021d'));
        f.add(new Character('\u021e'));
        f.add(new Character('\u021f'));
        f.add(new Character('\u0220'));
        f.add(new Character('\u0221'));
        f.add(new Character('\u0222'));
        f.add(new Character('\u0223'));
        f.add(new Character('\u0224'));
        f.add(new Character('\u0225'));
        f.add(new Character('\u0226'));
        f.add(new Character('\u0227'));
        f.add(new Character('\u0228'));
        f.add(new Character('\u0229'));
        f.add(new Character('\u022a'));
        f.add(new Character('\u022b'));
        f.add(new Character('\u022c'));
        f.add(new Character('\u022d'));
        f.add(new Character('\u022e'));
        f.add(new Character('\u022f'));
        f.add(new Character('\u0230'));
        f.add(new Character('\u0231'));
        f.add(new Character('\u0232'));
        f.add(new Character('\u0233'));
        f.add(new Character('\u0234'));
        f.add(new Character('\u0235'));
        f.add(new Character('\u0236'));
        f.add(new Character('\u0237'));
        f.add(new Character('\u0238'));
        f.add(new Character('\u0239'));
        f.add(new Character('\u023a'));
        f.add(new Character('\u023b'));
        f.add(new Character('\u023c'));
        f.add(new Character('\u023d'));
        f.add(new Character('\u023e'));
        f.add(new Character('\u023f'));
        f.add(new Character('\u0240'));
        f.add(new Character('\u0241'));
        f.add(new Character('\u0242'));
        f.add(new Character('\u0243'));
        f.add(new Character('\u0244'));
        f.add(new Character('\u0245'));
        f.add(new Character('\u0246'));
        f.add(new Character('\u0247'));
        f.add(new Character('\u0248'));
        f.add(new Character('\u0249'));
        f.add(new Character('\u024a'));
        f.add(new Character('\u024b'));
        f.add(new Character('\u024c'));
        f.add(new Character('\u024d'));
        f.add(new Character('\u024e'));
        f.add(new Character('\u024f'));
        f.add(new Character('\u0250'));
        f.add(new Character('\u0251'));
        f.add(new Character('\u0252'));
        f.add(new Character('\u0253'));
        f.add(new Character('\u0254'));
        f.add(new Character('\u0255'));
        f.add(new Character('\u0256'));
        f.add(new Character('\u0257'));
        f.add(new Character('\u0258'));
        f.add(new Character('\u0259'));
        f.add(new Character('\u025a'));
        f.add(new Character('\u025b'));
        f.add(new Character('\u025c'));
        f.add(new Character('\u025d'));
        f.add(new Character('\u025e'));
        f.add(new Character('\u025f'));
        f.add(new Character('\u0260'));
        f.add(new Character('\u0261'));
        f.add(new Character('\u0262'));
        f.add(new Character('\u0263'));
        f.add(new Character('\u0264'));
        f.add(new Character('\u0265'));
        f.add(new Character('\u0266'));
        f.add(new Character('\u0267'));
        f.add(new Character('\u0268'));
        f.add(new Character('\u0269'));
        f.add(new Character('\u026a'));
        f.add(new Character('\u026b'));
        f.add(new Character('\u026c'));
        f.add(new Character('\u026d'));
        f.add(new Character('\u026e'));
        f.add(new Character('\u026f'));
        f.add(new Character('\u0270'));
        f.add(new Character('\u0271'));
        f.add(new Character('\u0272'));
        f.add(new Character('\u0273'));
        f.add(new Character('\u0274'));
        f.add(new Character('\u0275'));
        f.add(new Character('\u0276'));
        f.add(new Character('\u0277'));
        f.add(new Character('\u0278'));
        f.add(new Character('\u0279'));
        f.add(new Character('\u027a'));
        f.add(new Character('\u027b'));
        f.add(new Character('\u027c'));
        f.add(new Character('\u027d'));
        f.add(new Character('\u027e'));
        f.add(new Character('\u027f'));
        f.add(new Character('\u0280'));
        f.add(new Character('\u0281'));
        f.add(new Character('\u0282'));
        f.add(new Character('\u0283'));
        f.add(new Character('\u0284'));
        f.add(new Character('\u0285'));
        f.add(new Character('\u0286'));
        f.add(new Character('\u0287'));
        f.add(new Character('\u0288'));
        f.add(new Character('\u0289'));
        f.add(new Character('\u028a'));
        f.add(new Character('\u028b'));
        f.add(new Character('\u028c'));
        f.add(new Character('\u028d'));
        f.add(new Character('\u028e'));
        f.add(new Character('\u028f'));
        f.add(new Character('\u0290'));
        f.add(new Character('\u0291'));
        f.add(new Character('\u0292'));
        f.add(new Character('\u0293'));
        f.add(new Character('\u0294'));
        f.add(new Character('\u0295'));
        f.add(new Character('\u0296'));
        f.add(new Character('\u0297'));
        f.add(new Character('\u0298'));
        f.add(new Character('\u0299'));
        f.add(new Character('\u029a'));
        f.add(new Character('\u029b'));
        f.add(new Character('\u029c'));
        f.add(new Character('\u029d'));
        f.add(new Character('\u029e'));
        f.add(new Character('\u029f'));
        f.add(new Character('\u02a0'));
        f.add(new Character('\u02a1'));
        f.add(new Character('\u02a2'));
        f.add(new Character('\u02a3'));
        f.add(new Character('\u02a4'));
        f.add(new Character('\u02a5'));
        f.add(new Character('\u02a6'));
        f.add(new Character('\u02a7'));
        f.add(new Character('\u02a8'));
        f.add(new Character('\u02a9'));
        f.add(new Character('\u02aa'));
        f.add(new Character('\u02ab'));
        f.add(new Character('\u02ac'));
        f.add(new Character('\u02ad'));
        f.add(new Character('\u02ae'));
        f.add(new Character('\u02af'));
        f.add(new Character('\u02b0'));
        f.add(new Character('\u02b1'));
        f.add(new Character('\u02b2'));
        f.add(new Character('\u02b3'));
        f.add(new Character('\u02b4'));
        f.add(new Character('\u02b5'));
        f.add(new Character('\u02b6'));
        f.add(new Character('\u02b7'));
        f.add(new Character('\u02b8'));
        f.add(new Character('\u02b9'));
        f.add(new Character('\u02ba'));
        f.add(new Character('\u02bb'));
        f.add(new Character('\u02bc'));
        f.add(new Character('\u02bd'));
        f.add(new Character('\u02be'));
        f.add(new Character('\u02bf'));
        f.add(new Character('\u02c0'));
        f.add(new Character('\u02c1'));
        f.add(new Character('\u02c2'));
        f.add(new Character('\u02c3'));
        f.add(new Character('\u02c4'));
        f.add(new Character('\u02c5'));
        f.add(new Character('\u02c6'));
        f.add(new Character('\u02c7'));
        f.add(new Character('\u02c8'));
        f.add(new Character('\u02c9'));
        f.add(new Character('\u02ca'));
        f.add(new Character('\u02cb'));
        f.add(new Character('\u02cc'));
        f.add(new Character('\u02cd'));
        f.add(new Character('\u02ce'));
        f.add(new Character('\u02cf'));
        f.add(new Character('\u02d0'));
        f.add(new Character('\u02d1'));
        f.add(new Character('\u02d2'));
        f.add(new Character('\u02d3'));
        f.add(new Character('\u02d4'));
        f.add(new Character('\u02d5'));
        f.add(new Character('\u02d6'));
        f.add(new Character('\u02d7'));
        f.add(new Character('\u02d8'));
        f.add(new Character('\u02d9'));
        f.add(new Character('\u02da'));
        f.add(new Character('\u02db'));
        f.add(new Character('\u02dc'));
        f.add(new Character('\u02dd'));
        f.add(new Character('\u02de'));
        f.add(new Character('\u02df'));
        f.add(new Character('\u02e0'));
        f.add(new Character('\u02e1'));
        f.add(new Character('\u02e2'));
        f.add(new Character('\u02e3'));
        f.add(new Character('\u02e4'));
        f.add(new Character('\u02e5'));
        f.add(new Character('\u02e6'));
        f.add(new Character('\u02e7'));
        f.add(new Character('\u02e8'));
        f.add(new Character('\u02e9'));
        f.add(new Character('\u02ea'));
        f.add(new Character('\u02eb'));
        f.add(new Character('\u02ec'));
        f.add(new Character('\u02ed'));
        f.add(new Character('\u02ee'));
        f.add(new Character('\u02ef'));
        f.add(new Character('\u02f0'));
        f.add(new Character('\u02f1'));
        f.add(new Character('\u02f2'));
        f.add(new Character('\u02f3'));
        f.add(new Character('\u02f4'));
        f.add(new Character('\u02f5'));
        f.add(new Character('\u02f6'));
        f.add(new Character('\u02f7'));
        f.add(new Character('\u02f8'));
        f.add(new Character('\u02f9'));
        f.add(new Character('\u02fa'));
        f.add(new Character('\u02fb'));
        f.add(new Character('\u02fc'));
        f.add(new Character('\u02fd'));
        f.add(new Character('\u02fe'));
        f.add(new Character('\u02ff'));
        f.add(new Character('\u0300'));
        f.add(new Character('\u0301'));
        f.add(new Character('\u0302'));
        f.add(new Character('\u0303'));
        f.add(new Character('\u0304'));
        f.add(new Character('\u0305'));
        f.add(new Character('\u0306'));
        f.add(new Character('\u0307'));
        f.add(new Character('\u0308'));
        f.add(new Character('\u0309'));
        f.add(new Character('\u030a'));
        f.add(new Character('\u030b'));
        f.add(new Character('\u030c'));
        f.add(new Character('\u030d'));
        f.add(new Character('\u030e'));
        f.add(new Character('\u030f'));
        f.add(new Character('\u0310'));
        f.add(new Character('\u0311'));
        f.add(new Character('\u0312'));
        f.add(new Character('\u0313'));
        f.add(new Character('\u0314'));
        f.add(new Character('\u0315'));
        f.add(new Character('\u0316'));
        f.add(new Character('\u0317'));
        f.add(new Character('\u0318'));
        f.add(new Character('\u0319'));
        f.add(new Character('\u031a'));
        f.add(new Character('\u031b'));
        f.add(new Character('\u031c'));
        f.add(new Character('\u031d'));
        f.add(new Character('\u031e'));
        f.add(new Character('\u031f'));
        f.add(new Character('\u0320'));
        f.add(new Character('\u0321'));
        f.add(new Character('\u0322'));
        f.add(new Character('\u0323'));
        f.add(new Character('\u0324'));
        f.add(new Character('\u0325'));
        f.add(new Character('\u0326'));
        f.add(new Character('\u0327'));
        f.add(new Character('\u0328'));
        f.add(new Character('\u0329'));
        f.add(new Character('\u032a'));
        f.add(new Character('\u032b'));
        f.add(new Character('\u032c'));
        f.add(new Character('\u032d'));
        f.add(new Character('\u032e'));
        f.add(new Character('\u032f'));
        f.add(new Character('\u0330'));
        f.add(new Character('\u0331'));
        f.add(new Character('\u0332'));
        f.add(new Character('\u0333'));
        f.add(new Character('\u0334'));
        f.add(new Character('\u0335'));
        f.add(new Character('\u0336'));
        f.add(new Character('\u0337'));
        f.add(new Character('\u0338'));
        f.add(new Character('\u0339'));
        f.add(new Character('\u033a'));
        f.add(new Character('\u033b'));
        f.add(new Character('\u033c'));
        f.add(new Character('\u033d'));
        f.add(new Character('\u033e'));
        f.add(new Character('\u033f'));
        f.add(new Character('\u0340'));
        f.add(new Character('\u0341'));
        f.add(new Character('\u0342'));
        f.add(new Character('\u0343'));
        f.add(new Character('\u0344'));
        f.add(new Character('\u0345'));
        f.add(new Character('\u0346'));
        f.add(new Character('\u0347'));
        f.add(new Character('\u0348'));
        f.add(new Character('\u0349'));
        f.add(new Character('\u034a'));
        f.add(new Character('\u034b'));
        f.add(new Character('\u034c'));
        f.add(new Character('\u034d'));
        f.add(new Character('\u034e'));
        f.add(new Character('\u034f'));
        f.add(new Character('\u0350'));
        f.add(new Character('\u0351'));
        f.add(new Character('\u0352'));
        f.add(new Character('\u0353'));
        f.add(new Character('\u0354'));
        f.add(new Character('\u0355'));
        f.add(new Character('\u0356'));
        f.add(new Character('\u0357'));
        f.add(new Character('\u0358'));
        f.add(new Character('\u0359'));
        f.add(new Character('\u035a'));
        f.add(new Character('\u035b'));
        f.add(new Character('\u035c'));
        f.add(new Character('\u035d'));
        f.add(new Character('\u035e'));
        f.add(new Character('\u035f'));
        f.add(new Character('\u0360'));
        f.add(new Character('\u0361'));
        f.add(new Character('\u0362'));
        f.add(new Character('\u0363'));
        f.add(new Character('\u0364'));
        f.add(new Character('\u0365'));
        f.add(new Character('\u0366'));
        f.add(new Character('\u0367'));
        f.add(new Character('\u0368'));
        f.add(new Character('\u0369'));
        f.add(new Character('\u036a'));
        f.add(new Character('\u036b'));
        f.add(new Character('\u036c'));
        f.add(new Character('\u036d'));
        f.add(new Character('\u036e'));
        f.add(new Character('\u036f'));
        f.add(new Character('\u0370'));
        f.add(new Character('\u0371'));
        f.add(new Character('\u0372'));
        f.add(new Character('\u0373'));
        f.add(new Character('\u0374'));
        f.add(new Character('\u0375'));
        f.add(new Character('\u0376'));
        f.add(new Character('\u0377'));
        f.add(new Character('\u0378'));
        f.add(new Character('\u0379'));
        f.add(new Character('\u037a'));
        f.add(new Character('\u037b'));
        f.add(new Character('\u037c'));
        f.add(new Character('\u037d'));
        f.add(new Character('\u037e'));
        f.add(new Character('\u037f'));
        f.add(new Character('\u0380'));
        f.add(new Character('\u0381'));
        f.add(new Character('\u0382'));
        f.add(new Character('\u0383'));
        f.add(new Character('\u0384'));
        f.add(new Character('\u0385'));
        f.add(new Character('\u0386'));
        f.add(new Character('\u0387'));
        f.add(new Character('\u0388'));
        f.add(new Character('\u0389'));
        f.add(new Character('\u038a'));
        f.add(new Character('\u038b'));
        f.add(new Character('\u038c'));
        f.add(new Character('\u038d'));
        f.add(new Character('\u038e'));
        f.add(new Character('\u038f'));
        f.add(new Character('\u0390'));
        f.add(new Character('\u0391'));
        f.add(new Character('\u0392'));
        f.add(new Character('\u0393'));
        f.add(new Character('\u0394'));
        f.add(new Character('\u0395'));
        f.add(new Character('\u0396'));
        f.add(new Character('\u0397'));
        f.add(new Character('\u0398'));
        f.add(new Character('\u0399'));
        f.add(new Character('\u039a'));
        f.add(new Character('\u039b'));
        f.add(new Character('\u039c'));
        f.add(new Character('\u039d'));
        f.add(new Character('\u039e'));
        f.add(new Character('\u039f'));
        f.add(new Character('\u03a0'));
        f.add(new Character('\u03a1'));
        f.add(new Character('\u03a2'));
        f.add(new Character('\u03a3'));
        f.add(new Character('\u03a4'));
        f.add(new Character('\u03a5'));
        f.add(new Character('\u03a6'));
        f.add(new Character('\u03a7'));
        f.add(new Character('\u03a8'));
        f.add(new Character('\u03a9'));
        f.add(new Character('\u03aa'));
        f.add(new Character('\u03ab'));
        f.add(new Character('\u03ac'));
        f.add(new Character('\u03ad'));
        f.add(new Character('\u03ae'));
        f.add(new Character('\u03af'));
        f.add(new Character('\u03b0'));
        f.add(new Character('\u03b1'));
        f.add(new Character('\u03b2'));
        f.add(new Character('\u03b3'));
        f.add(new Character('\u03b4'));
        f.add(new Character('\u03b5'));
        f.add(new Character('\u03b6'));
        f.add(new Character('\u03b7'));
        f.add(new Character('\u03b8'));
        f.add(new Character('\u03b9'));
        f.add(new Character('\u03ba'));
        f.add(new Character('\u03bb'));
        f.add(new Character('\u03bc'));
        f.add(new Character('\u03bd'));
        f.add(new Character('\u03be'));
        f.add(new Character('\u03bf'));
        f.add(new Character('\u03c0'));
        f.add(new Character('\u03c1'));
        f.add(new Character('\u03c2'));
        f.add(new Character('\u03c3'));
        f.add(new Character('\u03c4'));
        f.add(new Character('\u03c5'));
        f.add(new Character('\u03c6'));
        f.add(new Character('\u03c7'));
        f.add(new Character('\u03c8'));
        f.add(new Character('\u03c9'));
        f.add(new Character('\u03ca'));
        f.add(new Character('\u03cb'));
        f.add(new Character('\u03cc'));
        f.add(new Character('\u03cd'));
        f.add(new Character('\u03ce'));
        f.add(new Character('\u03cf'));
        f.add(new Character('\u03d0'));
        f.add(new Character('\u03d1'));
        f.add(new Character('\u03d2'));
        f.add(new Character('\u03d3'));
        f.add(new Character('\u03d4'));
        f.add(new Character('\u03d5'));
        f.add(new Character('\u03d6'));
        f.add(new Character('\u03d7'));
        f.add(new Character('\u03d8'));
        f.add(new Character('\u03d9'));
        f.add(new Character('\u03da'));
        f.add(new Character('\u03db'));
        f.add(new Character('\u03dc'));
        f.add(new Character('\u03dd'));
        f.add(new Character('\u03de'));
        f.add(new Character('\u03df'));
        f.add(new Character('\u03e0'));
        f.add(new Character('\u03e1'));
        f.add(new Character('\u03e2'));
        f.add(new Character('\u03e3'));
        f.add(new Character('\u03e4'));
        f.add(new Character('\u03e5'));
        f.add(new Character('\u03e6'));
        f.add(new Character('\u03e7'));
        f.add(new Character('\u03e8'));
        f.add(new Character('\u03e9'));
        f.add(new Character('\u03ea'));
        f.add(new Character('\u03eb'));
        f.add(new Character('\u03ec'));
        f.add(new Character('\u03ed'));
        f.add(new Character('\u03ee'));
        f.add(new Character('\u03ef'));
        f.add(new Character('\u03f0'));
        f.add(new Character('\u03f1'));
        f.add(new Character('\u03f2'));
        f.add(new Character('\u03f3'));
        f.add(new Character('\u03f4'));
        f.add(new Character('\u03f5'));
        f.add(new Character('\u03f6'));
        f.add(new Character('\u03f7'));
        f.add(new Character('\u03f8'));
        f.add(new Character('\u03f9'));
        f.add(new Character('\u03fa'));
        f.add(new Character('\u03fb'));
        f.add(new Character('\u03fc'));
        f.add(new Character('\u03fd'));
        f.add(new Character('\u03fe'));
        f.add(new Character('\u03ff'));
        f.add(new Character('\u0400'));
        f.add(new Character('\u0401'));
        f.add(new Character('\u0402'));
        f.add(new Character('\u0403'));
        f.add(new Character('\u0404'));
        f.add(new Character('\u0405'));
        f.add(new Character('\u0406'));
        f.add(new Character('\u0407'));
        f.add(new Character('\u0408'));
        f.add(new Character('\u0409'));
        f.add(new Character('\u040a'));
        f.add(new Character('\u040b'));
        f.add(new Character('\u040c'));
        f.add(new Character('\u040d'));
        f.add(new Character('\u040e'));
        f.add(new Character('\u040f'));
        f.add(new Character('\u0410'));
        f.add(new Character('\u0411'));
        f.add(new Character('\u0412'));
        f.add(new Character('\u0413'));
        f.add(new Character('\u0414'));
        f.add(new Character('\u0415'));
        f.add(new Character('\u0416'));
        f.add(new Character('\u0417'));
        f.add(new Character('\u0418'));
        f.add(new Character('\u0419'));
        f.add(new Character('\u041a'));
        f.add(new Character('\u041b'));
        f.add(new Character('\u041c'));
        f.add(new Character('\u041d'));
        f.add(new Character('\u041e'));
        f.add(new Character('\u041f'));
        f.add(new Character('\u0420'));
        f.add(new Character('\u0421'));
        f.add(new Character('\u0422'));
        f.add(new Character('\u0423'));
        f.add(new Character('\u0424'));
        f.add(new Character('\u0425'));
        f.add(new Character('\u0426'));
        f.add(new Character('\u0427'));
        f.add(new Character('\u0428'));
        f.add(new Character('\u0429'));
        f.add(new Character('\u042a'));
        f.add(new Character('\u042b'));
        f.add(new Character('\u042c'));
        f.add(new Character('\u042d'));
        f.add(new Character('\u042e'));
        f.add(new Character('\u042f'));
        f.add(new Character('\u0430'));
        f.add(new Character('\u0431'));
        f.add(new Character('\u0432'));
        f.add(new Character('\u0433'));
        f.add(new Character('\u0434'));
        f.add(new Character('\u0435'));
        f.add(new Character('\u0436'));
        f.add(new Character('\u0437'));
        f.add(new Character('\u0438'));
        f.add(new Character('\u0439'));
        f.add(new Character('\u043a'));
        f.add(new Character('\u043b'));
        f.add(new Character('\u043c'));
        f.add(new Character('\u043d'));
        f.add(new Character('\u043e'));
        f.add(new Character('\u043f'));
        f.add(new Character('\u0440'));
        f.add(new Character('\u0441'));
        f.add(new Character('\u0442'));
        f.add(new Character('\u0443'));
        f.add(new Character('\u0444'));
        f.add(new Character('\u0445'));
        f.add(new Character('\u0446'));
        f.add(new Character('\u0447'));
        f.add(new Character('\u0448'));
        f.add(new Character('\u0449'));
        f.add(new Character('\u044a'));
        f.add(new Character('\u044b'));
        f.add(new Character('\u044c'));
        f.add(new Character('\u044d'));
        f.add(new Character('\u044e'));
        f.add(new Character('\u044f'));
        f.add(new Character('\u0450'));
        f.add(new Character('\u0451'));
        f.add(new Character('\u0452'));
        f.add(new Character('\u0453'));
        f.add(new Character('\u0454'));
        f.add(new Character('\u0455'));
        f.add(new Character('\u0456'));
        f.add(new Character('\u0457'));
        f.add(new Character('\u0458'));
        f.add(new Character('\u0459'));
        f.add(new Character('\u045a'));
        f.add(new Character('\u045b'));
        f.add(new Character('\u045c'));
        f.add(new Character('\u045d'));
        f.add(new Character('\u045e'));
        f.add(new Character('\u045f'));
        f.add(new Character('\u0460'));
        f.add(new Character('\u0461'));
        f.add(new Character('\u0462'));
        f.add(new Character('\u0463'));
        f.add(new Character('\u0464'));
        f.add(new Character('\u0465'));
        f.add(new Character('\u0466'));
        f.add(new Character('\u0467'));
        f.add(new Character('\u0468'));
        f.add(new Character('\u0469'));
        f.add(new Character('\u046a'));
        f.add(new Character('\u046b'));
        f.add(new Character('\u046c'));
        f.add(new Character('\u046d'));
        f.add(new Character('\u046e'));
        f.add(new Character('\u046f'));
        f.add(new Character('\u0470'));
        f.add(new Character('\u0471'));
        f.add(new Character('\u0472'));
        f.add(new Character('\u0473'));
        f.add(new Character('\u0474'));
        f.add(new Character('\u0475'));
        f.add(new Character('\u0476'));
        f.add(new Character('\u0477'));
        f.add(new Character('\u0478'));
        f.add(new Character('\u0479'));
        f.add(new Character('\u047a'));
        f.add(new Character('\u047b'));
        f.add(new Character('\u047c'));
        f.add(new Character('\u047d'));
        f.add(new Character('\u047e'));
        f.add(new Character('\u047f'));
        f.add(new Character('\u0480'));
        f.add(new Character('\u0481'));
        f.add(new Character('\u0482'));
        f.add(new Character('\u0483'));
        f.add(new Character('\u0484'));
        f.add(new Character('\u0485'));
        f.add(new Character('\u0486'));
        f.add(new Character('\u0487'));
        f.add(new Character('\u0488'));
        f.add(new Character('\u0489'));
        f.add(new Character('\u048a'));
        f.add(new Character('\u048b'));
        f.add(new Character('\u048c'));
        f.add(new Character('\u048d'));
        f.add(new Character('\u048e'));
        f.add(new Character('\u048f'));
        f.add(new Character('\u0490'));
        f.add(new Character('\u0491'));
        f.add(new Character('\u0492'));
        f.add(new Character('\u0493'));
        f.add(new Character('\u0494'));
        f.add(new Character('\u0495'));
        f.add(new Character('\u0496'));
        f.add(new Character('\u0497'));
        f.add(new Character('\u0498'));
        f.add(new Character('\u0499'));
        f.add(new Character('\u049a'));
        f.add(new Character('\u049b'));
        f.add(new Character('\u049c'));
        f.add(new Character('\u049d'));
        f.add(new Character('\u049e'));
        f.add(new Character('\u049f'));
        f.add(new Character('\u04a0'));
        f.add(new Character('\u04a1'));
        f.add(new Character('\u04a2'));
        f.add(new Character('\u04a3'));
        f.add(new Character('\u04a4'));
        f.add(new Character('\u04a5'));
        f.add(new Character('\u04a6'));
        f.add(new Character('\u04a7'));
        f.add(new Character('\u04a8'));
        f.add(new Character('\u04a9'));
        f.add(new Character('\u04aa'));
        f.add(new Character('\u04ab'));
        f.add(new Character('\u04ac'));
        f.add(new Character('\u04ad'));
        f.add(new Character('\u04ae'));
        f.add(new Character('\u04af'));
        f.add(new Character('\u04b0'));
        f.add(new Character('\u04b1'));
        f.add(new Character('\u04b2'));
        f.add(new Character('\u04b3'));
        f.add(new Character('\u04b4'));
        f.add(new Character('\u04b5'));
        f.add(new Character('\u04b6'));
        f.add(new Character('\u04b7'));
        f.add(new Character('\u04b8'));
        f.add(new Character('\u04b9'));
        f.add(new Character('\u04ba'));
        f.add(new Character('\u04bb'));
        f.add(new Character('\u04bc'));
        f.add(new Character('\u04bd'));
        f.add(new Character('\u04be'));
        f.add(new Character('\u04bf'));
        f.add(new Character('\u04c0'));
        f.add(new Character('\u04c1'));
        f.add(new Character('\u04c2'));
        f.add(new Character('\u04c3'));
        f.add(new Character('\u04c4'));
        f.add(new Character('\u04c5'));
        f.add(new Character('\u04c6'));
        f.add(new Character('\u04c7'));
        f.add(new Character('\u04c8'));
        f.add(new Character('\u04c9'));
        f.add(new Character('\u04ca'));
        f.add(new Character('\u04cb'));
        f.add(new Character('\u04cc'));
        f.add(new Character('\u04cd'));
        f.add(new Character('\u04ce'));
        f.add(new Character('\u04cf'));
        f.add(new Character('\u04d0'));
        f.add(new Character('\u04d1'));
        f.add(new Character('\u04d2'));
        f.add(new Character('\u04d3'));
        f.add(new Character('\u04d4'));
        f.add(new Character('\u04d5'));
        f.add(new Character('\u04d6'));
        f.add(new Character('\u04d7'));
        f.add(new Character('\u04d8'));
        f.add(new Character('\u04d9'));
        f.add(new Character('\u04da'));
        f.add(new Character('\u04db'));
        f.add(new Character('\u04dc'));
        f.add(new Character('\u04dd'));
        f.add(new Character('\u04de'));
        f.add(new Character('\u04df'));
        f.add(new Character('\u04e0'));
        f.add(new Character('\u04e1'));
        f.add(new Character('\u04e2'));
        f.add(new Character('\u04e3'));
        f.add(new Character('\u04e4'));
        f.add(new Character('\u04e5'));
        f.add(new Character('\u04e6'));
        f.add(new Character('\u04e7'));
        f.add(new Character('\u04e8'));
        f.add(new Character('\u04e9'));
        f.add(new Character('\u04ea'));
        f.add(new Character('\u04eb'));
        f.add(new Character('\u04ec'));
        f.add(new Character('\u04ed'));
        f.add(new Character('\u04ee'));
        f.add(new Character('\u04ef'));
        f.add(new Character('\u04f0'));
        f.add(new Character('\u04f1'));
        f.add(new Character('\u04f2'));
        f.add(new Character('\u04f3'));
        f.add(new Character('\u04f4'));
        f.add(new Character('\u04f5'));
        f.add(new Character('\u04f6'));
        f.add(new Character('\u04f7'));
        f.add(new Character('\u04f8'));
        f.add(new Character('\u04f9'));
        f.add(new Character('\u04fa'));
        f.add(new Character('\u04fb'));
        f.add(new Character('\u04fc'));
        f.add(new Character('\u04fd'));
        f.add(new Character('\u04fe'));
        f.add(new Character('\u04ff'));
        f.add(new Character('\u0500'));
        f.add(new Character('\u0501'));
        f.add(new Character('\u0502'));
        f.add(new Character('\u0503'));
        f.add(new Character('\u0504'));
        f.add(new Character('\u0505'));
        f.add(new Character('\u0506'));
        f.add(new Character('\u0507'));
        f.add(new Character('\u0508'));
        f.add(new Character('\u0509'));
        f.add(new Character('\u050a'));
        f.add(new Character('\u050b'));
        f.add(new Character('\u050c'));
        f.add(new Character('\u050d'));
        f.add(new Character('\u050e'));
        f.add(new Character('\u050f'));
        f.add(new Character('\u0510'));
        f.add(new Character('\u0511'));
        f.add(new Character('\u0512'));
        f.add(new Character('\u0513'));
        f.add(new Character('\u0514'));
        f.add(new Character('\u0515'));
        f.add(new Character('\u0516'));
        f.add(new Character('\u0517'));
        f.add(new Character('\u0518'));
        f.add(new Character('\u0519'));
        f.add(new Character('\u051a'));
        f.add(new Character('\u051b'));
        f.add(new Character('\u051c'));
        f.add(new Character('\u051d'));
        f.add(new Character('\u051e'));
        f.add(new Character('\u051f'));
        f.add(new Character('\u0520'));
        f.add(new Character('\u0521'));
        f.add(new Character('\u0522'));
        f.add(new Character('\u0523'));
        f.add(new Character('\u0524'));
        f.add(new Character('\u0525'));
        f.add(new Character('\u0526'));
        f.add(new Character('\u0527'));
        f.add(new Character('\u0528'));
        f.add(new Character('\u0529'));
        f.add(new Character('\u052a'));
        f.add(new Character('\u052b'));
        f.add(new Character('\u052c'));
        f.add(new Character('\u052d'));
        f.add(new Character('\u052e'));
        f.add(new Character('\u052f'));
        f.add(new Character('\u0530'));
        f.add(new Character('\u0531'));
        f.add(new Character('\u0532'));
        f.add(new Character('\u0533'));
        f.add(new Character('\u0534'));
        f.add(new Character('\u0535'));
        f.add(new Character('\u0536'));
        f.add(new Character('\u0537'));
        f.add(new Character('\u0538'));
        f.add(new Character('\u0539'));
        f.add(new Character('\u053a'));
        f.add(new Character('\u053b'));
        f.add(new Character('\u053c'));
        f.add(new Character('\u053d'));
        f.add(new Character('\u053e'));
        f.add(new Character('\u053f'));
        f.add(new Character('\u0540'));
        f.add(new Character('\u0541'));
        f.add(new Character('\u0542'));
        f.add(new Character('\u0543'));
        f.add(new Character('\u0544'));
        f.add(new Character('\u0545'));
        f.add(new Character('\u0546'));
        f.add(new Character('\u0547'));
        f.add(new Character('\u0548'));
        f.add(new Character('\u0549'));
        f.add(new Character('\u054a'));
        f.add(new Character('\u054b'));
        f.add(new Character('\u054c'));
        f.add(new Character('\u054d'));
        f.add(new Character('\u054e'));
        f.add(new Character('\u054f'));
        f.add(new Character('\u0550'));
        f.add(new Character('\u0551'));
        f.add(new Character('\u0552'));
        f.add(new Character('\u0553'));
        f.add(new Character('\u0554'));
        f.add(new Character('\u0555'));
        f.add(new Character('\u0556'));
        f.add(new Character('\u0557'));
        f.add(new Character('\u0558'));
        f.add(new Character('\u0559'));
        f.add(new Character('\u055a'));
        f.add(new Character('\u055b'));
        f.add(new Character('\u055c'));
        f.add(new Character('\u055d'));
        f.add(new Character('\u055e'));
        f.add(new Character('\u055f'));
        f.add(new Character('\u0560'));
        f.add(new Character('\u0561'));
        f.add(new Character('\u0562'));
        f.add(new Character('\u0563'));
        f.add(new Character('\u0564'));
        f.add(new Character('\u0565'));
        f.add(new Character('\u0566'));
        f.add(new Character('\u0567'));
        f.add(new Character('\u0568'));
        f.add(new Character('\u0569'));
        f.add(new Character('\u056a'));
        f.add(new Character('\u056b'));
        f.add(new Character('\u056c'));
        f.add(new Character('\u056d'));
        f.add(new Character('\u056e'));
        f.add(new Character('\u056f'));
        f.add(new Character('\u0570'));
        f.add(new Character('\u0571'));
        f.add(new Character('\u0572'));
        f.add(new Character('\u0573'));
        f.add(new Character('\u0574'));
        f.add(new Character('\u0575'));
        f.add(new Character('\u0576'));
        f.add(new Character('\u0577'));
        f.add(new Character('\u0578'));
        f.add(new Character('\u0579'));
        f.add(new Character('\u057a'));
        f.add(new Character('\u057b'));
        f.add(new Character('\u057c'));
        f.add(new Character('\u057d'));
        f.add(new Character('\u057e'));
        f.add(new Character('\u057f'));
        f.add(new Character('\u0580'));
        f.add(new Character('\u0581'));
        f.add(new Character('\u0582'));
        f.add(new Character('\u0583'));
        f.add(new Character('\u0584'));
        f.add(new Character('\u0585'));
        f.add(new Character('\u0586'));
        f.add(new Character('\u0587'));
    }

    protected static void initRUFlags(HashSet f) {
        f.add(new Character('\u00b5'));
        f.add(new Character('\u0401'));
        f.add(new Character('\u0402'));
        f.add(new Character('\u0403'));
        f.add(new Character('\u0404'));
        f.add(new Character('\u0405'));
        f.add(new Character('\u0406'));
        f.add(new Character('\u0407'));
        f.add(new Character('\u0408'));
        f.add(new Character('\u0409'));
        f.add(new Character('\u040a'));
        f.add(new Character('\u040b'));
        f.add(new Character('\u040c'));
        f.add(new Character('\u040e'));
        f.add(new Character('\u040f'));
        f.add(new Character('\u0410'));
        f.add(new Character('\u0411'));
        f.add(new Character('\u0412'));
        f.add(new Character('\u0413'));
        f.add(new Character('\u0414'));
        f.add(new Character('\u0415'));
        f.add(new Character('\u0416'));
        f.add(new Character('\u0417'));
        f.add(new Character('\u0418'));
        f.add(new Character('\u0419'));
        f.add(new Character('\u041a'));
        f.add(new Character('\u041b'));
        f.add(new Character('\u041c'));
        f.add(new Character('\u041d'));
        f.add(new Character('\u041e'));
        f.add(new Character('\u041f'));
        f.add(new Character('\u0420'));
        f.add(new Character('\u0421'));
        f.add(new Character('\u0422'));
        f.add(new Character('\u0423'));
        f.add(new Character('\u0424'));
        f.add(new Character('\u0425'));
        f.add(new Character('\u0426'));
        f.add(new Character('\u0427'));
        f.add(new Character('\u0428'));
        f.add(new Character('\u0429'));
        f.add(new Character('\u042a'));
        f.add(new Character('\u042b'));
        f.add(new Character('\u042c'));
        f.add(new Character('\u042d'));
        f.add(new Character('\u042e'));
        f.add(new Character('\u042f'));
        f.add(new Character('\u0430'));
        f.add(new Character('\u0431'));
        f.add(new Character('\u0432'));
        f.add(new Character('\u0433'));
        f.add(new Character('\u0434'));
        f.add(new Character('\u0435'));
        f.add(new Character('\u0436'));
        f.add(new Character('\u0437'));
        f.add(new Character('\u0438'));
        f.add(new Character('\u0439'));
        f.add(new Character('\u043a'));
        f.add(new Character('\u043b'));
        f.add(new Character('\u043c'));
        f.add(new Character('\u043d'));
        f.add(new Character('\u043e'));
        f.add(new Character('\u043f'));
        f.add(new Character('\u0440'));
        f.add(new Character('\u0441'));
        f.add(new Character('\u0442'));
        f.add(new Character('\u0443'));
        f.add(new Character('\u0444'));
        f.add(new Character('\u0445'));
        f.add(new Character('\u0446'));
        f.add(new Character('\u0447'));
        f.add(new Character('\u0448'));
        f.add(new Character('\u0449'));
        f.add(new Character('\u044a'));
        f.add(new Character('\u044b'));
        f.add(new Character('\u044c'));
        f.add(new Character('\u044d'));
        f.add(new Character('\u044e'));
        f.add(new Character('\u044f'));
        f.add(new Character('\u0451'));
        f.add(new Character('\u0452'));
        f.add(new Character('\u0453'));
        f.add(new Character('\u0454'));
        f.add(new Character('\u0455'));
        f.add(new Character('\u0456'));
        f.add(new Character('\u0457'));
        f.add(new Character('\u0458'));
        f.add(new Character('\u0459'));
        f.add(new Character('\u045a'));
        f.add(new Character('\u045b'));
        f.add(new Character('\u045c'));
        f.add(new Character('\u045e'));
        f.add(new Character('\u045f'));
        f.add(new Character('\u0490'));
        f.add(new Character('\u0491'));
    }

    protected static void initPTFlags(HashSet f) {
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00c0'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c3'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c5'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c8'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00ca'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cc'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00cf'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d1'));
        f.add(new Character('\u00d2'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d5'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00d9'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00db'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e3'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e5'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00ef'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f1'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f5'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fb'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u00ff'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0178'));
    }

    protected static void initPLFlags(HashSet f) {
        f.add(new Character('\u00b5'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u0102'));
        f.add(new Character('\u0103'));
        f.add(new Character('\u0104'));
        f.add(new Character('\u0105'));
        f.add(new Character('\u0106'));
        f.add(new Character('\u0107'));
        f.add(new Character('\u010c'));
        f.add(new Character('\u010d'));
        f.add(new Character('\u010e'));
        f.add(new Character('\u010f'));
        f.add(new Character('\u0110'));
        f.add(new Character('\u0111'));
        f.add(new Character('\u0118'));
        f.add(new Character('\u0119'));
        f.add(new Character('\u011a'));
        f.add(new Character('\u011b'));
        f.add(new Character('\u0139'));
        f.add(new Character('\u013a'));
        f.add(new Character('\u013d'));
        f.add(new Character('\u013e'));
        f.add(new Character('\u0141'));
        f.add(new Character('\u0142'));
        f.add(new Character('\u0143'));
        f.add(new Character('\u0144'));
        f.add(new Character('\u0147'));
        f.add(new Character('\u0148'));
        f.add(new Character('\u0150'));
        f.add(new Character('\u0151'));
        f.add(new Character('\u0154'));
        f.add(new Character('\u0155'));
        f.add(new Character('\u0158'));
        f.add(new Character('\u0159'));
        f.add(new Character('\u015a'));
        f.add(new Character('\u015b'));
        f.add(new Character('\u015e'));
        f.add(new Character('\u015f'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0162'));
        f.add(new Character('\u0163'));
        f.add(new Character('\u0164'));
        f.add(new Character('\u0165'));
        f.add(new Character('\u016e'));
        f.add(new Character('\u016f'));
        f.add(new Character('\u0170'));
        f.add(new Character('\u0171'));
        f.add(new Character('\u0179'));
        f.add(new Character('\u017a'));
        f.add(new Character('\u017b'));
        f.add(new Character('\u017c'));
        f.add(new Character('\u017d'));
        f.add(new Character('\u017e'));
    }

    protected static void initKOFlags(HashSet f) {
        f.add(new Character('\u00a1'));
        f.add(new Character('\u00a4'));
        f.add(new Character('\u00a7'));
        f.add(new Character('\u00a8'));
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00ad'));
        f.add(new Character('\u00ae'));
        f.add(new Character('\u00b0'));
        f.add(new Character('\u00b1'));
        f.add(new Character('\u00b2'));
        f.add(new Character('\u00b3'));
        f.add(new Character('\u00b4'));
        f.add(new Character('\u00b6'));
        f.add(new Character('\u00b7'));
        f.add(new Character('\u00b8'));
        f.add(new Character('\u00b9'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00bc'));
        f.add(new Character('\u00bd'));
        f.add(new Character('\u00be'));
        f.add(new Character('\u00bf'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d7'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u0100'));
        f.add(new Character('\u0101'));
        f.add(new Character('\u0102'));
        f.add(new Character('\u0103'));
        f.add(new Character('\u0104'));
        f.add(new Character('\u0105'));
        f.add(new Character('\u0106'));
        f.add(new Character('\u0107'));
        f.add(new Character('\u0108'));
        f.add(new Character('\u0109'));
        f.add(new Character('\u010a'));
        f.add(new Character('\u010b'));
        f.add(new Character('\u010c'));
        f.add(new Character('\u010d'));
        f.add(new Character('\u010e'));
        f.add(new Character('\u010f'));
        f.add(new Character('\u0110'));
        f.add(new Character('\u0111'));
        f.add(new Character('\u0112'));
        f.add(new Character('\u0113'));
        f.add(new Character('\u0114'));
        f.add(new Character('\u0115'));
        f.add(new Character('\u0116'));
        f.add(new Character('\u0117'));
        f.add(new Character('\u0118'));
        f.add(new Character('\u0119'));
        f.add(new Character('\u011a'));
        f.add(new Character('\u011b'));
        f.add(new Character('\u011c'));
        f.add(new Character('\u011d'));
        f.add(new Character('\u011e'));
        f.add(new Character('\u011f'));
        f.add(new Character('\u0120'));
        f.add(new Character('\u0121'));
        f.add(new Character('\u0122'));
        f.add(new Character('\u0123'));
        f.add(new Character('\u0124'));
        f.add(new Character('\u0125'));
        f.add(new Character('\u0126'));
        f.add(new Character('\u0127'));
        f.add(new Character('\u0128'));
        f.add(new Character('\u0129'));
        f.add(new Character('\u012a'));
        f.add(new Character('\u012b'));
        f.add(new Character('\u012c'));
        f.add(new Character('\u012d'));
        f.add(new Character('\u012e'));
        f.add(new Character('\u012f'));
        f.add(new Character('\u0130'));
        f.add(new Character('\u0131'));
        f.add(new Character('\u0132'));
        f.add(new Character('\u0133'));
        f.add(new Character('\u0134'));
        f.add(new Character('\u0135'));
        f.add(new Character('\u0136'));
        f.add(new Character('\u0137'));
        f.add(new Character('\u0138'));
        f.add(new Character('\u0139'));
        f.add(new Character('\u013a'));
        f.add(new Character('\u013b'));
        f.add(new Character('\u013c'));
        f.add(new Character('\u013d'));
        f.add(new Character('\u013e'));
        f.add(new Character('\u013f'));
        f.add(new Character('\u0140'));
        f.add(new Character('\u0141'));
        f.add(new Character('\u0142'));
        f.add(new Character('\u0143'));
        f.add(new Character('\u0144'));
        f.add(new Character('\u0145'));
        f.add(new Character('\u0146'));
        f.add(new Character('\u0147'));
        f.add(new Character('\u0148'));
        f.add(new Character('\u0149'));
        f.add(new Character('\u014a'));
        f.add(new Character('\u014b'));
        f.add(new Character('\u014c'));
        f.add(new Character('\u014d'));
        f.add(new Character('\u014e'));
        f.add(new Character('\u014f'));
        f.add(new Character('\u0150'));
        f.add(new Character('\u0151'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0154'));
        f.add(new Character('\u0155'));
        f.add(new Character('\u0156'));
        f.add(new Character('\u0157'));
        f.add(new Character('\u0158'));
        f.add(new Character('\u0159'));
        f.add(new Character('\u015a'));
        f.add(new Character('\u015b'));
        f.add(new Character('\u015c'));
        f.add(new Character('\u015d'));
        f.add(new Character('\u015e'));
        f.add(new Character('\u015f'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0162'));
        f.add(new Character('\u0163'));
        f.add(new Character('\u0164'));
        f.add(new Character('\u0165'));
        f.add(new Character('\u0166'));
        f.add(new Character('\u0167'));
        f.add(new Character('\u0168'));
        f.add(new Character('\u0169'));
        f.add(new Character('\u016a'));
        f.add(new Character('\u016b'));
        f.add(new Character('\u016c'));
        f.add(new Character('\u016d'));
        f.add(new Character('\u016e'));
        f.add(new Character('\u016f'));
        f.add(new Character('\u0170'));
        f.add(new Character('\u0171'));
        f.add(new Character('\u0172'));
        f.add(new Character('\u0173'));
        f.add(new Character('\u0174'));
        f.add(new Character('\u0175'));
        f.add(new Character('\u0176'));
        f.add(new Character('\u0177'));
        f.add(new Character('\u0178'));
        f.add(new Character('\u0179'));
        f.add(new Character('\u017a'));
        f.add(new Character('\u017b'));
        f.add(new Character('\u017c'));
        f.add(new Character('\u017d'));
        f.add(new Character('\u017e'));
        f.add(new Character('\u017f'));
        f.add(new Character('\u0180'));
        f.add(new Character('\u0181'));
        f.add(new Character('\u0182'));
        f.add(new Character('\u0183'));
        f.add(new Character('\u0184'));
        f.add(new Character('\u0185'));
        f.add(new Character('\u0186'));
        f.add(new Character('\u0187'));
        f.add(new Character('\u0188'));
        f.add(new Character('\u0189'));
        f.add(new Character('\u018a'));
        f.add(new Character('\u018b'));
        f.add(new Character('\u018c'));
        f.add(new Character('\u018d'));
        f.add(new Character('\u018e'));
        f.add(new Character('\u018f'));
        f.add(new Character('\u0190'));
        f.add(new Character('\u0191'));
        f.add(new Character('\u0192'));
        f.add(new Character('\u0193'));
        f.add(new Character('\u0194'));
        f.add(new Character('\u0195'));
        f.add(new Character('\u0196'));
        f.add(new Character('\u0197'));
        f.add(new Character('\u0198'));
        f.add(new Character('\u0199'));
        f.add(new Character('\u019a'));
        f.add(new Character('\u019b'));
        f.add(new Character('\u019c'));
        f.add(new Character('\u019d'));
        f.add(new Character('\u019e'));
        f.add(new Character('\u019f'));
        f.add(new Character('\u01a0'));
        f.add(new Character('\u01a1'));
        f.add(new Character('\u01a2'));
        f.add(new Character('\u01a3'));
        f.add(new Character('\u01a4'));
        f.add(new Character('\u01a5'));
        f.add(new Character('\u01a6'));
        f.add(new Character('\u01a7'));
        f.add(new Character('\u01a8'));
        f.add(new Character('\u01a9'));
        f.add(new Character('\u01aa'));
        f.add(new Character('\u01ab'));
        f.add(new Character('\u01ac'));
        f.add(new Character('\u01ad'));
        f.add(new Character('\u01ae'));
        f.add(new Character('\u01af'));
        f.add(new Character('\u01b0'));
        f.add(new Character('\u01b1'));
        f.add(new Character('\u01b2'));
        f.add(new Character('\u01b3'));
        f.add(new Character('\u01b4'));
        f.add(new Character('\u01b5'));
        f.add(new Character('\u01b6'));
        f.add(new Character('\u01b7'));
        f.add(new Character('\u01b8'));
        f.add(new Character('\u01b9'));
        f.add(new Character('\u01ba'));
        f.add(new Character('\u01bb'));
        f.add(new Character('\u01bc'));
        f.add(new Character('\u01bd'));
        f.add(new Character('\u01be'));
        f.add(new Character('\u01bf'));
        f.add(new Character('\u01c0'));
        f.add(new Character('\u01c1'));
        f.add(new Character('\u01c2'));
        f.add(new Character('\u01c3'));
        f.add(new Character('\u01c4'));
        f.add(new Character('\u01c5'));
        f.add(new Character('\u01c6'));
        f.add(new Character('\u01c7'));
        f.add(new Character('\u01c8'));
        f.add(new Character('\u01c9'));
        f.add(new Character('\u01ca'));
        f.add(new Character('\u01cb'));
        f.add(new Character('\u01cc'));
        f.add(new Character('\u01cd'));
        f.add(new Character('\u01ce'));
        f.add(new Character('\u01cf'));
        f.add(new Character('\u01d0'));
        f.add(new Character('\u01d1'));
        f.add(new Character('\u01d2'));
        f.add(new Character('\u01d3'));
        f.add(new Character('\u01d4'));
        f.add(new Character('\u01d5'));
        f.add(new Character('\u01d6'));
        f.add(new Character('\u01d7'));
        f.add(new Character('\u01d8'));
        f.add(new Character('\u01d9'));
        f.add(new Character('\u01da'));
        f.add(new Character('\u01db'));
        f.add(new Character('\u01dc'));
        f.add(new Character('\u01dd'));
        f.add(new Character('\u01de'));
        f.add(new Character('\u01df'));
        f.add(new Character('\u01e0'));
        f.add(new Character('\u01e1'));
        f.add(new Character('\u01e2'));
        f.add(new Character('\u01e3'));
        f.add(new Character('\u01e4'));
        f.add(new Character('\u01e5'));
        f.add(new Character('\u01e6'));
        f.add(new Character('\u01e7'));
        f.add(new Character('\u01e8'));
        f.add(new Character('\u01e9'));
        f.add(new Character('\u01ea'));
        f.add(new Character('\u01eb'));
        f.add(new Character('\u01ec'));
        f.add(new Character('\u01ed'));
        f.add(new Character('\u01ee'));
        f.add(new Character('\u01ef'));
        f.add(new Character('\u01f0'));
        f.add(new Character('\u01f1'));
        f.add(new Character('\u01f2'));
        f.add(new Character('\u01f3'));
        f.add(new Character('\u01f4'));
        f.add(new Character('\u01f5'));
        f.add(new Character('\u01f6'));
        f.add(new Character('\u01f7'));
        f.add(new Character('\u01f8'));
        f.add(new Character('\u01f9'));
        f.add(new Character('\u01fa'));
        f.add(new Character('\u01fb'));
        f.add(new Character('\u01fc'));
        f.add(new Character('\u01fd'));
        f.add(new Character('\u01fe'));
        f.add(new Character('\u01ff'));
        f.add(new Character('\u0200'));
        f.add(new Character('\u0201'));
        f.add(new Character('\u0202'));
        f.add(new Character('\u0203'));
        f.add(new Character('\u0204'));
        f.add(new Character('\u0205'));
        f.add(new Character('\u0206'));
        f.add(new Character('\u0207'));
        f.add(new Character('\u0208'));
        f.add(new Character('\u0209'));
        f.add(new Character('\u020a'));
        f.add(new Character('\u020b'));
        f.add(new Character('\u020c'));
        f.add(new Character('\u020d'));
        f.add(new Character('\u020e'));
        f.add(new Character('\u020f'));
        f.add(new Character('\u0210'));
        f.add(new Character('\u0211'));
        f.add(new Character('\u0212'));
        f.add(new Character('\u0213'));
        f.add(new Character('\u0214'));
        f.add(new Character('\u0215'));
        f.add(new Character('\u0216'));
        f.add(new Character('\u0217'));
        f.add(new Character('\u0218'));
        f.add(new Character('\u0219'));
        f.add(new Character('\u021a'));
        f.add(new Character('\u021b'));
        f.add(new Character('\u021c'));
        f.add(new Character('\u021d'));
        f.add(new Character('\u021e'));
        f.add(new Character('\u021f'));
        f.add(new Character('\u0220'));
        f.add(new Character('\u0221'));
        f.add(new Character('\u0222'));
        f.add(new Character('\u0223'));
        f.add(new Character('\u0224'));
        f.add(new Character('\u0225'));
        f.add(new Character('\u0226'));
        f.add(new Character('\u0227'));
        f.add(new Character('\u0228'));
        f.add(new Character('\u0229'));
        f.add(new Character('\u022a'));
        f.add(new Character('\u022b'));
        f.add(new Character('\u022c'));
        f.add(new Character('\u022d'));
        f.add(new Character('\u022e'));
        f.add(new Character('\u022f'));
        f.add(new Character('\u0230'));
        f.add(new Character('\u0231'));
        f.add(new Character('\u0232'));
        f.add(new Character('\u0233'));
        f.add(new Character('\u0234'));
        f.add(new Character('\u0235'));
        f.add(new Character('\u0236'));
        f.add(new Character('\u0237'));
        f.add(new Character('\u0238'));
        f.add(new Character('\u0239'));
        f.add(new Character('\u023a'));
        f.add(new Character('\u023b'));
        f.add(new Character('\u023c'));
        f.add(new Character('\u023d'));
        f.add(new Character('\u023e'));
        f.add(new Character('\u023f'));
        f.add(new Character('\u0240'));
        f.add(new Character('\u0241'));
        f.add(new Character('\u0242'));
        f.add(new Character('\u0243'));
        f.add(new Character('\u0244'));
        f.add(new Character('\u0245'));
        f.add(new Character('\u0246'));
        f.add(new Character('\u0247'));
        f.add(new Character('\u0248'));
        f.add(new Character('\u0249'));
        f.add(new Character('\u024a'));
        f.add(new Character('\u024b'));
        f.add(new Character('\u024c'));
        f.add(new Character('\u024d'));
        f.add(new Character('\u024e'));
        f.add(new Character('\u024f'));
        f.add(new Character('\u0250'));
        f.add(new Character('\u0251'));
        f.add(new Character('\u0252'));
        f.add(new Character('\u0253'));
        f.add(new Character('\u0254'));
        f.add(new Character('\u0255'));
        f.add(new Character('\u0256'));
        f.add(new Character('\u0257'));
        f.add(new Character('\u0258'));
        f.add(new Character('\u0259'));
        f.add(new Character('\u025a'));
        f.add(new Character('\u025b'));
        f.add(new Character('\u025c'));
        f.add(new Character('\u025d'));
        f.add(new Character('\u025e'));
        f.add(new Character('\u025f'));
        f.add(new Character('\u0260'));
        f.add(new Character('\u0261'));
        f.add(new Character('\u0262'));
        f.add(new Character('\u0263'));
        f.add(new Character('\u0264'));
        f.add(new Character('\u0265'));
        f.add(new Character('\u0266'));
        f.add(new Character('\u0267'));
        f.add(new Character('\u0268'));
        f.add(new Character('\u0269'));
        f.add(new Character('\u026a'));
        f.add(new Character('\u026b'));
        f.add(new Character('\u026c'));
        f.add(new Character('\u026d'));
        f.add(new Character('\u026e'));
        f.add(new Character('\u026f'));
        f.add(new Character('\u0270'));
        f.add(new Character('\u0271'));
        f.add(new Character('\u0272'));
        f.add(new Character('\u0273'));
        f.add(new Character('\u0274'));
        f.add(new Character('\u0275'));
        f.add(new Character('\u0276'));
        f.add(new Character('\u0277'));
        f.add(new Character('\u0278'));
        f.add(new Character('\u0279'));
        f.add(new Character('\u027a'));
        f.add(new Character('\u027b'));
        f.add(new Character('\u027c'));
        f.add(new Character('\u027d'));
        f.add(new Character('\u027e'));
        f.add(new Character('\u027f'));
        f.add(new Character('\u0280'));
        f.add(new Character('\u0281'));
        f.add(new Character('\u0282'));
        f.add(new Character('\u0283'));
        f.add(new Character('\u0284'));
        f.add(new Character('\u0285'));
        f.add(new Character('\u0286'));
        f.add(new Character('\u0287'));
        f.add(new Character('\u0288'));
        f.add(new Character('\u0289'));
        f.add(new Character('\u028a'));
        f.add(new Character('\u028b'));
        f.add(new Character('\u028c'));
        f.add(new Character('\u028d'));
        f.add(new Character('\u028e'));
        f.add(new Character('\u028f'));
        f.add(new Character('\u0290'));
        f.add(new Character('\u0291'));
        f.add(new Character('\u0292'));
        f.add(new Character('\u0293'));
        f.add(new Character('\u0294'));
        f.add(new Character('\u0295'));
        f.add(new Character('\u0296'));
        f.add(new Character('\u0297'));
        f.add(new Character('\u0298'));
        f.add(new Character('\u0299'));
        f.add(new Character('\u029a'));
        f.add(new Character('\u029b'));
        f.add(new Character('\u029c'));
        f.add(new Character('\u029d'));
        f.add(new Character('\u029e'));
        f.add(new Character('\u029f'));
        f.add(new Character('\u02a0'));
        f.add(new Character('\u02a1'));
        f.add(new Character('\u02a2'));
        f.add(new Character('\u02a3'));
        f.add(new Character('\u02a4'));
        f.add(new Character('\u02a5'));
        f.add(new Character('\u02a6'));
        f.add(new Character('\u02a7'));
        f.add(new Character('\u02a8'));
        f.add(new Character('\u02a9'));
        f.add(new Character('\u02aa'));
        f.add(new Character('\u02ab'));
        f.add(new Character('\u02ac'));
        f.add(new Character('\u02ad'));
        f.add(new Character('\u02ae'));
        f.add(new Character('\u02af'));
        f.add(new Character('\u02b0'));
        f.add(new Character('\u02b1'));
        f.add(new Character('\u02b2'));
        f.add(new Character('\u02b3'));
        f.add(new Character('\u02b4'));
        f.add(new Character('\u02b5'));
        f.add(new Character('\u02b6'));
        f.add(new Character('\u02b7'));
        f.add(new Character('\u02b8'));
        f.add(new Character('\u02b9'));
        f.add(new Character('\u02ba'));
        f.add(new Character('\u02bb'));
        f.add(new Character('\u02bc'));
        f.add(new Character('\u02bd'));
        f.add(new Character('\u02be'));
        f.add(new Character('\u02bf'));
        f.add(new Character('\u02c0'));
        f.add(new Character('\u02c1'));
        f.add(new Character('\u02c2'));
        f.add(new Character('\u02c3'));
        f.add(new Character('\u02c4'));
        f.add(new Character('\u02c5'));
        f.add(new Character('\u02c6'));
        f.add(new Character('\u02c7'));
        f.add(new Character('\u02c8'));
        f.add(new Character('\u02c9'));
        f.add(new Character('\u02ca'));
        f.add(new Character('\u02cb'));
        f.add(new Character('\u02cc'));
        f.add(new Character('\u02cd'));
        f.add(new Character('\u02ce'));
        f.add(new Character('\u02cf'));
        f.add(new Character('\u02d0'));
        f.add(new Character('\u02d1'));
        f.add(new Character('\u02d2'));
        f.add(new Character('\u02d3'));
        f.add(new Character('\u02d4'));
        f.add(new Character('\u02d5'));
        f.add(new Character('\u02d6'));
        f.add(new Character('\u02d7'));
        f.add(new Character('\u02d8'));
        f.add(new Character('\u02d9'));
        f.add(new Character('\u02da'));
        f.add(new Character('\u02db'));
        f.add(new Character('\u02dc'));
        f.add(new Character('\u02dd'));
        f.add(new Character('\u02de'));
        f.add(new Character('\u02df'));
        f.add(new Character('\u02e0'));
        f.add(new Character('\u02e1'));
        f.add(new Character('\u02e2'));
        f.add(new Character('\u02e3'));
        f.add(new Character('\u02e4'));
        f.add(new Character('\u02e5'));
        f.add(new Character('\u02e6'));
        f.add(new Character('\u02e7'));
        f.add(new Character('\u02e8'));
        f.add(new Character('\u02e9'));
        f.add(new Character('\u02ea'));
        f.add(new Character('\u02eb'));
        f.add(new Character('\u02ec'));
        f.add(new Character('\u02ed'));
        f.add(new Character('\u02ee'));
        f.add(new Character('\u02ef'));
        f.add(new Character('\u02f0'));
        f.add(new Character('\u02f1'));
        f.add(new Character('\u02f2'));
        f.add(new Character('\u02f3'));
        f.add(new Character('\u02f4'));
        f.add(new Character('\u02f5'));
        f.add(new Character('\u02f6'));
        f.add(new Character('\u02f7'));
        f.add(new Character('\u02f8'));
        f.add(new Character('\u02f9'));
        f.add(new Character('\u02fa'));
        f.add(new Character('\u02fb'));
        f.add(new Character('\u02fc'));
        f.add(new Character('\u02fd'));
        f.add(new Character('\u02fe'));
        f.add(new Character('\u02ff'));
        f.add(new Character('\u0300'));
        f.add(new Character('\u0301'));
        f.add(new Character('\u0302'));
        f.add(new Character('\u0303'));
        f.add(new Character('\u0304'));
        f.add(new Character('\u0305'));
        f.add(new Character('\u0306'));
        f.add(new Character('\u0307'));
        f.add(new Character('\u0308'));
        f.add(new Character('\u0309'));
        f.add(new Character('\u030a'));
        f.add(new Character('\u030b'));
        f.add(new Character('\u030c'));
        f.add(new Character('\u030d'));
        f.add(new Character('\u030e'));
        f.add(new Character('\u030f'));
        f.add(new Character('\u0310'));
        f.add(new Character('\u0311'));
        f.add(new Character('\u0312'));
        f.add(new Character('\u0313'));
        f.add(new Character('\u0314'));
        f.add(new Character('\u0315'));
        f.add(new Character('\u0316'));
        f.add(new Character('\u0317'));
        f.add(new Character('\u0318'));
        f.add(new Character('\u0319'));
        f.add(new Character('\u031a'));
        f.add(new Character('\u031b'));
        f.add(new Character('\u031c'));
        f.add(new Character('\u031d'));
        f.add(new Character('\u031e'));
        f.add(new Character('\u031f'));
        f.add(new Character('\u0320'));
        f.add(new Character('\u0321'));
        f.add(new Character('\u0322'));
        f.add(new Character('\u0323'));
        f.add(new Character('\u0324'));
        f.add(new Character('\u0325'));
        f.add(new Character('\u0326'));
        f.add(new Character('\u0327'));
        f.add(new Character('\u0328'));
        f.add(new Character('\u0329'));
        f.add(new Character('\u032a'));
        f.add(new Character('\u032b'));
        f.add(new Character('\u032c'));
        f.add(new Character('\u032d'));
        f.add(new Character('\u032e'));
        f.add(new Character('\u032f'));
        f.add(new Character('\u0330'));
        f.add(new Character('\u0331'));
        f.add(new Character('\u0332'));
        f.add(new Character('\u0333'));
        f.add(new Character('\u0334'));
        f.add(new Character('\u0335'));
        f.add(new Character('\u0336'));
        f.add(new Character('\u0337'));
        f.add(new Character('\u0338'));
        f.add(new Character('\u0339'));
        f.add(new Character('\u033a'));
        f.add(new Character('\u033b'));
        f.add(new Character('\u033c'));
        f.add(new Character('\u033d'));
        f.add(new Character('\u033e'));
        f.add(new Character('\u033f'));
        f.add(new Character('\u0340'));
        f.add(new Character('\u0341'));
        f.add(new Character('\u0342'));
        f.add(new Character('\u0343'));
        f.add(new Character('\u0344'));
        f.add(new Character('\u0345'));
        f.add(new Character('\u0346'));
        f.add(new Character('\u0347'));
        f.add(new Character('\u0348'));
        f.add(new Character('\u0349'));
        f.add(new Character('\u034a'));
        f.add(new Character('\u034b'));
        f.add(new Character('\u034c'));
        f.add(new Character('\u034d'));
        f.add(new Character('\u034e'));
        f.add(new Character('\u034f'));
        f.add(new Character('\u0350'));
        f.add(new Character('\u0351'));
        f.add(new Character('\u0352'));
        f.add(new Character('\u0353'));
        f.add(new Character('\u0354'));
        f.add(new Character('\u0355'));
        f.add(new Character('\u0356'));
        f.add(new Character('\u0357'));
        f.add(new Character('\u0358'));
        f.add(new Character('\u0359'));
        f.add(new Character('\u035a'));
        f.add(new Character('\u035b'));
        f.add(new Character('\u035c'));
        f.add(new Character('\u035d'));
        f.add(new Character('\u035e'));
        f.add(new Character('\u035f'));
        f.add(new Character('\u0360'));
        f.add(new Character('\u0361'));
        f.add(new Character('\u0362'));
        f.add(new Character('\u0363'));
        f.add(new Character('\u0364'));
        f.add(new Character('\u0365'));
        f.add(new Character('\u0366'));
        f.add(new Character('\u0367'));
        f.add(new Character('\u0368'));
        f.add(new Character('\u0369'));
        f.add(new Character('\u036a'));
        f.add(new Character('\u036b'));
        f.add(new Character('\u036c'));
        f.add(new Character('\u036d'));
        f.add(new Character('\u036e'));
        f.add(new Character('\u036f'));
        f.add(new Character('\u0370'));
        f.add(new Character('\u0371'));
        f.add(new Character('\u0372'));
        f.add(new Character('\u0373'));
        f.add(new Character('\u0374'));
        f.add(new Character('\u0375'));
        f.add(new Character('\u0376'));
        f.add(new Character('\u0377'));
        f.add(new Character('\u0378'));
        f.add(new Character('\u0379'));
        f.add(new Character('\u037a'));
        f.add(new Character('\u037b'));
        f.add(new Character('\u037c'));
        f.add(new Character('\u037d'));
        f.add(new Character('\u037e'));
        f.add(new Character('\u037f'));
        f.add(new Character('\u0380'));
        f.add(new Character('\u0381'));
        f.add(new Character('\u0382'));
        f.add(new Character('\u0383'));
        f.add(new Character('\u0384'));
        f.add(new Character('\u0385'));
        f.add(new Character('\u0386'));
        f.add(new Character('\u0387'));
        f.add(new Character('\u0388'));
        f.add(new Character('\u0389'));
        f.add(new Character('\u038a'));
        f.add(new Character('\u038b'));
        f.add(new Character('\u038c'));
        f.add(new Character('\u038d'));
        f.add(new Character('\u038e'));
        f.add(new Character('\u038f'));
        f.add(new Character('\u0390'));
        f.add(new Character('\u0391'));
        f.add(new Character('\u0392'));
        f.add(new Character('\u0393'));
        f.add(new Character('\u0394'));
        f.add(new Character('\u0395'));
        f.add(new Character('\u0396'));
        f.add(new Character('\u0397'));
        f.add(new Character('\u0398'));
        f.add(new Character('\u0399'));
        f.add(new Character('\u039a'));
        f.add(new Character('\u039b'));
        f.add(new Character('\u039c'));
        f.add(new Character('\u039d'));
        f.add(new Character('\u039e'));
        f.add(new Character('\u039f'));
        f.add(new Character('\u03a0'));
        f.add(new Character('\u03a1'));
        f.add(new Character('\u03a2'));
        f.add(new Character('\u03a3'));
        f.add(new Character('\u03a4'));
        f.add(new Character('\u03a5'));
        f.add(new Character('\u03a6'));
        f.add(new Character('\u03a7'));
        f.add(new Character('\u03a8'));
        f.add(new Character('\u03a9'));
        f.add(new Character('\u03aa'));
        f.add(new Character('\u03ab'));
        f.add(new Character('\u03ac'));
        f.add(new Character('\u03ad'));
        f.add(new Character('\u03ae'));
        f.add(new Character('\u03af'));
        f.add(new Character('\u03b0'));
        f.add(new Character('\u03b1'));
        f.add(new Character('\u03b2'));
        f.add(new Character('\u03b3'));
        f.add(new Character('\u03b4'));
        f.add(new Character('\u03b5'));
        f.add(new Character('\u03b6'));
        f.add(new Character('\u03b7'));
        f.add(new Character('\u03b8'));
        f.add(new Character('\u03b9'));
        f.add(new Character('\u03ba'));
        f.add(new Character('\u03bb'));
        f.add(new Character('\u03bc'));
        f.add(new Character('\u03bd'));
        f.add(new Character('\u03be'));
        f.add(new Character('\u03bf'));
        f.add(new Character('\u03c0'));
        f.add(new Character('\u03c1'));
        f.add(new Character('\u03c2'));
        f.add(new Character('\u03c3'));
        f.add(new Character('\u03c4'));
        f.add(new Character('\u03c5'));
        f.add(new Character('\u03c6'));
        f.add(new Character('\u03c7'));
        f.add(new Character('\u03c8'));
        f.add(new Character('\u03c9'));
        f.add(new Character('\u03ca'));
        f.add(new Character('\u03cb'));
        f.add(new Character('\u03cc'));
        f.add(new Character('\u03cd'));
        f.add(new Character('\u03ce'));
        f.add(new Character('\u03cf'));
        f.add(new Character('\u03d0'));
        f.add(new Character('\u03d1'));
        f.add(new Character('\u03d2'));
        f.add(new Character('\u03d3'));
        f.add(new Character('\u03d4'));
        f.add(new Character('\u03d5'));
        f.add(new Character('\u03d6'));
        f.add(new Character('\u03d7'));
        f.add(new Character('\u03d8'));
        f.add(new Character('\u03d9'));
        f.add(new Character('\u03da'));
        f.add(new Character('\u03db'));
        f.add(new Character('\u03dc'));
        f.add(new Character('\u03dd'));
        f.add(new Character('\u03de'));
        f.add(new Character('\u03df'));
        f.add(new Character('\u03e0'));
        f.add(new Character('\u03e1'));
        f.add(new Character('\u03e2'));
        f.add(new Character('\u03e3'));
        f.add(new Character('\u03e4'));
        f.add(new Character('\u03e5'));
        f.add(new Character('\u03e6'));
        f.add(new Character('\u03e7'));
        f.add(new Character('\u03e8'));
        f.add(new Character('\u03e9'));
        f.add(new Character('\u03ea'));
        f.add(new Character('\u03eb'));
        f.add(new Character('\u03ec'));
        f.add(new Character('\u03ed'));
        f.add(new Character('\u03ee'));
        f.add(new Character('\u03ef'));
        f.add(new Character('\u03f0'));
        f.add(new Character('\u03f1'));
        f.add(new Character('\u03f2'));
        f.add(new Character('\u03f3'));
        f.add(new Character('\u03f4'));
        f.add(new Character('\u03f5'));
        f.add(new Character('\u03f6'));
        f.add(new Character('\u03f7'));
        f.add(new Character('\u03f8'));
        f.add(new Character('\u03f9'));
        f.add(new Character('\u03fa'));
        f.add(new Character('\u03fb'));
        f.add(new Character('\u03fc'));
        f.add(new Character('\u03fd'));
        f.add(new Character('\u03fe'));
        f.add(new Character('\u03ff'));
        f.add(new Character('\u0400'));
        f.add(new Character('\u0401'));
        f.add(new Character('\u0402'));
        f.add(new Character('\u0403'));
        f.add(new Character('\u0404'));
        f.add(new Character('\u0405'));
        f.add(new Character('\u0406'));
        f.add(new Character('\u0407'));
        f.add(new Character('\u0408'));
        f.add(new Character('\u0409'));
        f.add(new Character('\u040a'));
        f.add(new Character('\u040b'));
        f.add(new Character('\u040c'));
        f.add(new Character('\u040d'));
        f.add(new Character('\u040e'));
        f.add(new Character('\u040f'));
        f.add(new Character('\u0410'));
        f.add(new Character('\u0411'));
        f.add(new Character('\u0412'));
        f.add(new Character('\u0413'));
        f.add(new Character('\u0414'));
        f.add(new Character('\u0415'));
        f.add(new Character('\u0416'));
        f.add(new Character('\u0417'));
        f.add(new Character('\u0418'));
        f.add(new Character('\u0419'));
        f.add(new Character('\u041a'));
        f.add(new Character('\u041b'));
        f.add(new Character('\u041c'));
        f.add(new Character('\u041d'));
        f.add(new Character('\u041e'));
        f.add(new Character('\u041f'));
        f.add(new Character('\u0420'));
        f.add(new Character('\u0421'));
        f.add(new Character('\u0422'));
        f.add(new Character('\u0423'));
        f.add(new Character('\u0424'));
        f.add(new Character('\u0425'));
        f.add(new Character('\u0426'));
        f.add(new Character('\u0427'));
        f.add(new Character('\u0428'));
        f.add(new Character('\u0429'));
        f.add(new Character('\u042a'));
        f.add(new Character('\u042b'));
        f.add(new Character('\u042c'));
        f.add(new Character('\u042d'));
        f.add(new Character('\u042e'));
        f.add(new Character('\u042f'));
        f.add(new Character('\u0430'));
        f.add(new Character('\u0431'));
        f.add(new Character('\u0432'));
        f.add(new Character('\u0433'));
        f.add(new Character('\u0434'));
        f.add(new Character('\u0435'));
        f.add(new Character('\u0436'));
        f.add(new Character('\u0437'));
        f.add(new Character('\u0438'));
        f.add(new Character('\u0439'));
        f.add(new Character('\u043a'));
        f.add(new Character('\u043b'));
        f.add(new Character('\u043c'));
        f.add(new Character('\u043d'));
        f.add(new Character('\u043e'));
        f.add(new Character('\u043f'));
        f.add(new Character('\u0440'));
        f.add(new Character('\u0441'));
        f.add(new Character('\u0442'));
        f.add(new Character('\u0443'));
        f.add(new Character('\u0444'));
        f.add(new Character('\u0445'));
        f.add(new Character('\u0446'));
        f.add(new Character('\u0447'));
        f.add(new Character('\u0448'));
        f.add(new Character('\u0449'));
        f.add(new Character('\u044a'));
        f.add(new Character('\u044b'));
        f.add(new Character('\u044c'));
        f.add(new Character('\u044d'));
        f.add(new Character('\u044e'));
        f.add(new Character('\u044f'));
        f.add(new Character('\u0450'));
        f.add(new Character('\u0451'));
        f.add(new Character('\u0452'));
        f.add(new Character('\u0453'));
        f.add(new Character('\u0454'));
        f.add(new Character('\u0455'));
        f.add(new Character('\u0456'));
        f.add(new Character('\u0457'));
        f.add(new Character('\u0458'));
        f.add(new Character('\u0459'));
        f.add(new Character('\u045a'));
        f.add(new Character('\u045b'));
        f.add(new Character('\u045c'));
        f.add(new Character('\u045d'));
        f.add(new Character('\u045e'));
        f.add(new Character('\u045f'));
        f.add(new Character('\u0460'));
        f.add(new Character('\u0461'));
        f.add(new Character('\u0462'));
        f.add(new Character('\u0463'));
        f.add(new Character('\u0464'));
        f.add(new Character('\u0465'));
        f.add(new Character('\u0466'));
        f.add(new Character('\u0467'));
        f.add(new Character('\u0468'));
        f.add(new Character('\u0469'));
        f.add(new Character('\u046a'));
        f.add(new Character('\u046b'));
        f.add(new Character('\u046c'));
        f.add(new Character('\u046d'));
        f.add(new Character('\u046e'));
        f.add(new Character('\u046f'));
        f.add(new Character('\u0470'));
        f.add(new Character('\u0471'));
        f.add(new Character('\u0472'));
        f.add(new Character('\u0473'));
        f.add(new Character('\u0474'));
        f.add(new Character('\u0475'));
        f.add(new Character('\u0476'));
        f.add(new Character('\u0477'));
        f.add(new Character('\u0478'));
        f.add(new Character('\u0479'));
        f.add(new Character('\u047a'));
        f.add(new Character('\u047b'));
        f.add(new Character('\u047c'));
        f.add(new Character('\u047d'));
        f.add(new Character('\u047e'));
        f.add(new Character('\u047f'));
        f.add(new Character('\u0480'));
        f.add(new Character('\u0481'));
        f.add(new Character('\u0482'));
        f.add(new Character('\u0483'));
        f.add(new Character('\u0484'));
        f.add(new Character('\u0485'));
        f.add(new Character('\u0486'));
        f.add(new Character('\u0487'));
        f.add(new Character('\u0488'));
        f.add(new Character('\u0489'));
        f.add(new Character('\u048a'));
        f.add(new Character('\u048b'));
        f.add(new Character('\u048c'));
        f.add(new Character('\u048d'));
        f.add(new Character('\u048e'));
        f.add(new Character('\u048f'));
        f.add(new Character('\u0490'));
        f.add(new Character('\u0491'));
        f.add(new Character('\u0492'));
        f.add(new Character('\u0493'));
        f.add(new Character('\u0494'));
        f.add(new Character('\u0495'));
        f.add(new Character('\u0496'));
        f.add(new Character('\u0497'));
        f.add(new Character('\u0498'));
        f.add(new Character('\u0499'));
        f.add(new Character('\u049a'));
        f.add(new Character('\u049b'));
        f.add(new Character('\u049c'));
        f.add(new Character('\u049d'));
        f.add(new Character('\u049e'));
        f.add(new Character('\u049f'));
        f.add(new Character('\u04a0'));
        f.add(new Character('\u04a1'));
        f.add(new Character('\u04a2'));
        f.add(new Character('\u04a3'));
        f.add(new Character('\u04a4'));
        f.add(new Character('\u04a5'));
        f.add(new Character('\u04a6'));
        f.add(new Character('\u04a7'));
        f.add(new Character('\u04a8'));
        f.add(new Character('\u04a9'));
        f.add(new Character('\u04aa'));
        f.add(new Character('\u04ab'));
        f.add(new Character('\u04ac'));
        f.add(new Character('\u04ad'));
        f.add(new Character('\u04ae'));
        f.add(new Character('\u04af'));
        f.add(new Character('\u04b0'));
        f.add(new Character('\u04b1'));
        f.add(new Character('\u04b2'));
        f.add(new Character('\u04b3'));
        f.add(new Character('\u04b4'));
        f.add(new Character('\u04b5'));
        f.add(new Character('\u04b6'));
        f.add(new Character('\u04b7'));
        f.add(new Character('\u04b8'));
        f.add(new Character('\u04b9'));
        f.add(new Character('\u04ba'));
        f.add(new Character('\u04bb'));
        f.add(new Character('\u04bc'));
        f.add(new Character('\u04bd'));
        f.add(new Character('\u04be'));
        f.add(new Character('\u04bf'));
        f.add(new Character('\u04c0'));
        f.add(new Character('\u04c1'));
        f.add(new Character('\u04c2'));
        f.add(new Character('\u04c3'));
        f.add(new Character('\u04c4'));
        f.add(new Character('\u04c5'));
        f.add(new Character('\u04c6'));
        f.add(new Character('\u04c7'));
        f.add(new Character('\u04c8'));
        f.add(new Character('\u04c9'));
        f.add(new Character('\u04ca'));
        f.add(new Character('\u04cb'));
        f.add(new Character('\u04cc'));
        f.add(new Character('\u04cd'));
        f.add(new Character('\u04ce'));
        f.add(new Character('\u04cf'));
        f.add(new Character('\u04d0'));
        f.add(new Character('\u04d1'));
        f.add(new Character('\u04d2'));
        f.add(new Character('\u04d3'));
        f.add(new Character('\u04d4'));
        f.add(new Character('\u04d5'));
        f.add(new Character('\u04d6'));
        f.add(new Character('\u04d7'));
        f.add(new Character('\u04d8'));
        f.add(new Character('\u04d9'));
        f.add(new Character('\u04da'));
        f.add(new Character('\u04db'));
        f.add(new Character('\u04dc'));
        f.add(new Character('\u04dd'));
        f.add(new Character('\u04de'));
        f.add(new Character('\u04df'));
        f.add(new Character('\u04e0'));
        f.add(new Character('\u04e1'));
        f.add(new Character('\u04e2'));
        f.add(new Character('\u04e3'));
        f.add(new Character('\u04e4'));
        f.add(new Character('\u04e5'));
        f.add(new Character('\u04e6'));
        f.add(new Character('\u04e7'));
        f.add(new Character('\u04e8'));
        f.add(new Character('\u04e9'));
        f.add(new Character('\u04ea'));
        f.add(new Character('\u04eb'));
        f.add(new Character('\u04ec'));
        f.add(new Character('\u04ed'));
        f.add(new Character('\u04ee'));
        f.add(new Character('\u04ef'));
        f.add(new Character('\u04f0'));
        f.add(new Character('\u04f1'));
        f.add(new Character('\u04f2'));
        f.add(new Character('\u04f3'));
        f.add(new Character('\u04f4'));
        f.add(new Character('\u04f5'));
        f.add(new Character('\u04f6'));
        f.add(new Character('\u04f7'));
        f.add(new Character('\u04f8'));
        f.add(new Character('\u04f9'));
        f.add(new Character('\u04fa'));
        f.add(new Character('\u04fb'));
        f.add(new Character('\u04fc'));
        f.add(new Character('\u04fd'));
        f.add(new Character('\u04fe'));
        f.add(new Character('\u04ff'));
        f.add(new Character('\u0500'));
        f.add(new Character('\u0501'));
        f.add(new Character('\u0502'));
        f.add(new Character('\u0503'));
        f.add(new Character('\u0504'));
        f.add(new Character('\u0505'));
        f.add(new Character('\u0506'));
        f.add(new Character('\u0507'));
        f.add(new Character('\u0508'));
        f.add(new Character('\u0509'));
        f.add(new Character('\u050a'));
        f.add(new Character('\u050b'));
        f.add(new Character('\u050c'));
        f.add(new Character('\u050d'));
        f.add(new Character('\u050e'));
        f.add(new Character('\u050f'));
        f.add(new Character('\u0510'));
        f.add(new Character('\u0511'));
        f.add(new Character('\u0512'));
        f.add(new Character('\u0513'));
        f.add(new Character('\u0514'));
        f.add(new Character('\u0515'));
        f.add(new Character('\u0516'));
        f.add(new Character('\u0517'));
        f.add(new Character('\u0518'));
        f.add(new Character('\u0519'));
        f.add(new Character('\u051a'));
        f.add(new Character('\u051b'));
        f.add(new Character('\u051c'));
        f.add(new Character('\u051d'));
        f.add(new Character('\u051e'));
        f.add(new Character('\u051f'));
        f.add(new Character('\u0520'));
        f.add(new Character('\u0521'));
        f.add(new Character('\u0522'));
        f.add(new Character('\u0523'));
        f.add(new Character('\u0524'));
        f.add(new Character('\u0525'));
        f.add(new Character('\u0526'));
        f.add(new Character('\u0527'));
        f.add(new Character('\u0528'));
        f.add(new Character('\u0529'));
        f.add(new Character('\u052a'));
        f.add(new Character('\u052b'));
        f.add(new Character('\u052c'));
        f.add(new Character('\u052d'));
        f.add(new Character('\u052e'));
        f.add(new Character('\u052f'));
        f.add(new Character('\u0530'));
        f.add(new Character('\u0531'));
        f.add(new Character('\u0532'));
        f.add(new Character('\u0533'));
        f.add(new Character('\u0534'));
        f.add(new Character('\u0535'));
    }

    protected static void initJAFlags(HashSet f) {
        f.add(new Character('\u00a6'));
        f.add(new Character('\u00a7'));
        f.add(new Character('\u00a8'));
        f.add(new Character('\u00b0'));
        f.add(new Character('\u00b1'));
        f.add(new Character('\u00b4'));
        f.add(new Character('\u00b6'));
        f.add(new Character('\u00d7'));
        f.add(new Character('\u0100'));
        f.add(new Character('\u0101'));
        f.add(new Character('\u0102'));
        f.add(new Character('\u0103'));
        f.add(new Character('\u0104'));
        f.add(new Character('\u0105'));
        f.add(new Character('\u0106'));
        f.add(new Character('\u0107'));
        f.add(new Character('\u0108'));
        f.add(new Character('\u0109'));
        f.add(new Character('\u010a'));
        f.add(new Character('\u010b'));
        f.add(new Character('\u010c'));
        f.add(new Character('\u010d'));
        f.add(new Character('\u010e'));
        f.add(new Character('\u010f'));
        f.add(new Character('\u0110'));
        f.add(new Character('\u0111'));
        f.add(new Character('\u0112'));
        f.add(new Character('\u0113'));
        f.add(new Character('\u0114'));
        f.add(new Character('\u0115'));
        f.add(new Character('\u0116'));
        f.add(new Character('\u0117'));
        f.add(new Character('\u0118'));
        f.add(new Character('\u0119'));
        f.add(new Character('\u011a'));
        f.add(new Character('\u011b'));
        f.add(new Character('\u011c'));
        f.add(new Character('\u011d'));
        f.add(new Character('\u011e'));
        f.add(new Character('\u011f'));
        f.add(new Character('\u0120'));
        f.add(new Character('\u0121'));
        f.add(new Character('\u0122'));
        f.add(new Character('\u0123'));
        f.add(new Character('\u0124'));
        f.add(new Character('\u0125'));
        f.add(new Character('\u0126'));
        f.add(new Character('\u0127'));
        f.add(new Character('\u0128'));
        f.add(new Character('\u0129'));
        f.add(new Character('\u012a'));
        f.add(new Character('\u012b'));
        f.add(new Character('\u012c'));
        f.add(new Character('\u012d'));
        f.add(new Character('\u012e'));
        f.add(new Character('\u012f'));
        f.add(new Character('\u0130'));
        f.add(new Character('\u0131'));
        f.add(new Character('\u0132'));
        f.add(new Character('\u0133'));
        f.add(new Character('\u0134'));
        f.add(new Character('\u0135'));
        f.add(new Character('\u0136'));
        f.add(new Character('\u0137'));
        f.add(new Character('\u0138'));
        f.add(new Character('\u0139'));
        f.add(new Character('\u013a'));
        f.add(new Character('\u013b'));
        f.add(new Character('\u013c'));
        f.add(new Character('\u013d'));
        f.add(new Character('\u013e'));
        f.add(new Character('\u013f'));
        f.add(new Character('\u0140'));
        f.add(new Character('\u0141'));
        f.add(new Character('\u0142'));
        f.add(new Character('\u0143'));
        f.add(new Character('\u0144'));
        f.add(new Character('\u0145'));
        f.add(new Character('\u0146'));
        f.add(new Character('\u0147'));
        f.add(new Character('\u0148'));
        f.add(new Character('\u0149'));
        f.add(new Character('\u014a'));
        f.add(new Character('\u014b'));
        f.add(new Character('\u014c'));
        f.add(new Character('\u014d'));
        f.add(new Character('\u014e'));
        f.add(new Character('\u014f'));
        f.add(new Character('\u0150'));
        f.add(new Character('\u0151'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0154'));
        f.add(new Character('\u0155'));
        f.add(new Character('\u0156'));
        f.add(new Character('\u0157'));
        f.add(new Character('\u0158'));
        f.add(new Character('\u0159'));
        f.add(new Character('\u015a'));
        f.add(new Character('\u015b'));
        f.add(new Character('\u015c'));
        f.add(new Character('\u015d'));
        f.add(new Character('\u015e'));
        f.add(new Character('\u015f'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0162'));
        f.add(new Character('\u0163'));
        f.add(new Character('\u0164'));
        f.add(new Character('\u0165'));
        f.add(new Character('\u0166'));
        f.add(new Character('\u0167'));
        f.add(new Character('\u0168'));
        f.add(new Character('\u0169'));
        f.add(new Character('\u016a'));
        f.add(new Character('\u016b'));
        f.add(new Character('\u016c'));
        f.add(new Character('\u016d'));
        f.add(new Character('\u016e'));
        f.add(new Character('\u016f'));
        f.add(new Character('\u0170'));
        f.add(new Character('\u0171'));
        f.add(new Character('\u0172'));
        f.add(new Character('\u0173'));
        f.add(new Character('\u0174'));
        f.add(new Character('\u0175'));
        f.add(new Character('\u0176'));
        f.add(new Character('\u0177'));
        f.add(new Character('\u0178'));
        f.add(new Character('\u0179'));
        f.add(new Character('\u017a'));
        f.add(new Character('\u017b'));
        f.add(new Character('\u017c'));
        f.add(new Character('\u017d'));
        f.add(new Character('\u017e'));
        f.add(new Character('\u017f'));
        f.add(new Character('\u0180'));
        f.add(new Character('\u0181'));
        f.add(new Character('\u0182'));
        f.add(new Character('\u0183'));
        f.add(new Character('\u0184'));
        f.add(new Character('\u0185'));
        f.add(new Character('\u0186'));
        f.add(new Character('\u0187'));
        f.add(new Character('\u0188'));
        f.add(new Character('\u0189'));
        f.add(new Character('\u018a'));
        f.add(new Character('\u018b'));
        f.add(new Character('\u018c'));
        f.add(new Character('\u018d'));
        f.add(new Character('\u018e'));
        f.add(new Character('\u018f'));
        f.add(new Character('\u0190'));
        f.add(new Character('\u0191'));
        f.add(new Character('\u0192'));
        f.add(new Character('\u0193'));
        f.add(new Character('\u0194'));
        f.add(new Character('\u0195'));
        f.add(new Character('\u0196'));
        f.add(new Character('\u0197'));
        f.add(new Character('\u0198'));
        f.add(new Character('\u0199'));
        f.add(new Character('\u019a'));
        f.add(new Character('\u019b'));
        f.add(new Character('\u019c'));
        f.add(new Character('\u019d'));
        f.add(new Character('\u019e'));
        f.add(new Character('\u019f'));
        f.add(new Character('\u01a0'));
        f.add(new Character('\u01a1'));
        f.add(new Character('\u01a2'));
        f.add(new Character('\u01a3'));
        f.add(new Character('\u01a4'));
        f.add(new Character('\u01a5'));
        f.add(new Character('\u01a6'));
        f.add(new Character('\u01a7'));
        f.add(new Character('\u01a8'));
        f.add(new Character('\u01a9'));
        f.add(new Character('\u01aa'));
        f.add(new Character('\u01ab'));
        f.add(new Character('\u01ac'));
        f.add(new Character('\u01ad'));
        f.add(new Character('\u01ae'));
        f.add(new Character('\u01af'));
        f.add(new Character('\u01b0'));
        f.add(new Character('\u01b1'));
        f.add(new Character('\u01b2'));
        f.add(new Character('\u01b3'));
        f.add(new Character('\u01b4'));
        f.add(new Character('\u01b5'));
        f.add(new Character('\u01b6'));
        f.add(new Character('\u01b7'));
        f.add(new Character('\u01b8'));
        f.add(new Character('\u01b9'));
        f.add(new Character('\u01ba'));
        f.add(new Character('\u01bb'));
        f.add(new Character('\u01bc'));
        f.add(new Character('\u01bd'));
        f.add(new Character('\u01be'));
        f.add(new Character('\u01bf'));
        f.add(new Character('\u01c0'));
        f.add(new Character('\u01c1'));
        f.add(new Character('\u01c2'));
        f.add(new Character('\u01c3'));
        f.add(new Character('\u01c4'));
        f.add(new Character('\u01c5'));
        f.add(new Character('\u01c6'));
        f.add(new Character('\u01c7'));
        f.add(new Character('\u01c8'));
        f.add(new Character('\u01c9'));
        f.add(new Character('\u01ca'));
        f.add(new Character('\u01cb'));
        f.add(new Character('\u01cc'));
        f.add(new Character('\u01cd'));
        f.add(new Character('\u01ce'));
        f.add(new Character('\u01cf'));
        f.add(new Character('\u01d0'));
        f.add(new Character('\u01d1'));
        f.add(new Character('\u01d2'));
        f.add(new Character('\u01d3'));
        f.add(new Character('\u01d4'));
        f.add(new Character('\u01d5'));
        f.add(new Character('\u01d6'));
        f.add(new Character('\u01d7'));
        f.add(new Character('\u01d8'));
        f.add(new Character('\u01d9'));
        f.add(new Character('\u01da'));
        f.add(new Character('\u01db'));
        f.add(new Character('\u01dc'));
        f.add(new Character('\u01dd'));
        f.add(new Character('\u01de'));
        f.add(new Character('\u01df'));
        f.add(new Character('\u01e0'));
        f.add(new Character('\u01e1'));
        f.add(new Character('\u01e2'));
        f.add(new Character('\u01e3'));
        f.add(new Character('\u01e4'));
        f.add(new Character('\u01e5'));
        f.add(new Character('\u01e6'));
        f.add(new Character('\u01e7'));
        f.add(new Character('\u01e8'));
        f.add(new Character('\u01e9'));
        f.add(new Character('\u01ea'));
        f.add(new Character('\u01eb'));
        f.add(new Character('\u01ec'));
        f.add(new Character('\u01ed'));
        f.add(new Character('\u01ee'));
        f.add(new Character('\u01ef'));
        f.add(new Character('\u01f0'));
        f.add(new Character('\u01f1'));
        f.add(new Character('\u01f2'));
        f.add(new Character('\u01f3'));
        f.add(new Character('\u01f4'));
        f.add(new Character('\u01f5'));
        f.add(new Character('\u01f6'));
        f.add(new Character('\u01f7'));
        f.add(new Character('\u01f8'));
        f.add(new Character('\u01f9'));
        f.add(new Character('\u01fa'));
        f.add(new Character('\u01fb'));
        f.add(new Character('\u01fc'));
        f.add(new Character('\u01fd'));
        f.add(new Character('\u01fe'));
        f.add(new Character('\u01ff'));
        f.add(new Character('\u0200'));
        f.add(new Character('\u0201'));
        f.add(new Character('\u0202'));
        f.add(new Character('\u0203'));
        f.add(new Character('\u0204'));
        f.add(new Character('\u0205'));
        f.add(new Character('\u0206'));
        f.add(new Character('\u0207'));
        f.add(new Character('\u0208'));
        f.add(new Character('\u0209'));
        f.add(new Character('\u020a'));
        f.add(new Character('\u020b'));
        f.add(new Character('\u020c'));
        f.add(new Character('\u020d'));
        f.add(new Character('\u020e'));
        f.add(new Character('\u020f'));
        f.add(new Character('\u0210'));
        f.add(new Character('\u0211'));
        f.add(new Character('\u0212'));
        f.add(new Character('\u0213'));
        f.add(new Character('\u0214'));
        f.add(new Character('\u0215'));
        f.add(new Character('\u0216'));
        f.add(new Character('\u0217'));
        f.add(new Character('\u0218'));
        f.add(new Character('\u0219'));
        f.add(new Character('\u021a'));
        f.add(new Character('\u021b'));
        f.add(new Character('\u021c'));
        f.add(new Character('\u021d'));
        f.add(new Character('\u021e'));
        f.add(new Character('\u021f'));
        f.add(new Character('\u0220'));
        f.add(new Character('\u0221'));
        f.add(new Character('\u0222'));
        f.add(new Character('\u0223'));
        f.add(new Character('\u0224'));
        f.add(new Character('\u0225'));
        f.add(new Character('\u0226'));
        f.add(new Character('\u0227'));
        f.add(new Character('\u0228'));
        f.add(new Character('\u0229'));
        f.add(new Character('\u022a'));
        f.add(new Character('\u022b'));
        f.add(new Character('\u022c'));
        f.add(new Character('\u022d'));
        f.add(new Character('\u022e'));
        f.add(new Character('\u022f'));
        f.add(new Character('\u0230'));
        f.add(new Character('\u0231'));
        f.add(new Character('\u0232'));
        f.add(new Character('\u0233'));
        f.add(new Character('\u0234'));
        f.add(new Character('\u0235'));
        f.add(new Character('\u0236'));
        f.add(new Character('\u0237'));
        f.add(new Character('\u0238'));
        f.add(new Character('\u0239'));
        f.add(new Character('\u023a'));
        f.add(new Character('\u023b'));
        f.add(new Character('\u023c'));
        f.add(new Character('\u023d'));
        f.add(new Character('\u023e'));
        f.add(new Character('\u023f'));
        f.add(new Character('\u0240'));
        f.add(new Character('\u0241'));
        f.add(new Character('\u0242'));
        f.add(new Character('\u0243'));
        f.add(new Character('\u0244'));
        f.add(new Character('\u0245'));
        f.add(new Character('\u0246'));
        f.add(new Character('\u0247'));
        f.add(new Character('\u0248'));
        f.add(new Character('\u0249'));
        f.add(new Character('\u024a'));
        f.add(new Character('\u024b'));
        f.add(new Character('\u024c'));
        f.add(new Character('\u024d'));
        f.add(new Character('\u024e'));
        f.add(new Character('\u024f'));
        f.add(new Character('\u0250'));
        f.add(new Character('\u0251'));
        f.add(new Character('\u0252'));
        f.add(new Character('\u0253'));
        f.add(new Character('\u0254'));
        f.add(new Character('\u0255'));
        f.add(new Character('\u0256'));
        f.add(new Character('\u0257'));
        f.add(new Character('\u0258'));
        f.add(new Character('\u0259'));
        f.add(new Character('\u025a'));
        f.add(new Character('\u025b'));
        f.add(new Character('\u025c'));
        f.add(new Character('\u025d'));
        f.add(new Character('\u025e'));
        f.add(new Character('\u025f'));
        f.add(new Character('\u0260'));
        f.add(new Character('\u0261'));
        f.add(new Character('\u0262'));
        f.add(new Character('\u0263'));
        f.add(new Character('\u0264'));
        f.add(new Character('\u0265'));
        f.add(new Character('\u0266'));
        f.add(new Character('\u0267'));
        f.add(new Character('\u0268'));
        f.add(new Character('\u0269'));
        f.add(new Character('\u026a'));
        f.add(new Character('\u026b'));
        f.add(new Character('\u026c'));
        f.add(new Character('\u026d'));
        f.add(new Character('\u026e'));
        f.add(new Character('\u026f'));
        f.add(new Character('\u0270'));
        f.add(new Character('\u0271'));
        f.add(new Character('\u0272'));
        f.add(new Character('\u0273'));
        f.add(new Character('\u0274'));
        f.add(new Character('\u0275'));
        f.add(new Character('\u0276'));
        f.add(new Character('\u0277'));
        f.add(new Character('\u0278'));
        f.add(new Character('\u0279'));
        f.add(new Character('\u027a'));
        f.add(new Character('\u027b'));
        f.add(new Character('\u027c'));
        f.add(new Character('\u027d'));
        f.add(new Character('\u027e'));
        f.add(new Character('\u027f'));
        f.add(new Character('\u0280'));
        f.add(new Character('\u0281'));
        f.add(new Character('\u0282'));
        f.add(new Character('\u0283'));
        f.add(new Character('\u0284'));
        f.add(new Character('\u0285'));
        f.add(new Character('\u0286'));
        f.add(new Character('\u0287'));
        f.add(new Character('\u0288'));
        f.add(new Character('\u0289'));
        f.add(new Character('\u028a'));
        f.add(new Character('\u028b'));
        f.add(new Character('\u028c'));
        f.add(new Character('\u028d'));
        f.add(new Character('\u028e'));
        f.add(new Character('\u028f'));
        f.add(new Character('\u0290'));
        f.add(new Character('\u0291'));
        f.add(new Character('\u0292'));
        f.add(new Character('\u0293'));
        f.add(new Character('\u0294'));
        f.add(new Character('\u0295'));
        f.add(new Character('\u0296'));
        f.add(new Character('\u0297'));
        f.add(new Character('\u0298'));
        f.add(new Character('\u0299'));
        f.add(new Character('\u029a'));
        f.add(new Character('\u029b'));
        f.add(new Character('\u029c'));
        f.add(new Character('\u029d'));
        f.add(new Character('\u029e'));
        f.add(new Character('\u029f'));
        f.add(new Character('\u02a0'));
        f.add(new Character('\u02a1'));
        f.add(new Character('\u02a2'));
        f.add(new Character('\u02a3'));
        f.add(new Character('\u02a4'));
        f.add(new Character('\u02a5'));
        f.add(new Character('\u02a6'));
        f.add(new Character('\u02a7'));
        f.add(new Character('\u02a8'));
        f.add(new Character('\u02a9'));
        f.add(new Character('\u02aa'));
        f.add(new Character('\u02ab'));
        f.add(new Character('\u02ac'));
        f.add(new Character('\u02ad'));
        f.add(new Character('\u02ae'));
        f.add(new Character('\u02af'));
        f.add(new Character('\u02b0'));
        f.add(new Character('\u02b1'));
        f.add(new Character('\u02b2'));
        f.add(new Character('\u02b3'));
        f.add(new Character('\u02b4'));
        f.add(new Character('\u02b5'));
        f.add(new Character('\u02b6'));
        f.add(new Character('\u02b7'));
        f.add(new Character('\u02b8'));
        f.add(new Character('\u02b9'));
        f.add(new Character('\u02ba'));
        f.add(new Character('\u02bb'));
        f.add(new Character('\u02bc'));
        f.add(new Character('\u02bd'));
        f.add(new Character('\u02be'));
        f.add(new Character('\u02bf'));
        f.add(new Character('\u02c0'));
        f.add(new Character('\u02c1'));
        f.add(new Character('\u02c2'));
        f.add(new Character('\u02c3'));
        f.add(new Character('\u02c4'));
        f.add(new Character('\u02c5'));
        f.add(new Character('\u02c6'));
        f.add(new Character('\u02c7'));
        f.add(new Character('\u02c8'));
        f.add(new Character('\u02c9'));
        f.add(new Character('\u02ca'));
        f.add(new Character('\u02cb'));
        f.add(new Character('\u02cc'));
        f.add(new Character('\u02cd'));
        f.add(new Character('\u02ce'));
        f.add(new Character('\u02cf'));
        f.add(new Character('\u02d0'));
        f.add(new Character('\u02d1'));
        f.add(new Character('\u02d2'));
        f.add(new Character('\u02d3'));
        f.add(new Character('\u02d4'));
        f.add(new Character('\u02d5'));
        f.add(new Character('\u02d6'));
        f.add(new Character('\u02d7'));
        f.add(new Character('\u02d8'));
        f.add(new Character('\u02d9'));
        f.add(new Character('\u02da'));
        f.add(new Character('\u02db'));
        f.add(new Character('\u02dc'));
        f.add(new Character('\u02dd'));
        f.add(new Character('\u02de'));
        f.add(new Character('\u02df'));
        f.add(new Character('\u02e0'));
        f.add(new Character('\u02e1'));
        f.add(new Character('\u02e2'));
        f.add(new Character('\u02e3'));
        f.add(new Character('\u02e4'));
        f.add(new Character('\u02e5'));
        f.add(new Character('\u02e6'));
        f.add(new Character('\u02e7'));
        f.add(new Character('\u02e8'));
        f.add(new Character('\u02e9'));
        f.add(new Character('\u02ea'));
        f.add(new Character('\u02eb'));
        f.add(new Character('\u02ec'));
        f.add(new Character('\u02ed'));
        f.add(new Character('\u02ee'));
        f.add(new Character('\u02ef'));
        f.add(new Character('\u02f0'));
        f.add(new Character('\u02f1'));
        f.add(new Character('\u02f2'));
        f.add(new Character('\u02f3'));
        f.add(new Character('\u02f4'));
        f.add(new Character('\u02f5'));
        f.add(new Character('\u02f6'));
        f.add(new Character('\u02f7'));
        f.add(new Character('\u02f8'));
        f.add(new Character('\u02f9'));
        f.add(new Character('\u02fa'));
        f.add(new Character('\u02fb'));
        f.add(new Character('\u02fc'));
        f.add(new Character('\u02fd'));
        f.add(new Character('\u02fe'));
        f.add(new Character('\u02ff'));
        f.add(new Character('\u0300'));
        f.add(new Character('\u0301'));
        f.add(new Character('\u0302'));
        f.add(new Character('\u0303'));
        f.add(new Character('\u0304'));
        f.add(new Character('\u0305'));
        f.add(new Character('\u0306'));
        f.add(new Character('\u0307'));
        f.add(new Character('\u0308'));
        f.add(new Character('\u0309'));
        f.add(new Character('\u030a'));
        f.add(new Character('\u030b'));
        f.add(new Character('\u030c'));
        f.add(new Character('\u030d'));
        f.add(new Character('\u030e'));
        f.add(new Character('\u030f'));
        f.add(new Character('\u0310'));
        f.add(new Character('\u0311'));
        f.add(new Character('\u0312'));
        f.add(new Character('\u0313'));
        f.add(new Character('\u0314'));
        f.add(new Character('\u0315'));
        f.add(new Character('\u0316'));
        f.add(new Character('\u0317'));
        f.add(new Character('\u0318'));
        f.add(new Character('\u0319'));
        f.add(new Character('\u031a'));
        f.add(new Character('\u031b'));
        f.add(new Character('\u031c'));
        f.add(new Character('\u031d'));
        f.add(new Character('\u031e'));
        f.add(new Character('\u031f'));
        f.add(new Character('\u0320'));
        f.add(new Character('\u0321'));
        f.add(new Character('\u0322'));
        f.add(new Character('\u0323'));
        f.add(new Character('\u0324'));
        f.add(new Character('\u0325'));
        f.add(new Character('\u0326'));
        f.add(new Character('\u0327'));
        f.add(new Character('\u0328'));
        f.add(new Character('\u0329'));
        f.add(new Character('\u032a'));
        f.add(new Character('\u032b'));
        f.add(new Character('\u032c'));
        f.add(new Character('\u032d'));
        f.add(new Character('\u032e'));
        f.add(new Character('\u032f'));
        f.add(new Character('\u0330'));
        f.add(new Character('\u0331'));
        f.add(new Character('\u0332'));
        f.add(new Character('\u0333'));
        f.add(new Character('\u0334'));
        f.add(new Character('\u0335'));
        f.add(new Character('\u0336'));
        f.add(new Character('\u0337'));
        f.add(new Character('\u0338'));
        f.add(new Character('\u0339'));
        f.add(new Character('\u033a'));
        f.add(new Character('\u033b'));
        f.add(new Character('\u033c'));
        f.add(new Character('\u033d'));
        f.add(new Character('\u033e'));
        f.add(new Character('\u033f'));
        f.add(new Character('\u0340'));
        f.add(new Character('\u0341'));
        f.add(new Character('\u0342'));
        f.add(new Character('\u0343'));
        f.add(new Character('\u0344'));
        f.add(new Character('\u0345'));
        f.add(new Character('\u0346'));
        f.add(new Character('\u0347'));
        f.add(new Character('\u0348'));
        f.add(new Character('\u0349'));
        f.add(new Character('\u034a'));
        f.add(new Character('\u034b'));
        f.add(new Character('\u034c'));
        f.add(new Character('\u034d'));
        f.add(new Character('\u034e'));
        f.add(new Character('\u034f'));
        f.add(new Character('\u0350'));
        f.add(new Character('\u0351'));
        f.add(new Character('\u0352'));
        f.add(new Character('\u0353'));
        f.add(new Character('\u0354'));
        f.add(new Character('\u0355'));
        f.add(new Character('\u0356'));
        f.add(new Character('\u0357'));
        f.add(new Character('\u0358'));
        f.add(new Character('\u0359'));
        f.add(new Character('\u035a'));
        f.add(new Character('\u035b'));
        f.add(new Character('\u035c'));
        f.add(new Character('\u035d'));
        f.add(new Character('\u035e'));
        f.add(new Character('\u035f'));
        f.add(new Character('\u0360'));
        f.add(new Character('\u0361'));
        f.add(new Character('\u0362'));
        f.add(new Character('\u0363'));
        f.add(new Character('\u0364'));
        f.add(new Character('\u0365'));
        f.add(new Character('\u0366'));
        f.add(new Character('\u0367'));
        f.add(new Character('\u0368'));
        f.add(new Character('\u0369'));
        f.add(new Character('\u036a'));
        f.add(new Character('\u036b'));
        f.add(new Character('\u036c'));
        f.add(new Character('\u036d'));
        f.add(new Character('\u036e'));
        f.add(new Character('\u036f'));
        f.add(new Character('\u0370'));
        f.add(new Character('\u0371'));
        f.add(new Character('\u0372'));
        f.add(new Character('\u0373'));
        f.add(new Character('\u0374'));
        f.add(new Character('\u0375'));
        f.add(new Character('\u0376'));
        f.add(new Character('\u0377'));
        f.add(new Character('\u0378'));
        f.add(new Character('\u0379'));
        f.add(new Character('\u037a'));
        f.add(new Character('\u037b'));
        f.add(new Character('\u037c'));
        f.add(new Character('\u037d'));
        f.add(new Character('\u037e'));
        f.add(new Character('\u037f'));
        f.add(new Character('\u0380'));
        f.add(new Character('\u0381'));
        f.add(new Character('\u0382'));
        f.add(new Character('\u0383'));
        f.add(new Character('\u0384'));
        f.add(new Character('\u0385'));
        f.add(new Character('\u0386'));
        f.add(new Character('\u0387'));
        f.add(new Character('\u0388'));
        f.add(new Character('\u0389'));
        f.add(new Character('\u038a'));
        f.add(new Character('\u038b'));
        f.add(new Character('\u038c'));
        f.add(new Character('\u038d'));
        f.add(new Character('\u038e'));
        f.add(new Character('\u038f'));
        f.add(new Character('\u0390'));
        f.add(new Character('\u0391'));
        f.add(new Character('\u0392'));
        f.add(new Character('\u0393'));
        f.add(new Character('\u0394'));
        f.add(new Character('\u0395'));
        f.add(new Character('\u0396'));
        f.add(new Character('\u0397'));
        f.add(new Character('\u0398'));
        f.add(new Character('\u0399'));
        f.add(new Character('\u039a'));
        f.add(new Character('\u039b'));
        f.add(new Character('\u039c'));
        f.add(new Character('\u039d'));
        f.add(new Character('\u039e'));
        f.add(new Character('\u039f'));
        f.add(new Character('\u03a0'));
        f.add(new Character('\u03a1'));
        f.add(new Character('\u03a2'));
        f.add(new Character('\u03a3'));
        f.add(new Character('\u03a4'));
        f.add(new Character('\u03a5'));
        f.add(new Character('\u03a6'));
        f.add(new Character('\u03a7'));
        f.add(new Character('\u03a8'));
        f.add(new Character('\u03a9'));
        f.add(new Character('\u03aa'));
        f.add(new Character('\u03ab'));
        f.add(new Character('\u03ac'));
        f.add(new Character('\u03ad'));
        f.add(new Character('\u03ae'));
        f.add(new Character('\u03af'));
        f.add(new Character('\u03b0'));
        f.add(new Character('\u03b1'));
        f.add(new Character('\u03b2'));
        f.add(new Character('\u03b3'));
        f.add(new Character('\u03b4'));
        f.add(new Character('\u03b5'));
        f.add(new Character('\u03b6'));
        f.add(new Character('\u03b7'));
        f.add(new Character('\u03b8'));
        f.add(new Character('\u03b9'));
        f.add(new Character('\u03ba'));
        f.add(new Character('\u03bb'));
        f.add(new Character('\u03bc'));
        f.add(new Character('\u03bd'));
        f.add(new Character('\u03be'));
        f.add(new Character('\u03bf'));
        f.add(new Character('\u03c0'));
        f.add(new Character('\u03c1'));
        f.add(new Character('\u03c2'));
        f.add(new Character('\u03c3'));
        f.add(new Character('\u03c4'));
        f.add(new Character('\u03c5'));
        f.add(new Character('\u03c6'));
        f.add(new Character('\u03c7'));
        f.add(new Character('\u03c8'));
        f.add(new Character('\u03c9'));
        f.add(new Character('\u03ca'));
        f.add(new Character('\u03cb'));
        f.add(new Character('\u03cc'));
        f.add(new Character('\u03cd'));
        f.add(new Character('\u03ce'));
        f.add(new Character('\u03cf'));
        f.add(new Character('\u03d0'));
        f.add(new Character('\u03d1'));
        f.add(new Character('\u03d2'));
        f.add(new Character('\u03d3'));
        f.add(new Character('\u03d4'));
        f.add(new Character('\u03d5'));
        f.add(new Character('\u03d6'));
        f.add(new Character('\u03d7'));
        f.add(new Character('\u03d8'));
        f.add(new Character('\u03d9'));
        f.add(new Character('\u03da'));
        f.add(new Character('\u03db'));
        f.add(new Character('\u03dc'));
        f.add(new Character('\u03dd'));
        f.add(new Character('\u03de'));
        f.add(new Character('\u03df'));
        f.add(new Character('\u03e0'));
        f.add(new Character('\u03e1'));
        f.add(new Character('\u03e2'));
        f.add(new Character('\u03e3'));
        f.add(new Character('\u03e4'));
        f.add(new Character('\u03e5'));
        f.add(new Character('\u03e6'));
        f.add(new Character('\u03e7'));
        f.add(new Character('\u03e8'));
        f.add(new Character('\u03e9'));
        f.add(new Character('\u03ea'));
        f.add(new Character('\u03eb'));
        f.add(new Character('\u03ec'));
        f.add(new Character('\u03ed'));
        f.add(new Character('\u03ee'));
        f.add(new Character('\u03ef'));
        f.add(new Character('\u03f0'));
        f.add(new Character('\u03f1'));
        f.add(new Character('\u03f2'));
        f.add(new Character('\u03f3'));
        f.add(new Character('\u03f4'));
        f.add(new Character('\u03f5'));
        f.add(new Character('\u03f6'));
        f.add(new Character('\u03f7'));
        f.add(new Character('\u03f8'));
        f.add(new Character('\u03f9'));
        f.add(new Character('\u03fa'));
        f.add(new Character('\u03fb'));
        f.add(new Character('\u03fc'));
        f.add(new Character('\u03fd'));
        f.add(new Character('\u03fe'));
        f.add(new Character('\u03ff'));
        f.add(new Character('\u0400'));
        f.add(new Character('\u0401'));
        f.add(new Character('\u0402'));
        f.add(new Character('\u0403'));
        f.add(new Character('\u0404'));
        f.add(new Character('\u0405'));
        f.add(new Character('\u0406'));
        f.add(new Character('\u0407'));
        f.add(new Character('\u0408'));
        f.add(new Character('\u0409'));
        f.add(new Character('\u040a'));
        f.add(new Character('\u040b'));
        f.add(new Character('\u040c'));
        f.add(new Character('\u040d'));
        f.add(new Character('\u040e'));
        f.add(new Character('\u040f'));
        f.add(new Character('\u0410'));
        f.add(new Character('\u0411'));
        f.add(new Character('\u0412'));
        f.add(new Character('\u0413'));
        f.add(new Character('\u0414'));
        f.add(new Character('\u0415'));
        f.add(new Character('\u0416'));
        f.add(new Character('\u0417'));
        f.add(new Character('\u0418'));
        f.add(new Character('\u0419'));
        f.add(new Character('\u041a'));
        f.add(new Character('\u041b'));
        f.add(new Character('\u041c'));
        f.add(new Character('\u041d'));
        f.add(new Character('\u041e'));
        f.add(new Character('\u041f'));
        f.add(new Character('\u0420'));
        f.add(new Character('\u0421'));
        f.add(new Character('\u0422'));
        f.add(new Character('\u0423'));
        f.add(new Character('\u0424'));
        f.add(new Character('\u0425'));
        f.add(new Character('\u0426'));
        f.add(new Character('\u0427'));
        f.add(new Character('\u0428'));
        f.add(new Character('\u0429'));
        f.add(new Character('\u042a'));
        f.add(new Character('\u042b'));
        f.add(new Character('\u042c'));
        f.add(new Character('\u042d'));
        f.add(new Character('\u042e'));
        f.add(new Character('\u042f'));
        f.add(new Character('\u0430'));
        f.add(new Character('\u0431'));
        f.add(new Character('\u0432'));
        f.add(new Character('\u0433'));
        f.add(new Character('\u0434'));
        f.add(new Character('\u0435'));
        f.add(new Character('\u0436'));
        f.add(new Character('\u0437'));
        f.add(new Character('\u0438'));
        f.add(new Character('\u0439'));
        f.add(new Character('\u043a'));
        f.add(new Character('\u043b'));
        f.add(new Character('\u043c'));
        f.add(new Character('\u043d'));
        f.add(new Character('\u043e'));
        f.add(new Character('\u043f'));
        f.add(new Character('\u0440'));
        f.add(new Character('\u0441'));
        f.add(new Character('\u0442'));
        f.add(new Character('\u0443'));
        f.add(new Character('\u0444'));
        f.add(new Character('\u0445'));
        f.add(new Character('\u0446'));
        f.add(new Character('\u0447'));
        f.add(new Character('\u0448'));
        f.add(new Character('\u0449'));
        f.add(new Character('\u044a'));
        f.add(new Character('\u044b'));
        f.add(new Character('\u044c'));
        f.add(new Character('\u044d'));
        f.add(new Character('\u044e'));
        f.add(new Character('\u044f'));
        f.add(new Character('\u0450'));
        f.add(new Character('\u0451'));
        f.add(new Character('\u0452'));
        f.add(new Character('\u0453'));
        f.add(new Character('\u0454'));
        f.add(new Character('\u0455'));
        f.add(new Character('\u0456'));
        f.add(new Character('\u0457'));
        f.add(new Character('\u0458'));
        f.add(new Character('\u0459'));
        f.add(new Character('\u045a'));
        f.add(new Character('\u045b'));
        f.add(new Character('\u045c'));
        f.add(new Character('\u045d'));
        f.add(new Character('\u045e'));
        f.add(new Character('\u045f'));
        f.add(new Character('\u0460'));
        f.add(new Character('\u0461'));
        f.add(new Character('\u0462'));
        f.add(new Character('\u0463'));
        f.add(new Character('\u0464'));
        f.add(new Character('\u0465'));
        f.add(new Character('\u0466'));
        f.add(new Character('\u0467'));
        f.add(new Character('\u0468'));
    }

    private static void initITFlags(HashSet f) {
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00c0'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c3'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c5'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c8'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00ca'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cc'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00cf'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d1'));
        f.add(new Character('\u00d2'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d5'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00d9'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00db'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e3'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e5'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00ef'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f1'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f5'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fb'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u00ff'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0178'));
    }

    protected static void initHUFlags(HashSet f) {
        f.add(new Character('\u00b5'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u0102'));
        f.add(new Character('\u0103'));
        f.add(new Character('\u0104'));
        f.add(new Character('\u0105'));
        f.add(new Character('\u0106'));
        f.add(new Character('\u0107'));
        f.add(new Character('\u010c'));
        f.add(new Character('\u010d'));
        f.add(new Character('\u010e'));
        f.add(new Character('\u010f'));
        f.add(new Character('\u0110'));
        f.add(new Character('\u0111'));
        f.add(new Character('\u0118'));
        f.add(new Character('\u0119'));
        f.add(new Character('\u011a'));
        f.add(new Character('\u011b'));
        f.add(new Character('\u0139'));
        f.add(new Character('\u013a'));
        f.add(new Character('\u013d'));
        f.add(new Character('\u013e'));
        f.add(new Character('\u0141'));
        f.add(new Character('\u0142'));
        f.add(new Character('\u0143'));
        f.add(new Character('\u0144'));
        f.add(new Character('\u0147'));
        f.add(new Character('\u0148'));
        f.add(new Character('\u0150'));
        f.add(new Character('\u0151'));
        f.add(new Character('\u0154'));
        f.add(new Character('\u0155'));
        f.add(new Character('\u0158'));
        f.add(new Character('\u0159'));
        f.add(new Character('\u015a'));
        f.add(new Character('\u015b'));
        f.add(new Character('\u015e'));
        f.add(new Character('\u015f'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0162'));
        f.add(new Character('\u0163'));
        f.add(new Character('\u0164'));
        f.add(new Character('\u0165'));
        f.add(new Character('\u016e'));
        f.add(new Character('\u016f'));
        f.add(new Character('\u0170'));
        f.add(new Character('\u0171'));
        f.add(new Character('\u0179'));
        f.add(new Character('\u017a'));
        f.add(new Character('\u017b'));
        f.add(new Character('\u017c'));
        f.add(new Character('\u017d'));
        f.add(new Character('\u017e'));
    }

    protected static void initFRFlags(HashSet f) {
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00c0'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c3'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c5'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c8'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00ca'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cc'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00cf'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d1'));
        f.add(new Character('\u00d2'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d5'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00d9'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00db'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e3'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e5'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00ef'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f1'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f5'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fb'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u00ff'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0178'));
    }

    protected static void initESFlags(HashSet f) {
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00c0'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c3'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c5'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c8'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00ca'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cc'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00cf'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d1'));
        f.add(new Character('\u00d2'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d5'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00d9'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00db'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e3'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e5'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00ef'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f1'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f5'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fb'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u00ff'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0178'));
    }

    protected static void initDEFlags(HashSet f) {
        f.add(new Character('\u00aa'));
        f.add(new Character('\u00ba'));
        f.add(new Character('\u00c0'));
        f.add(new Character('\u00c1'));
        f.add(new Character('\u00c2'));
        f.add(new Character('\u00c3'));
        f.add(new Character('\u00c4'));
        f.add(new Character('\u00c5'));
        f.add(new Character('\u00c6'));
        f.add(new Character('\u00c7'));
        f.add(new Character('\u00c8'));
        f.add(new Character('\u00c9'));
        f.add(new Character('\u00ca'));
        f.add(new Character('\u00cb'));
        f.add(new Character('\u00cc'));
        f.add(new Character('\u00cd'));
        f.add(new Character('\u00ce'));
        f.add(new Character('\u00cf'));
        f.add(new Character('\u00d0'));
        f.add(new Character('\u00d1'));
        f.add(new Character('\u00d2'));
        f.add(new Character('\u00d3'));
        f.add(new Character('\u00d4'));
        f.add(new Character('\u00d5'));
        f.add(new Character('\u00d6'));
        f.add(new Character('\u00d8'));
        f.add(new Character('\u00d9'));
        f.add(new Character('\u00da'));
        f.add(new Character('\u00db'));
        f.add(new Character('\u00dc'));
        f.add(new Character('\u00dd'));
        f.add(new Character('\u00de'));
        f.add(new Character('\u00df'));
        f.add(new Character('\u00e0'));
        f.add(new Character('\u00e1'));
        f.add(new Character('\u00e2'));
        f.add(new Character('\u00e3'));
        f.add(new Character('\u00e4'));
        f.add(new Character('\u00e5'));
        f.add(new Character('\u00e6'));
        f.add(new Character('\u00e7'));
        f.add(new Character('\u00e8'));
        f.add(new Character('\u00e9'));
        f.add(new Character('\u00ea'));
        f.add(new Character('\u00eb'));
        f.add(new Character('\u00ec'));
        f.add(new Character('\u00ed'));
        f.add(new Character('\u00ee'));
        f.add(new Character('\u00ef'));
        f.add(new Character('\u00f0'));
        f.add(new Character('\u00f1'));
        f.add(new Character('\u00f2'));
        f.add(new Character('\u00f3'));
        f.add(new Character('\u00f4'));
        f.add(new Character('\u00f5'));
        f.add(new Character('\u00f6'));
        f.add(new Character('\u00f8'));
        f.add(new Character('\u00f9'));
        f.add(new Character('\u00fa'));
        f.add(new Character('\u00fb'));
        f.add(new Character('\u00fc'));
        f.add(new Character('\u00fd'));
        f.add(new Character('\u00fe'));
        f.add(new Character('\u00ff'));
        f.add(new Character('\u0152'));
        f.add(new Character('\u0153'));
        f.add(new Character('\u0160'));
        f.add(new Character('\u0161'));
        f.add(new Character('\u0178'));
    }

    protected static void initCSFlags(HashSet f) {
        f.add(new Character('\u05d0'));
        f.add(new Character('\u05d1'));
        f.add(new Character('\u05d2'));
        f.add(new Character('\u05d3'));
        f.add(new Character('\u05d4'));
        f.add(new Character('\u05d5'));
        f.add(new Character('\u05d6'));
        f.add(new Character('\u05d7'));
        f.add(new Character('\u05d8'));
        f.add(new Character('\u05d9'));
        f.add(new Character('\u05da'));
        f.add(new Character('\u05db'));
        f.add(new Character('\u05dc'));
        f.add(new Character('\u05dd'));
        f.add(new Character('\u05de'));
        f.add(new Character('\u05df'));
        f.add(new Character('\u05e0'));
        f.add(new Character('\u05e1'));
        f.add(new Character('\u05e2'));
        f.add(new Character('\u05e3'));
        f.add(new Character('\u05e4'));
        f.add(new Character('\u05e5'));
        f.add(new Character('\u05e6'));
        f.add(new Character('\u05e7'));
        f.add(new Character('\u05e8'));
        f.add(new Character('\u05e9'));
        f.add(new Character('\u05ea'));
        f.add(new Character('\u05f0'));
        f.add(new Character('\u05f1'));
        f.add(new Character('\u05f2'));
    }

    protected static HashSet initOrdinaryFlagsLUWO() {
        langsUNO = new ArrayList();
        langsUNO.add("en");
        langsUNO.add("cs");
        langsUNO.add("de");
        langsUNO.add("es");
        langsUNO.add("fr");
        langsUNO.add("hu");
        langsUNO.add("it");
        langsUNO.add("ja");
        langsUNO.add("ko");
        langsUNO.add("pl");
        langsUNO.add("pt");
        langsUNO.add("ru");
        langsUNO.add("zh");
        HashSet<Character> f = new HashSet<Character>(349);
        ordinaryFlagsSet.put(PLATFORM_LUWO_KEY, f);
        f.add(new Character('#'));
        f.add(new Character('$'));
        f.add(new Character('@'));
        SQLIdentifier.initCommonOrdinaryFlags(f);
        Locale locale = Locale.getDefault();
        SQLIdentifier.initOrdinaryFlagsLUWO(f, locale);
        return f;
    }
}

