/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.matching;

import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.AbstractPairMatcher;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.GeneralMatchingPairs;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.GeneralPairMatcher;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.IMatchingPairs;

public class GenericSQLPairMatcher
extends AbstractPairMatcher {
    protected GeneralPairMatcher _generalMatcher = new GeneralPairMatcher(GeneralMatchingPairs.getInstance());
    protected int _originalTokenLength;
    protected int _matchingTokenLength;
    protected int _originalTokenEndOffset = -1;

    public GenericSQLPairMatcher(IMatchingPairs matchingPairs) {
        super(matchingPairs);
    }

    public int getMatchingTokenLength() {
        return this._matchingTokenLength;
    }

    /*
     * Unable to fully structure code
     */
    public int getMatchingTokenStartOffset(String token, int start, boolean forward, String text) {
        block15: {
            block13: {
                originalToken = this.getOriginalToken(text, start);
                if (originalToken == null) {
                    return -1;
                }
                if (originalToken.length() == 1) {
                    return this._generalMatcher.getMatchingTokenStartOffset(token, start, forward, text);
                }
                m = Pattern.compile(this._matchingPairs.getMatchingPatternClosure(originalToken)).matcher(text);
                tokenStack = new Stack<int[]>();
                tokenStack.push(new int[]{this._originalTokenEndOffset - this._originalTokenLength, this._originalTokenEndOffset});
                tempStart = 0;
                tempEnd = 0;
                tempToken = null;
                if (!forward) break block13;
                nextStart = this._originalTokenEndOffset;
                while (m.find(nextStart) && !tokenStack.isEmpty()) {
                    block14: {
                        tempStart = m.start();
                        tempEnd = m.end();
                        if (!this.isCode(tempStart)) {
                            nextStart = tempEnd;
                            continue;
                        }
                        tempToken = text.substring(tempStart, tempEnd);
                        currentToken = this.getCurrentToken(text, tempEnd, false);
                        if (currentToken == null || !currentToken.equals(tempToken)) {
                            nextStart = tempEnd;
                            continue;
                        }
                        top = (int[])tokenStack.peek();
                        if (!this._matchingPairs.isLeftToken(tempToken)) ** GOTO lbl36
                        tokenStack.push(new int[]{tempStart, tempEnd});
                        break block14;
lbl-1000:
                        // 1 sources

                        {
                            tokenStack.pop();
                            if (tokenStack.isEmpty()) {
                                return -1;
                            }
                            top = (int[])tokenStack.peek();
lbl36:
                            // 2 sources

                            ** while (!Pattern.compile((String)this._matchingPairs.getMatchingPattern((String)tempToken)).matcher((CharSequence)text.substring((int)top[0], (int)top[1])).matches())
                        }
lbl37:
                        // 1 sources

                        tokenStack.pop();
                    }
                    nextStart = tempEnd;
                }
                break block15;
            }
            tokenList = new ArrayList<int[]>();
            while (m.find()) {
                tempStart = m.start();
                tempEnd = m.end();
                tempToken = text.substring(tempStart, tempEnd);
                if (tempStart >= this._originalTokenEndOffset - this._originalTokenLength) break;
                currentToken = this.getCurrentToken(text, tempEnd, false);
                if (!this.isCode(tempStart) || currentToken == null || !currentToken.equals(tempToken)) continue;
                tokenList.add(new int[]{tempStart, tempEnd});
            }
            tokens = tokenList.toArray();
            i = tokens.length - 1;
            while (i >= 0 && !tokenStack.isEmpty()) {
                block16: {
                    top = (int[])tokenStack.peek();
                    tempStart = ((int[])tokens[i])[0];
                    tempEnd = ((int[])tokens[i])[1];
                    tempToken = text.substring(tempStart, tempEnd);
                    if (this._matchingPairs.isLeftToken(tempToken)) ** GOTO lbl71
                    tokenStack.push(new int[]{tempStart, tempEnd});
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        tokenStack.pop();
                        if (tokenStack.isEmpty()) {
                            return -1;
                        }
                        top = (int[])tokenStack.peek();
lbl71:
                        // 2 sources

                        ** while (!Pattern.compile((String)this._matchingPairs.getMatchingPattern((String)tempToken)).matcher((CharSequence)text.substring((int)top[0], (int)top[1])).matches())
                    }
lbl72:
                    // 1 sources

                    tokenStack.pop();
                }
                --i;
            }
        }
        if (tokenStack.isEmpty()) {
            this._matchingTokenLength = tempToken.length();
            currentToken = this.getCurrentToken(text, tempStart, false);
            if (currentToken != null && Pattern.compile(this._matchingPairs.getMatchingPattern(originalToken)).matcher(currentToken).matches()) {
                return tempStart;
            }
        }
        return -1;
    }

    public String getOriginalToken(String text, int offset) {
        String token = this._generalMatcher.getOriginalToken(text, offset);
        if (token != null) {
            this._originalTokenEndOffset = this._generalMatcher.getOriginalTokenEndOffset(text, offset);
            this._originalTokenLength = this._generalMatcher.getOriginalTokenLength();
            this._matchingTokenLength = this._generalMatcher.getMatchingTokenLength();
            return token;
        }
        return this.getCurrentToken(text, offset, true);
    }

    public int getOriginalTokenEndOffset(String text, int offset) {
        return this._originalTokenEndOffset;
    }

    public int getOriginalTokenLength() {
        return this._originalTokenLength;
    }

    public void setSQLEditor(SQLEditor editor) {
        super.setSQLEditor(editor);
        this._generalMatcher.setSQLEditor(editor);
    }

    protected boolean isDelimiter(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == ';' || c == '(' || c == ')' || c == '[' || c == ']' || c == ',';
    }

    private String getCurrentToken(String text, int offset, boolean needRecord) {
        String token = null;
        int len = text.length();
        if (offset >= 0 && offset <= len) {
            int begin = offset - 1;
            int end = offset;
            int[] begins = new int[2];
            int[] ends = new int[]{len, len};
            int count = 1;
            while (begin >= 0 && count >= 0) {
                if (this.isDelimiter(text.charAt(begin))) {
                    begins[count] = begin + 1;
                    --count;
                }
                --begin;
            }
            count = 1;
            while (end < len && count >= 0) {
                if (this.isDelimiter(text.charAt(end))) {
                    ends[count ^ 1] = end;
                    --count;
                }
                ++end;
            }
            String token0 = text.substring(begins[0], ends[0]);
            String token1 = text.substring(begins[1], ends[1]);
            if (this._matchingPairs.isSupportedToken(token0) && !this._matchingPairs.isSupportedToken(token1)) {
                token = token0;
                if (needRecord) {
                    this._originalTokenEndOffset = ends[0];
                }
            } else if (!this._matchingPairs.isSupportedToken(token0) && this._matchingPairs.isSupportedToken(token1)) {
                token = token1;
                if (needRecord) {
                    this._originalTokenEndOffset = ends[1];
                }
            } else if (!this._matchingPairs.isSupportedToken(token0) && !this._matchingPairs.isSupportedToken(token1)) {
                if (begins[1] > ends[0]) {
                    token = null;
                } else {
                    token = text.substring(begins[1], ends[0]);
                    if (this._matchingPairs.isSupportedToken(token)) {
                        if (needRecord) {
                            this._originalTokenEndOffset = ends[0];
                        }
                    } else {
                        token = null;
                    }
                }
            } else if (token0.length() >= token1.length()) {
                token = token0;
                if (needRecord) {
                    this._originalTokenEndOffset = ends[0];
                }
            } else {
                token = token1;
                if (needRecord) {
                    this._originalTokenEndOffset = ends[1];
                }
            }
        }
        if (token != null && needRecord) {
            this._originalTokenLength = token.length();
        }
        return token;
    }
}

