/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ui.core;

import org.eclipse.datatools.enablement.ingres.internal.ui.core.IngresConnectionService;
import org.eclipse.datatools.enablement.ingres.internal.ui.core.IngresDBHelper;
import org.eclipse.datatools.enablement.ingres.internal.ui.core.IngresExcecutionService;
import org.eclipse.datatools.enablement.ingres.internal.ui.core.IngresSQLService;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.core.services.ExecutionService;
import org.eclipse.datatools.sqltools.core.services.SQLService;

public class IngresDBConfiguration
extends SQLDevToolsConfiguration {
    private static final String[] PRODUCTS = new String[]{"Ingres", "II"};

    public ConnectionService getConnectionService() {
        return new IngresConnectionService();
    }

    public DBHelper getDBHelper() {
        return new IngresDBHelper();
    }

    public SQLService getSQLService() {
        return new IngresSQLService();
    }

    public ExecutionService getExecutionService() {
        return new IngresExcecutionService();
    }

    private String format(String in) {
        return in.trim().toLowerCase();
    }

    public boolean recognize(String product, String version) {
        if (product != null) {
            String formattedProduct = this.format(product);
            int i = 0;
            while (i < PRODUCTS.length) {
                if (formattedProduct.indexOf(this.format(PRODUCTS[i])) > -1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String[] getAssociatedConnectionProfileType() {
        return new String[]{"org.eclipse.datatools.enablement.ingres.profile.connectionProfile"};
    }
}

