/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.catalog;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.IngresDBEventLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.IngresSequenceLoader;
import org.eclipse.datatools.enablement.ingres.internal.loaders.IngresSynonymLoader;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngressqlmodelPackage;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.impl.IngresSchemaImpl;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;

public class IngresCatalogSchema
extends IngresSchemaImpl {
    private final Object SEQUENCE_LOCK = new Object();
    private final Object DBEVENT_LOCK = new Object();
    private final Object SYNONYM_LOCK = new Object();
    private Boolean sequencesLoaded = Boolean.FALSE;
    private Boolean dbEventsLoaded = Boolean.FALSE;
    private Boolean synonymsLoaded = Boolean.FALSE;
    private transient SoftReference sequenceLoaderRef;
    private transient SoftReference dbEventLoaderRef;
    private transient SoftReference synonymLoaderRef;
    private final transient ConnectionFilterListener filterListener = new ConnectionFilterListener(){

        public void connectionFilterAdded(String filterKey) {
            IngresCatalogSchema.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            IngresCatalogSchema.this.handleFilterChanged(filterKey);
        }
    };

    public NotificationChain basicSetCatalog(Catalog newCatalog, NotificationChain msgs) {
        ConnectionInfo connectionInfo;
        if (this.catalog != null && this.catalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.catalog.getDatabase());
            connectionInfo.removeFilterListener(this.filterListener);
        }
        if (newCatalog != null && newCatalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(newCatalog.getDatabase());
            connectionInfo.addFilterListener(this.filterListener);
        }
        return super.basicSetCatalog(newCatalog, msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            if (this.sequencesLoaded.booleanValue()) {
                this.sequencesLoaded = Boolean.FALSE;
            }
        }
        object = this.DBEVENT_LOCK;
        synchronized (object) {
            if (this.dbEventsLoaded.booleanValue()) {
                this.dbEventsLoaded = Boolean.FALSE;
            }
        }
        object = this.SYNONYM_LOCK;
        synchronized (object) {
            if (this.synonymsLoaded.booleanValue()) {
                this.synonymsLoaded = Boolean.FALSE;
            }
        }
        super.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSequences() {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            if (!this.sequencesLoaded.booleanValue()) {
                this.loadSequences();
            }
        }
        return super.getSequences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSynonyms() {
        Object object = this.SYNONYM_LOCK;
        synchronized (object) {
            if (!this.synonymsLoaded.booleanValue()) {
                this.loadSynonyms();
            }
        }
        return super.getSynonyms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getDBEvents() {
        Object object = this.DBEVENT_LOCK;
        synchronized (object) {
            if (!this.dbEventsLoaded.booleanValue()) {
                this.loadDbEvents();
            }
        }
        return super.getDBEvents();
    }

    protected final IngresSequenceLoader getSequenceLoader() {
        if (this.sequenceLoaderRef == null || this.sequenceLoaderRef.get() == null) {
            this.sequenceLoaderRef = new SoftReference<IngresSequenceLoader>(this.createSequenceLoader());
        }
        return (IngresSequenceLoader)((Object)this.sequenceLoaderRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSequences() {
        Object object = this.SEQUENCE_LOCK;
        synchronized (object) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getSequences();
                        ArrayList existingSequences = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getSequenceLoader().loadSequences((List)container, existingSequences);
                        this.getSequenceLoader().clearSequences(existingSequences);
                        this.sequencesLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    protected final IngresDBEventLoader getDbEventLoader() {
        if (this.dbEventLoaderRef == null || this.dbEventLoaderRef.get() == null) {
            this.dbEventLoaderRef = new SoftReference<IngresDBEventLoader>(this.createDbEventLoader());
        }
        return (IngresDBEventLoader)((Object)this.dbEventLoaderRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDbEvents() {
        Object object = this.DBEVENT_LOCK;
        synchronized (object) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getDBEvents();
                        ArrayList existingDbEvents = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getDbEventLoader().loadDbEvents((List)container, existingDbEvents);
                        this.getDbEventLoader().clearDbEvents(existingDbEvents);
                        this.dbEventsLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    protected final IngresSynonymLoader getSynonymLoader() {
        if (this.synonymLoaderRef == null || this.synonymLoaderRef.get() == null) {
            this.synonymLoaderRef = new SoftReference<IngresSynonymLoader>(this.createSynonymLoader());
        }
        return (IngresSynonymLoader)((Object)this.synonymLoaderRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSynonyms() {
        Object object = this.SYNONYM_LOCK;
        synchronized (object) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getSynonyms();
                        ArrayList existingSynonyms = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getSynonymLoader().loadSynonyms((List)container, existingSynonyms);
                        this.getSynonymLoader().clearSynonyms(existingSynonyms);
                        this.synonymsLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    private IngresSequenceLoader createSequenceLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLSchemaPackage.eINSTANCE.getSequence().getInstanceClassName());
        if (loader != null) {
            IngresSequenceLoader sequenceLoader = (IngresSequenceLoader)loader;
            sequenceLoader.setCatalogObject((ICatalogObject)this);
            return sequenceLoader;
        }
        return new IngresSequenceLoader((ICatalogObject)this);
    }

    private IngresDBEventLoader createDbEventLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, IngressqlmodelPackage.eINSTANCE.getIngresDBEvent().getInstanceClassName());
        if (loader != null) {
            IngresDBEventLoader sequenceLoader = (IngresDBEventLoader)loader;
            sequenceLoader.setCatalogObject((ICatalogObject)this);
            return sequenceLoader;
        }
        return new IngresDBEventLoader((ICatalogObject)this);
    }

    private IngresSynonymLoader createSynonymLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, IngressqlmodelPackage.eINSTANCE.getIngresSynonym().getInstanceClassName());
        if (loader != null) {
            IngresSynonymLoader synonymLoader = (IngresSynonymLoader)loader;
            synonymLoader.setCatalogObject((ICatalogObject)this);
            return synonymLoader;
        }
        return new IngresSynonymLoader((ICatalogObject)this);
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        if (this.sequencesLoaded.booleanValue() && filterKey.equals(this.getSequenceFilterKey()) || conInf != null && conInf.getFilter(this.getSequenceFilterKey()) == null && ("DatatoolsSequenceFilterPredicate".equals(filterKey) || filterKey.equals(String.valueOf(this.getCatalog().getName()) + "::" + "DatatoolsSequenceFilterPredicate"))) {
            this.sequencesLoaded = Boolean.FALSE;
            this.getSequenceLoader().clearSequences((List)super.getSequences());
            refresh = true;
        }
        if (this.dbEventsLoaded.booleanValue() && filterKey.equals(this.getDbEventFilterKey()) || conInf != null && conInf.getFilter(this.getDbEventFilterKey()) == null && ("DatatoolsDbEventFilterPredicate".equals(filterKey) || filterKey.equals(String.valueOf(this.getCatalog().getName()) + "::" + "DatatoolsDbEventFilterPredicate"))) {
            this.dbEventsLoaded = Boolean.FALSE;
            this.getDbEventLoader().clearDbEvents((List)super.getDBEvents());
            refresh = true;
        }
        if (this.synonymsLoaded.booleanValue() && filterKey.equals(this.getSynonymFilterKey()) || conInf != null && conInf.getFilter(this.getSynonymFilterKey()) == null && ("DatatoolsSynonymFilterPredicate".equals(filterKey) || filterKey.equals(String.valueOf(this.getCatalog().getName()) + "::" + "DatatoolsSynonymFilterPredicate"))) {
            this.synonymsLoaded = Boolean.FALSE;
            this.getSynonymLoader().clearSynonyms((List)super.getSynonyms());
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    private String getSequenceFilterKey() {
        return String.valueOf(this.getCatalog().getName()) + "::" + this.getName() + "::" + "DatatoolsSequenceFilterPredicate";
    }

    private String getDbEventFilterKey() {
        return String.valueOf(this.getCatalog().getName()) + "::" + this.getName() + "::" + "DatatoolsDbEventFilterPredicate";
    }

    private String getSynonymFilterKey() {
        return String.valueOf(this.getCatalog().getName()) + "::" + this.getName() + "::" + "DatatoolsDbEventFilterPredicate";
    }
}

