/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.helpers;

import java.text.MessageFormat;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;

public class TriggerHelper {
    public static final TriggerHelper INSTANCE = new TriggerHelper();
    private static final String FORMAT = " [{0} / {1}]";
    private static final String SEPARATION = " - ";
    private static final String BLANK = "";
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    private static final String UPDATE = resource.queryString("DATATOOLS.CORE.UI.TRIGGER_UPDATE.DECORATION");
    private static final String DELETE = resource.queryString("DATATOOLS.CORE.UI.TRIGGER_DELETE.DECORATION");
    private static final String INSERT = resource.queryString("DATATOOLS.CORE.UI.TRIGGER_INSERT.DECORATION");
    private static final String BEFORE = resource.queryString("DATATOOLS.CORE.UI.TRIGGER_BEFORE.DECORATION");
    private static final String AFTER = resource.queryString("DATATOOLS.CORE.UI.TRIGGER_AFTER.DECORATION");
    private static final String INSTEADOF = resource.queryString("DATATOOLS.CORE.UI.TRIGGER_INSTEADOF.DECORATION");

    private TriggerHelper() {
    }

    public String getDecoration(Trigger trigger) {
        ActionTimeType type;
        String triggerType = null;
        String triggerTime = null;
        if (trigger.isInsertType()) {
            triggerType = INSERT;
        }
        if (trigger.isDeleteType()) {
            triggerType = triggerType == null ? DELETE : String.valueOf(triggerType) + SEPARATION + DELETE;
        }
        if (trigger.isUpdateType()) {
            triggerType = triggerType == null ? UPDATE : String.valueOf(triggerType) + SEPARATION + UPDATE;
        }
        if ((type = trigger.getActionTime()) == ActionTimeType.AFTER_LITERAL) {
            triggerTime = AFTER;
        } else if (type == ActionTimeType.BEFORE_LITERAL) {
            triggerTime = BEFORE;
        } else if (type == ActionTimeType.INSTEADOF_LITERAL) {
            triggerTime = INSTEADOF;
        }
        return MessageFormat.format(FORMAT, triggerType != null ? triggerType : BLANK, triggerTime != null ? triggerTime : BLANK);
    }
}

