/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParameterMode implements Enumerator
{
    IN_LITERAL(0, "In", "In"),
    OUT_LITERAL(1, "Out", "Out"),
    IN_OUT_LITERAL(2, "InOut", "InOut");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int IN_OUT = 2;
    private static final ParameterMode[] VALUES_ARRAY;
    public static final List<ParameterMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterMode[]{IN_LITERAL, OUT_LITERAL, IN_OUT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterMode get(int value) {
        switch (value) {
            case 0: {
                return IN_LITERAL;
            }
            case 1: {
                return OUT_LITERAL;
            }
            case 2: {
                return IN_OUT_LITERAL;
            }
        }
        return null;
    }

    private ParameterMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

