/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan;

import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.IPlanManager;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.util.ILogger;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class EPVFacade {
    private static ILogger _log = PlanViewPlugin.getLogger(null);
    private static EPVFacade _instance;
    private IPlanManager _manager = PlanViewPlugin.getPlanManager();
    private IWorkbenchPage _activePage;

    private EPVFacade() {
    }

    public boolean createNewPlanInstance(PlanRequest request) {
        this.checkView(request.getMode());
        if (request == null) {
            return false;
        }
        if (this._manager.getPlanInstance(request) != null) {
            return false;
        }
        IPlanInstance instance = this._manager.createNewPlanInstance(request);
        return instance != null;
    }

    public static synchronized EPVFacade getInstance() {
        if (_instance == null) {
            _instance = new EPVFacade();
        }
        return _instance;
    }

    public void planFailed(PlanRequest request, Throwable th) {
        this.checkView(request.getMode());
        if (request == null) {
            return;
        }
        IPlanInstance instance = this._manager.getPlanInstance(request);
        if (instance == null || instance.isFinished()) {
            return;
        }
        instance.finishFail(th);
    }

    public void planGenerated(PlanRequest request, String rawPlan) {
        this.checkView(request.getMode());
        if (request == null) {
            return;
        }
        IPlanInstance instance = this._manager.getPlanInstance(request);
        if (instance == null || instance.isFinished()) {
            return;
        }
        instance.finishSuccess(rawPlan);
    }

    public int getStatus(PlanRequest request) {
        if (request == null) {
            return 2;
        }
        IPlanInstance instance = this._manager.getPlanInstance(request);
        if (instance == null) {
            return 2;
        }
        return instance.getStatus();
    }

    private boolean checkView(final int mode) {
        int i;
        IWorkbenchWindow activeWindow = PlanViewPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            IWorkbenchWindow[] windows = PlanViewPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            i = 0;
            while (i < windows.length) {
                activeWindow = windows[0];
                if (activeWindow != null) break;
                ++i;
            }
            if (activeWindow == null) {
                return false;
            }
        }
        this._activePage = activeWindow.getActivePage();
        if (this._activePage == null) {
            IWorkbenchPage[] pages = activeWindow.getPages();
            i = 0;
            while (i < pages.length) {
                this._activePage = pages[0];
                if (this._activePage != null) break;
                ++i;
            }
            if (this._activePage == null) {
                return false;
            }
        }
        activeWindow.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                try {
                    EPVFacade.this._activePage.showView("org.eclipse.datatools.sqltools.plan.planView", null, mode);
                }
                catch (PartInitException ex) {
                    _log.error("EPVFacade.checkview.error", (Throwable)ex);
                }
            }
        });
        return true;
    }
}

