/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWCatalogFederatedServer;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.LUWOverwriteStatus;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWFactory;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWGenericWrapper;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWOption;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWGenericWrapperImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class LUWCatalogWrapper
extends LUWGenericWrapperImpl
implements ICatalogObject {
    private boolean serversLoaded = false;
    private boolean propertiesLoaded = false;
    private boolean optionsLoaded = false;

    public void refresh() {
        this.propertiesLoaded = false;
        if (this.serversLoaded) {
            this.serversLoaded = false;
            this.servers.clear();
        }
        if (this.optionsLoaded) {
            this.optionsLoaded = false;
            this.getOptions().clear();
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((LUWCatalogDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getLUWDatabase();
    }

    public String getDescription() {
        if (!this.propertiesLoaded) {
            this.loadProperties();
        }
        return this.description;
    }

    public EList getOptions() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getOptions();
        }
        if (!this.optionsLoaded) {
            this.loadOptions();
        }
        return super.getOptions();
    }

    public EList getServers() {
        if (LUWOverwriteStatus.IS_OVERWRITE) {
            return super.getServers();
        }
        if (!this.serversLoaded) {
            this.loadServers();
        }
        return super.getServers();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 3) {
            this.getDescription();
        } else if (id == 16) {
            this.getOptions();
        } else if (id == 14) {
            this.getServers();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadOptions() {
        if (this.optionsLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            EList options = super.getOptions();
            options.clear();
            LUWCatalogWrapper.loadOptions(this.getConnection(), this, options);
            this.optionsLoaded = true;
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    public static void loadOptions(Connection connection, LUWGenericWrapper wrapper, EList options) throws SQLException {
        String query = "SELECT OPTION, SETTING FROM SYSCAT.WRAPOPTIONS WHERE WRAPNAME ='" + wrapper.getName() + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String name = r.getString("OPTION");
                String value = r.getString("SETTING");
                LUWOption option = LUWFactory.eINSTANCE.createLUWOption();
                option.setName(name);
                option.setValue(value);
                options.add((Object)option);
                if (name == null || value == null || !name.toUpperCase().equals("DB2_FENCED")) continue;
                boolean bFenced = value.toUpperCase().equals("Y");
                wrapper.setFenced(bFenced);
            }
        }
        catch (Exception exception) {}
        r.close();
        s.close();
    }

    private synchronized void loadProperties() {
        if (this.propertiesLoaded) {
            return;
        }
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            LUWCatalogWrapper.loadProperties(this.getConnection(), this);
            this.propertiesLoaded = true;
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    public static void loadProperties(Connection connection, LUWGenericWrapper wrapper) throws SQLException {
        String query = "SELECT REMARKS FROM SYSCAT.WRAPPERS WHERE WRAPNAME='" + wrapper.getName() + "'";
        Statement s = connection.createStatement();
        ResultSet r = s.executeQuery(query);
        try {
            while (r.next()) {
                String description = r.getString("REMARKS");
                wrapper.setDescription(description);
            }
        }
        catch (Exception exception) {}
        r.close();
        s.close();
    }

    private synchronized void loadServers() {
        if (this.serversLoaded) {
            return;
        }
        EList serversList = super.getServers();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            for (LUWCatalogFederatedServer server : this.getLUWDatabase().getServers()) {
                if (!server.getWrapperName().equalsIgnoreCase(this.getName())) continue;
                serversList.add((Object)server);
            }
        }
        catch (Exception exception) {}
        this.serversLoaded = true;
        this.eSetDeliver(deliver);
    }
}

