/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ddl;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlBuilder;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCPrimaryKey;
import org.eclipse.datatools.enablement.ingres.internal.catalog.IngresCatalogCheckConstraint;
import org.eclipse.datatools.enablement.ingres.internal.catalog.IngresCatalogView;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresDBEvent;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresIdentitySpecifier;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresSynonym;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresTrigger;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class IngresDdlBuilder
extends GenericDdlBuilder {
    protected static final String RULE = "RULE";
    protected static final String SYNONYM = "SYNONYM";
    protected static final String DB_EVENT = "DBEVENT";
    protected static final String SEQUENCE = "SEQUENCE";
    private static final String START = "START";
    private static final String BY = "BY";
    private static final String INCREMENT = "INCREMENT";
    private static final String MAXVALUE = "MAXVALUE";
    private static final String MINVALUE = "MINVALUE";
    private static final String CACHE = "CACHE";
    private static final String CYCLE = "CYCLE";
    private static final String ORDER = "ORDER";
    private static final String BEGIN = "BEGIN";
    private static final String SEMICOLON = ";";
    private static final String END = "END";
    private static final String RETURN = "RETURN";

    public String createProcedures(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        return procedure.getSource().getBody();
    }

    public String createProcedureEmptyBody(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmtBuf = new StringBuffer();
        stmtBuf.append("CREATE").append(" ").append("PROCEDURE").append(" ");
        stmtBuf.append(this.getName((Routine)procedure, quoteIdentifiers, qualifyNames));
        stmtBuf.append(" ").append("AS").append(" ").append(BEGIN).append(" ");
        stmtBuf.append(RETURN).append(SEMICOLON).append(" ").append(END);
        return stmtBuf.toString();
    }

    public String dropProcedures(Procedure trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP PROCEDURE " + this.getName((Routine)trigger, quoteIdentifiers, qualifyNames);
    }

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        if (trigger instanceof IngresTrigger) {
            return ((IngresTrigger)trigger).getSource().getBody();
        }
        return super.createTrigger(trigger, quoteIdentifiers, qualifyNames);
    }

    public String dropTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP RULE " + this.getName(trigger, quoteIdentifiers, qualifyNames);
    }

    public String createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        if (view instanceof IngresCatalogView) {
            return ((IngresCatalogView)view).getSource().getBody();
        }
        return super.createView(view, quoteIdentifiers, qualifyNames);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getIndexKeyColumns(Index index, boolean quoteIdentifiers) {
        StringBuffer columns = new StringBuffer();
        Iterator it = index.getIncludedMembers().iterator();
        if (!it.hasNext()) {
            return null;
        }
        IndexMember m = (IndexMember)it.next();
        String columnName = m.getColumn().getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        columns.append(columnName);
        columns.append(" ");
        columns.append(m.getIncrementType().getName());
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            columns.append(",");
            columns.append(" ");
            columns.append(columnName);
            columns.append(" ");
            columns.append(m.getIncrementType().getName());
        }
        return columns.toString();
    }

    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String result = null;
        if (!index.getName().startsWith("$")) {
            result = super.createIndex(index, quoteIdentifiers, qualifyNames);
        }
        return result;
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String result = null;
        if (!index.getName().startsWith("$")) {
            result = super.dropIndex(index, quoteIdentifiers, qualifyNames);
        }
        return result;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint, quoteIdentifiers);
        } else if (index != null) {
            parentTable = index.getTable();
            parentKey = this.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            return null;
        }
        String statement = "ALTER TABLE " + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + " " + "ADD" + " " + this.getConstraintName((TableConstraint)foreignKey, quoteIdentifiers) + " " + "FOREIGN KEY" + " " + "(" + this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers) + ")" + NEWLINE;
        statement = String.valueOf(statement) + "\tREFERENCES " + this.getName((Table)parentTable, quoteIdentifiers, qualifyNames) + " " + "(" + parentKey + ")";
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "ON" + " " + "DELETE" + " ";
        }
        statement = String.valueOf(statement) + this.getReferentialAction(action);
        action = foreignKey.getOnUpdate();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "ON" + " " + "UPDATE" + " ";
        }
        statement = String.valueOf(statement) + this.getReferentialAction(action);
        if (foreignKey.isDeferrable()) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + this.getDeferrableClause((Constraint)foreignKey);
        }
        return statement;
    }

    public String dropTableConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        if (constraint.getName().startsWith("$")) {
            return null;
        }
        return super.dropTableConstraint(constraint, quoteIdentifiers, qualifyNames);
    }

    public String createSequence(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmtBuf = new StringBuffer();
        stmtBuf.append("CREATE").append(" ").append(SEQUENCE).append(" ");
        stmtBuf.append(this.getName(sequence, quoteIdentifiers)).append(" ");
        if (sequence.getIdentity() instanceof IngresIdentitySpecifier) {
            IngresIdentitySpecifier options = (IngresIdentitySpecifier)sequence.getIdentity();
            stmtBuf.append("AS").append(" ").append(options.getDataType()).append(" ");
            if ("decimal".equalsIgnoreCase(options.getDataType())) {
                stmtBuf.append("(");
                stmtBuf.append(options.getSeqPrecision());
                stmtBuf.append(",");
                stmtBuf.append("0");
                stmtBuf.append(")");
                stmtBuf.append(" ");
            }
            stmtBuf.append(START).append(" ").append("WITH").append(" ");
            stmtBuf.append(options.getStartValue()).append(" ");
            stmtBuf.append(INCREMENT).append(" ").append(BY).append(" ");
            stmtBuf.append(options.getIncrement()).append(" ");
            if (options.getMaximumOption() != null && options.getMaximumOption().booleanValue()) {
                stmtBuf.append(MAXVALUE).append(" ");
                stmtBuf.append(options.getMaximum()).append(" ");
            } else {
                stmtBuf.append("NO").append(" ").append(MAXVALUE).append(" ");
            }
            if (options.getMinimumOption() != null && options.getMinimumOption().booleanValue()) {
                stmtBuf.append(MINVALUE).append(" ");
                stmtBuf.append(options.getMinimum()).append(" ");
            } else {
                stmtBuf.append("NO").append(" ").append(MINVALUE).append(" ");
            }
            if (options.getCacheOption() != null && options.getCacheOption().booleanValue()) {
                stmtBuf.append(CACHE).append(" ");
                stmtBuf.append(options.getCacheSize()).append(" ");
            } else {
                stmtBuf.append("NO").append(" ").append(CACHE).append(" ");
            }
            if (options.isCycleOption()) {
                stmtBuf.append(CYCLE).append(" ");
            } else {
                stmtBuf.append("NO").append(" ").append(CYCLE).append(" ");
            }
            if (options.getOrderOption() != null && options.getOrderOption().booleanValue()) {
                stmtBuf.append(ORDER).append(" ");
            } else {
                stmtBuf.append("NO").append(" ").append(ORDER).append(" ");
            }
        }
        return stmtBuf.toString();
    }

    public String dropSequence(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmtBuf = new StringBuffer();
        stmtBuf.append("DROP").append(" ").append(SEQUENCE).append(" ").append(this.getName(sequence, quoteIdentifiers));
        return stmtBuf.toString();
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getConstraintName((TableConstraint)constraint, quoteIdentifiers);
        String text = "ADD " + constraintName + " " + this.getUniqueConstraintType(constraint) + " " + "(" + this.getKeyColumns((ReferenceConstraint)constraint, quoteIdentifiers) + ")";
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + " " + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    protected String getUniqueConstraintType(UniqueConstraint constraint) {
        if (constraint instanceof JDBCPrimaryKey) {
            return "PRIMARY KEY";
        }
        return "UNIQUE";
    }

    protected String getCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getConstraintName((TableConstraint)constraint, quoteIdentifiers);
        String text = String.valueOf(constraintName) + " ";
        text = constraint instanceof IngresCatalogCheckConstraint ? String.valueOf(text) + constraint.getSearchCondition().getSQL() + " " : String.valueOf(text) + "CHECK (" + constraint.getSearchCondition().getSQL() + ")" + " ";
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    public String createSynonym(IngresSynonym synonym, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmtBuf = new StringBuffer();
        stmtBuf.append("CREATE").append(" ").append(SYNONYM).append(" ");
        stmtBuf.append(this.getName(synonym, quoteIdentifiers));
        stmtBuf.append(" ").append("FOR").append(" ");
        stmtBuf.append(this.getSynonymTableName(synonym, quoteIdentifiers, qualifyNames));
        return stmtBuf.toString();
    }

    public String dropSynonym(IngresSynonym synonym, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmtBuf = new StringBuffer();
        stmtBuf.append("DROP").append(" ").append(SYNONYM).append(" ");
        stmtBuf.append(this.getName(synonym, quoteIdentifiers));
        return stmtBuf.toString();
    }

    public String createDBEvent(IngresDBEvent event, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmtBuf = new StringBuffer();
        stmtBuf.append("CREATE").append(" ").append(DB_EVENT).append(" ");
        stmtBuf.append(this.getName(event, quoteIdentifiers));
        return stmtBuf.toString();
    }

    public String dropDBEvent(IngresDBEvent event, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmtBuf = new StringBuffer();
        stmtBuf.append("DROP").append(" ").append(DB_EVENT).append(" ");
        stmtBuf.append(this.getName(event, quoteIdentifiers));
        return stmtBuf.toString();
    }

    protected String getSynonymTableName(IngresSynonym synonym, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = synonym.getTableName();
        String schemaName = synonym.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getQuotedIdentifierString((SQLObject)synonym.getSchema());
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        return tableName;
    }

    protected String getName(IngresSynonym synonym, boolean quoteIdentifiers) {
        String name = synonym.getName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString(synonym);
        }
        return name;
    }

    protected String getName(IngresDBEvent event, boolean quoteIdentifiers) {
        String name = event.getName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString(event);
        }
        return name;
    }

    protected String getName(Sequence sequence, boolean quoteIdentifiers) {
        String name = sequence.getName();
        if (quoteIdentifiers) {
            name = this.getQuotedIdentifierString((SQLObject)sequence);
        }
        return name;
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers) {
        String name = constraint.getName();
        if (name.startsWith("$")) {
            name = "";
        } else if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getConstraintName(TableConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName(constraint, quoteIdentifiers);
        if (constraintName != null && constraintName.trim().length() > 0) {
            constraintName = "CONSTRAINT " + constraintName;
        }
        return constraintName;
    }
}

