/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.parameter.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.core.dbitem.IEvent;
import org.eclipse.datatools.sqltools.routineeditor.parameter.EventParameter;
import org.eclipse.datatools.sqltools.routineeditor.parameter.internal.EventParameterAddDialog;
import org.eclipse.datatools.sqltools.routineeditor.parameter.internal.EventParameterCellModifier;
import org.eclipse.datatools.sqltools.routineeditor.parameter.internal.Messages;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class EventParameterTableDialog
extends Dialog {
    private Table _table;
    private TableViewer _tableViewer;
    private Button _addButton;
    private Button _removeButton;
    private EventParameter[] _parameters;
    private List _paramList;
    private Map _paramMap;
    private IEvent _eventItem;
    public static final String NAME_COLUMN = "name";
    public static final String VALUE_COLUMN = "value";
    private String[] _columnNames = new String[]{"name", "value"};

    public EventParameterTableDialog(Shell parentShell, EventParameter[] parameters, IEvent eventItem) {
        super(parentShell);
        this._parameters = parameters;
        this._paramList = new ArrayList();
        this._paramMap = new HashMap();
        this._eventItem = eventItem;
        int i = 0;
        while (i < parameters.length) {
            if (!this._paramMap.containsKey(parameters[i].getName())) {
                this._paramList.add(parameters[i]);
            }
            this._paramMap.put(parameters[i].getName(), null);
            ++i;
        }
        this._parameters = new EventParameter[this._paramList.size()];
        this._paramList.toArray(this._parameters);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("EventParameterTableDialog.title"));
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), HelpUtil.getContextId((String)"event_launch_configuration_parameters", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.createTable(composite);
        this.createTableViewer();
        this._tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                EventParameter wrapper = (EventParameter)element;
                if (columnIndex == 0) {
                    return wrapper.getName();
                }
                return wrapper.getValue();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this._tableViewer.setInput((Object)this._parameters);
        Composite compositeForButton = new Composite(composite, 0);
        GridData gridDataForButton = new GridData(1168);
        compositeForButton.setLayoutData((Object)gridDataForButton);
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = 1;
        compositeForButton.setLayout((Layout)gridlayout);
        this._addButton = new Button(compositeForButton, 0);
        this._addButton.setText(Messages.getString("EventParameterTableDialog.button.add"));
        this.setButtonLayoutData(this._addButton);
        this._addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventParameterAddDialog dlg = new EventParameterAddDialog(EventParameterTableDialog.this.getShell(), EventParameterTableDialog.this._eventItem);
                if (dlg.open() == 0 && dlg.getEventParameter() != null && !EventParameterTableDialog.this._paramMap.containsKey(dlg.getEventParameter().getName())) {
                    EventParameterTableDialog.this._paramList.add(dlg.getEventParameter());
                    EventParameterTableDialog.this._parameters = new EventParameter[EventParameterTableDialog.this._paramList.size()];
                    EventParameterTableDialog.this._paramList.toArray(EventParameterTableDialog.this._parameters);
                    EventParameterTableDialog.this._tableViewer.setInput((Object)EventParameterTableDialog.this._parameters);
                    EventParameterTableDialog.this._tableViewer.refresh();
                }
            }
        });
        this._removeButton = new Button(compositeForButton, 0);
        this._removeButton.setText(Messages.getString("EventParameterTableDialog.button.remove"));
        this.setButtonLayoutData(this._removeButton);
        this._removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)EventParameterTableDialog.this._tableViewer.getSelection();
                EventParameterTableDialog.this._paramList.remove(sel.getFirstElement());
                EventParameterTableDialog.this._parameters = new EventParameter[EventParameterTableDialog.this._paramList.size()];
                EventParameterTableDialog.this._paramList.toArray(EventParameterTableDialog.this._parameters);
                EventParameterTableDialog.this._tableViewer.setInput((Object)EventParameterTableDialog.this._parameters);
                EventParameterTableDialog.this._tableViewer.refresh();
            }
        });
        return composite;
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this._table = new Table(parent, style);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 200;
        this._table.setLayoutData((Object)gd);
        TableLayout tablelayout = new TableLayout();
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 100));
        tablelayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 100));
        this._table.setLayout((Layout)tablelayout);
        this._table.setLinesVisible(true);
        this._table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this._table, 16384, 0);
        column.setText(Messages.getString("EventParameterTableDialog.column.name"));
        column = new TableColumn(this._table, 16384, 1);
        column.setText(Messages.getString("EventParameterTableDialog.column.value"));
    }

    private void createTableViewer() {
        this._tableViewer = new TableViewer(this._table);
        this._tableViewer.setUseHashlookup(true);
        this._tableViewer.setColumnProperties(this._columnNames);
        CellEditor[] editors = new CellEditor[this._columnNames.length];
        editors[0] = null;
        editors[1] = new TextCellEditor((Composite)this._table);
        this._tableViewer.setCellEditors(editors);
        this._tableViewer.setCellModifier((ICellModifier)new EventParameterCellModifier(this._tableViewer));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    public EventParameter[] getEventParameter() {
        return this._parameters;
    }
}

