/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.project.DartFilePage;
import org.eclipse.dartboard.util.StatusUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DartFileWizard
extends Wizard
implements INewWizard {
    private static final ILog LOG = Platform.getLog(DartFileWizard.class);
    private DartFilePage dartFilePage;
    private IStructuredSelection selection;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(Messages.NewFile_WindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.dartFilePage = new DartFilePage(DartFilePage.class.getSimpleName(), this.selection);
        this.dartFilePage.setTitle(Messages.NewFile_Title);
        this.dartFilePage.setDescription(Messages.NewFile_Description);
        this.dartFilePage.setFileExtension("dart");
        this.addPage((IWizardPage)this.dartFilePage);
    }

    public boolean performFinish() {
        String containerName = this.dartFilePage.getContainerFullPath().toOSString();
        String fileName = this.dartFilePage.getFileName();
        IRunnableWithProgress op = monitor -> {
            try {
                try {
                    this.doFinish(containerName, fileName, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            StatusUtil.applyToStatusLine((DialogPage)this.dartFilePage, StatusUtil.createError(e.getTargetException()));
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)Messages.NewFile_Creating, (Object)fileName), 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            StatusUtil.throwCoreException(NLS.bind((String)Messages.NewFile_Container_Doesnot_Exist, (Object)containerName));
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream("".getBytes());){
                if (file.exists()) {
                    file.setContents((InputStream)stream, true, true, monitor);
                } else {
                    file.create((InputStream)stream, true, monitor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.log(StatusUtil.createError(e.getMessage()));
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.NewFile_OpeningFile);
        this.getShell().getDisplay().asyncExec(() -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                LOG.log(StatusUtil.createError(e.getMessage()));
            }
        });
        monitor.worked(1);
    }
}

