/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import org.eclipse.comma.monitoring.lib.CError;
import org.eclipse.comma.monitoring.lib.CState;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.utils.StringBuilder2;

public class CInterfaceRuntimeError
extends CError {
    private CState interfaceState;

    public CInterfaceRuntimeError(CObservedMessage triggerMessage, String errorMessage, CState interfaceState) {
        this.errorDescription = errorMessage;
        this.interfaceState = interfaceState;
    }

    @Override
    public String toString() {
        StringBuilder2 builder = new StringBuilder2();
        builder.append("Interface runtime error");
        builder.newLine();
        builder.append(this.errorDescription);
        builder.newLine();
        if (this.interfaceState != null) {
            builder.newLine();
            builder.append("Active state: " + this.interfaceState.getActiveState());
            builder.newLine();
            builder.append(this.interfaceState.toString());
            builder.newLine();
        }
        builder.newLine();
        builder.append(this.traceContextToText());
        return builder.toString();
    }

    @Override
    public String toUML() {
        StringBuilder2 builder = new StringBuilder2();
        builder.append("@startuml");
        builder.newLine();
        builder.append("title Interface runtime error: " + this.errorDescription);
        builder.newLine();
        builder.append(this.traceContextToUML());
        if (this.interfaceState != null) {
            builder.append("note right");
            builder.newLine();
            builder.append("Active state: " + this.interfaceState.getActiveState());
            builder.newLine();
            builder.append(String.valueOf(this.interfaceState.toString()) + "end note");
            builder.newLine();
        }
        builder.append("@enduml");
        builder.newLine();
        return builder.toString();
    }
}

