/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.comma.monitoring.lib.CConnectionResults;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintMonitorResult;
import org.eclipse.comma.monitoring.lib.CMonitorResults;
import org.eclipse.comma.monitoring.lib.CPortConnectionMonitoringContext;
import org.eclipse.comma.monitoring.lib.constraints.CRuleError;

public class CComponentResults
extends CMonitorResults {
    @Expose
    private String componentInstanceName;
    @Expose
    @SerializedName(value="warnings")
    private List<CRuleError> constraintErrors = new ArrayList<CRuleError>();
    @Expose
    private List<CFunctionalConstraintMonitorResult> functionalConstraintResults = new ArrayList<CFunctionalConstraintMonitorResult>();
    @Expose
    private Map<String, List<CConnectionResults>> portResults = new HashMap<String, List<CConnectionResults>>();

    public CComponentResults(String componentInstanceName) {
        this.componentInstanceName = componentInstanceName;
    }

    public void addConnectionResult(CConnectionResults connectionResult) {
        this.coverageInfo.addAll(connectionResult.getCoverageInfo());
        String port = ((CPortConnectionMonitoringContext)connectionResult.getContext()).getPort();
        if (this.portResults.containsKey(port)) {
            this.portResults.get(port).add(connectionResult);
        } else {
            ArrayList<CConnectionResults> conResults = new ArrayList<CConnectionResults>();
            conResults.add(connectionResult);
            this.portResults.put(port, conResults);
        }
    }

    public void addConstraintErrors(List<CRuleError> constraintErrors) {
        this.constraintErrors.addAll(constraintErrors);
    }

    public void addFunctionalConstraintResults(List<CFunctionalConstraintMonitorResult> functionalConstraintResults) {
        this.functionalConstraintResults.addAll(functionalConstraintResults);
    }

    @Override
    public boolean hasIssues() {
        return !this.constraintErrors.isEmpty() || !this.functionalConstraintResults.isEmpty();
    }
}

