/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.refactoring;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.ui.internal.refactoring.RefactoringMessages;
import org.eclipse.pde.api.tools.ui.internal.refactoring.TypeFilterChange;

public class RefactoringUtils {
    static Change createDeleteFilterChanges(IType type) {
        block5: {
            IApiFilterStore store;
            IResource resource;
            block6: {
                resource = type.getUnderlyingResource();
                if (resource == null) break block5;
                store = RefactoringUtils.resolveFilterStore(resource.getProject());
                if (store != null) break block6;
                return null;
            }
            try {
                IApiProblemFilter[] filters = store.getFilters(resource);
                if (filters.length != 0) {
                    CompositeChange cchange = new CompositeChange(RefactoringMessages.RefactoringUtils_remove_usused_filters);
                    IApiProblemFilter[] iApiProblemFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IApiProblemFilter filter = iApiProblemFilterArray[n2];
                        cchange.add((Change)new TypeFilterChange(store, filter, null, null, 1));
                        ++n2;
                    }
                    return cchange;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    static Change createDeleteFilterChanges(IPackageFragment fragment) {
        block5: {
            IApiFilterStore store;
            block6: {
                IResource resource = fragment.getUnderlyingResource();
                if (resource == null) break block5;
                store = RefactoringUtils.resolveFilterStore(resource.getProject());
                if (store != null) break block6;
                return null;
            }
            try {
                IApiProblemFilter[] filters = RefactoringUtils.collectAllAffectedFilters(store, RefactoringUtils.collectAffectedTypes(fragment));
                if (filters.length != 0) {
                    CompositeChange cchange = new CompositeChange(RefactoringMessages.RefactoringUtils_remove_usused_filters);
                    IApiProblemFilter[] iApiProblemFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IApiProblemFilter filter = iApiProblemFilterArray[n2];
                        cchange.add((Change)new TypeFilterChange(store, filter, null, null, 1));
                        ++n2;
                    }
                    return cchange;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    static IApiProblemFilter[] collectAllAffectedFilters(IApiFilterStore store, IType[] types) {
        HashSet filters = new HashSet();
        IApiProblemFilter[] fs = null;
        IResource resource = null;
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                resource = type.getUnderlyingResource();
                if (resource != null) {
                    fs = store.getFilters(resource);
                    Collections.addAll(filters, fs);
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n2;
        }
        return filters.toArray(new IApiProblemFilter[filters.size()]);
    }

    static IType[] collectAffectedTypes(IPackageFragment fragment) {
        HashSet<IType> types = new HashSet<IType>();
        try {
            if (fragment.containsJavaResources()) {
                ICompilationUnit[] cunits = fragment.getCompilationUnits();
                IType type = null;
                ICompilationUnit[] iCompilationUnitArray = cunits;
                int n = cunits.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit cunit = iCompilationUnitArray[n2];
                    type = cunit.findPrimaryType();
                    if (type != null) {
                        types.add(type);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return types.toArray(new IType[types.size()]);
    }

    static Change createRenameFilterChanges(IType type, String newname) {
        return RefactoringUtils.createDeleteFilterChanges(type);
    }

    static Change createRenameFilterChanges(IPackageFragment fragment, String newname) {
        return RefactoringUtils.createDeleteFilterChanges(fragment);
    }

    static IApiFilterStore resolveFilterStore(IProject project) throws CoreException {
        IApiComponent component = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline().getApiComponent(project);
        if (component != null) {
            return component.getFilterStore();
        }
        return null;
    }

    static String getNewQualifiedName(IType type, String newname) {
        IType dtype = type.getDeclaringType();
        String newqname = newname;
        if (dtype == null) {
            IPackageFragment packageFragment = type.getPackageFragment();
            if (!packageFragment.isDefaultPackage()) {
                newqname = String.valueOf(packageFragment.getElementName()) + '.' + newname;
            }
        } else {
            newqname = String.valueOf(dtype.getFullyQualifiedName()) + '$' + newname;
        }
        return newqname;
    }

    static String getNewQualifiedName(String newname, String oldtypename) {
        return oldtypename;
    }

    static String getNewResourcePath(IPath oldpath, String typename) {
        if (typename.indexOf(36) < 0) {
            String ext = oldpath.getFileExtension();
            IPath newpath = oldpath.removeLastSegments(1).append(typename);
            if (ext != null) {
                return newpath.addFileExtension(ext).toString();
            }
            return newpath.toString();
        }
        return oldpath.toString();
    }
}

