/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.validation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.behavior.utilities.TransitionComparator;
import org.eclipse.comma.behavior.validation.TimeConstraintsValidator;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class StateMachineValidator
extends TimeConstraintsValidator {
    public static final String STATEMACHINE_MISSING_INITIAL_STATE = "statemachine_missing_initial_state";
    public static final String STATEMACHINE_DUPLICATE_INITIAL_STATE = "statemachine_duplicate_initial_state";

    @Check
    public void checkInitialState(StateMachine m) {
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        int sizeInitialStates = IterableExtensions.size((Iterable)IterableExtensions.filter(m.getStates(), (Functions.Function1)_function));
        if (sizeInitialStates == 0) {
            this.error("The state machine does not have an initial state.", (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, STATEMACHINE_MISSING_INITIAL_STATE, new String[0]);
        } else if (sizeInitialStates > 1) {
            this.error("The state machine has more than one initial state.", (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, STATEMACHINE_DUPLICATE_INITIAL_STATE, new String[0]);
        }
    }

    @Check
    public void checkUnreachableStates(StateMachine m) {
        boolean _notEquals;
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        Iterable initialStates = IterableExtensions.filter(m.getStates(), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)initialStates);
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            return;
        }
        State initialState = ((State[])Conversions.unwrapArray((Object)initialStates, State.class))[0];
        LinkedHashSet<State> reachable = new LinkedHashSet<State>(5);
        reachable.add(initialState);
        this.closure(reachable, initialState);
        EList<State> _states = m.getStates();
        for (State s : _states) {
            boolean _not;
            boolean _contains = reachable.contains(s);
            boolean bl2 = _not = !_contains;
            if (!_not) continue;
            this.error("Unreachable state", (EObject)s, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
    }

    public void closure(final Set<State> states, State start) {
        List<Transition> transitions = StateMachineUtilities.transitionsForState(start);
        Functions.Function1<Transition, EList<Clause>> _function = new Functions.Function1<Transition, EList<Clause>>(){

            public EList<Clause> apply(Transition it) {
                return it.getClauses();
            }
        };
        Functions.Function1<Clause, State> _function_1 = new Functions.Function1<Clause, State>(){

            public State apply(Clause it) {
                return it.getTarget();
            }
        };
        Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return it != null;
            }
        };
        Consumer<State> _function_3 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _add = states.add(it);
                if (_add) {
                    StateMachineValidator.this.closure(states, it);
                }
            }
        };
        IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map(transitions, (Functions.Function1)_function)), (Functions.Function1)_function_1), (Functions.Function1)_function_2).forEach(_function_3);
    }

    @Check
    public void checkOverlappingTransitions(StateMachine sm) {
        Consumer<State> _function = new Consumer<State>(){

            @Override
            public void accept(State it) {
                StateMachineValidator.this.checkOverlappingTransitionsInState(it);
            }
        };
        sm.getStates().forEach((Consumer)_function);
    }

    public void checkOverlappingTransitionsInState(State s) {
        TransitionComparator comparator = new TransitionComparator();
        List<Transition> allTransitions = StateMachineUtilities.transitionsForState(s);
        ArrayList<Transition> visitedTransitions = new ArrayList<Transition>();
        HashSet<Transition> duplicatesInState = new HashSet<Transition>();
        HashSet<Transition> duplicatesOfInAllStates = new HashSet<Transition>();
        boolean duplicatesFromDifferentAllStates = false;
        for (Transition t1 : allTransitions) {
            for (Transition t2 : visitedTransitions) {
                boolean _tripleEquals_2;
                boolean _tripleEquals;
                boolean _not;
                Set<Clause> clIntersection = comparator.clauseIntersection(t1, t2);
                boolean _isEmpty = clIntersection.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (!_not) continue;
                int intersectionSize = clIntersection.size();
                boolean identicalTransitions = intersectionSize == t1.getClauses().size() && intersectionSize == t2.getClauses().size();
                EObject _eContainer = t1.eContainer();
                EObject _eContainer_1 = t2.eContainer();
                boolean bl2 = _tripleEquals = _eContainer == _eContainer_1;
                if (_tripleEquals) {
                    boolean _tripleEquals_1;
                    EObject _eContainer_2 = t1.eContainer();
                    boolean bl3 = _tripleEquals_1 = _eContainer_2 == s;
                    if (!_tripleEquals_1) continue;
                    if (identicalTransitions) {
                        duplicatesInState.add(t1);
                        continue;
                    }
                    for (Clause cl : clIntersection) {
                        this.warning("Clause duplicates another clause in a different transition in the same state", t1, (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__CLAUSES, t1.getClauses().indexOf((Object)cl));
                    }
                    continue;
                }
                EObject _eContainer_3 = t1.eContainer();
                boolean bl4 = _tripleEquals_2 = _eContainer_3 == s;
                if (_tripleEquals_2) {
                    if (identicalTransitions) {
                        duplicatesOfInAllStates.add(t1);
                        continue;
                    }
                    for (Clause cl_1 : clIntersection) {
                        this.warning("Clause duplicates another clause in a transition from in_all_states block", t1, (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__CLAUSES, t1.getClauses().indexOf((Object)cl_1));
                    }
                    continue;
                }
                duplicatesFromDifferentAllStates = true;
            }
            visitedTransitions.add(t1);
        }
        if (duplicatesFromDifferentAllStates) {
            this.warning("Duplicate clauses in transitions from two different in_all_states blocks", (EObject)s, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
        }
        for (Transition t : duplicatesInState) {
            this.warning("Duplicate of a local transition", (EObject)s, (EStructuralFeature)BehaviorPackage.Literals.STATE__TRANSITIONS, s.getTransitions().indexOf((Object)t));
        }
        for (Transition t_1 : duplicatesOfInAllStates) {
            this.warning("Duplicate of a transition from in_all_states block", (EObject)s, (EStructuralFeature)BehaviorPackage.Literals.STATE__TRANSITIONS, s.getTransitions().indexOf((Object)t_1));
        }
    }

    @Check
    public void checkDuplicateTransitionsInAllStatesBlock(InAllStatesBlock block) {
        TransitionComparator comparator = new TransitionComparator();
        int nrTransitions = block.getTransitions().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, nrTransitions, true);
        for (Integer i : _doubleDotLessThan) {
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(i + 1, nrTransitions, true);
            for (Integer j : _doubleDotLessThan_1) {
                boolean identicalTransitions;
                boolean _not;
                Set<Clause> clIntersection = comparator.clauseIntersection((Transition)block.getTransitions().get(i.intValue()), (Transition)block.getTransitions().get(j.intValue()));
                boolean _isEmpty = clIntersection.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (!_not) continue;
                int intersectionSize = clIntersection.size();
                boolean bl2 = identicalTransitions = intersectionSize == ((Transition)block.getTransitions().get(i.intValue())).getClauses().size() && intersectionSize == ((Transition)block.getTransitions().get(j.intValue())).getClauses().size();
                if (identicalTransitions) {
                    this.warning("Duplicate transition", block, (EStructuralFeature)BehaviorPackage.Literals.IN_ALL_STATES_BLOCK__TRANSITIONS, i);
                    continue;
                }
                for (Clause cl : clIntersection) {
                    this.warning("Clause duplicates another clause in a different transition in the same block", (EObject)block.getTransitions().get(i.intValue()), (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__CLAUSES, ((Transition)block.getTransitions().get(i.intValue())).getClauses().indexOf((Object)cl));
                }
            }
        }
    }
}

