/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.QUANTIFIER;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.VectorTypeDecl;

class SnakesHelper {
    SnakesHelper() {
    }

    static String defaultValue(TypeDecl type) {
        if (type instanceof SimpleTypeDecl) {
            SimpleTypeDecl t = (SimpleTypeDecl)type;
            if (t.getBase() != null) {
                return SnakesHelper.defaultValue((TypeDecl)t.getBase());
            }
            if (t.getName().equals("int")) {
                return "0";
            }
            if (t.getName().equals("real")) {
                return "0.0";
            }
            if (t.getName().equals("bool")) {
                return "True";
            }
            if (t.getName().equals("string")) {
                return "\"\"";
            }
            return "\"\"";
        }
        if (type instanceof VectorTypeDecl) {
            return "[]";
        }
        if (type instanceof EnumTypeDecl) {
            EnumTypeDecl t = (EnumTypeDecl)type;
            return String.format("\"%s:%s\"", t.getName(), ((EnumElement)t.getLiterals().get(0)).getName());
        }
        if (type instanceof MapTypeDecl) {
            return "{}";
        }
        if (type instanceof RecordTypeDecl) {
            String value = ((RecordTypeDecl)type).getFields().stream().map(f -> String.format("\"%s\":%s", f.getName(), SnakesHelper.defaultValue(f.getType().getType()))).collect(Collectors.joining(","));
            return String.format("{%s}", value);
        }
        throw new RuntimeException("Not supported");
    }

    static String expression(Expression expression, Function<String, String> variablePrefix) {
        if (expression instanceof ExpressionConstantInt) {
            return Long.toString(((ExpressionConstantInt)expression).getValue());
        }
        if (expression instanceof ExpressionConstantString) {
            return String.format("\"%s\"", ((ExpressionConstantString)expression).getValue());
        }
        if (expression instanceof ExpressionNot) {
            return String.format("not (%s)", SnakesHelper.expression(((ExpressionNot)expression).getSub(), variablePrefix));
        }
        if (expression instanceof ExpressionConstantReal) {
            return Double.toString(((ExpressionConstantReal)expression).getValue());
        }
        if (expression instanceof ExpressionConstantBool) {
            return ((ExpressionConstantBool)expression).isValue() ? "True" : "False";
        }
        if (expression instanceof ExpressionAny) {
            return "\"*\"";
        }
        if (expression instanceof ExpressionAddition) {
            ExpressionAddition e = (ExpressionAddition)expression;
            return String.format("%s + %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionSubtraction) {
            ExpressionSubtraction e = (ExpressionSubtraction)expression;
            return String.format("%s - %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionMultiply) {
            ExpressionMultiply e = (ExpressionMultiply)expression;
            return String.format("%s * %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionDivision) {
            ExpressionDivision e = (ExpressionDivision)expression;
            return String.format("%s / %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionModulo) {
            ExpressionModulo e = (ExpressionModulo)expression;
            return String.format("%s % %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionMinimum) {
            ExpressionMinimum e = (ExpressionMinimum)expression;
            return String.format("min(%s, %s)", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionMaximum) {
            ExpressionMaximum e = (ExpressionMaximum)expression;
            return String.format("max(%s, %s)", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionPower) {
            ExpressionPower e = (ExpressionPower)expression;
            return String.format("pow(%s, %s)", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionVariable) {
            ExpressionVariable v = (ExpressionVariable)expression;
            return String.format("%s%s", variablePrefix.apply(v.getVariable().getName()), v.getVariable().getName());
        }
        if (expression instanceof ExpressionGreater) {
            ExpressionGreater e = (ExpressionGreater)expression;
            return String.format("%s > %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionLess) {
            ExpressionLess e = (ExpressionLess)expression;
            return String.format("%s < %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionLeq) {
            ExpressionLeq e = (ExpressionLeq)expression;
            return String.format("%s <= %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionGeq) {
            ExpressionGeq e = (ExpressionGeq)expression;
            return String.format("%s >= %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionEqual) {
            ExpressionEqual e = (ExpressionEqual)expression;
            return String.format("%s == %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionNEqual) {
            ExpressionNEqual e = (ExpressionNEqual)expression;
            return String.format("%s != %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionAnd) {
            ExpressionAnd e = (ExpressionAnd)expression;
            return String.format("%s and %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionOr) {
            ExpressionOr e = (ExpressionOr)expression;
            return String.format("%s or %s", SnakesHelper.expression(e.getLeft(), variablePrefix), SnakesHelper.expression(e.getRight(), variablePrefix));
        }
        if (expression instanceof ExpressionEnumLiteral) {
            ExpressionEnumLiteral e = (ExpressionEnumLiteral)expression;
            return String.format("\"%s:%s\"", e.getType().getName(), e.getLiteral().getName());
        }
        if (expression instanceof ExpressionVector) {
            ExpressionVector e = (ExpressionVector)expression;
            return String.format("[%s]", e.getElements().stream().map(ee -> SnakesHelper.expression(ee, variablePrefix)).collect(Collectors.joining(", ")));
        }
        if (expression instanceof ExpressionMinus) {
            ExpressionMinus e = (ExpressionMinus)expression;
            return String.format("%s * -1", SnakesHelper.expression(e.getSub(), variablePrefix));
        }
        if (expression instanceof ExpressionPlus) {
            ExpressionPlus e = (ExpressionPlus)expression;
            return SnakesHelper.expression(e.getSub(), variablePrefix);
        }
        if (expression instanceof ExpressionBracket) {
            ExpressionBracket e = (ExpressionBracket)expression;
            return SnakesHelper.expression(e.getSub(), variablePrefix);
        }
        if (expression instanceof ExpressionFunctionCall) {
            ExpressionFunctionCall e = (ExpressionFunctionCall)expression;
            if (e.getFunctionName().equals("add")) {
                return String.format("%s + [%s]", SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix), SnakesHelper.expression((Expression)e.getArgs().get(1), variablePrefix));
            }
            if (e.getFunctionName().equals("size")) {
                return String.format("len(%s)", SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix));
            }
            if (e.getFunctionName().equals("isEmpty")) {
                return String.format("len(%s) == 0", SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix));
            }
            if (e.getFunctionName().equals("contains")) {
                return String.format("%s in %s", SnakesHelper.expression((Expression)e.getArgs().get(1), variablePrefix), SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix));
            }
            if (e.getFunctionName().equals("abs")) {
                return String.format("abs(%s)", SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix));
            }
            if (e.getFunctionName().equals("asReal")) {
                return String.format("float(%s)", SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix));
            }
            if (e.getFunctionName().equals("hasKey")) {
                String map = SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix);
                String key = SnakesHelper.expression((Expression)e.getArgs().get(1), variablePrefix);
                return String.format("(%s in %s)", key, map);
            }
            if (e.getFunctionName().equals("deleteKey")) {
                String map = SnakesHelper.expression((Expression)e.getArgs().get(0), variablePrefix);
                String key = SnakesHelper.expression((Expression)e.getArgs().get(1), variablePrefix);
                return String.format("{_k: _v for _k, _v in %s.items() if _k != %s}", map, key);
            }
        } else if (expression instanceof ExpressionQuantifier) {
            ExpressionQuantifier e = (ExpressionQuantifier)expression;
            String collection = SnakesHelper.expression(e.getCollection(), variablePrefix);
            String it = e.getIterator().getName();
            String condition = SnakesHelper.expression(e.getCondition(), variable -> "");
            if (e.getQuantifier() == QUANTIFIER.EXISTS) {
                return String.format("len([%s for %s in %s if %s]) != 0", it, it, collection, condition);
            }
            if (e.getQuantifier() == QUANTIFIER.DELETE) {
                return String.format("[%s for %s in %s if not (%s)]", it, it, collection, condition);
            }
            if (e.getQuantifier() == QUANTIFIER.FORALL) {
                return String.format("len([%s for %s in %s if %s]) == len(%s)", it, it, collection, condition, collection);
            }
        } else {
            if (expression instanceof ExpressionMap) {
                ExpressionMap e = (ExpressionMap)expression;
                return String.format("{%s}", e.getPairs().stream().map(p -> {
                    String key = SnakesHelper.expression(p.getKey(), variablePrefix);
                    String value = SnakesHelper.expression(p.getValue(), variablePrefix);
                    return String.format("%s: %s", key, value);
                }).collect(Collectors.joining(", ")));
            }
            if (expression instanceof ExpressionMapRW) {
                ExpressionMapRW e = (ExpressionMapRW)expression;
                String map = SnakesHelper.expression(e.getMap(), variablePrefix);
                String key = SnakesHelper.expression(e.getKey(), variablePrefix);
                if (e.getValue() == null) {
                    return String.format("%s[%s]", map, key);
                }
                String value = SnakesHelper.expression(e.getValue(), variablePrefix);
                return String.format("{**%s, **{%s: %s}}", map, key, value);
            }
            if (expression instanceof ExpressionRecord) {
                ExpressionRecord e = (ExpressionRecord)expression;
                return String.format("{%s}", e.getFields().stream().map(p -> {
                    String key = p.getRecordField().getName();
                    String value = SnakesHelper.expression(p.getExp(), variablePrefix);
                    return String.format("\"%s\": %s", key, value);
                }).collect(Collectors.joining(", ")));
            }
            if (expression instanceof ExpressionRecordAccess) {
                ExpressionRecordAccess e = (ExpressionRecordAccess)expression;
                String map = SnakesHelper.expression(e.getRecord(), variablePrefix);
                return String.format("%s[\"%s\"]", map, e.getField().getName());
            }
        }
        throw new RuntimeException("Not supported");
    }

    static List<String> parameters(Object event, Function<String, String> variablePrefix) {
        if (event instanceof CommandReply) {
            CommandReply r = (CommandReply)event;
            return r.getParameters().stream().map(p -> SnakesHelper.expression(p, variablePrefix)).collect(Collectors.toList());
        }
        if (event instanceof EventCall) {
            EventCall e = (EventCall)event;
            return e.getParameters().stream().map(p -> SnakesHelper.expression(p, variablePrefix)).collect(Collectors.toList());
        }
        if (event instanceof TriggeredTransition) {
            TriggeredTransition t = (TriggeredTransition)event;
            return t.getTrigger().getParameters().stream().filter(p -> p.getDirection() != DIRECTION.OUT).map(p -> {
                int index = t.getTrigger().getParameters().indexOf(p);
                Variable v = (Variable)t.getParameters().get(index);
                return String.format("%s%s", variablePrefix.apply(v.getName()), v.getName());
            }).collect(Collectors.toList());
        }
        throw new RuntimeException("Not supported");
    }

    static String name(Object event, TriggeredTransition triggerTransition) {
        if (event instanceof CommandReply) {
            return String.valueOf(triggerTransition.getTrigger().getName()) + "_reply";
        }
        if (event instanceof EventCall) {
            EventCall e = (EventCall)event;
            return e.getEvent().getName();
        }
        if (event instanceof TriggeredTransition) {
            TriggeredTransition t = (TriggeredTransition)event;
            return t.getTrigger().getName();
        }
        throw new RuntimeException("Not supported");
    }

    static String action(Action action, Function<String, String> variablePrefix) {
        if (action instanceof AssignmentAction) {
            AssignmentAction a = (AssignmentAction)action;
            String variable = String.format("%s%s", variablePrefix.apply(a.getAssignment().getName()), a.getAssignment().getName());
            return String.format("%s = %s", variable, SnakesHelper.expression(a.getExp(), variablePrefix));
        }
        if (action instanceof RecordFieldAssignmentAction) {
            RecordFieldAssignmentAction a = (RecordFieldAssignmentAction)action;
            ExpressionRecordAccess access = (ExpressionRecordAccess)a.getFieldAccess();
            String record = SnakesHelper.expression(access.getRecord(), variablePrefix);
            String field = access.getField().getName();
            String value = SnakesHelper.expression(a.getExp(), variablePrefix);
            return String.format("%s[\"%s\"] = %s", record, field, value);
        }
        throw new RuntimeException("Not supported");
    }
}

