/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.modelqualitychecks.PPlace;
import org.eclipse.comma.modelqualitychecks.PTransition;
import org.eclipse.comma.modelqualitychecks.SnakesHelper;

class POutput {
    final PPlace place;
    final PTransition transition;
    private List<Action> actions = null;
    RepeatAction repeatAction = null;

    POutput(PPlace place, PTransition transition) {
        this.place = place;
        this.transition = transition;
    }

    POutput(PPlace place, PTransition transition, List<Action> actions) {
        this(place, transition);
        this.actions = actions;
    }

    String toSnakes(Function<String, String> variablePrefix) {
        String label = "";
        String exec = "";
        if (this.actions != null && !this.actions.isEmpty()) {
            exec = String.valueOf(exec) + this.actions.stream().map(a -> String.format(".e('%s')", SnakesHelper.action(a, variablePrefix).replace("\"", "\\\""))).collect(Collectors.joining());
        }
        if (this.repeatAction != null) {
            if (this.repeatAction == RepeatAction.INIT) {
                exec = String.valueOf(exec) + ".er('= 0')";
            } else if (this.repeatAction == RepeatAction.INCREASE) {
                exec = String.valueOf(exec) + ".er('+= 1')";
            } else if (this.repeatAction == RepeatAction.SET_1) {
                exec = String.valueOf(exec) + ".er('= 1')";
            }
        }
        if (this.place.type == PPlace.PPlaceType.PARAMETERS && exec.equals("")) {
            label = "Variable('l')";
        } else if (this.place.type == PPlace.PPlaceType.TRANSITION && exec.equals("")) {
            String locals = this.transition.event != null ? "l" : "None";
            label = String.format("Expression('g.combine(g, %s)')", locals);
        } else if (this.place.type == PPlace.PPlaceType.VARIABLES) {
            label = String.format("Expression(\"gl%s.globals()\")", exec);
        } else if (this.place.type == PPlace.PPlaceType.STATE) {
            assert (this.actions == null || this.actions.isEmpty()) : "Should not happen";
            label = String.format("Expression(\"''\")", exec);
        } else if (this.place.type == PPlace.PPlaceType.CLAUSE) {
            label = !exec.equals("") ? String.format("Expression(\"gl%s\")", exec) : "Variable('gl')";
        } else assert (false) : "Should not happen";
        return String.format("n.add_output('%s', '%s', %s)\n", this.place.name, this.transition.getSnakesName(variablePrefix), label);
    }

    static enum RepeatAction {
        INIT,
        INCREASE,
        SET_1;

    }
}

