/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.File;
import java.util.Scanner;
import org.eclipse.comma.monitoring.lib.CTraceReader;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedNotification;
import org.eclipse.comma.monitoring.lib.messages.CObservedReply;
import org.eclipse.comma.monitoring.lib.messages.CObservedSignal;
import org.eclipse.comma.monitoring.lib.utils.Utils;
import org.eclipse.comma.monitoring.lib.values.CBulkdata;
import org.eclipse.comma.monitoring.lib.values.CEnumValue;
import org.eclipse.comma.monitoring.lib.values.CVector;

public class CFileTraceReader
extends CTraceReader {
    protected Scanner scanner;
    private boolean traceHasErrors = false;
    private boolean traceInWrongFormat = false;
    private int currentLine = 0;
    private double timeDelta = 0.0;

    public CFileTraceReader(String tracePath) throws Exception {
        this.scanner = new Scanner(new File(tracePath));
        this.moveToEvents();
    }

    public boolean traceHasErrors() {
        return this.traceHasErrors;
    }

    public boolean traceInWrongFormat() {
        return this.traceInWrongFormat;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public CObservedMessage readMessage() throws Exception {
        if (this.traceHasErrors || this.traceInWrongFormat) {
            throw new Exception("Trace contains errors");
        }
        String messageId = "";
        CObservedMessage result = null;
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine().trim();
            ++this.currentLine;
            if (line.isEmpty() || line.startsWith("//")) continue;
            String[] words = line.split("\\s+");
            if (words.length == 1) {
                if (words[0].startsWith("id")) {
                    messageId = words[0];
                    continue;
                }
                throw new Exception("Line " + this.currentLine + ": expected message id.");
            }
            if (words.length != 9) {
                throw new Exception("Line " + this.currentLine + ": wrong message format.");
            }
            switch (words[0]) {
                case "Command": {
                    result = new CObservedCommand(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                case "Signal": {
                    result = new CObservedSignal(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                case "Notification": {
                    result = new CObservedNotification(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                case "Reply": {
                    result = new CObservedReply(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                default: {
                    throw new Exception("Line " + this.currentLine + ": unknown message kind.");
                }
            }
            result.setInterface(words[7]);
            result.setMessageId(messageId);
            result.setTimestamp(words[1]);
            this.timeDelta += Double.parseDouble(words[2]);
            result.setTimeDelta(Utils.roundDouble(this.timeDelta * 1000.0, 3));
            this.processParameters(result);
            break;
        }
        return result;
    }

    private void processParameters(CObservedMessage message) throws Exception {
        while (this.scanner.hasNextLine()) {
            ++this.currentLine;
            String line = this.scanner.nextLine().trim();
            if (line.equals("End")) {
                return;
            }
            Scanner lineScanner = new Scanner(line);
            message.addParameter(this.processValue(lineScanner.next(), lineScanner));
            if (!lineScanner.hasNext()) continue;
            throw new Exception("Line " + this.currentLine + ": remaining tokens after parameter value is processed");
        }
        throw new Exception("Missing closing End for a message");
    }

    protected Object processValue(String type, Scanner scanner) throws Exception {
        switch (type) {
            case "int": {
                return scanner.nextLong();
            }
            case "real": {
                String val = scanner.next();
                if (val.equals("NaN")) {
                    return Double.NaN;
                }
                return Double.parseDouble(val);
            }
            case "bool": {
                return scanner.nextBoolean();
            }
            case "string": {
                scanner.useDelimiter("\"");
                scanner.next();
                String value = scanner.next();
                while (value.endsWith("\\")) {
                    value = String.valueOf(value.substring(0, value.length() - 1)) + "\"" + scanner.next();
                }
                scanner.reset();
                scanner.next();
                return value;
            }
            case "bulkdata": {
                return new CBulkdata(scanner.nextInt());
            }
            case "enum": {
                return new CEnumValue(String.valueOf(scanner.next()) + "::" + scanner.next());
            }
            case "vector": {
                String baseType = scanner.next();
                int size = scanner.nextInt();
                CVector vectorValue = new CVector();
                int i = 1;
                while (i <= size) {
                    vectorValue.addNew(this.processValue(baseType, scanner));
                    ++i;
                }
                String endToken = scanner.next();
                if (!"END".equals(endToken)) {
                    throw new Exception("Line " + this.currentLine + ": missing closing END for a vector");
                }
                return vectorValue;
            }
            case "record": {
                return this.processRecord(scanner);
            }
        }
        throw new Exception("Line " + this.currentLine + ": unsupported type");
    }

    protected Object processRecord(Scanner scanner) throws Exception {
        throw new Exception("Line " + this.currentLine + ": unexpected record value. Model does not use record types.");
    }

    private void moveToEvents() {
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine().trim();
            ++this.currentLine;
            if (line.equals("events")) {
                return;
            }
            if (!line.equals("errors")) continue;
            this.traceHasErrors = true;
            return;
        }
        this.traceInWrongFormat = true;
    }
}

